-- author: rafftnix
-- date: 27.08.2013

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

SeedlingPallet = {};

function SeedlingPallet.prerequisitesPresent(specializations)
    return true;
end;

function SeedlingPallet:load(xmlFile)
	self.planterTriggerCallback = SeedlingPallet.planterTriggerCallback;
	self.setFillLevel = Utils.overwrittenFunction(self.setFillLevel, SeedlingPallet.setFillLevel);	
	
	self.treePlanterTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seedlingPallet#triggerIndex"));
	addTrigger(self.treePlanterTrigger, "planterTriggerCallback", self);
	
	self.treeSeedlingsNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seedlingPallet#treesIndex"));
	self.treeSeedlings = {}
	self.amountLimited = true;
	for a=0, getNumOfChildren(self.treeSeedlingsNode)-1 do
		table.insert(self.treeSeedlings, getChildAt(self.treeSeedlingsNode, a));
	end;
end;

function SeedlingPallet:delete()
	removeTrigger(self.treePlanterTrigger);  
end;

function SeedlingPallet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SeedlingPallet:keyEvent(unicode, sym, modifier, isDown)
end;

function SeedlingPallet:update(dt)

end;

function SeedlingPallet:draw()
  
end;

function SeedlingPallet:planterTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local planter = g_currentMission.nodeToVehicle[otherShapeId];
	if planter ~= nil and planter.treeSeedlings ~= nil and planter.fillTypes ~= nil and planter.fillTypes[Fillable.fillTypeNameToInt["seedling"]] ~= nil and planter.seedlingFillTriggers ~= nil then
		if onEnter and self.fillLevel > 0 then
			table.insert(planter.seedlingFillTriggers, self);
		elseif onLeave then
			for a=1, table.getn(planter.seedlingFillTriggers) do
				if self == planter.seedlingFillTriggers[a] then
					table.remove(planter.seedlingFillTriggers, a);
					break;
				end;
			end;
		end;
	end;
end;

function SeedlingPallet:setFillLevel(oldFunc, fillLevel, fillType, force)
	oldFunc(self, fillLevel, fillType, force);
	
	for a=1, table.getn(self.treeSeedlings) do
		if a <= fillLevel then
			setVisibility(self.treeSeedlings[a], true);
		else
			setVisibility(self.treeSeedlings[a], false);
		end;
	end;
	
	if fillLevel == 0 then
		if self.isServer then
			g_currentMission.vehiclesToDelete[self] = self;
		end;
	end;
end;