-- author: rafftnix
-- date: 19.01.2014

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

SawMill = {}
SawMill.directory = g_currentModDirectory; 
SawMill_mt = Class(SawMill, StorageTipTrigger);

function onCreateSawMill(self, id)
	local mill = SawMill:new(g_server ~= nil, g_client ~= nil);
	if mill:load(id) then
		g_currentMission:addOnCreateLoadedObject(mill);
		mill:register(true);
		g_currentMission:addOnCreateLoadedObjectToSave(mill);
	else
		mill:delete();
	end;
end;

function SawMill:new(isServer, isClient, mt)
	if mt == nil then
		mt = SawMill_mt;
	end;

	local self = StorageTipTrigger:new(isServer, isClient, mt);

	return self;
end;

function SawMill:load(id)
	print("loading sawmill");
	StorageTipTrigger.load(self, id);

	-- conveyor
	self.conveyorTrigger = Utils.indexToObject(getParent(id), getUserAttribute(id, "conveyorTriggerIndex"));
	self.conveyorRefNode = Utils.indexToObject(getParent(id), getUserAttribute(id, "conveyorRefNodeIndex"));
	self.trunksToConvey = {}

	addTrigger(self.conveyorTrigger, "conveyorTriggerCallback", self);
	-- trunk sell trigger
	self.trunkSellTrigger = Utils.indexToObject(getParent(id), getUserAttribute(id, "trunkSellTriggerIndex"));
	addTrigger(self.trunkSellTrigger, "trunkSellTriggerCallback", self);
		
	-- woodChip output
	self.sawDustTrailers = {}
	self.sawDustToFill = 0;
	self.sawDustMultiplier = Utils.getNoNil(getUserAttribute(id, "sawDustMultiplier"), 0.1);
	self.sawDustFillSpeed = Utils.getNoNil(getUserAttribute(id, "sawDustFillSpeed"), 25);
	self.sawDustOutputTrigger = Utils.indexToObject(getParent(id), getUserAttribute(id, "sawDustOutputTriggerIndex"));
	addTrigger(self.sawDustOutputTrigger, "sawDustOutputTriggerCallback", self);
	
	self.sawDustParticleSystemActive = false;
	self.sawDustParticleSystemActiveBackup = false;
	
	-- particle system
	if getUserAttribute(id, "particleNodeIndex") ~= nil then
		local nodeId = Utils.indexToObject(getParent(id), getUserAttribute(id, "particleNodeIndex"));
		self.sawDustOutputParticle = {}
		
		local psSettings = {}
		psSettings.psFile = getUserAttribute(id, "particleSystemFilename");
		psSettings.posX, psSettings.posY, psSettings.posZ = 0, 0, 0;
		psSettings.forceNoWorldSpace = true;
		Utils.loadParticleSystemFromData(psSettings, self.sawDustOutputParticle, nil, false, nil, SawMill.directory, nodeId);
	end;
	
	-- dependent particle system 
	if getUserAttribute(id, "dependentParticleNodeIndex") ~= nil then
		local nodeId = Utils.indexToObject(getParent(id), getUserAttribute(id, "dependentParticleNodeIndex"));
		self.dependentSawDustOutputParticle = {}
		
		local psSettings = {}
		psSettings.psFile = getUserAttribute(id, "dependentParticleSystemFilename");
		psSettings.posX, psSettings.posY, psSettings.posZ = 0, 0, 0;
		psSettings.forceNoWorldSpace = true;
		Utils.loadParticleSystemFromData(psSettings, self.dependentSawDustOutputParticle, nil, false, nil, SawMill.directory, nodeId);
	end;
	
	return true;
end;

function SawMill:delete()
	if self.conveyorTrigger ~= nil then
		removeTrigger(self.conveyorTrigger);
		self.conveyorTrigger = nil;
		StorageTipTrigger.delete(self);
	end;
	
	if self.trunkSellTrigger ~= nil then
		removeTrigger(self.trunkSellTrigger);
		self.trunkSellTrigger = nil;
	end;
	
	if self.sawDustOutputTrigger ~= nil then
		removeTrigger(self.sawDustOutputTrigger);
		self.sawDustOutputTrigger = nil;
	end;
	
	if self.smokeParticleSystem ~= nil then
		Utils.deleteParticleSystem(self.smokeParticleSystem);
	end;
	
	if self.sawDustOutputParticle ~= nil then
		Utils.deleteParticleSystem(self.sawDustOutputParticle);
	end;
	
	if self.dependentSawDustOutputParticle ~= nil then
		Utils.deleteParticleSystem(self.dependentSawDustOutputParticle);
	end;
end;

function SawMill:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	StorageTipTrigger.loadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	self.sawDustToFill = Utils.getNoNil(getXMLFloat(xmlFile, key.."#sawDustToFill"), 0);
	return true;
end;

function SawMill:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = StorageTipTrigger.getSaveAttributesAndNodes(self, nodeIdent);
	attributes = attributes..' sawDustToFill="'..tostring(self.sawDustToFill)..'"';
	return attributes, nodes;
end;

function SawMill:readStream(streamId, connection)
	StorageTipTrigger.readStream(self, streamId, connection);
	if connection:getIsServer() then
		self.sawDustParticleSystemActive = streamReadBool(streamId);
	end;
end;

function SawMill:writeStream(streamId, connection)
	StorageTipTrigger.writeStream(self, streamId, connection);
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.sawDustParticleSystemActive);
	end;
end;

function SawMill:readUpdateStream(streamId, timestamp, connection)
	StorageTipTrigger.readUpdateStream(self, streamId, timestamp, connection);
end;

function SawMill:writeUpdateStream(streamId, connection, dirtyMask)
	StorageTipTrigger.writeUpdateStream(self, streamId, connection, dirtyMask);
end;

function SawMill:update(dt)
	StorageTipTrigger.update(self, dt);
end;

function SawMill:updateTick(dt)
	StorageTipTrigger.updateTick(self, dt);
	
	if self.isServer then
		local filling = false;
		if self.sawDustToFill > 0 then
			for a=1, table.getn(self.sawDustTrailers) do
				local trailer = self.sawDustTrailers[a];
				local fillType = Fillable.fillTypeNameToInt["woodChip"];
				if trailer:allowFillType(fillType, false) and trailer.fillLevel < trailer.capacity then
					local amount = math.min(self.sawDustFillSpeed*dt, self.sawDustToFill, trailer.capacity-trailer.fillLevel);
					trailer:setFillLevel(trailer.fillLevel + amount, fillType, false);
					self.sawDustToFill = self.sawDustToFill - amount;
					filling = true;
					break;
				end;
			end;
			
			if not filling then
				if self.fillLevel < self.capacity then
					local amount = math.min(self.sawDustFillSpeed*dt, self.sawDustToFill, self.capacity-self.fillLevel);
					self.fillLevel = self.fillLevel + amount;
					self.sawDustToFill = self.sawDustToFill - amount;
					filling = true;
				end;
			end;
		end;
	
		self.sawDustParticleSystemActive = filling;
		if filling then
			self:raiseDirtyFlags(self.storageTipTriggerDirtyFlag);
		end;
	end;
	
	if self.sawDustOutputParticle ~= nil then
		if self.sawDustParticleSystemActive ~= self.sawDustParticleSystemActiveBackup then
			Utils.setEmittingState(self.sawDustOutputParticle, self.sawDustParticleSystemActive);
			self.sawDustParticleSystemActiveBackup = self.sawDustParticleSystemActive;
			if self.dependentSawDustOutputParticle ~= nil then
				addTimer(getParticleSystemLifespan(self.sawDustOutputParticle[1].geometry), "updateDependentParticleSystem", self);
			end;
			if self.isServer then
				g_server:broadcastEvent(SawMillSetParticlesActiveEvent:new(self, self.sawDustParticleSystemActive), nil, nil, self);
			end;
		end;
	end;
		
	if self.isServer then
		for a=1, table.getn(self.trunksToConvey) do
			local entry = self.trunksToConvey[a];
			local trunk = entry.trunk;
			local nodeId = trunk.nodeId;
			
			if nodeId ~= 0 and trunk.woodClaw == nil then
				local x, y, z = getWorldTranslation(self.conveyorRefNode);
				local vx, vy, vz = getWorldTranslation(trunk.visNode);
				local rx, ry, rz = getWorldTranslation(trunk.visRefNode);
				local lvx,lvy,lvz = worldToLocal(self.conveyorRefNode, vx,vy,vz);
				local lrx,lry,lrz = worldToLocal(self.conveyorRefNode, rx,ry,rz);
				
				if entry.lastPos ~= nil then
					local speed;
					if lvx > lrx then
						speed = Utils.vector3Length(vx-entry.lastPos[1], vy-entry.lastPos[2], vz-entry.lastPos[3]) / dt;
					else
						speed = Utils.vector3Length(rx-entry.lastPos[1], ry-entry.lastPos[2], rz-entry.lastPos[3]) / dt;
					end;		
					
					if math.abs(speed) > 0.0006 then
						entry.force = math.max(0, entry.force - 0.00005);
					else
						entry.force = math.min(math.huge, entry.force + 0.0001);
					end;
					
					local lx, ly, lz;
					if lvx > lrx then 
						local lx, ly, lz = worldToLocal(nodeId, vx,vy,vz);
						entry.lastPos = {vx, vy, vz};
						addForce(nodeId, (x-vx)*entry.force, (y-vy)*entry.force, (z-vz)*entry.force, lx, ly, lz, true); 
					else
						local lx, ly, lz = worldToLocal(nodeId, rx,ry,rz);
						entry.lastPos = {rx, ry, rz};
						addForce(nodeId, (x-rx)*entry.force, (y-ry)*entry.force, (z-rz)*entry.force, lx, ly, lz, true); 
					end;
				else
					entry.lastPos = {rx, ry, rz};
				end;
			end;
		end;
	end;
end;

function SawMill:conveyorTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter or onLeave then
		if g_currentMission.treeManager ~= nil then
			local trunk = g_currentMission.treeManager.nodeIdToTrunk[otherId];
			if trunk ~= nil then
				if onEnter then
					local enter = true;
					for i,t in pairs(self.trunksToConvey) do
						if t == trunk then
							enter = false;
							break;
						end;
					end;
					if enter then
						local entry = {}
						entry.force = 0;
						entry.trunk = trunk;
						table.insert(self.trunksToConvey, entry);
					end;
				elseif onLeave then
					for a=1, table.getn(self.trunksToConvey) do
						if self.trunksToConvey[a].trunk == trunk then
							trunk.pos = nil;
							table.remove(self.trunksToConvey, a);
							break;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function SawMill:trunkSellTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local trunk = g_currentMission.treeManager.nodeIdToTrunk[otherId];
	if trunk ~= nil then
		if self.isServer then
			g_currentMission:addSharedMoney(math.floor(trunk.sellPrice * (4-g_currentMission.missionStats.difficulty)), "other");
			
			local sawDustAmount = trunk.woodChipAmount * self.sawDustMultiplier;
			self.sawDustToFill = self.sawDustToFill + sawDustAmount;
			
			for a=1, table.getn(self.trunksToConvey) do
				if self.trunksToConvey[a] == trunk then
					table.remove(self.trunksToConvey, a);
				end;
			end;
			
			trunk:delete();			
		end;
	end;
end;

function SawMill:sawDustOutputTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local trailer = g_currentMission.objectToTrailer[otherId];
	if trailer ~= nil then
		if onEnter then
			table.insert(self.sawDustTrailers, trailer);
		elseif onLeave then
			for a=1, table.getn(self.sawDustTrailers) do
				if self.sawDustTrailers[a] == trailer then
					table.remove(self.sawDustTrailers, a);
				end;
			end;
		end;
	end;
end;

function SawMill:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	StorageTipTrigger.triggerCallback(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId);
end;

function SawMill:updateDependentParticleSystem()
	Utils.setEmittingState(self.dependentSawDustOutputParticle, self.sawDustParticleSystemActive);
end;