-- author: rafftnix
-- date: 31.01.2014

PlaceableStorageTipTrigger = {}
local PlaceableStorageTipTrigger_mt = Class(PlaceableStorageTipTrigger, Placeable);
InitObjectClass(PlaceableStorageTipTrigger, "PlaceableStorageTipTrigger");

function PlaceableStorageTipTrigger:new(isServer, isClient, mt)
	if mt == nil then
		mt = PlaceableStorageTipTrigger_mt;
	end;
	
	local self = Placeable:new(isServer, isClient, mt);
	registerObjectClassName(self, "PlaceableStorageTipTrigger");
	
	g_currentMission:addTipTrigger(self);
	return self;
end;

function PlaceableStorageTipTrigger:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
	PlaceableStorageTipTrigger:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom);
	if not moveMode then
		local xmlFile = loadXMLFile("temp", xmlFilename);
		
		local triggerIndex = getXMLString(xmlFile, "placeable.storage#tipTriggerIndex");
		local triggerId = Utils.indexToObject(self.nodeId, triggerIndex);
		StorageTipTrigger.load(self, triggerId);
				
		-- remove grass under building
		local startNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fruitCut#startIndex"));
		local widthNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fruitCut#widthIndex"));
		local heightNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fruitCut#heightIndex"));

		local sx, sy, sz = getWorldTranslation(startNode);
		local wx, wy, wz = getWorldTranslation(widthNode);
		local hx, hy, hz = getWorldTranslation(heightNode);
		
		Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_GRASS, sx, sz, wx, wz, hx, hz);
		Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_WHEAT, sx, sz, wx, wz, hx, hz);
		
		delete(xmlFile);
		
		if self.acceptedFillType == Fillable.fillTypeNameToInt["woodChip"] and g_currentMission.treeManager ~= nil then
			table.insert(g_currentMission.treeManager.tutorialGuisToOpen, "woodChipStorage");
		end;
	end;
	
	return true;
end;

function PlaceableStorageTipTrigger:delete()
	if self.triggerId ~= nil then
		StorageTipTrigger.delete(self);
	end;
	PlaceableStorageTipTrigger:superClass().delete(self);
end;

function PlaceableStorageTipTrigger:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	PlaceableStorageTipTrigger:superClass().loadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	self.fillLevel = math.min(self.capacity, Utils.getNoNil(getXMLFloat(xmlFile, key.."#fillLevel"), 0));
	return true;
end;

function PlaceableStorageTipTrigger:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = PlaceableStorageTipTrigger:superClass().getSaveAttributesAndNodes(self, nodeIdent);
	attributes = attributes..' fillLevel="'..tostring(self.fillLevel)..'"';
	return attributes, nodes;
end;

function PlaceableStorageTipTrigger:readStream(streamId, connection)
	PlaceableStorageTipTrigger:superClass().readStream(self, streamId, connection);
	StorageTipTrigger.readStream(self, streamId, connection);
end;

function PlaceableStorageTipTrigger:writeStream(streamId, connection)
	PlaceableStorageTipTrigger:superClass().writeStream(self, streamId, connection);
	StorageTipTrigger.writeStream(self, streamId, connection);
end;

function PlaceableStorageTipTrigger:readUpdateStream(streamId, timestamp, connection)
	PlaceableStorageTipTrigger:superClass().readUpdateStream(self, streamId, timestamp, connection);
	StorageTipTrigger.readUpdateStream(self, streamId, timestamp, connection);
end;

function PlaceableStorageTipTrigger:writeUpdateStream(streamId, connection, dirtyMask)
	PlaceableStorageTipTrigger:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	StorageTipTrigger.writeUpdateStream(self, streamId, connection, dirtyMask);
end;

function PlaceableStorageTipTrigger:update(dt)
	PlaceableStorageTipTrigger:superClass().update(self, dt);
	StorageTipTrigger.update(self, dt);
end;

function PlaceableStorageTipTrigger:updateTick(dt)
	PlaceableStorageTipTrigger:superClass().updateTick(self, dt);
	StorageTipTrigger.updateTick(self, dt);
end;

function PlaceableStorageTipTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	StorageTipTrigger.triggerCallback(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId);
end;

function PlaceableStorageTipTrigger:updateTrailerTipping(trailer, fillDelta, fillType)
	StorageTipTrigger.updateTrailerTipping(self, trailer, fillDelta, fillType);
end;

function PlaceableStorageTipTrigger:getTipInfoForTrailer(trailer, tipReferencePointIndex)
	return StorageTipTrigger.getTipInfoForTrailer(self, trailer, tipReferencePointIndex);
end;

function PlaceableStorageTipTrigger:getTipDistanceFromTrailer(trailer, tipReferencePointIndex)
	return StorageTipTrigger.getTipDistanceFromTrailer(self, trailer, tipReferencePointIndex);
end;

function PlaceableStorageTipTrigger:updateMoving(notNeeded)
	StorageTipTrigger.updateMoving(self, notNeeded);
end;

function PlaceableStorageTipTrigger:addShovelFillLevel(shovel, delta, fillType)
	return StorageTipTrigger.addShovelFillLevel(self, shovel, delta, fillType);
end;

function PlaceableStorageTipTrigger:getAllowShovelFillType(fillType)
	return StorageTipTrigger.getAllowShovelFillType(self, fillType);
end;

function PlaceableStorageTipTrigger:getNoAllowedText(trailer)
	return StorageTipTrigger.getNoAllowedText(self, trailer);
end;

registerPlaceableType("PlaceableStorageTipTrigger", PlaceableStorageTipTrigger);