-- author: rafftnix
-- date: 31.01.2014

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

PlaceableSawMill = {}
local PlaceableSawMill_mt = Class(PlaceableSawMill, Placeable);
InitObjectClass(PlaceableSawMill, "PlaceableSawMill");

function PlaceableSawMill:new(isServer, isClient, mt)
	if mt == nil then
		mt = PlaceableSawMill_mt;
	end;
	local self = Placeable:new(isServer, isClient, mt);
	registerObjectClassName(self, "PlaceableSawMill");
	g_currentMission:addTipTrigger(self);
	return self;
end;

function PlaceableSawMill:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
	PlaceableSawMill:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom);
	if not moveMode then
		local xmlFile = loadXMLFile("temp", xmlFilename);
		
		local triggerIndex = getXMLString(xmlFile, "placeable.sawMill#triggerId");
		local triggerId = Utils.indexToObject(self.nodeId, triggerIndex);
		SawMill.load(self, triggerId);
		
		self.smokeParticlesActive = false;
		self.smokeParticles = {}
		Utils.loadParticleSystem(xmlFile, self.smokeParticles, "placeable.sawMill.smokeParticle", self.nodeId, true, "objects/BioHeatPlant/smokeParticle.i3d", PlaceableBioHeatPlant.modDir);
		
		-- remove grass under building
		local startNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fruitCut#startIndex"));
		local widthNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fruitCut#widthIndex"));
		local heightNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fruitCut#heightIndex"));

		local sx, sy, sz = getWorldTranslation(startNode);
		local wx, wy, wz = getWorldTranslation(widthNode);
		local hx, hy, hz = getWorldTranslation(heightNode);
		
		Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_GRASS, sx, sz, wx, wz, hx, hz);
		Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_WHEAT, sx, sz, wx, wz, hx, hz);
		
		delete(xmlFile);
		
		table.insert(g_currentMission.treeManager.tutorialGuisToOpen, "sawMill");
	end;
	
	return true;
end;

function PlaceableSawMill:delete()
	Utils.deleteParticleSystem(self.smokeParticles);
	SawMill.delete(self);
	PlaceableSawMill:superClass().delete(self);
end;

function PlaceableSawMill:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	PlaceableSawMill:superClass().loadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	self.fillLevel = math.min(self.capacity, Utils.getNoNil(getXMLFloat(xmlFile, key.."#fillLevel"), 0));
	self.sawDustToFill = Utils.getNoNil(getXMLFloat(xmlFile, key.."#sawDustToFill"), 0);
	return true;
end;

function PlaceableSawMill:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = PlaceableSawMill:superClass().getSaveAttributesAndNodes(self, nodeIdent);
	attributes = attributes..' fillLevel="'..tostring(self.fillLevel)..'"';
	attributes = attributes..' sawDustToFill="'..tostring(self.sawDustToFill)..'"';
	return attributes, nodes;
end;

function PlaceableSawMill:readStream(streamId, connection)
	PlaceableSawMill:superClass().readStream(self, streamId, connection);
	SawMill.readStream(self, streamId, connection);
end;

function PlaceableSawMill:writeStream(streamId, connection)
	PlaceableSawMill:superClass().writeStream(self, streamId, connection);
	SawMill.writeStream(self, streamId, connection);
end;

function PlaceableSawMill:readUpdateStream(streamId, timestamp, connection)
	PlaceableSawMill:superClass().readUpdateStream(self, streamId, timestamp, connection);
	SawMill.readUpdateStream(self, streamId, timestamp, connection);
end;

function PlaceableSawMill:writeUpdateStream(streamId, connection, dirtyMask)
	PlaceableSawMill:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	SawMill.writeUpdateStream(self, streamId, connection, dirtyMask);
end;

function PlaceableSawMill:update(dt)
	PlaceableSawMill:superClass().update(self, dt);
	SawMill.update(self, dt);
end;

function PlaceableSawMill:updateTick(dt)
	PlaceableSawMill:superClass().updateTick(self, dt);
	SawMill.updateTick(self, dt);
end;

function PlaceableSawMill:conveyorTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	SawMill.conveyorTriggerCallback(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId);
end;

function PlaceableSawMill:trunkSellTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	SawMill.trunkSellTriggerCallback(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId);
end;

function PlaceableSawMill:sawDustOutputTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	SawMill.sawDustOutputTriggerCallback(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId);
end;

function PlaceableSawMill:updateDependentParticleSystem()
	SawMill.updateDependentParticleSystem(self);
end;

registerPlaceableType("PlaceableSawMill", PlaceableSawMill);