-- author: rafftnix
-- date: 31.01.2014

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

PlaceableBioHeatPlant = {}
PlaceableBioHeatPlant_mt = Class(PlaceableBioHeatPlant, Placeable);
PlaceableBioHeatPlant.modDir = g_currentModDirectory;
InitObjectClass(PlaceableBioHeatPlant, "PlaceableBioHeatPlant");

function PlaceableBioHeatPlant:new(isServer, isClient, mt)
	if mt == nil then
		mt = PlaceableBioHeatPlant_mt;
	end;
	
	local self = Placeable:new(isServer, isClient, mt);
	registerObjectClassName(self, "PlaceableBioHeatPlant");
	
	g_currentMission:addTipTrigger(self);
	return self;
end;

function PlaceableBioHeatPlant:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
	PlaceableBioHeatPlant:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom);
	if not moveMode then
		local xmlFile = loadXMLFile("temp", xmlFilename);
		
		local triggerIndex = getXMLString(xmlFile, "placeable.bioHeatPlant#triggerIndex");
		local triggerId = Utils.indexToObject(self.nodeId, triggerIndex);
		BioHeatPlant.load(self, triggerId);
		
		self.smokeParticlesActive = false;
		self.smokeParticles = {}
		local num = 0;
		while true do
			if not hasXMLProperty(xmlFile, "placeable.bioHeatPlant.smokeParticleSystem("..num..")") then
				break;
			end;
			local ps = {}
			Utils.loadParticleSystem(xmlFile, ps, "placeable.bioHeatPlant.smokeParticleSystem("..num..")", self.nodeId, false, "objects/BioHeatPlant/smokeParticle.i3d", PlaceableBioHeatPlant.modDir);
			table.insert(self.smokeParticles, ps);
			num = num + 1;
		end;
		
		if g_currentMission.treeManager ~= nil then
			table.insert(g_currentMission.treeManager.tutorialGuisToOpen, "bioHeatPlant");
		end;
		
		-- remove grass under building
		local startNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fruitCut#startIndex"));
		local widthNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fruitCut#widthIndex"));
		local heightNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fruitCut#heightIndex"));

		local sx, sy, sz = getWorldTranslation(startNode);
		local wx, wy, wz = getWorldTranslation(widthNode);
		local hx, hy, hz = getWorldTranslation(heightNode);
		
		Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_GRASS, sx, sz, wx, wz, hx, hz);
		Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_WHEAT, sx, sz, wx, wz, hx, hz);
		
		delete(xmlFile);
	end;
	
	return true;
end;

function PlaceableBioHeatPlant:delete()
	if self.triggerId ~= nil then
		BioHeatPlant.delete(self);
	end;
	
	if self.smokeParticles ~= nil then
		for a=1, table.getn(self.smokeParticles) do
			Utils.deleteParticleSystem(self.smokeParticles[a]);
		end;
	end;
	
	PlaceableBioHeatPlant:superClass().delete(self);
end;

function PlaceableBioHeatPlant:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	PlaceableBioHeatPlant:superClass().loadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	self.fillLevel = math.min(self.capacity, Utils.getNoNil(getXMLFloat(xmlFile, key.."#fillLevel"), 0));
	self.todaysEarnings = Utils.getNoNil(getXMLFloat(xmlFile, key.."#todaysEarnings"), 0);
	return true;
end;

function PlaceableBioHeatPlant:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = PlaceableBioHeatPlant:superClass().getSaveAttributesAndNodes(self, nodeIdent);
	attributes = attributes..' fillLevel="'..tostring(self.fillLevel)..'"';
	attributes = attributes..' todaysEarnings="'..tostring(math.floor(self.todaysEarnings))..'"';
	return attributes, nodes;
end;

function PlaceableBioHeatPlant:readStream(streamId, connection)
	PlaceableBioHeatPlant:superClass().readStream(self, streamId, connection);
	StorageTipTrigger.readStream(self, streamId, connection);
end;

function PlaceableBioHeatPlant:writeStream(streamId, connection)
	PlaceableBioHeatPlant:superClass().writeStream(self, streamId, connection);
	StorageTipTrigger.writeStream(self, streamId, connection);
end;

function PlaceableBioHeatPlant:readUpdateStream(streamId, timestamp, connection)
	PlaceableBioHeatPlant:superClass().readUpdateStream(self, streamId, timestamp, connection);
	StorageTipTrigger.readUpdateStream(self, streamId, timestamp, connection);
end;

function PlaceableBioHeatPlant:writeUpdateStream(streamId, connection, dirtyMask)
	PlaceableBioHeatPlant:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	StorageTipTrigger.writeUpdateStream(self, streamId, connection, dirtyMask);
end;

function PlaceableBioHeatPlant:synchFillLevelTimer()
	return BioHeatPlant.synchFillLevelTimer(self);
end;

function PlaceableBioHeatPlant:update(dt)
	PlaceableBioHeatPlant:superClass().update(self, dt);
	BioHeatPlant.update(self, dt);
end;

function PlaceableBioHeatPlant:updateTick(dt)
	PlaceableBioHeatPlant:superClass().updateTick(self, dt);
	BioHeatPlant.updateTick(self, dt);
	
	if self.smokeParticles ~= nil and (self.fillLevel > 0) ~= self.smokeParticlesActive then
		for a=1, table.getn(self.smokeParticles) do
			Utils.setEmittingState(self.smokeParticles[a], self.fillLevel > 0);
		end;
		self.smokeParticlesActive = self.fillLevel > 0;
	end;
end;

function PlaceableBioHeatPlant:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	StorageTipTrigger.triggerCallback(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId);
end;

function PlaceableBioHeatPlant:updateTrailerTipping(trailer, fillDelta, fillType)
	StorageTipTrigger.updateTrailerTipping(self, trailer, fillDelta, fillType);
end;

function PlaceableBioHeatPlant:getTipInfoForTrailer(trailer, tipReferencePointIndex)
	return StorageTipTrigger.getTipInfoForTrailer(self, trailer, tipReferencePointIndex);
end;

function PlaceableBioHeatPlant:getTipDistanceFromTrailer(trailer, tipReferencePointIndex)
	return StorageTipTrigger.getTipDistanceFromTrailer(self, trailer, tipReferencePointIndex);
end;

function PlaceableBioHeatPlant:updateMoving(notNeeded)
	StorageTipTrigger.updateMoving(self, notNeeded);
end;

function PlaceableBioHeatPlant:addShovelFillLevel(shovel, delta, fillType)
	return StorageTipTrigger.addShovelFillLevel(self, shovel, delta, fillType);
end;

function PlaceableBioHeatPlant:getAllowShovelFillType(fillType)
	return StorageTipTrigger.getAllowShovelFillType(self, fillType);
end;

function PlaceableBioHeatPlant:getNoAllowedText(trailer)
	return StorageTipTrigger.getNoAllowedText(self, trailer);
end;

registerPlaceableType("PlaceableBioHeatPlant", PlaceableBioHeatPlant);