-- author: fruktor

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

PipeParking = {};

function PipeParking.prerequisitesPresent(specializations)
    return true;
end;

function PipeParking:load(xmlFile)
	self.pp = {};
	
	self.pp.hor = {};
	self.pp.hor.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeParking.horizontal#node"));
	local x,y,z = Utils.getVectorFromString( getXMLString(xmlFile, "vehicle.pipeParking.horizontal#transRot") )
	self.pp.hor.transRot = { math.rad(x), math.rad(y), math.rad(z) };
	local x,y,z = Utils.getVectorFromString( getXMLString(xmlFile, "vehicle.pipeParking.horizontal#workRot") )
	self.pp.hor.workRot = { math.rad(x), math.rad(y), math.rad(z) };
	self.pp.hor.rotSpeed = getXMLFloat(xmlFile, "vehicle.pipeParking.horizontal#rotSpeed");
	self.pp.hor.movingToolsIndex = getXMLInt(xmlFile, "vehicle.pipeParking.horizontal#movingToolsIndex");
	self.pp.hor.cmpJntIndices = {};
	local str = getXMLString(xmlFile, "vehicle.pipeParking.horizontal#componentJointIndices");
	local strT = Utils.splitString(" ",str);
	for i,t in pairs(strT) do
		table.insert(self.pp.hor.cmpJntIndices, tonumber(t));
	end;	
	
	self.pp.ver = {};
	self.pp.ver.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeParking.vertical#node"));
	local x,y,z = Utils.getVectorFromString( getXMLString(xmlFile, "vehicle.pipeParking.vertical#transRot") )
	self.pp.ver.transRot = { math.rad(x), math.rad(y), math.rad(z) };
	local x,y,z = Utils.getVectorFromString( getXMLString(xmlFile, "vehicle.pipeParking.vertical#workRot") )
	self.pp.ver.workRot = { math.rad(x), math.rad(y), math.rad(z) };
	self.pp.ver.rotSpeed = getXMLFloat(xmlFile, "vehicle.pipeParking.vertical#rotSpeed");
	self.pp.ver.movingToolsIndex = getXMLInt(xmlFile, "vehicle.pipeParking.vertical#movingToolsIndex");
	self.pp.ver.cmpJntIndices = {};
	local str = getXMLString(xmlFile, "vehicle.pipeParking.vertical#componentJointIndices");
	local strT = Utils.splitString(" ",str);
	for i,t in pairs(strT) do
		table.insert(self.pp.ver.cmpJntIndices, tonumber(t));
	end;
	
	self.pp.hor.targetReached = true;
	self.pp.hor.target = { self.pp.hor.transRot[1], self.pp.hor.transRot[2], self.pp.hor.transRot[3] };
	
	self.pp.ver.targetReached = true;
	self.pp.ver.target = { self.pp.ver.transRot[1], self.pp.ver.transRot[2], self.pp.ver.transRot[3] };
end;

function PipeParking:delete()
  
end;

function PipeParking:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PipeParking:keyEvent(unicode, sym, modifier, isDown)
end;

function PipeParking:update(dt)
	if self:getIsActive() then
		if self.pp.lastMoveDir ~= self.foldMoveDirection and math.abs(self.foldMoveDirection) > 0.1 then
			self.pp.lastMoveDir = self.foldMoveDirection;
			if self.foldMoveDirection > 0.1 then
				self.pp.hor.target = { self.pp.hor.transRot[1], self.pp.hor.transRot[2], self.pp.hor.transRot[3] };
				self.pp.ver.target = { self.pp.ver.transRot[1], self.pp.ver.transRot[2], self.pp.ver.transRot[3] };
			elseif self.foldMoveDirection < -0.1 then
				self.pp.hor.target = { self.pp.hor.workRot[1], self.pp.hor.workRot[2], self.pp.hor.workRot[3] };
				self.pp.ver.target = { self.pp.ver.workRot[1], self.pp.ver.workRot[2], self.pp.ver.workRot[3] };
			end;
			self.pp.hor.targetReached = false;
			self.pp.ver.targetReached = false;		
		end;

		if self.pp.hor.targetReached == false or self.pp.ver.targetReached == false then
			--#
			self.movingTools[self.pp.hor.movingToolsIndex].rotSpeed = 0;
			self.movingTools[self.pp.ver.movingToolsIndex].rotSpeed = 0;
			
			--#
			if self.foldMoveDirection > 0.1 or (self.foldMoveDirection < -0.1 and self.pp.ver.targetReached == true) then
				local rot = { getRotation(self.pp.hor.node) };
				local targetRot = {0,0,0};
				for i=1,3 do
					targetRot[i] = Utils.normalizeRotationForShortestPath(self.pp.hor.target[i], rot[i]);
					if targetRot[i] > rot[i] then
						rot[i] = math.min( targetRot[i], rot[i] + self.pp.hor.rotSpeed*dt/1000 );
					else
						rot[i] = math.max( targetRot[i], rot[i] - self.pp.hor.rotSpeed*dt/1000 );			
					end;
				end;
				setRotation(self.pp.hor.node, rot[1],rot[2],rot[3]);
				--print("hor.target: "..tostring(rot[1]).."   "..tostring(rot[2]).."   "..tostring(rot[3]))

				local mt = self.movingTools[self.pp.hor.movingToolsIndex];
				if math.abs(mt.curRot[mt.rotationAxis] - rot[mt.rotationAxis]) < 0.001 then
					self.pp.hor.targetReached = true;
				end;
				mt.curRot[mt.rotationAxis] = rot[mt.rotationAxis];
			end;

			--# if self.pp.hor.targetReached == true or self.foldMoveDirection ~= 1 then
			if self.foldMoveDirection < -0.1 or (self.foldMoveDirection > 0.1 and self.pp.hor.targetReached == true) then
			
				local rot = { getRotation(self.pp.ver.node) };
				local targetRot = {0,0,0};
				for i=1,3 do
					targetRot[i] = Utils.normalizeRotationForShortestPath(self.pp.ver.target[i], rot[i]);
					if targetRot[i] > rot[i] then
						rot[i] = math.min( targetRot[i], rot[i] + self.pp.ver.rotSpeed*dt/1000 );
					else
						rot[i] = math.max( targetRot[i], rot[i] - self.pp.ver.rotSpeed*dt/1000 );			
					end;
				end;
				setRotation(self.pp.ver.node, rot[1],rot[2],rot[3]);
				--print("ver.target: "..tostring(rot[1]).."   "..tostring(rot[2]).."   "..tostring(rot[3]))

				local mt = self.movingTools[self.pp.ver.movingToolsIndex];
				if math.abs(mt.curRot[mt.rotationAxis] - rot[mt.rotationAxis]) < 0.001 then
					self.pp.ver.targetReached = true;
				end;
				mt.curRot[mt.rotationAxis] = rot[mt.rotationAxis];
			
			end;

			for i,t in pairs(self.pp.hor.cmpJntIndices) do
				setJointFrame(self.componentJoints[t].jointIndex, 0, self.componentJoints[t].jointNode);
			end;
			for i,t in pairs(self.pp.ver.cmpJntIndices) do
				setJointFrame(self.componentJoints[t].jointIndex, 0, self.componentJoints[t].jointNode);
			end;
			
		end;
	else
		self.pp.hor.targetReached = true;	
		self.pp.ver.targetReached = true;	
		self.pp.lastMoveDir = 0;
	end;
end;

function PipeParking:draw()
  
end;

function PipeParking:onAttach(attacherVehicle) 
end;

function PipeParking:onDetach()
end;