-- author: rafftnix
-- date: 29.12.2012

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

Outrigger = {};

function Outrigger.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations); 
end;

function Outrigger:load(xmlFile)
	self.setOutriggerState = SpecializationUtil.callSpecializationsFunction("setOutriggerState");
	self.outriggerCallback = Outrigger.outriggerCallback;
	self.outriggerActive = false;
	
	self.isSelectable = true;
	self.outriggerMoving = false;
	
	self.outriggers = {}
	local num = 0;
	while true do
		local key = string.format("vehicle.outrigger.outrigger(%d)", num);
		local animationName = getXMLString(xmlFile, key.."#animationName");
		if animationName ~= nil then
			local entry = {}
			entry.contactNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#contactNodeIndex"));
			addContactReport(entry.contactNode, 0.0001, "outriggerCallback", self);
			entry.animationName = animationName;
			entry.animTimeOffset = Utils.getNoNil(getXMLFloat(xmlFile, key.."#animTimeOffset"), 0);
			entry.contactAnimTime = 0;
			entry.hasContact = false;
			local compJointString = getXMLString(xmlFile, key.."#compJointIndex");
			entry.compJoints = Utils.splitString(" ", compJointString);
			for a=1, table.getn(entry.compJoints) do
				entry.compJoints[a] = tonumber(entry.compJoints[a]);
			end;
			table.insert(self.outriggers, entry);
			num = num + 1;
		else
			break;
		end;
	end;
end;

function Outrigger:delete()
  
end;

function Outrigger:readStream(streamId, connection)
	self:setOutriggerState(streamReadBool(streamId), true);
	if self.outriggerActive then
		for a=1, table.getn(self.outriggers) do
			self:playAnimation(self.outriggers[a].animationName, 1, nil, true);
		end;
	end;
end;

function Outrigger:writeStream(streamId, connection)
	streamWriteBool(streamId, self.outriggerActive);
end;

function Outrigger:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	self.outriggerSaveData = getXMLBool(xmlFile, key.."#outriggerActive");
	return BaseMission.VEHICLE_LOAD_OK;
end;

function Outrigger:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'outriggerActive="'..tostring(self.outriggerActive)..'"';
	return attributes, nil;
end;

function Outrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Outrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function Outrigger:update(dt)
	if self.outriggerSaveData ~= nil then
		self:setOutriggerState(self.outriggerSaveData, true);
		self.outriggerSaveData = nil;
	end;
		
	if self:getIsActiveForInput(true) then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then
			self:setOutriggerState(not self.outriggerActive);
		end;
	end;
end;

function Outrigger:updateTick(dt)
	if self.outriggerMoving then
		local animRuns = false;
		for a=1, table.getn(self.outriggers) do
			local localAnimRuns = self:getIsAnimationPlaying(self.outriggers[a].animationName);
			if localAnimRuns then
				for i=1, table.getn(self.outriggers[a].compJoints) do
					local index = self.outriggers[a].compJoints[i];
					local jointIndex = self.componentJoints[index].jointIndex;
					local node = self.componentJoints[index].jointNode;
					setJointFrame(jointIndex, 0, node);
				end;
			end;
			animRuns = animRuns or localAnimRuns;
		end;
		self.outriggerMoving = animRuns;
		
		-- stop moving outrigger
		if self.outriggerActive and self.isServer then
			for a=1, table.getn(self.outriggers) do
				if self.outriggers[a].hasContact then
					if self:getIsAnimationPlaying(self.outriggers[a].animationName) then
						if self:getAnimationTime(self.outriggers[a].animationName) > (self.outriggers[a].contactAnimTime + self.outriggers[a].animTimeOffset) then
							self:stopAnimation(self.outriggers[a].animationName, false);
						end;
					end;
				end;
			end;
		end;
	end;
end;

function Outrigger:setOutriggerState(isActive, noEventSend)
	self.outriggerActive = isActive;
	self.outriggerMoving = true;
	if self.isServer then
		if isActive then
			for a=1, table.getn(self.outriggers) do
				self:stopAnimation(self.outriggers[a].animationName, false);
				self:playAnimation(self.outriggers[a].animationName, 1, nil, false);
			end;
		else
			for a=1, table.getn(self.outriggers) do
				self:stopAnimation(self.outriggers[a].animationName, false);
				self:playAnimation(self.outriggers[a].animationName, -1, nil, false);
			end;
		end;
	end;
	if not noEventSend then
		OutriggerEvent.sendEvent(self, self.outriggerActive, noEventSend);
	end;
end;

function Outrigger:draw()
	if self.outriggerActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("disableOutriggers"), InputBinding.IMPLEMENT_EXTRA4);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("enableOutriggers"), InputBinding.IMPLEMENT_EXTRA4);
	end;
end;

function Outrigger:outriggerCallback(objectId, otherObjectId, isStart, normalForce, tangentialForce)
	if self.isServer then
		for a=1, table.getn(self.outriggers) do
			if self.outriggers[a].contactNode == objectId then
				self.outriggers[a].hasContact = isStart or normalForce > 0 or tangentialForce > 0;
				if isStart then
					self.outriggers[a].contactAnimTime = self:getAnimationTime(self.outriggers[a].animationName);
				elseif normalForce == 0 and tangentialForce == 0 then
					self.outriggers[a].contactAnimTime = 0;
				end;
			end;
		end;
	end;
end;