-- author: rafftnix, fireandice
-- date: 05.04.2014

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

-- draw a line between raycast node and ground/trunk

LoadHelpLine = {}

function LoadHelpLine.prerequisitesPresent(specializations)
    return true;
end;

function LoadHelpLine:load(xmlFile)
	self.loadHelpLineRaycastCallback = LoadHelpLine.loadHelpLineRaycastCallback;

	self.loadHelpLineRaycastNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.loadHelpLine#raycastNodeIndex"));
	self.loadHelpLineMaxRaycastDist = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.loadHelpLine#maxRaycastDist"), 20);
	self.loadHelpLineMinRaycastDist = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.loadHelpLine#minRaycastDist"), 0.5);
	self.loadHelpLineActive = false;
	self.loadHelpLineX = 0;
	self.loadHelpLineY = 0;
	self.loadHelpLineZ = 0;
	self.loadHelpLineCount = getXMLInt(xmlFile, "vehicle.loadHelpLine#count");
	self.loadHelpLines = {}
	
	local num = 0;
	while true do
		local key = string.format("vehicle.loadHelpLine.helpLine(%d)", num);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local entry = {}
		entry.startNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#start"));
		entry.endNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#end"));
		table.insert(self.loadHelpLines, entry);
		num = num + 1;
	end;
end;

function LoadHelpLine:delete()
  
end;

function LoadHelpLine:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LoadHelpLine:keyEvent(unicode, sym, modifier, isDown)
end;

function LoadHelpLine:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOADHELPLINE) then
			self.loadHelpLineActive = not self.loadHelpLineActive;
		end;
	end;
	
	if self:getIsActiveForInput(false) then
		if self.loadHelpLineActive then
			local x, y, z = getWorldTranslation(self.loadHelpLineRaycastNode);
			local nx, ny, nz = 0, -1, 0; 
			raycastAll(x, y, z, nx, ny, nz, "loadHelpLineRaycastCallback", self.loadHelpLineMaxRaycastDist, self);
			if self.loadHelpLineX ~= 0 and self.loadHelpLineY ~= 0 and self.loadHelpLineZ ~= 0 then
				drawDebugLine(x, y, z, 1, 0, 0, self.loadHelpLineX, self.loadHelpLineY, self.loadHelpLineZ, 1, 0, 0);
			end;
			for a=1, table.getn(self.loadHelpLines) do
				local entry = self.loadHelpLines[a];
				if entry ~= nil then
					local x1, y1, z1 = getWorldTranslation(entry.startNode);
					local x2, y2, z2 = getWorldTranslation(entry.endNode);
					y = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, y, z) + 0.2;
					y1 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x1, y1, z1) + 0.2;
					y2 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x2, y2, z2) + 0.2;
					local yDiff = self.loadHelpLineY - y;
					drawDebugLine(x1, y1+yDiff, z1, 1, 0, 0, x2, y2+yDiff, z2, 1, 0, 0);
				end;
			end;
		end;
	end;
end;

function LoadHelpLine:draw()
	if self.loadHelpLineActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("DeactivateLoadHelpLine"), InputBinding.LOADHELPLINE);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("ActivateLoadHelpLine"), InputBinding.LOADHELPLINE);
	end;
end;

function LoadHelpLine:onLeave()
	self.loadHelpLineActive = false;
end;

function LoadHelpLine:loadHelpLineRaycastCallback(hitObjectId, x, y, z, distance, nx, ny, nz, subShapeIndex)
	if hitObjectId == g_currentMission.terrainRootNode or (g_currentMission.treeManager ~= nil and g_currentMission.treeManager.nodeIdToTrunk[hitObjectId] and not g_currentMission.treeManager.nodeIdToTrunk[hitObjectId].isAttached) then
		self.loadHelpLineX = x;
		self.loadHelpLineY = y;
		self.loadHelpLineZ = z;
	end;
end;