-- author: rafftnix, fruktor
-- date: 05.12.2013

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

-- starter for harvestable trees.

HarvestableTrees = {}
HarvestableTrees.modDir = g_currentModDirectory;

function HarvestableTrees:loadMap()
	if not self.loadDone then 
		self.loadDone = true;

		g_currentMission.harvestableTrees = self;
		table.insert(g_currentMission.onCreateLoadedObjectsToSave, self);

		self.treeJoints = {} -- for all trunk joints
		self.harvestableTreesPattern = {}
		self.trunksForJointLoadHelp = {}
		self.trunkIdsSet = false;
		
		-- load all harvestable trees once, so we can dublicate them
		for typeIndex = 1, TreeManager.numRegisteredTreeTypes do
			local treeTypeName = TreeManager.treeTypes[typeIndex].treeType;
		 
			self.harvestableTreesPattern[typeIndex] = {}
			
			for treeIndex, treeInfos in pairs(g_currentMission.treeManager.treeTypes[treeTypeName].trees) do
			
				local treePattern = {}
				treePattern.trunks = {}
				treePattern.baseDir = treeInfos.baseDir;
				
				local xmlFile = loadXMLFile("harvestableTreeXML", treeInfos.baseDir..treeInfos.xmlFilename);
				treePattern.xmlFile = xmlFile;
				
				-- load trunk node ids 
				local treeRootNode = Utils.loadSharedI3DFile(getXMLString(xmlFile, "tree.filename"), treeInfos.baseDir);
				
				-- load sound files
				local soundKey = "tree.sounds.cut";
				if hasXMLProperty(xmlFile, soundKey) then
					treePattern.cutSound = {}
					local sound = treePattern.cutSound;
					sound.filename = Utils.getFilename(getXMLString(xmlFile, soundKey.."#file"), treePattern.baseDir);
					sound.volume = getXMLFloat(xmlFile, soundKey.."#volume");
					sound.pitch = getXMLFloat(xmlFile, soundKey.."#pitch");
					sound.radius = Utils.getNoNil(getXMLFloat(xmlFile, soundKey.."#radius"), 2);
					sound.innerRadius = Utils.getNoNil(getXMLFloat(xmlFile, soundKey.."#innerRadius"), 1);
				end;
				
				-- load sound files
				local soundKey = "tree.sounds.impact";
				if hasXMLProperty(xmlFile, soundKey) then
					treePattern.impactSound = {}
					local sound = treePattern.impactSound;
					sound.filename = Utils.getFilename(getXMLString(xmlFile, soundKey.."#file"), treePattern.baseDir);
					sound.volume = Utils.getNoNil(getXMLFloat(xmlFile, soundKey.."#volume"), 1);
					sound.pitch = Utils.getNoNil(getXMLFloat(xmlFile, soundKey.."#pitch"), 1);
					sound.radius = Utils.getNoNil(getXMLFloat(xmlFile, soundKey.."#radius"), 25);
					sound.innerRadius = Utils.getNoNil(getXMLFloat(xmlFile, soundKey.."#innerRadius"), 1);
				end;
				
				-- register trunks
				local num = 0;
				while true do
					local key = string.format("tree.trunks.trunk(%d)", num);
					if not hasXMLProperty(xmlFile, key) then
						break;
					end;
					
					local trunk = {};					
					trunk.nodeIndex = getXMLString(xmlFile, key .. "#nodeIndex");
					trunk.nodeId = Utils.indexToObject(treeRootNode, trunk.nodeIndex);
					trunk.isRoot = Utils.getNoNil( getXMLBool(xmlFile, key .. "#isRoot"), false );
					trunk.sellPrice = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#sellPrice"), 0);
					trunk.woodChipAmount = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#woodChipAmount"), 0);
					trunk.woodChipAmountFL = trunk.woodChipAmount;
					trunk.branchGroupIndex = getXMLString(xmlFile, key .. "#branchGroupIndex");
					trunk.cutMeSignIndex = getXMLString(xmlFile, key .. "#cutMeSignIndex");
					
					local x, y, z = Utils.getVectorFromString( getXMLString(xmlFile, key .. "#centerOfMass") );
					if x ~= nil and y ~= nil and z ~= nil then
						setCenterOfMass(trunk.nodeId, x, y, z);
						trunk.centerOfMass = { x, y, z };
					end;					
					
					trunk.visNodeIndex = getXMLString(xmlFile, key .. "#visNodeIndex");
					trunk.visRefNodeIndex = getXMLString(xmlFile, key .. "#visRefNodeIndex");

					trunk.loadPos = {getTranslation(trunk.nodeId)}
					
					trunk.joints = {};
					local jnum = 0;
					while true do
						local key = string.format("tree.trunks.trunk(%d).joint(%d)", num, jnum);
						if not hasXMLProperty(xmlFile, key) then
							break;
						end;						
						local joint ={};
						joint.trunkIndex1 = num + 1;
						joint.trunkIndex2 = getXMLInt(xmlFile, key .. "#trunkIndex") + 1;
						joint.jointNodeIndex = getXMLString(xmlFile, key .. "#jointNodeIndex");
						joint.markNodeIndex = getXMLString(xmlFile, key .. "#markNodeIndex");
						joint.cutDuration = getXMLFloat(xmlFile, key .. "#cutDuration");
						joint.jointTableIndex = jnum+1;
						table.insert(trunk.joints, joint);
						jnum = jnum+1;
					end;
				
					table.insert(treePattern.trunks, trunk);
					num = num + 1;
				end;
				
				for a=1, table.getn(treePattern.trunks) do
					local trunk = treePattern.trunks[a];
					unlink(trunk.nodeId); 
					setTranslation(trunk.nodeId, 5000, -5000, 5000);
					link(getRootNode(), trunk.nodeId);
				end;
				
				delete(treeRootNode);
				
				self.harvestableTreesPattern[typeIndex][treeIndex] = treePattern;
			end;
		end;
	end;
end;

function HarvestableTrees:deleteMap()
	unregisterObjectClassName(self);
	self.firstRunDone = false;
	self.loadDone = false;
end;

function HarvestableTrees:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HarvestableTrees:keyEvent(unicode, sym, modifier, isDown)
end;

function HarvestableTrees:update(dt)
	if self.loadingJoints ~= nil then
		local cnt = 1;
		while table.getn(self.loadingJoints) > 0 do
			
			-- naive approach			
			local e = self.loadingJoints[table.getn(self.loadingJoints)];
			for a=1, table.getn(e.trunk1Pattern.joints) do
				local joint = e.trunk1Pattern.joints[a];
				if joint.trunkIndex1 == e.trunk1.trunkIndex and joint.trunkIndex2 == e.trunk2.trunkIndex then
					self:joinTrunks(e.trunk1, e.trunk2, joint.jointNodeIndex, joint.cutDuration, joint.jointTableIndex);
					break;
				end;
			end;			
			
			table.remove(self.loadingJoints, table.getn(self.loadingJoints));
						
			if cnt > 50 then 
				break;
			end;
			cnt = cnt + 1;
		
		end;
	end;
end;

function HarvestableTrees:draw()

end;

function HarvestableTrees:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local num = 0;
	self.loadingJoints = {};
	while true do
		local key2 = key .. string.format(".joint(%d)",num); 
		if not hasXMLProperty(xmlFile, key2) then
			break;
		end;	
		local trunk1Id = getXMLInt(xmlFile, key2.."#trunk1Id");
		local trunk2Id = getXMLInt(xmlFile, key2.."#trunk2Id");
		
		local trunk1 = self.trunksForJointLoadHelp[trunk1Id];
		local trunk2 = self.trunksForJointLoadHelp[trunk2Id];		
		
		local trunk1Pattern = self.harvestableTreesPattern[trunk1.typeIndex][trunk1.treeIndex].trunks[trunk1.trunkIndex];
		local trunk2Pattern = self.harvestableTreesPattern[trunk2.typeIndex][trunk2.treeIndex].trunks[trunk2.trunkIndex];

		local e = {};
		e.trunk1 = trunk1;
		e.trunk2 = trunk2;
		e.trunk1Pattern = trunk1Pattern;
		table.insert(self.loadingJoints, e);
		
		num = num + 1;
	end;
	
	self.trunksForJointLoadHelp = {}
	return true;
end;

function HarvestableTrees:getSaveAttributesAndNodes(nodeIdent)
	g_currentMission.harvestableTrees.trunkIdsSet = false;

	local attributes, nodes = "", "";
		
	for a=1, table.getn(self.treeJoints) do
		local joint = self.treeJoints[a];
		if a > 1 then
			nodes = nodes .. '\n';
		end;
		nodes = nodes .. '		<joint trunk1Id="'..joint.trunk1.saveHelpId..'" trunk2Id="'..joint.trunk2.saveHelpId..'" />'; 
	end;
	
	self.saveTrunkCount = 0;
	
	return attributes, nodes;
end;

function HarvestableTrees:plantNewHarvestableTree(x, y, z, rx, ry, rz, typeIndex, treeIndex)
	local treePattern = self.harvestableTreesPattern[typeIndex][treeIndex];
	
	local trunks = {}
	
	for a=1, table.getn(treePattern.trunks) do
		local trunkPattern = treePattern.trunks[a];
		local nodeId = clone(trunkPattern.nodeId, true);
		local trunk = Trunk:new(g_server ~= nil, g_client ~= nil);
		trunk:load(nodeId, x+trunkPattern.loadPos[1], y+trunkPattern.loadPos[2], z+trunkPattern.loadPos[3], rx,ry,rz , typeIndex, treeIndex, a, nil, nil);	
		trunk:register();
		table.insert(trunks, trunk);
	end;
	
	for a=1, table.getn(treePattern.trunks) do
		for b=1, table.getn(treePattern.trunks[a].joints) do
			local e = treePattern.trunks[a].joints[b];
			self:joinTrunks(trunks[a], trunks[e.trunkIndex2], e.jointNodeIndex, e.cutDuration, b);
		end;
	end;
end;

function HarvestableTrees:getTrunkNodeId(treeTypeNum, treeIndex, trunkIndex)
	local treePattern = self.harvestableTreesPattern[treeTypeNum][treeIndex];
	local nodeId = clone(treePattern.trunks[trunkIndex].nodeId, true);
	return nodeId;
end;

function HarvestableTrees:joinTrunks(trunk1, trunk2, jointNodeIndex, cutDuration, jointTableIndex)
	setTranslation(trunk1.nodeId, unpack(trunk1.pos));
	setRotation(trunk1.nodeId, unpack(trunk1.rot));
	setTranslation(trunk2.nodeId, unpack(trunk2.pos));
	setRotation(trunk2.nodeId, unpack(trunk2.rot));
	
	local treePattern = self.harvestableTreesPattern[trunk1.typeIndex][trunk1.treeIndex];
	local jointNode = Utils.indexToObject(trunk1.nodeId, jointNodeIndex);
	
	local joint = {};

	if g_server ~= nil then
		local constr = JointConstructor:new();
		constr:setActors(trunk1.nodeId, trunk2.nodeId);
		constr:setJointTransforms(jointNode, jointNode);
		for a=1, 3 do
			constr:setRotationLimit(a-1, 0, 0);
			constr:setTranslationLimit(a-1, true, 0, 0);
		end;
		joint.jointIndex = constr:finalize();			
		setPairCollision(trunk1.nodeId, trunk2.nodeId, false);
	end;
	
	setSolverIterationCount(trunk1.nodeId, 6);
	setSolverIterationCount(trunk2.nodeId, 6);
	
	joint.jointNode = jointNode;
	joint.jointNodeIndex = jointNodeIndex;
	joint.cutDuration = cutDuration;

	joint.jointTableIndex = jointTableIndex;
	
	joint.trunk1 = trunk1;
	joint.trunk2 = trunk2;
	table.insert(trunk1.jointsToOtherTrunks, joint);
	table.insert(trunk2.jointsToOtherTrunks, joint);
	
	table.insert(self.treeJoints, joint);
end;

addModEventListener(HarvestableTrees);