-- author: rafftnix
-- date: 23.01.2013
-- incorporates with workRPM.lua

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

ForrestHoe = {};

function ForrestHoe.prerequisitesPresent(specializations)
    return true;
end;

function ForrestHoe:load(xmlFile)
	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
	self.setHasTreeContact = SpecializationUtil.callSpecializationsFunction("setHasTreeContact");
	self.woodContactReport = ForrestHoe.woodContactReport;
	self.woodTriggerCallback = ForrestHoe.woodTriggerCallback;
	if self.stopDamageCalculation == nil then
		self.stopDamageCalculation = ForrestHoe.stopDamageCalculation;
	end;
	
	self.woodContactNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forrestHoe#contactNodeIndex")); 
	self.woodTriggerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forrestHoe#triggerNodeIndex")); 
	self.rotaryHoe = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forrestHoe#rotaryHoeIndex")); 
	
	if self.isServer then
		if self.woodContactNode ~= nil then
			addContactReport(self.woodContactNode, 0.0001, "woodContactReport", self);
		elseif self.woodTriggerNode ~= nil then
			addTrigger(self.woodTriggerNode, "woodTriggerCallback", self);
		end;
	end;
	
	self.shapeSpeedFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.forrestHoe#shapeSpeedFactor"), 1);
	self.woodContactTimer = 0;
	self.woodContactTimerTime = self.shapeSpeedFactor * 2000;
	self.trunkToDelete = nil;
	self.isTurnedOn = false;
	self.hasTreeContact = false;
	
	self.rotaryHoeAc = 0.001;
	self.rotaryHoeMaxSpeed = 0.1;
	self.rotaryHoeSpeed = 0;
	
	self.woodChipParticle = {}
	Utils.loadParticleSystem(xmlFile, self.woodChipParticle, "vehicle.forrestHoe.particleSystem", self.components, false, "machinery/AhwiForstfraese/woodChipPS.i3d", self.baseDirectory); 

	self.hoeGui = {}
	self.hoeGui.x = 0.875;
	self.hoeGui.y = 0.25;
	self.hoeGui.w = 0.075;
	self.hoeGui.h = 0.1;
	
	self.hoeGui.till = Overlay:new("till", Utils.getFilename(getXMLString(xmlFile, "vehicle.forrestHoe.gui#tillImg"), self.baseDirectory), self.hoeGui.x, self.hoeGui.y, self.hoeGui.w, self.hoeGui.h);	

	local key = "vehicle.forrestHoe.sounds.hoeSound";
	local hoeSoundFile = getXMLString(xmlFile, key.."#file");
	if hoeSoundFile ~= nil then
		self.hoeSound = {}
		local sound = self.hoeSound;
		
		local filename = Utils.getFilename(hoeSoundFile, self.baseDirectory);
		local radius = Utils.getNoNil(getXMLFloat(xmlFile, key.."#radius"), 10);
		local innerRadius = Utils.getNoNil(getXMLFloat(xmlFile, key.."#innerRadius"), 1);
		local volume = Utils.getNoNil(getXMLFloat(xmlFile, key.."#volume"), 1);
		local pitch = Utils.getNoNil(getXMLFloat(xmlFile, key.."#pitch"), 1);
		
		sound.source = createAudioSource("hoeSound", filename, radius, innerRadius, volume, 0);
		sound.sample = getAudioSourceSample(sound.source);
		setSamplePitch(sound.sample, pitch);
		link(self.components[1].node, sound.source);
		
		sound.volume = volume;
		sound.pitch = pitch;
		
		setVisibility(sound.source, false);
	end;
	
	local key = "vehicle.forrestHoe.sounds.workSound";
	local workSoundFile = getXMLString(xmlFile, key.."#file");
	if workSoundFile ~= nil then
		self.workSound = {}
		local sound = self.workSound;
		
		local filename = Utils.getFilename(workSoundFile, self.baseDirectory);
		local radius = Utils.getNoNil(getXMLFloat(xmlFile, key.."#radius"), 10);
		local innerRadius = Utils.getNoNil(getXMLFloat(xmlFile, key.."#innerRadius"), 1);
		local volume = Utils.getNoNil(getXMLFloat(xmlFile, key.."#volume"), 1);
		local pitch = Utils.getNoNil(getXMLFloat(xmlFile, key.."#pitch"), 1);
		
		sound.source = createAudioSource("workSound", filename, radius, innerRadius, volume, 0);
		sound.sample = getAudioSourceSample(sound.source);
		setSamplePitch(sound.sample, pitch);
		link(self.components[1].node, sound.source);
		
		sound.volume = volume;
		sound.pitch = pitch;
		
		setVisibility(sound.source, false);
	end;
end;

function ForrestHoe:delete()
	if self.woodChipParticle ~= nil then
		Utils.deleteParticleSystem(self.woodChipParticle);
	end;
	if self.woodTriggerNode ~= nil then
		removeTrigger(self.woodTriggerNode);
	end;
	if self.woodContactNode ~= nil then
		removeContactReport(self.woodContactNode);
	end;
end;

function ForrestHoe:readStream(streamId, connection)
	self:setIsTurnedOn(streamReadBool(streamId), true);
	self:setHasTreeContact(streamReadBool(streamId));
end;
 
function ForrestHoe:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isTurnedOn);
	streamWriteBool(streamId, self.hasTreeContact);
end;
 
function ForrestHoe:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ForrestHoe:keyEvent(unicode, sym, modifier, isDown)
end;

function ForrestHoe:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self:setIsTurnedOn(not self.isTurnedOn);
		end;
	end;
	
	if self.rotaryHoe ~= nil then
		rotate(self.rotaryHoe, -(dt*self.rotaryHoeSpeed), 0, 0);
	end;
end;

function ForrestHoe:updateTick(dt)
	if self.hasTreeContact and self.isTurnedOn then
		self.woodContactTimer = math.max(0, self.woodContactTimer-dt);
		if self.isServer then
			if self.trunkToDelete ~= nil then
				if self.woodContactTimer == 0 then
					self.trunkToDelete:delete();
					self.trunkToDelete = nil;
				end;
			elseif self.hasTreeContact then
				self:setHasTreeContact(false);
			end;
		end;
	end;
	
	if self.isTurnedOn then
		self.rotaryHoeSpeed = math.min(self.rotaryHoeSpeed+self.rotaryHoeAc, self.rotaryHoeMaxSpeed);
	else
		self.rotaryHoeSpeed = math.max(self.rotaryHoeSpeed-self.rotaryHoeAc, 0);
	end;
end;

function ForrestHoe:draw()
	if self.isTurnedOn then
		g_currentMission:addHelpButtonText(g_i18n:getText("turn_off_ForrestHoe"), InputBinding.IMPLEMENT_EXTRA);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("turn_on_ForrestHoe"), InputBinding.IMPLEMENT_EXTRA);
	end;
	if self.hasTreeContact and self.isTurnedOn then
		self.hoeGui.till:render();
		setTextBold(false);
		setTextColor(0.803, 0.803, 0.803, 1);
		renderText(0.875, 0.275, 0.045, tostring(math.floor((self.woodContactTimer / self.woodContactTimerTime)*100)).."%");
		setTextColor(1, 1, 1, 1);
	end;
end;

function ForrestHoe:setIsTurnedOn(isTurnedOn, noEventSend)
	if not noEventSend then
		SetTurnedOnEvent.sendEvent(self, isTurnedOn, noEventSend);
	end;
	if not isTurnedOn then
		self:setHasTreeContact(false);
	end;
	setVisibility(self.hoeSound.source, isTurnedOn);
	self.isTurnedOn = isTurnedOn;
end;

function ForrestHoe:woodContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)
	local trunk = g_currentMission.treeManager.nodeIdToTrunk[otherObjectId];
	if trunk ~= nil then
		if isStart then -- contact
			self.trunkToDelete = trunk;
			self:setHasTreeContact(true); 
		elseif (normalForce == 0 and tangentialForce == 0) and not self.isTurnedOn then -- no contact
			self.trunkToDelete = nil;
			self:setHasTreeContact(false);
		end;
	end;
end;

function ForrestHoe:woodTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	local trunk = g_currentMission.treeManager.nodeIdToTrunk[otherId];
	if trunk ~= nil then
		if onEnter then 
			self.trunkToDelete = trunk;
			self:setHasTreeContact(true); 
		elseif onLeave then 
			self.trunkToDelete = nil;
			self:setHasTreeContact(false);
		end;
	end;
end;

function ForrestHoe:setHasTreeContact(hasContact) 
	if hasContact then
		self.woodContactTimer = self.woodContactTimerTime;
	end;
	
	if hasContact ~= self.hasTreeContact and self.isServer then
		ForrestHoeTreeContactEvent.sendEvent(self, hasContact);
	end;
	
	setVisibility(self.workSound.source, hasContact and self.isTurnedOn);
	
	self.hasTreeContact = hasContact;
	Utils.setEmittingState(self.woodChipParticle, hasContact and self.isTurnedOn);
end;

function ForrestHoe:onDetach()
	self:setIsTurnedOn(false, true);
end;

function ForrestHoe:onDeactivate()
	self:setIsTurnedOn(false, true);
end;

function ForrestHoe:stopDamageCalculation(objectId, otherObjectId, isStart, normalForce, tangentialForce, vehicle)
	if g_currentMission.treeManager ~= nil then
		if g_currentMission.treeManager.nodeIdToTrunk ~= nil then
			if g_currentMission.treeManager.nodeIdToTrunk[otherObjectId] ~= nil then
				return false;
			end;
		end;
	end;
	return true;
end;