-- author: rafftnix
-- date: 16.12.2012

RemoveTrunkJointEvent = {};
RemoveTrunkJointEvent_mt = Class(RemoveTrunkJointEvent, Event);
InitEventClass(RemoveTrunkJointEvent, "RemoveTrunkJointEvent");

function RemoveTrunkJointEvent:emptyNew()
    local self = Event:new(RemoveTrunkJointEvent_mt);
    self.className="RemoveTrunkJointEvent";
    return self;
end;

function RemoveTrunkJointEvent:new(object, id)
    local self = RemoveTrunkJointEvent:emptyNew(); 
    self.object = object; 
	self.id = id;
    return self;
end;

function RemoveTrunkJointEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.id);
end;

function RemoveTrunkJointEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	self.id = streamReadInt8(streamId);
    self:run(connection);
end;

function RemoveTrunkJointEvent:run(connection)
	self.object:removeTrunkJoint(self.id, 0,0,0);
end;