-- author rafftnix
-- date 16.12.2012


PlaceNewTreeEvent = {};
PlaceNewTreeEvent_mt = Class(PlaceNewTreeEvent, Event);
InitEventClass(PlaceNewTreeEvent, "PlaceNewTreeEvent");
function PlaceNewTreeEvent:emptyNew()
    local self = Event:new(PlaceNewTreeEvent_mt);
    self.className="PlaceNewTreeEvent";
    return self;
end;

function PlaceNewTreeEvent:new(treeTypeNum, x, y, z, scale, yRotation, treeIndex)
    local self = PlaceNewTreeEvent:emptyNew(); 
	self.treeTypeNum = treeTypeNum;
	self.x = x;
	self.z = z;
	self.scale = scale;
	self.yRotation = yRotation;
	self.treeIndex = treeIndex;
    return self;
end;

function PlaceNewTreeEvent:writeStream(streamId, connection)
    streamWriteInt8(streamId, self.treeTypeNum);
	streamWriteFloat32(streamId, self.x);
	streamWriteFloat32(streamId, self.z);
	streamWriteInt8(streamId, self.scale);
	streamWriteInt8(streamId, self.yRotation);
	streamWriteInt8(streamId, self.treeIndex);
end;

function PlaceNewTreeEvent:readStream(streamId, connection)
    self.treeTypeNum = streamReadInt8(streamId);
	self.x = streamReadFloat32(streamId);
	self.z = streamReadFloat32(streamId);
	self.scale = streamReadInt8(streamId);
	self.yRotation = streamReadInt8(streamId);
	self.treeIndex = streamReadInt8(streamId);
	
    self:run(connection);
end;

function PlaceNewTreeEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(PlaceNewTreeEvent:new(self.treeTypeNum, self.x, 0, self.z, self.scale, self.yRotation, self.treeIndex), nil, connection, nil);
	end; 

	-- prepare the information for using
	self.treeType = TreeManager.treeTypes[self.treeTypeNum].treeType;
	self.scale = self.scale/100; -- percent
	self.yRotation = math.rad(self.yRotation * 3);
	
	TreeManager:placeNewTree(self.treeType, self.x, 0, self.z, self.scale, self.yRotation, self.treeIndex, true); 
end;

function PlaceNewTreeEvent.sendEvent(treeType, x, y, z, scale, yRotation, treeIndex, noEventSend)
	if noEventSend == nil or noEventSend == false then 
		-- prepare the information for sending
		treeTypeNum = TreeManager.treeTypes[treeType].num;
		-- we dont need to send y to the other clients
		scale = scale * 100; -- percent
		yRotation = math.floor(math.deg(yRotation)/3);
	
		if g_server ~= nil then   
			g_server:broadcastEvent(PlaceNewTreeEvent:new(treeTypeNum, x, y, z, scale, yRotation, treeIndex), nil, nil, nil); 
		else  
			g_client:getServerConnection():sendEvent(PlaceNewTreeEvent:new(treeTypeNum, x, y, z, scale, yRotation, treeIndex)); 
		end;
	end;
end;