-- author: rafftnix
-- date: 31.12.2012

OutriggerEvent = {};
OutriggerEvent_mt = Class(OutriggerEvent, Event);
InitEventClass(OutriggerEvent, "OutriggerEvent");
function OutriggerEvent:emptyNew()
    local self = Event:new(OutriggerEvent_mt);
    self.className="OutriggerEvent";
    return self;
end;

function OutriggerEvent:new(object, active)
    local self = OutriggerEvent:emptyNew(); 
    self.object = object; 
	self.active = active;
    return self;
end;

function OutriggerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.active);
end;

function OutriggerEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.active = streamReadBool(streamId);
    self:run(connection);
end;

function OutriggerEvent:run(connection)
	self.object:setOutriggerState(self.active, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(OutriggerEvent:new(self.object, self.active), nil, connection, self.object);
	end; 
end;

function OutriggerEvent.sendEvent(object, active, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(OutriggerEvent:new(object, active), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(OutriggerEvent:new(object, active)); 
		end;
	end;
end;