-- author: rafftnix
-- date: 22.03.2013

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!


BioHeatPlant = {}

local BioHeatPlant_mt = Class(BioHeatPlant, StorageTipTrigger);

function onCreateBHT(self, id)
	local bht = BioHeatPlant:new(g_server ~= nil, g_client ~= nil);
	if bht:load(id) then
		g_currentMission:addOnCreateLoadedObject(bht);
		bht:register(true);
		g_currentMission:addOnCreateLoadedObjectToSave(bht);
	else
		bht:delete();
	end;
end;

function BioHeatPlant:new(isServer, isClient, customMt)
	if customMt == nil then
		customMt = BioHeatPlant_mt;
	end;
    local self = StorageTipTrigger:new(isServer, isClient, customMt);

    return self;
end;

function BioHeatPlant:load(id)
	StorageTipTrigger.load(self, id);

	self.substanceUsage = Utils.getNoNil(getUserAttribute(id, "substanceUsage"), 5000) / 86400000; -- usage per outgame-day
	self.efficiency = Utils.getNoNil(getUserAttribute(id, "efficiency"), 0.5);
	self.today = g_currentMission.environment.currentDay;
	self.warningTimer = 0;
	self.warningTimerTime = 6000;
	self.todaysEarnings = 0;
	
    return true;
end;

function BioHeatPlant:delete()
	g_currentMission:removeOnCreateLoadedObjectToSave(self);

	StorageTipTrigger.delete(self);
	removeTimer(self.synchTimer);
end;

function BioHeatPlant:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	StorageTipTrigger.loadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	
	self.todaysEarnings = Utils.getNoNil(getXMLFloat(xmlFile, key.."#todaysEarnings"), 0);
	
	return true;
end;
	
function BioHeatPlant:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = StorageTipTrigger.getSaveAttributesAndNodes(self, nodeIdent);
	attributes = attributes..' todaysEarnings="'..tostring(math.floor(self.todaysEarnings))..'"';
	return attributes, nodes;
end;

function BioHeatPlant:update(dt)
	StorageTipTrigger.update(self, dt);
	
	if self.warningTimer > 0 and self.showFillLevel then
		g_currentMission:addWarning(g_i18n:getText("BioHeatPlant_full"), 0.018, 0.033);
	end;
end;

function BioHeatPlant:synchFillLevelTimer()
	if self.fillLevel > 0 then
		self:raiseDirtyFlags(self.storageTipTriggerDirtyFlag);
	end;
	return true;
end;

function BioHeatPlant:updateTick(dt)
	if self.firstRunDone == nil then
		self.firstRunDone = true;
		if self.isServer then
			self.synchTimer = addTimer(3000, "synchFillLevelTimer", self);
		end;
	end;

	if StorageTipTrigger.updateTick ~= nil then
		StorageTipTrigger.updateTick(self, dt);
	end;

	if self.warningTimer > 0 then
		self.warningTimer = self.warningTimer - dt;
	end;
	
	if self.fillLevel == self.capacity then
		self.warningTimer = self.warningTimerTime;
	end;
	
	if g_server ~= nil then
		if self.fillLevel > 0 then
			local amount = math.min((dt * self.substanceUsage) * g_currentMission.missionStats.timeScale, self.fillLevel);
			self.fillLevel = self.fillLevel - amount;
			self.todaysEarnings = self.todaysEarnings + (amount * self.efficiency * (4-g_currentMission.missionStats.difficulty));
		end;
		
		if self.today ~= g_currentMission.environment.currentDay then
			g_currentMission:addSharedMoney(self.todaysEarnings);
			self.todaysEarnings = 0;
			self.today = g_currentMission.environment.currentDay;
		end;
	end;
end;