-- author: rafftnix
-- date: 23.01.2014

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

-- plays an ambient sound near a random tree

AmbientSounds = {}
AmbientSounds.modDir = g_currentModDirectory;
local AmbientSounds_mt = Class(AmbientSounds);

function AmbientSounds:new(mt)
	if mt == nil then
		mt = AmbientSounds_mt;
	end;
	
	local self = {}
	
	setmetatable(self, mt);
	
	self.ambientSounds = {}
	self.timer = nil;
	self.currentSound = nil;
	
	g_currentMission:addNonUpdateable(self);
	
	self:registerSound("sounds/birdsChirping01.wav", 200, 50, 1);
	self:registerSound("sounds/birdsChirping02.wav", 200, 50, 1);
	
	return self;
end;

function AmbientSounds:delete()
	for a=1, table.getn(self.ambientSounds) do
		unlink(self.ambientSounds[a].source);
		delete(self.ambientSounds[a].source);
	end;
	
	removeTimer(self.timer);
end;

function AmbientSounds:registerSound(filename, radius, innerRadius, volume)
	local sound = {}
	sound.source = createAudioSource("ambientSound", Utils.getFilename(filename, AmbientSounds.modDir), radius, innerRadius, volume, 1);
	sound.sample = getAudioSourceSample(sound.source);
	sound.volume = volume;
	link(getRootNode(), sound.source);
	setVisibility(sound.source, false);
	
	table.insert(self.ambientSounds, sound);
end;

function AmbientSounds:startSounds()
	self.timer = addTimer(1, "timerCallback", self);
end;

function AmbientSounds:timerCallback()
	-- disable last sound
	if self.currentSound ~= nil then
		setVisibility(self.currentSound.source, false);
	end;
	
	-- find place to play ambient sound
	local x, y, z = 0, 0, 0;
	if table.getn(g_currentMission.treeManager.growingTrees) > 3 and math.random(0,1) > 0 then -- growing trees
		local index = math.random(1, table.getn(g_currentMission.treeManager.growingTrees));
		local tree = g_currentMission.treeManager.growingTrees[index];
		x, y, z = getWorldTranslation(tree.tree);
	elseif table.getn(g_currentMission.treeManager.nodeIdToTrunk) > 3 then -- harvestable trees
		local num = math.random(0, table.getn(g_currentMission.treeManager.nodeIdToTrunk));
		local num2 = 0;
		for nodeId, trunk in pairs(g_currentMission.treeManager.nodeIdToTrunk) do
			num2 = num2 + 1;
			if num == num2 then
				x, y, z = getWorldTranslation(trunk.nodeId);
				break;
			end;
		end;
	end;
	
	if x ~= 0 then
		local sound = self.ambientSounds[math.random(1, table.getn(self.ambientSounds))];
		self.currentSound = sound;
		x = math.random(x-5, x+5);
		y = math.random(y+1, y+5);
		z = math.random(z-5, z+5);
		setTranslation(sound.source, sx, sy, sz);
		setVisibility(sound.source, true);
		playSample(sound.sample, 1, sound.volume, 0);
		
		setTimerTime(self.timer, getSampleDuration(sound.sample));
	else
		setTimerTime(self.timer, 2000);
	end;
	
	return true;
end;