-- author: rafftnix
-- date: 23.01.2013


AdditionalCamera = {};

function AdditionalCamera.prerequisitesPresent(specializations)
    return true;
end;

function AdditionalCamera:load(xmlFile)
	self.additionalCams = {}
	local num = 0;
	while true do
		local key = "vehicle.additionalCameras.additionalCamera("..tostring(num)..")";
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local cam = VehicleCamera:new(self);
		cam:loadFromXML(xmlFile, key);
		cam.additionalCamOwner = self;
		table.insert(self.additionalCams, cam);
		num = num + 1;
	end;

	self.additionalCamAddedTo = nil;
end;

function AdditionalCamera:delete()
	if self.additionalCamAddedTo ~= nil then
		local vehicle = self.additionalCamAddedTo;
		if vehicle.cameras[vehicle.camIndex].additionalCamOwner == self then
			vehicle.cameras[vehicle.camIndex]:onDeactivate();
			vehicle.camIndex = vehicle.camIndex + 1;
			vehicle.camIndex = 1;
			vehicle.cameras[vehicle.camIndex]:onActivate();
		end;
	end;
end;

function AdditionalCamera:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AdditionalCamera:keyEvent(unicode, sym, modifier, isDown)
end;

function AdditionalCamera:update(dt)

end;

function AdditionalCamera:draw()
  
end;

function AdditionalCamera:onAttach(attacherVehicle) 
	local vehicle = attacherVehicle;
	while true do
		if vehicle.attacherVehicle ~= nil then
			vehicle = vehicle.attacherVehicle;
		else
			break;
		end;
	end;

	for a=1, table.getn(self.additionalCams) do
		vehicle.numCameras = vehicle.numCameras + 1;
		table.insert(vehicle.cameras, self.additionalCams[a]);
	end;
	self.additionalCamAddedTo = vehicle;
end;

function AdditionalCamera:onDetach()
	local vehicle = self.additionalCamAddedTo;
	
	if vehicle.cameras[vehicle.camIndex].additionalCamOwner == self then
		vehicle.cameras[vehicle.camIndex]:onDeactivate();
		vehicle.camIndex = vehicle.camIndex + 1;
		vehicle.camIndex = 1;
		vehicle.cameras[vehicle.camIndex]:onActivate();
	end;

	local numRemovedCameras = 0;
	for a=1, table.getn(vehicle.cameras) do
		if vehicle.cameras[a-numRemovedCameras].additionalCamOwner == self then
			table.remove(vehicle.cameras, a-numRemovedCameras);
			vehicle.numCameras = vehicle.numCameras - 1;
			numRemovedCameras = numRemovedCameras + 1;
		end;
	end;
	
	self.additionalCamAddedTo = nil;
end;