-- author: rafftnix, fruktor
-- date: 28.11.2013

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

-- This script regulates the speed of moving tools


AdaptableMovingToolSpeed = {}

function AdaptableMovingToolSpeed.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function AdaptableMovingToolSpeed:load(xmlFile)
	self.setMovingToolsSpeedFactor = SpecializationUtil.callSpecializationsFunction("setMovingToolsSpeedFactor");

	self.currentMovingToolSpeedFactor = 1;
	self.adaptableMovingToolSpeedFactorAcc = Utils.getNoNil(getXMLString(xmlFile, "vehicle.adaptableMovingToolSpeed#speed"), 0.002);
	
	for a=1, table.getn(self.movingTools) do
		local tool = self.movingTools[a];
		if tool.rotSpeed ~= nil then
			tool.rotSpeedBackupAMT = tool.rotSpeed;
		end;
		if tool.transSpeed ~= nil then
			tool.transSpeedBackupAMT = tool.transSpeed;
		end;
	end;	
end;

function AdaptableMovingToolSpeed:delete()
  
end;

function AdaptableMovingToolSpeed:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local speedFactor = getXMLFloat(xmlFile, key .. "#movingToolSpeedFactor");
	if speedFactor ~= nil then
		self:setMovingToolsSpeedFactor(speedFactor);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function AdaptableMovingToolSpeed:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'movingToolSpeedFactor="'..tostring(math.floor(100*self.currentMovingToolSpeedFactor)/100)..'"';
	return attributes, "";
end;

function AdaptableMovingToolSpeed:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AdaptableMovingToolSpeed:keyEvent(unicode, sym, modifier, isDown)
end;

function AdaptableMovingToolSpeed:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.SETMOVINGTOOLSPEEDUP) then
			local speedFactor = math.max(math.min(self.currentMovingToolSpeedFactor+self.adaptableMovingToolSpeedFactorAcc, 20), self.adaptableMovingToolSpeedFactorAcc);
			self:setMovingToolsSpeedFactor(speedFactor);
		end;
		if InputBinding.isPressed(InputBinding.SETMOVINGTOOLSPEEDDOWN) then
			local speedFactor = math.max(math.min(self.currentMovingToolSpeedFactor-self.adaptableMovingToolSpeedFactorAcc, 20), self.adaptableMovingToolSpeedFactorAcc);
			self:setMovingToolsSpeedFactor(speedFactor);
		end;
	end;
end;

function AdaptableMovingToolSpeed:updateTick(dt)
	
end;

function AdaptableMovingToolSpeed:draw()
	text = string.gsub(g_i18n:getText("movingToolSpeed"), "speedFactor", math.floor(self.currentMovingToolSpeedFactor * 100)); 
	g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.SETMOVINGTOOLSPEEDUP).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.SETMOVINGTOOLSPEEDDOWN)..": "..text);
end;

function AdaptableMovingToolSpeed:setMovingToolsSpeedFactor(speedFactor)
	self.currentMovingToolSpeedFactor = speedFactor;
	
	for k, tool in pairs(self.movingTools) do 
		if tool.rotSpeedBackupAMT ~= nil then
			tool.rotSpeed = self.currentMovingToolSpeedFactor * tool.rotSpeedBackupAMT;
		end;
		if tool.transSpeedBackupAMT ~= nil then
			tool.transSpeed = self.currentMovingToolSpeedFactor * tool.transSpeedBackupAMT;
		end;
	end;	
	
	if self.activeMC ~= nil and self.setActiveMC ~= nil then 
		self:setActiveMC(self.activeMC);
	end;
end;