RealisticUtils = {};


--fx must be between 0 and 1
RealisticUtils.linearFx = function(fx, minVal, maxVal)
	return minVal + fx * (maxVal-minVal);
end;


RealisticUtils.getNewStationPriceMultiplier = function(baseMultiplier)
	--return baseMultiplier * (0.85 + 0.3*math.random()); -- 15% more or less => between 0.85 and 1.15 of the genuine price multiplier	
	return baseMultiplier * (0.6 + 0.7*math.random()); -- between 40% less and 30% more => between 0.6 and 1.3 of the genuine price multiplier	
end;


RealisticUtils.getFillTypeInfosV2 = function(fillTypeName)
	
	-- pricePerKg of some fruit/filltype should NEVER be 0
	-- example : grass. there is some random computation done by the game engine at some times, and when you play in mp, the client game will crash (only XP OS)
	
	local density = 0.75; --kg/L
	local pricePerKg = 1; --/T
	local found = false;

	if fillTypeName~=nil and fillTypeName~="" then
	
		found = true;
		
		if fillTypeName=="wheat" then
			density, pricePerKg = 0.79, 0.200; -- 200/T
		elseif fillTypeName=="barley" then
			density, pricePerKg = 0.71, 0.195; -- 195/T
		elseif fillTypeName=="maize" then
			density, pricePerKg = 0.82, 0.190; -- 190/T
		elseif fillTypeName=="rape" then
			density, pricePerKg = 0.64, 0.400; -- 400/T
		elseif fillTypeName=="chaff" or fillTypeName=="forage" then
			density, pricePerKg = 0.40, 0.040; -- 2000/ha =>	2000/50T => 40/T			
		elseif fillTypeName=="sugarBeet" then
			density, pricePerKg = 0.69, 0.040; --40/T
		elseif fillTypeName=="potato" then
			density, pricePerKg = 0.67, 0.065; --65/T. should be something like 150-200/T but in the game, we do not have to irrigate, prepare the soil, weed or clean/wash/sort the potatoes
			
			
		elseif fillTypeName=="sunflower" then
			density, pricePerKg = 0.42, 0.480; -- 480/T (should be 380/T, but since the yield is lower than rape, we put the high figure here to compensate for gameplay)
		elseif fillTypeName=="rye" then -- seigle
			density, pricePerKg = 0.73, 0.180; -- 180/T
			
		elseif fillTypeName=="pea" then
			density, pricePerKg = 0.81, 0.340; -- 340/T
		elseif fillTypeName=="bean" then
			density, pricePerKg = 0.84, 0.350; -- 350/T
		elseif fillTypeName=="linseed" then
			density, pricePerKg = 0.72, 0.800; -- 800/T
			
		elseif fillTypeName=="oat" then
			density, pricePerKg = 0.54, 0.275; -- 275/T	
			
		elseif fillTypeName=="carrot" then
			density, pricePerKg = 0.64, 0.175; -- 175/T	
		elseif fillTypeName=="onion" then
			density, pricePerKg = 0.61, 0.110; -- 110/T	
			
		--20131217 - new fruits
		elseif fillTypeName=="soybean" then
			density, pricePerKg = 0.8, 0.550; -- 550/T
		elseif fillTypeName=="rice" then
			density, pricePerKg = 0.68, 0.430; -- 430/T
		elseif fillTypeName=="greenWheat" then
			density, pricePerKg = 0.65, 0.050; -- 50/T
			
		
		elseif fillTypeName=="manure" then
			density, pricePerKg = 0.65, 0.020;	--20/T
		elseif fillTypeName=="liquidManure" then
			density, pricePerKg = 0.92, 0.007;	--7/T
			
		--seed prices are already defined in getFruitInfosV2 (this is the seedPrice parameter of fruitType)
		elseif fillTypeName=="seeds_wheat" then
			density, pricePerKg = 0.72, 0;	
		elseif fillTypeName=="seeds_barley" then
			density, pricePerKg = 0.63, 0;	
		elseif fillTypeName=="seeds_maize" then
			density, pricePerKg = 0.76, 0;	
		elseif fillTypeName=="seeds_rape" then
			density, pricePerKg = 0.6, 0;	
		elseif fillTypeName=="seeds_grass" then
			density, pricePerKg = 0.2, 0;	
		elseif fillTypeName=="seeds_potato" then
			density, pricePerKg = 0.67, 0; -- same density as potato fillType
		elseif fillTypeName=="seeds_sugarBeet" then
			density, pricePerKg = 0.67, 0; -- sugar beet seeds + refinement and pesticide
			
		elseif fillTypeName=="seeds_sunflower" then
			density, pricePerKg = 0.4, 0;
		elseif fillTypeName=="seeds_rye" then -- seigle
			density, pricePerKg = 0.67, 0;	
			
		elseif fillTypeName=="seeds_oat" then -- avoine
			density, pricePerKg = 0.52, 0;		
			
		elseif fillTypeName=="seeds_carrot" then
			density, pricePerKg = 0.45, 0;	
		elseif fillTypeName=="seeds_onion" then
			density, pricePerKg = 0.45, 0;	
			
		--20131217 - new fruits	
		elseif fillTypeName=="seeds_soybean" then
			density, pricePerKg = 0.75, 0;	
		elseif fillTypeName=="seeds_rice" then
			density, pricePerKg = 0.66, 0;	
		elseif fillTypeName=="seeds_greenWheat" then
			density, pricePerKg = 0.72, 0;	
		
		elseif fillTypeName=="silage" then
			density, pricePerKg = 0.4, 0.175*RealisticGlobalListener.silagePriceBalancing;	--175/T   compress silage = 0.85 density / uncompressed = 0.4
		elseif fillTypeName=="forage_mixing" then
			density, pricePerKg = 0.2, 0.250; --250/T
			
		elseif fillTypeName=="wheat_windrow" then
			density, pricePerKg = 0.040, 0.040*RealisticGlobalListener.windrowPriceBalancing;	--40/T
		elseif fillTypeName=="barley_windrow" then
			density, pricePerKg = 0.036, 0.044*RealisticGlobalListener.windrowPriceBalancing;	--44/T
		elseif fillTypeName=="dryGrass_windrow" or fillTypeName=="dryGrass" then
			density, pricePerKg = 0.050, 0.085*RealisticGlobalListener.windrowPriceBalancing; -- 85/T			
		elseif fillTypeName=="grass_windrow" or fillTypeName=="grass" then
			density, pricePerKg = 0.25, 0.015*RealisticGlobalListener.windrowPriceBalancing; -- 15/T	    	
			
		elseif fillTypeName=="oat_windrow" then
			density, pricePerKg = 0.045, 0.054*RealisticGlobalListener.windrowPriceBalancing;	--54/T	
			
		--20131217 - new fruits	
		elseif fillTypeName=="rice_windrow" then
			density, pricePerKg = 0.035, 0.025*RealisticGlobalListener.windrowPriceBalancing;	--25/T
			
			
		elseif fillTypeName=="fuel" then
			density, pricePerKg = RealisticGlobalListener.fuelDensity, 1.025*RealisticGlobalListener.fuelPriceBalancing;	--0.85/L == 1.025/Kg.  
		elseif fillTypeName=="fertilizer" then
			density, pricePerKg = 1.28, 0.190*RealisticGlobalListener.fertilizerPriceBalancing;	--230/M3 == 190/T.   factor 4 to balance gameplay
			
		elseif fillTypeName=="milk" then
			density, pricePerKg = 1.03, 0.97*RealisticGlobalListener.milkPriceBalancing; -- 1/L  this is the "real" price with no government help(cost production)  -> price wanted in game = 
		elseif fillTypeName=="egg" then
			density, pricePerKg = 0.37, 1.35*RealisticGlobalListener.eggPriceBalancing; -- density of an egg box, price = 0.50 per egg for not-industrial eggs (1 egg = 60g)   the pricePerLiter for egg = price for 1 egg in the game.   Factor 10 to balance gameplay (you have to manually pick up eggs in the game)
		elseif fillTypeName=="wool" then -- 50kg/m3
			density, pricePerKg = 0.05, 1*RealisticGlobalListener.woolPriceBalancing;	-- "real" price = 1/kg -- wanted price ingame (hard difficulty) = 1/L -> 20/kg (there is already the priceBalancing applied, that means we need a woolPriceBalancing of 4)
			
		elseif fillTypeName=="water" then
			density, pricePerKg = 1, 0;
			
		elseif fillTypeName=="pig" then
			density, pricePerKg = 100, 1.75*RealisticGlobalListener.pigPriceBalancing;	-- 100kgs per pig

		elseif fillTypeName=="void" then -- for autostackers
			density, pricePerKg = 0, 0;
			
		else --no filltype matching the input filltypeName
			found = false;
			if Vehicle.debugRendering then
				print("RealisticUtils.getFillTypeInfosV2 - " .. tostring(fillTypeName) .. " not found.");
			end;
		end;
		
	end;--fillTypeName~=nil and fillTypeName~="" 
	
	-- bl 75-85
	-- orge 65-75
	-- mas 75-85
	-- colza 60-69
	-- tournesol 38-48.5
	-- soja 68-78
	-- pois 75-85
	-- ensilage mais : 30-50  70 au tas bien tass
	
	-- betteraves : 0.67
	-- pomme de terre : 0.65-0.7
	
	-- sunflower/tournesol : environ 420kg/M3, prix march autour de 350-400/T
	-- rye/seigle : entre 520 et 740kg/M3, prix march 
	
	
	
	-- price is multiplied by priceBalancing to mach an average 20000$ net profit in hard mode (for 1 ha done manually - no worker) => not realistic, but : who wants to "play" for more than 100 hours to afford a medium size tractor (Geotrac or Same explorer) ?  
	-- it would be too difficult or real if we put the right figures...
	-- and, in reality, you can't buy a new tractor every 10 hours or so of work...
	-- moreover, there are no starting stock in hard mode, there are no pre-seed fields like in FS2011 on the map and we must buy all the fields (there was no field buying in FS2011)
	-- meanwhile, there are great demand in FS2013 that allow the player to earn more if he use its farm silos.
	pricePerKg = RealisticGlobalListener.priceBalancing*pricePerKg;
	local pricePerLiter = density * pricePerKg;
	
	return found, density, pricePerKg, pricePerLiter;
	
	

end;



RealisticUtils.getWindrowLiterPerSqm = function(windrowFillTypeName)

	local found = false;
	local literPerSqm = 10; --default value = 100,000L per hectare

	if windrowFillTypeName~=nil then
		
		found = true;
			
		if windrowFillTypeName=="grass_windrow" then --we want about 35T (140,000 L) per hectare
			literPerSqm = 14;
		elseif windrowFillTypeName=="dryGrass_windrow" then --we want about 7T (140,000L) per hectare
			literPerSqm = 14;
		elseif windrowFillTypeName=="wheat_windrow" then --we want about 5T (125,000L) per hectare
			literPerSqm = 12.5;
		elseif windrowFillTypeName=="barley_windrow" then --we want about 4T (110,000L) per hectare
			literPerSqm = 11;	

		elseif windrowFillTypeName=="rye_windrow" then --we want about 6T (150,000L) per hectare
			literPerSqm = 15;
			
		elseif windrowFillTypeName=="oat_windrow" then --we want about 5.5T (122,000L) per hectare
			literPerSqm = 12.2;	
		
		--20131217 - new fruit
		elseif windrowFillTypeName=="rice_windrow" then --we want about 2.5T (71,500L) per hectare
			literPerSqm = 12.5;	
			
		else
			found = false;
		end;
		
	end;
	
	if Vehicle.debugRendering and not found then
		print("RealisticUtils.getWindrowLiterPerSqm - windrow fill type not found : " .. tostring(windrowFillTypeName));
	end;
	
	return found, literPerSqm;

end;


RealisticUtils.getOutputCompoundFruitLiterPerSqmV2 = function(outputCompoundFruitName)

	local found = false;
	local literPerSqm = 0;

	if outputCompoundFruitName~=nil then
		
		found = true;
			
		if outputCompoundFruitName=="maize_chaff" then
			literPerSqm = 12.5; -- 50T/Ha => (chaff = 0.4 density) 125000L/Ha
		elseif outputCompoundFruitName=="wheat_chaff" then
			literPerSqm = 6.75; -- 27T/Ha => (chaff = 0.4 density) 67500L/Ha
		elseif outputCompoundFruitName=="barley_chaff" then
			literPerSqm = 7.25; -- 29T/Ha => (chaff = 0.4 density) 72500L/Ha
		elseif outputCompoundFruitName=="rape_chaff" then
			literPerSqm = 5.25; -- 21T/Ha => (chaff = 0.4 density) 52500L/Ha
		elseif outputCompoundFruitName=="grass_chaff" then
			literPerSqm = 8.75*1.5; -- 35T/Ha  => (chaff = 0.4 density) 87500L/Ha ---	no fertilizer for grass, and so, we need to multiply by 1.5 here to get the "1.5" factor like other crops 
			
		elseif outputCompoundFruitName=="rye_chaff" then --seigle
			literPerSqm = 8.25; -- 33T/Ha => (chaff = 0.4 density) 82500L/Ha
			
		elseif outputCompoundFruitName=="oat_chaff" then --avoine
			literPerSqm = 7; -- 28T/Ha => (chaff = 0.4 density) 70000L/Ha

		--20131217 - new fruit
		elseif outputCompoundFruitName=="greenWheat_chaff" then
			literPerSqm = 8.25; -- 33T/Ha => (chaff = 0.4 density) 82500L/Ha
			
		else
			found = false;
		end;
		
	end;
	
	if Vehicle.debugRendering and not found then
		print("RealisticUtils.getOutputCompoundFruitLiterPerSqmV2 - compound fruit not found : " .. tostring(outputCompoundFruitName));
	end;
	
	return found, literPerSqm*0.75; -- considering the "2" factor when fertilized, that means 50% more yield than actual figures	

end;


RealisticUtils.getFruitInfosV2 = function(fruitName)
	
	-- price per liter
	local seedPrice = 0.5; -- 0.5 / L		
	local usage = 0.025;-- 250L / hectare
	local yield = 1;-- 10000L/hectare	
	local found = false;

	if fruitName~=nil then
	
		found = true;
			
		if fruitName=="wheat" then
			seedPrice, usage, yield = 0.525, 0.02, 1.25; -- 12500L/ha = 9.87T
		elseif fruitName=="barley" then
			seedPrice, usage, yield = 0.495, 0.0225, 1.08; -- 10800L/ha = 7.67T
		elseif fruitName=="maize" then
			seedPrice, usage, yield = 4.5, 0.0037, 1.52; -- 15200L/ha = 12.46T
		elseif fruitName=="rape" then
			seedPrice, usage, yield = 14, 0.0004, 0.69; -- 6900L/Ha = 4.4T | 2.4kg/ha => 4L/ha => 400 000 graines ~= 56
		elseif fruitName=="grass" then
			seedPrice, usage, yield = 1.2, 0.0067, 14; -- 140000L/ha = 35T
		elseif fruitName=="dryGrass" then
			seedPrice, usage, yield = 0, 0, 12; -- 120000L/ha = 6T -- a little less liters than wet grass because there are some losses when doing hay
		elseif fruitName=="chaff" then
			seedPrice, usage, yield = 0, 0, 12.5; -- 125000L / ha = 50T
		elseif fruitName=="potato" then
			seedPrice, usage, yield = 0.25, 0.285, 7.4; -- 50T/ha  0.67 density => 74 000L / ha
		elseif fruitName=="sugarBeet" then
			seedPrice, usage, yield = 80, 0.000375, 11.6; -- 80T / ha   0.69 density => 116 000L / ha
		
		elseif fruitName=="sunflower" then
			seedPrice, usage, yield = 12.25, 0.000875, 0.8333; -- 8333L/Ha = 3.5T | 3.5kg/ha => 8.75L/ha => 70 000 graines ~= 107	
		elseif fruitName=="rye" then -- seigle
			seedPrice, usage, yield = 0.3333, 0.0180, 1.35; -- 13500L/Ha = 10T 	
			
		
			
			
		elseif fruitName=="pea" then
			seedPrice, usage, yield = 0.729, 0.0284, 0.74; -- 0.729/L = 0.9/kg  | 284L/Ha = 230kg/ha | 7400L/ha = 6T
		elseif fruitName=="bean" then
			seedPrice, usage, yield = 1.008, 0.0190, 0.685; -- 1.008/L = 1.2/kg  | 190L/Ha = 160kg/ha | 6850L/ha = 5.75T
		elseif fruitName=="linseed" then
			seedPrice, usage, yield = 1.728, 0.0083, 0.3475; -- 1.728/L = 2.4/kg  | 83L/Ha = 60kg/ha | 3475L/ha = 2.5T
		
		elseif fruitName=="oat" then -- avoine
			seedPrice, usage, yield = 0.34, 0.0210, 1.35; -- 13000L/Ha = 7T 

		elseif fruitName=="carrot" then
			seedPrice, usage, yield = 34, 0.0011, 4.6875; -- 46875/Ha = 30T 
		elseif fruitName=="onion" then
			seedPrice, usage, yield = 135, 0.00067, 9.015; -- 90150L/Ha = 55T 
			
		--20131217 - new fruits
		elseif fruitName=="soybean" then
			seedPrice, usage, yield = 1.275, 0.0094, 0.52; -- 5200L/ha = 4.16T		
		elseif fruitName=="rice" then
			seedPrice, usage, yield = 0.594, 0.0318, 0.82; -- 8200L/ha = 5.57T
		elseif fruitName=="greenWheat" then
			seedPrice, usage, yield = 0.450, 0.0220, 0.615; -- 6150L/ha = 4T
			
				
		else
			found=false;
		end;
		
	end;
	
	
	
	
	-- actual yield will be twice as much as the standard yield with manure or fertilizer. not quite realistic, but its a game, and we want to do some transport too (who wants to thresh for 2 hours to do a field and fill only one small tipper ?)
	return found, RealisticGlobalListener.priceBalancing*RealisticGlobalListener.seedPriceBalancing*seedPrice, usage, yield*0.75;	-- considering the "2" factor when fertilized, that means 50% more yield than actual figures
	
	-- bl : semence = 70/quintal  semis : 150 kgs/hectare  rcolte : 90 quintaux/hectare   5T straw / ha
	-- orge : semence = 70/quintal  semis : 150 kgs/hectare  rcolte : 75 quintaux/hectare   4T straw / ha
	-- mas : semence = 80/50000 graines  semis : 100000 graines/hectare  rcolte : 110 quintaux/hectare
	-- colza : semence = 180/2000000 graines  semis : 400000 graines/hectare  rcolte : 45 quintaux/hectare   semence => PMG entre 3 et 6g => entre 1.2 et 2.4kgs/ha. entre 18 et 36/ha
	--                   hybride = 210 la dose de 1 500 000 graines => 400 000 graines  ha => 56/ha
	
	-- herbe : semence = 4/kg  semis : 2g/m  rcolte : 300 quintaux/hectare (matire humide)
	
	-- sugarbeet : semence = 300 per unit (1 unit = 2.5Kg = 100 000 seeds = 3.75L) => 80/L    semis = 2.5Kg/ha (3.75L)  rcolte = 80T/ha  - 90 000 / 100 000 graines / ha   - PMG = 17-25g
	-- potato : semence = 0.25/L  semis = 2T/ha rcolte = 50T/ha
	
	-- ensilage mais :  rcolte : 500 quintaux/hectare (matire humide)
	
	-- sunflower/tournesol : 30-35q / Ha, 65.000  70.000 graines/ha, PMG = 50g 3.5kg/Ha   semence = 230 / dose de 150 000 graines => cout semence = 107 par Ha. on se base sur une densit de la semence de 400g par Litre => usage = 8.75L / ha
	
	-- rye/seigle : semis 100-135kg/ha (densit = 0.67 => 180L/Ha), semence = 50/quintal (60/Ha => 0.3333/L)

end;


--useful for combien to set there power requirement increase function of the crop being harvested
RealisticUtils.getCropMaterialQtyFx = function(cropName)
	
	--default qty fx
	local materialQtyFx = 1;
	
	if cropName=="grass" or cropName=="dryGrass" then
		materialQtyFx = 2.5; -- since there is no fertilized ground for grass, we double the value here (a little more because because grass chaff yield better than whole crop chaff)	
	end;
	
	--print("RealisticUtils.getCropMaterialQtyFx - cropName = " .. cropName);
	
	return materialQtyFx;
	
end;


RealisticUtils.setFillTypePriceV2 = function (fillTypeName, onlyStartPrice)	

	--seeds prices are set with fruitType.seedPricePerLiter. and so, setting a price for the "fillType" seeds is useless. 
	if fillTypeName=="seeds" then
		return;
	end;
	
	local desc = Fillable.fillTypeNameToDesc[fillTypeName];	
	local found, density, pricePerKg, pricePerLiter = RealisticUtils.getFillTypeInfosV2(desc.name);
	
	if Vehicle.debugRendering then
		if not found then
			print("RealisticUtils.setFillTypePriceV2 - fillTypeName '" .. tostring(fillTypeName) .. "' - fillable name '" .. tostring(desc.name) .. "' was not found in getFillTypeInfosV2");
		end;
	end;
	
	if found then
	
		--only needed because the fruit prices displayed on the PDA are in /M3 whereas the pda says "/T"
		local price = pricePerLiter;
		if RealisticGlobalListener.realPDADisplayedFillTypes[desc.index]~=nil then
			-- pda display the price in /T (assuming 1000L = 1T, but its wrong...). the price should be modified in the tip trigger sell event too (OverrideTipTrigger.lua)
			--price = pricePerKg/(RealisticGlobalListener.priceBalancing*RealisticGlobalListener.realDifficultyFX6);--we want to display the realistic price on the pda
			--20131029 - no more "real price display" (in the pda, you see what you get)   ----  DO NOT FORGET to modify "OverrideTipTrigger.lua"
			price = pricePerKg;
		end;	

		--print("RealisticUtils.setFillTypePriceV2 - setting price - " .. tostring(desc.name) .. " = " .. tostring(price) .. " / RealisticGlobalListener.realPDADisplayedFillTypes[desc.index]=" .. tostring(RealisticGlobalListener.realPDADisplayedFillTypes[desc.index]) );
				
		desc.startPricePerLiter = price;
		if onlyStartPrice==nil or onlyStartPrice==false then			
			desc.pricePerLiter = price;
			desc.previousHourPrice = price;
		end;	
	
	end;
	
end;


RealisticUtils.printWarning = function(stackTrace, message, isError)
	
	local msg = "*** " .. tostring(RealisticGlobalListener.realMissionTime) .. " MoreRealistic - ";
	
	if isError then
		msg = msg .. "ERROR - ";
	else
		msg = msg .. "WARNING - ";
	end;
	
	msg = msg .. stackTrace .. " - " .. message;
	
	print(msg);	

end;






function RealisticUtils.realAreaCorrection(self, area, genuineArea, maxCorrection)

	if RealisticGlobalListener.AREA_CORRECTION_ENABLED then

		--******************* DURAL ******************************************
		-- i observe that cuttingarea alignment was wrong depending on y world rotation of the tool
		-- if we take the world x axis as 90 axis, and the world z axis as 0 axis, then the alignment of cuttingareas is perfect when the world y rotation of the tool is 45 or -135
		-- the baddest is when the world y rotation is 135 or -45
		-- don't ask why the max correction is 40cm.. i don't know (think it has to be with terrain "tile" size and shape or something like that...) => maybe it as to be with "cellSize" in map.i3d (usually, this value is 8)

		local rotX, rotY, rotZ = getWorldRotation(area.start);
		local x,y,z = localDirectionToWorld(area.start, 0, 1, 1);
		local correction = 0;
		local angle45rad = 0.25*math.pi;
		
		if maxCorrection==nil then
			maxCorrection = RealisticGlobalListener.AREA_MAX_CORRECTION;
		end;
		
		if y<0 then -- for plough
			rotY = -rotY;
		end;
		
		local diffAngle = angle45rad - rotY;
		if z<0 then
			diffAngle = angle45rad + rotY;
		end;
		
		correction = - maxCorrection * math.abs(math.sin(diffAngle));
		
		if rotY>angle45rad or (z<0 and rotY>-angle45rad) then
			correction = -correction;
		end;
		
		if y<0 then -- for plough
			correction = -correction;
		end;		
		
		--print("RealisticTool : rotY : " .. rotY .. " | z : " .. z .. " | y : " .. y .. " | correction : " .. correction);

		setTranslation(area.start, genuineArea.start.x + correction, genuineArea.start.y, genuineArea.start.z);
		setTranslation(area.width, genuineArea.width.x + correction, genuineArea.width.y, genuineArea.width.z);
		setTranslation(area.height, genuineArea.height.x + correction, genuineArea.height.y, genuineArea.height.z);

	end;
		
end;




RealisticUtils.isCommercialFillType = function(fillTypeIndex)

	local fillType = Fillable.fillTypeIndexToDesc[fillTypeIndex];
	
	--print("RealisticUtils.isCommercialFillType - testing fillTypeIndex=" .. tostring(fillTypeIndex));
	
	if fillType~=nil then
		local fillTypeName = fillType.name;
	
		--print("RealisticUtils.isCommercialFillType - filltypename = " .. tostring(fillTypeName));

		if fillTypeName=="wheat" 
		or fillTypeName=="barley"
		or fillTypeName=="rape"
		or fillTypeName=="maize"
		or fillTypeName=="sugarBeet"
		or fillTypeName=="potato"
		then
			return true;
		end;		
		
	end;
	
	return false;

end;






--********************************************************************************************************************************************************************************************
--OLDER FUNCTIONS


RealisticUtils.getModDirectoryAndSubDirectory  = function(modXmlFileName)

	if modXmlFileName==".." then --cow specific
		return "cow","cow";
	end;

	--print("RealisticUtils : modXmlFileName : " .. modXmlFileName);

	local modsDirectory = getUserProfileAppPath() .. "mods";
	
	--print("RealisticUtils : modsDirectory : " .. modsDirectory);
	
	local modRelativeFullPath = modXmlFileName:gsub(modsDirectory.."/", "");	
		
	--print("RealisticUtils : modRelativeFullPath : " .. modRelativeFullPath);
	
	local modDirIndex = modRelativeFullPath:find("/", 1, true);	
	local modDirectory = modRelativeFullPath:sub(1 , modDirIndex-1);	
	local modSubDirIndex = modRelativeFullPath:find("/", modDirIndex+1, true);
	local modSubDirectory = "";
	if modSubDirIndex~=nil then
		modSubDirectory = modRelativeFullPath:sub(modDirIndex+1 , modSubDirIndex-1);
	end;
	
	return modDirectory, modSubDirectory;
 
end;


RealisticUtils.getDlcDirectoryAndSubDirectory  = function(dlcXmlFileName)

	if dlcXmlFileName==".." then --cow specific
		return "","";
	end;

	--print("RealisticUtils : dlcXmlFileName : " .. dlcXmlFileName);

	local dlcsDirectory = getUserProfileAppPath() .. "pdlc2.1";
	
	--print("RealisticUtils : dlcsDirectory : " .. dlcsDirectory);
	
	local dlcRelativeFullPath = dlcXmlFileName:gsub(dlcsDirectory.."/", "");	
		
	--print("RealisticUtils : dlcRelativeFullPath : " .. dlcRelativeFullPath);
	
	local dlcDirIndex = dlcRelativeFullPath:find("/", 1, true);	
	local dlcDirectory = dlcRelativeFullPath:sub(1 , dlcDirIndex-1);	
	local dlcSubDirIndex = dlcRelativeFullPath:find("/", dlcDirIndex+1, true);
	local dlcSubDirectory = "";
	if dlcSubDirIndex~=nil then
		dlcSubDirectory = dlcRelativeFullPath:sub(dlcDirIndex+1 , dlcSubDirIndex-1);
	end;
	
	return dlcDirectory, dlcSubDirectory;
 
end;







-- determining if the wheelshape is under the main component or not
function RealisticUtils.computeIsJointWheelShape(self, wheel)

	--getting the "component" containing the wheelshape
	local parentId = wheel.node;
	while true do
		newParentId = getParent(parentId);
		if newParentId==nil then
			break;
		elseif newParentId==getRootNode() then
			break;
		end;
		parentId=newParentId;
	end;
	
	if parentId~=self.components[1].node then
		return true;
	end;

	return false;

end;



function RealisticUtils.getWheelComponentIndex(self, wheel)

	--getting the "component" containing the wheelshape
	local parentId = wheel.node;
	while true do
		newParentId = getParent(parentId);
		if newParentId==nil then
			break;
		elseif newParentId==getRootNode() then
			break;
		end;
		parentId=newParentId;
	end;
	
	local componentIndex = 1;
	for c, component in pairs(self.components) do
		if parentId == component.node then
			componentIndex = c;
			--print(self.time .. " RealisticUtils.getWheelComponentIndex : " .. tostring(componentIndex));
		end;
	end;

	return componentIndex;

end;


-- spring compression in cm !!!!
--yCosValue = cosinus angle between y axis of the vehicle and flat ground (=> ==1 when the vehicle is on a flat ground)
--wheel spring = value of the wheelshape spring
function RealisticUtils.computeMassFromSpringExtensionV3(springCompression, wheelSpring, specificAlpha)

	local mass = 0;

	if yCosValue~=0 then		
		local alpha = 139*Vehicle.springScale;	
		if specificAlpha~=nil then
			alpha = specificAlpha;
		end;
		--mass = math.max(0, springCompression-2) * wheelSpring / alpha / yCosValue; -- mass on the wheel (T)	
		mass = math.max(0, springCompression-2) * wheelSpring / alpha; -- mass on the wheel (T)	
	end;
	
	--if specificAlpha~=nil then
	--	print(RealisticGlobalListener.realMissionTime .. " springCompression, wheelSpring, yCosValue, mass : " .. springCompression .. " , " .. wheelSpring .. " , " .. yCosValue .. " , " .. mass);	
	--end;
	
	return mass;

end;


function RealisticUtils.isCurrentTipTriggerValidForTrailer(trailer)

	if trailer.currentTipTrigger==nil then		
		return false;
	end;	
	
	--test tipTrigger class		
	--print("testing tipTrigger");		
	--for _,k in pairs(tipTrigger) do
	--	print("function name : " .. _ .. " value : " .. tostring(k));			
	--end;
	--print("end testing tipTrigger");
	
	
	if trailer.currentTipTrigger.isRegistered==false then		
		--print("tipTrigger not registered !!!");		
		trailer.currentTipTrigger = nil;
		return false;
	end;	

    if g_currentMission:getIsTrailerInTipRange(trailer, trailer.currentTipTrigger)==false then
		--print("tipTrigger is not in trailer tip range !!!");
		return false;
	end;
	
	return true;

end;


function RealisticUtils.testClass(className, classToTest)

	print("testing " .. tostring(className));		
	for _,k in pairs(classToTest) do
		print("function name : " .. tostring(_) .. " value : " .. tostring(k));			
	end;
	
	--table.foreach(classToTest,print);
	
	print("end testing " .. tostring(className));
	
end;

function RealisticUtils.testObject(displayName, object)

	print("testing " .. tostring(displayName));
	for key, value in pairs(getmetatable(object)) do
		print(key, value);
	end;
	print("end testing " .. tostring(displayName));
end;

