
RealisticTrailer = {};

function RealisticTrailer.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations) and SpecializationUtil.hasSpecialization(Trailer, specializations) ;
end;


function RealisticTrailer:load(xmlFile) 

	self.isRealistic = true;
	self.isRealisticTrailer = true;
		
	self.realTippingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTippingPowerConsumption"), 0);	
	self.realTippingPowerConsumptionWhenOpened = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realTippingPowerConsumption#activeWhenOpened"), false); -- mainly for belt-trailer
	self.realTippingPowerConsumptionWhenClosing = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realTippingPowerConsumption#activeWhenClosing"), false); -- mainly for push-off trailer
	
	self.realTrailerUnloadingNeedsEngineRev = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realTrailerUnloadingNeedsEngineRev"), true);
	
	self.realCurrentPowerConsumption = 0;
	
	--self.realFillAutoAimZLength = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realFillAutoAimZLength"), 0); -- in meter => total aim length is divided by 1.5 to obtained the number of aim points
	
	-- "adding" the "realMaxDischargeSpeed" to the trailer tipping animation
	local i = 0;
	while true do
		local key = string.format("vehicle.tipAnimations.tipAnimation(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;		
		
		if self.tipAnimations[i+1]~= nil then			
			self.tipAnimations[i+1].realMaxDischargeSpeed = getXMLFloat(xmlFile, key.."#realMaxDischargeSpeed");			
			self.tipAnimations[i+1].realDischargeAnimTimeFx = Utils.getNoNil(getXMLFloat(xmlFile, key.."#realDischargeAnimTimeFx"), 1);
		end;
		
		i = i + 1;
		
	end;
	
end;

function RealisticTrailer:delete()    
end;

function RealisticTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticTrailer:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticTrailer:updateTick(dt)	

	if self.isServer and self.isActive then
		self.realToolNeedEngineRev = false;
		self.realCurrentPowerConsumption = 0;
		if self.tipState == Trailer.TIPSTATE_OPENING
			or (self.realTippingPowerConsumptionWhenOpened and self.tipState == Trailer.TIPSTATE_OPEN)
			or (self.realTippingPowerConsumptionWhenClosing and self.tipState == Trailer.TIPSTATE_CLOSING) then -- the trailer is "tipping"
			self.realCurrentPowerConsumption = self.realCurrentPowerConsumption + self.realTippingPowerConsumption;
			if self.realTrailerUnloadingNeedsEngineRev then
				self.realToolNeedEngineRev = true;
			end;
		end;		
		
	end;

end;


function RealisticTrailer:update(dt)
end;

function RealisticTrailer:draw() 		
end;

