RealisticTool = {};

function RealisticTool.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
end;


function RealisticTool:load(xmlFile) 

	self.isRealistic = true;
	
	self.realOnDesactivatePS = SpecializationUtil.callSpecializationsFunction("realOnDesactivatePS");

	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
	self.realResistanceSmoothing = Utils.clamp(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realResistanceSmoothing"), 0), 0, 0.9999);
	self.realWorkingSpeedLimit = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realWorkingSpeedLimit"), 9999); --kph   9999=no real speed limit -> use default check speed limit
	self.realSpeedViolationMaxTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realSpeedViolationMaxTime"), 4000);
	self.realPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realPowerConsumption"), 0); --KW : when turned on (example : air turbine)
	self.realPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realPowerConsumptionInc"), 0); -- same as above, but proportionnal to speed (0 at 0kph)
	self.realPowerConsumptionWhenWorking = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realPowerConsumptionWhenWorking"), 0); --KW : when turned on and working (ex : power harrow)
	self.realPowerConsumptionWhenWorkingInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realPowerConsumptionWhenWorkingInc"), 0);-- same as above, but proportionnal to speed (0 at 0kph)
	
	self.realResistanceOnlyWhenActive = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realResistanceOnlyWhenActive"), false); -- for implement that have always ground contact like the Horsch Pronto or Sprinter
	self.realDraftIncreaseWithSpeed = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realDraftIncreaseWithSpeed"), true);
	
	
	self.realFrictionCorrection = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realFrictionCorrection"), 0);
	
	self.realTilledGroundResistanceDecreaseFx = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTilledGroundBonus#resistanceDecreaseFx"), 0);
	self.realTilledGroundPowerConsumptionDecreaseFx = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTilledGroundBonus#powerConsumptionDecreaseFx"), 0);
	self.realTilledGroundPowerConsumptionWhenWorkingDecreaseFx = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTilledGroundBonus#powerConsumptionWhenWorkingDecreaseFx"), 0);
	
	self.realAiTurnRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realAiTurnRadius"), 0);
	
	
	--this should be set independantly for each implement in the xml config file
	--[[if self.realTilledGroundResistanceDecreaseFx==nil then
		--different values function of implement type
		if SpecializationUtil.hasSpecialization(SowingMachine, self.specializations) then			
			self.realTilledGroundResistanceDecreaseFx = 0;--seeder : most seeder do not enter the ground if it is too firm -> almost less power required to move the seeder on a firm ground. seeders should be tuned one by one function of integrated tilling equipement, pto power, disc or coulter etc
		elseif SpecializationUtil.hasSpecialization(Cultivator, self.specializations) then			
			self.realTilledGroundResistanceDecreaseFx = 0.25;--cultivator : pretty great difference between an already tilled ground and a firm ground (default = 25% less HP required to pull the cultivator on an already tilled ground)
		elseif SpecializationUtil.hasSpecialization(Plough, self.specializations) then			
			self.realTilledGroundResistanceDecreaseFx = 0.1;--plough : less impacted than other implement
		else			
			self.realTilledGroundResistanceDecreaseFx = 0.3;--other implement
		end;
	end;]]
	
	self.realCurrentPowerConsumption = 0;
	self.realCurrentTilledGroundRatio = 0;
	
	
	for i=1, numCuttingAreas do
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].realTractionResistance = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#realTractionResistance"), 0);
		self.cuttingAreas[i].realTractionResistanceInc = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#realTractionResistanceInc"), 0);
		self.cuttingAreas[i].realTractionResistanceWithLoadMass = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#realTractionResistanceWithLoadMass"), 0);		
		self.cuttingAreas[i].realLastResistance = 0;
	end;
	
	self.realToolNeedTraction = false;	
	self.realIsWorking = false;
	--self.realCuttingAreaCorrectionX = 0;
	
	
	
	
	self.realSpeedViolationTimer = self.realSpeedViolationMaxTime;
	if self.realWorkingSpeedLimit~=9999 then
		self.doCheckSpeedLimit = function() return false; end; -- speedlimit managed by realisticTool class
	end;
	self.realGetIsWorkingTooFast = RealisticTool.realGetIsWorkingTooFast;
  
end;

function RealisticTool:delete()    
end;

function RealisticTool:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticTool:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticTool:updateTick(dt)

	if self.isServer then
		if not self.isActive then		
			self.realCurrentForceNeeded = 0;
			self.realCurrentTilledGroundRatio = 0;
		else 
			-- cuttingarea correction function of world y rotation
			--RealisticTool.realCuttingAreaCorrection(self);
						
			if self.isTurnedOn then -- the tool is active (seeder turbine, pto tools, hydraulic tools...)
				local power = (self.realPowerConsumption + self.realPowerConsumptionInc * self.realGroundSpeed)*(1 - self.realTilledGroundPowerConsumptionDecreaseFx*self.realCurrentTilledGroundRatio);
				if self.realIsWorking then
					power = power + (self.realPowerConsumptionWhenWorking + self.realPowerConsumptionWhenWorkingInc*self.realGroundSpeed)*(1-self.realTilledGroundPowerConsumptionWhenWorkingDecreaseFx*self.realCurrentTilledGroundRatio);
				end;
				self.realCurrentPowerConsumption = power;
			else
				self.realCurrentPowerConsumption = 0;
			end;
			
		end;		
	end;
	
	
	
	if self.realIsWorking then
		--if RealisticTool.doCheckSpeedLimit(self) and self.realGroundSpeed*3.6 > self.realWorkingSpeedLimit then
		if RealisticTool.doCheckSpeedLimit(self) and self.realGroundSpeed*3.6 > self.realWorkingSpeedLimit then
			self.realSpeedViolationTimer = self.realSpeedViolationTimer - dt;
			if self.isServer then
				if self.realSpeedViolationTimer < 0 then
					if self.attacherVehicle then
						self.attacherVehicle:detachImplementByObject(self);
					end;
				end;
			end;
		else		
			self.realSpeedViolationTimer = self.realSpeedViolationMaxTime;
		end;
		
		
		--************************************************************** DURAL *******************************************************
		--** when working the ground, check if the soil is already cultivated or not (firm soil => more HP needed to pull the implement)
		if self.isServer and self.realMovingDirection>0.01 then
		
			local terrainDetailRequiredMask = bitOR(0, 2^g_currentMission.cultivatorChannel);
			terrainDetailRequiredMask = bitOR(terrainDetailRequiredMask, 2^g_currentMission.ploughChannel);
			
			--local terrainDetailRequiredMask = bitOR(0, 2^g_currentMission.sowingChannel);
			--terrainDetailRequiredMask = bitOR(terrainDetailRequiredMask, 2^g_currentMission.sowingWidthChannel);

			local sumTestSoilArea = 0;
			local sumCuttingArea = 0;
			for k, cuttingArea in pairs(self.cuttingAreas) do
				if self:getIsAreaActive(cuttingArea) then
				
					local bOffset = 0.5;
					local fOffset = 1.5;
					
					--20131218 - handle badly modelled mod => inversed z axis (z axis toward the rear of the tool)
					if self.realInversedZAxis then
						bOffset = -bOffset;
						fOffset = -fOffset;
					end;
				
					local stX, stY, stZ = getWorldTranslation(cuttingArea.start);
					local wtX, wtY, wtZ = getWorldTranslation(cuttingArea.width);
					local htX, htY, htZ = getWorldTranslation(cuttingArea.height);
					
					stX, stY, stZ = worldToLocal(self.realMainComponent.node, stX, stY, stZ);
					wtX, wtY, wtZ = worldToLocal(self.realMainComponent.node, wtX, wtY, wtZ);
					htX, htY, htZ = worldToLocal(self.realMainComponent.node, htX, htY, htZ);
					
					--print(self.time .. " - " .. self.realVehicleName .. " - stX, stY, stZ = " .. tostring(stX) .. " / " .. tostring(stY) .. " / " .. tostring(stZ));
					
					--4th point of the parallelogram
					local h2tX = htX + wtX-stX;
					local h2tZ = htZ + wtZ-stZ;
					
					local tmpMaxZ = math.max(stZ, wtZ);
					local tmpMaxX = math.max(h2tX, math.max(htX, math.max(stX, wtX)));
					local tmpMinX = math.min(h2tX, math.min(htX, math.min(stX, wtX)));
					
					local sX, _, sZ = localToWorld(self.realMainComponent.node, tmpMaxX, stY, tmpMaxZ+bOffset);
					local wX, _, wZ = localToWorld(self.realMainComponent.node, tmpMinX, stY, tmpMaxZ+bOffset);
					local hX, _, hZ = localToWorld(self.realMainComponent.node, tmpMaxX, stY, tmpMaxZ+fOffset);
					
					--[[
					--backup translation
					local stX, stY, stZ = getTranslation(cuttingArea.start);
					local wtX, wtY, wtZ = getTranslation(cuttingArea.width);
					local htX, htY, htZ = getTranslation(cuttingArea.height);
					
					local offset = 2;
					local tmpZ = wtZ + htZ-stZ;
					if self.movingDirection<0 then
						tmpZ = math.min(tmpZ, math.min(math.min(stZ, wtZ), htZ));
						offset = -offset;
					else
						tmpZ = math.max(tmpZ, math.max(math.max(stZ, wtZ), htZ));						
					end;
					local tmpX = wtX-stX + htX;
					local tmpMaxX = math.max(tmpX, math.max(math.max(stX, wtX), htX));
					local tmpMinX = math.min(tmpX, math.min(math.min(stX, wtX), htX));
					
					--setting new translation to get the "forward" rectangle shape
					setTranslation(cuttingArea.start, tmpMaxX, stY, tmpZ);
					setTranslation(cuttingArea.width, tmpMinX, wtY, tmpZ);
					setTranslation(cuttingArea.height, tmpMaxX, htY, tmpZ+offset);
					
					--get correct trapeze coordinates
					local lX, _, lZ = getWorldTranslation(cuttingArea.start);
					local rX, _, rZ = getWorldTranslation(cuttingArea.width);
					local bX, _, bZ = getWorldTranslation(cuttingArea.height);
					
					
					--set back correct translation
					setTranslation(cuttingArea.start, stX, stY, stZ);
					setTranslation(cuttingArea.width, wtX, wtY, wtZ);
					setTranslation(cuttingArea.height, htX, htY, htZ);]]				
					
					
					--local testSoilArea, totalCuttingArea = AITractor.getAIArea(self, lX, lZ, rX, rZ, bX, bZ, terrainDetailRequiredMask, 0, FruitUtil.FRUITTYPE_UNKNOWN, 0,0, FruitUtil.FRUITTYPE_UNKNOWN,0,0);
					
					local testSoilArea, totalCuttingArea = AITractor.getAIArea(self, sX, sZ, wX, wZ, hX, hZ, terrainDetailRequiredMask, 0, FruitUtil.FRUITTYPE_UNKNOWN, 0,0, FruitUtil.FRUITTYPE_UNKNOWN,0,0);
					sumTestSoilArea = sumTestSoilArea + testSoilArea;
					sumCuttingArea = sumCuttingArea + totalCuttingArea;
				end;
			end;
			
			--local lX, lY, lZ = getWorldTranslation(self.aiLeftMarker);
			--local rX, rY, rZ = getWorldTranslation(self.aiRightMarker);
			--local bX, bY, bZ = getWorldTranslation(self.aiBackMarker);
			
			--local softSoilArea, totalTestArea = AITractor.getAIArea(self, lX, lZ, rX, rZ, bX, bZ, terrainDetailRequiredMask, 0, FruitUtil.FRUITTYPE_UNKNOWN, 0,0, FruitUtil.FRUITTYPE_UNKNOWN,0,0);
			local ratio = 0;
			if sumCuttingArea>0 then
				ratio = sumTestSoilArea/sumCuttingArea;
			end;
			self.realCurrentTilledGroundRatio = 0.9*self.realCurrentTilledGroundRatio + 0.1*ratio;
			
			--print(self.time .. " - " .. self.realVehicleName .. " - testArea/totalArea/TilledRatio/TilledGroundBonus = " .. tostring(sumTestSoilArea) .. " / " .. tostring(sumCuttingArea) .. " / " .. tostring(self.realCurrentTilledGroundRatio) .. " / " .. tostring(self.realFirmGroundResistancePenaltyFx));
		end;
		--********************************************************* END DURAL *********************************************************		
		
		
	else -- not self.realIsWorking
		self.realSpeedViolationTimer = self.realSpeedViolationMaxTime;
	end;
	
end;

function RealisticTool:update(dt)

	-- do not brake for the first 2 seconds after attaching, to allow balancing of the difference between the attacher joints	
	if self.isActive and self.realAttachableIsReady then

		local isWorking = false;

		if self.attacherVehicle==nil then
			return;
		end;
			
		if self.cultivatorHasGroundContact~=nil then --cultivator
			isWorking = self.cultivatorHasGroundContact;
		elseif self.ploughHasGroundContact~=nil then --plough
			isWorking = self.ploughHasGroundContact;
		elseif self.reelStarted~=nil and self.lastAreaBiggerZero~=nil then -- combine cutter
			isWorking = self.reelStarted and self.lastAreaBiggerZero;
		elseif self.sowingMachineHasGroundContact~=nil then -- seeder
			isWorking = self.sowingMachineHasGroundContact;
		elseif self.realToolHasGroundContact~=nil then -- other realistic tools ??? (for custom mods)
			isWorking = self.realToolHasGroundContact;				
		end;
		
		if self.onlyActiveWhenLowered~=nil then
			isWorking = isWorking and (not self.onlyActiveWhenLowered or self:isLowered(false))
		end;
		
		if self.realResistanceOnlyWhenActive then
			isWorking = isWorking and self.isTurnedOn;
		end;
		
		self.realIsWorking = isWorking;
		
		--print("RealisticTool:update => realIsWorking = " .. tostring(self.realIsWorking));
		
		if self.isServer then
				
			self.realToolNeedTraction = false;
			local newForceNeeded = 0;
			local draftForceGroundFx = (1-self.realTilledGroundResistanceDecreaseFx*self.realCurrentTilledGroundRatio)*RealisticGlobalListener.draftForceTuning;
			
			if isWorking then
				
				local i = 0;
				local addMass = self.realMainComponentCurrentMass-self.realMainComponentMass;
				for k, cuttingArea in pairs (self.cuttingAreas) do
					i = i + 1;
					if self:getIsAreaActive(cuttingArea) then						
						local newResistance = cuttingArea.realTractionResistance; -- newResistance can't be negative !
					
						if self.realDraftIncreaseWithSpeed then
							newResistance = newResistance * (1 + 0.01*self.realGroundSpeed^2) + cuttingArea.realTractionResistanceInc * self.realGroundSpeed;
						else
							newResistance = newResistance + cuttingArea.realTractionResistanceInc * self.realGroundSpeed;
						end;
						
						newResistance = math.max(0, newResistance*draftForceGroundFx + cuttingArea.realTractionResistanceWithLoadMass * addMass); -- newResistance can't be negative !
												
						newForceNeeded = newForceNeeded + newResistance;
						self.realToolNeedTraction = true;
					end;
				end;
				
			end;
			
			--print(self.time .. " - " .. self.realVehicleName .. " - res force = " .. tostring(newForceNeeded));
			self.realCurrentForceNeeded = self.realResistanceSmoothing*self.realCurrentForceNeeded + (1-self.realResistanceSmoothing)*newForceNeeded;
			
			--applying force
			--if isWorking and self.attacherVehicle~=nil and self.attacherVehicle.isRealistic and (self.time>self.attachTime+2000) then
			if isWorking and self.attacherVehicle~=nil and self.attacherVehicle.isRealistic then
				if self.attacherVehicle.realGroundSpeed>0.1 then
					-- NOTE : NEVER, NEVER apply a 0 force... it can make the game engine crash... (example : when attaching the Amazone Cayena for the first time after buying it)
					-- in fact, seems to happen when applying a force to the implement while it is being attached to the tractor
					--20130610 -> the crash occurs because of "getMovedLimitedValue" in Vehicle.updateTick of the attacher vehicle (if moveTime==0, the new moveAlpha=INFINITE and so, "setJointFrame" crashes the game)
					
					--take into account the correction force to compensate implement without wheels and then having a huge friction resistance (exemple : amazone ADP303 seeder)
					local force = -self.realCurrentForceNeeded+self.realFrictionCorrection*self.realMainComponentCurrentMass;
					force = force*dt/1000 / self.realGroundSpeed;-- direction vector = velocity vector
					
					addForce(self.realMainComponent.node, force*self.realVelX, force*self.realVelY, force*self.realVelZ, self.realComX, self.realComY, self.realComZ, true);
					--print(self.time .. " - " .. self.realVehicleName .. " - applying res force of " .. tostring(self.realCurrentForceNeeded) .. " - groundspeed = " .. tostring(self.realGroundSpeed) .. " - vel x,y,z = " .. tostring(self.realVelX) .. " / " .. tostring(self.realVelY) .. " / " .. tostring(self.realVelZ) );
				end;
			end;	
		end;
		
	else -- not active
		self.realIsWorking = false;			
	end;

end;

function RealisticTool:draw()
			
end;





RealisticTool.doCheckSpeedLimit = function(self)	
	if self.attacherVehicle ~= nil then
		return self.checkSpeedLimit and RealisticTool.doCheckSpeedLimit(self.attacherVehicle);
	end
	return self.checkSpeedLimit;
end;


--called within RealisticVehicle:draw
RealisticTool.realGetIsWorkingTooFast = function(self)
	local isWorkingTooFast = math.abs(self.realSpeedViolationTimer - self.realSpeedViolationMaxTime) > 200;
	return isWorkingTooFast, self.realWorkingSpeedLimit;
end;





function RealisticTool.realCuttingAreaCorrection(self)

	local i = 1;
	for k, cuttingArea in pairs(self.cuttingAreas) do
		RealisticUtils.realAreaCorrection(self, cuttingArea, self.realGenCuttingAreas[i]);
		i = i + 1;
	end;

end;


function RealisticTool:realOnDesactivatePS()
	
	--plough
	if self.groundParticleSystemActive~=nil then
		if self.groundParticleSystemActive then
			--print(self.time .. " RealisticTool:realOnDesactivatePS - stopping plough PS");
			self.groundParticleSystemActive = false;
			Utils.setEmittingState(self.groundParticleSystems, false);
		end;
	--cultivators and sowing machines
	elseif self.groundParticleSystems~= nil then 
		--print(self.time .. " RealisticTool:realOnDesactivatePS - stopping cultivator/sowing machine PS");
		for _, ps in pairs(self.groundParticleSystems) do
			if ps.isActive then
				ps.isActive = false;
				Utils.setEmittingState(ps.ps, false);
			end;
		end;
	end;

end;


