RealisticSteerableTransmissionWarningEvent = {};
RealisticSteerableTransmissionWarningEvent_mt = Class(RealisticSteerableTransmissionWarningEvent, Event);

InitEventClass(RealisticSteerableTransmissionWarningEvent, "RealisticSteerableTransmissionWarningEvent");

 
function RealisticSteerableTransmissionWarningEvent:emptyNew()
	local self = Event:new(RealisticSteerableTransmissionWarningEvent_mt);
	self.className="RealisticSteerableTransmissionWarningEvent";
	return self;
end;

function RealisticSteerableTransmissionWarningEvent:new(object)
	local self = RealisticSteerableTransmissionWarningEvent:emptyNew();	
	self.object = object;	
	return self;
end;

function RealisticSteerableTransmissionWarningEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);	
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self.object.realShowTransmissionWarning = true;	
	end;
	--print(self.object.time .. " event setting vehicle / realShowTransmissionWarning = " .. tostring(self.object.realVehicleName) .. " / " .. tostring(self.object.realShowTransmissionWarning));
end;

function RealisticSteerableTransmissionWarningEvent:writeStream(streamId, connection)
	--only the "steerable" vehicle to pass. we know that only the server can raise the event and the client read it.
	streamWriteInt32(streamId, networkGetObjectId(self.object));
end;