RealisticSteerableToggleShuttleEvent = {};
RealisticSteerableToggleShuttleEvent_mt = Class(RealisticSteerableToggleShuttleEvent, Event);

InitEventClass(RealisticSteerableToggleShuttleEvent, "RealisticSteerableToggleShuttleEvent");

 
function RealisticSteerableToggleShuttleEvent:emptyNew()
	local self = Event:new(RealisticSteerableToggleShuttleEvent_mt);
	self.className="RealisticSteerableToggleShuttleEvent";
	return self;
end;

function RealisticSteerableToggleShuttleEvent:new(object)
	local self = RealisticSteerableToggleShuttleEvent:emptyNew();
	self.object = object;
	return self;
end;

function RealisticSteerableToggleShuttleEvent:readStream(streamId, connection)
	--only the server receive the command to toggle the shuttle
	local id = streamReadInt32(streamId);	
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticSteerableToggleShuttleEvent:writeStream(streamId, connection)
	--only the client raise the event and send the command to the server
	streamWriteInt32(streamId, networkGetObjectId(self.object));	
end;

function RealisticSteerableToggleShuttleEvent:run(connection)	
	--only the server receive the command to toggle the shuttle		
	self.object:realSetNextShuttleDirection();		
end;