RealisticSteerableToggleReverseGearEngagedEvent = {};
RealisticSteerableToggleReverseGearEngagedEvent_mt = Class(RealisticSteerableToggleReverseGearEngagedEvent, Event);

InitEventClass(RealisticSteerableToggleReverseGearEngagedEvent, "RealisticSteerableToggleReverseGearEngagedEvent");

 
function RealisticSteerableToggleReverseGearEngagedEvent:emptyNew()
	local self = Event:new(RealisticSteerableToggleReverseGearEngagedEvent_mt);
	self.className="RealisticSteerableToggleReverseGearEngagedEvent";
	return self;
end;

function RealisticSteerableToggleReverseGearEngagedEvent:new(object, reverseEngaged)
	local self = RealisticSteerableToggleReverseGearEngagedEvent:emptyNew();
	self.reverseEngaged = reverseEngaged;
	self.object = object;
	return self;
end;

function RealisticSteerableToggleReverseGearEngagedEvent:readStream(streamId, connection)	
	local id = streamReadInt32(streamId);
	self.reverseEngaged = streamReadBool(streamId);
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticSteerableToggleReverseGearEngagedEvent:writeStream(streamId, connection)	
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.reverseEngaged);
end;

function RealisticSteerableToggleReverseGearEngagedEvent:run(connection)
	self.object:realSetReverseGearActive(self.reverseEngaged, true);	
	if not connection:getIsServer() then
		g_server:broadcastEvent(RealisticSteerableToggleReverseGearEngagedEvent:new(self.object, self.reverseEngaged), nil, connection, self.object);
	end;
end;