RealisticSteerableToggleAwdEvent = {};
RealisticSteerableToggleAwdEvent_mt = Class(RealisticSteerableToggleAwdEvent, Event);

InitEventClass(RealisticSteerableToggleAwdEvent, "RealisticSteerableToggleAwdEvent");

 
function RealisticSteerableToggleAwdEvent:emptyNew()
	local self = Event:new(RealisticSteerableToggleAwdEvent_mt);
	self.className="RealisticSteerableToggleAwdEvent";
	return self;
end;

function RealisticSteerableToggleAwdEvent:new(object, awdActive)
	local self = RealisticSteerableToggleAwdEvent:emptyNew();
	self.awdActive = awdActive;
	self.object = object;
	return self;
end;

function RealisticSteerableToggleAwdEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.awdActive = streamReadBool(streamId);
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticSteerableToggleAwdEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.awdActive);
end;

function RealisticSteerableToggleAwdEvent:run(connection)
	self.object:realSetAwdActive(self.awdActive, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(RealisticSteerableToggleAwdEvent:new(self.object, self.awdActive), nil, connection, self.object);
	end;
end;