RealisticSteerableSetSpeedLevelLimitEvent = {};
RealisticSteerableSetSpeedLevelLimitEvent_mt = Class(RealisticSteerableSetSpeedLevelLimitEvent, Event);

InitEventClass(RealisticSteerableSetSpeedLevelLimitEvent, "RealisticSteerableSetSpeedLevelLimitEvent");

 
function RealisticSteerableSetSpeedLevelLimitEvent:emptyNew()
	local self = Event:new(RealisticSteerableSetSpeedLevelLimitEvent_mt);
	self.className="RealisticSteerableSetSpeedLevelLimitEvent";
	return self;
end;

function RealisticSteerableSetSpeedLevelLimitEvent:new(object, speedLevel)
	local self = RealisticSteerableSetSpeedLevelLimitEvent:emptyNew();
	self.speedLevelToModify = speedLevel;
	self.object = object;
	return self;
end;

function RealisticSteerableSetSpeedLevelLimitEvent:readStream(streamId, connection)
	--only the server get the info
	local id = streamReadInt32(streamId);
	self.speedLevelToModify = streamReadInt8(streamId);
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticSteerableSetSpeedLevelLimitEvent:writeStream(streamId, connection)
	--only the client send the event
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.speedLevelToModify);
end;

function RealisticSteerableSetSpeedLevelLimitEvent:run(connection)
	--only the server "run" after getting the info	
	self.object:realSetSpeedLevelLimit(self.speedLevelToModify);	
end;