


RealisticSteerable = {};


function RealisticSteerable.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(Steerable, specializations) and SpecializationUtil.hasSpecialization(RealisticMotorized, specializations);
end;


RealisticSteerable.load = function (self, xmlFile)

	self.realIsSteerable = true;

	self.realBrakeSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.accelerationSpeed#brakeSpeed"), 5)*0.001;
	self.realSpeedometerMaxSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realSpeedometerMaxSpeed"), 70);
	
	self.realDisplaySlip = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realDisplaySlip"), false);
	self.realDisplaySlipPercent = 0;
	
	--EDIT 20131204 - display harvesting losses for combines
	self.realDisplayHarvestingLosses = false; -- parameter set in "realisticCombine"
	self.realDisplayHarvestingLossesPercent = 0;
	
	
	--[[
	if not self.isServer then
		self.realDisplaySlip = false; -- not supported for client in mp
	end;]]
	
	

	local fX = 0.9595;
	local fY = 0.785;
	
	local bX = 0.9595;
	local bY = 0.752;
	
	local width = 29/1920;
	local height = 34/1080;
	
	self.realForwardOverlay1 = Overlay:new("realForwardOverlay1", Utils.getFilename("/moreRealistic/_RES/Forward-OFF.png", g_modsDirectory), fX, fY-0.0015, width, height);
	self.realForwardOverlay2 = Overlay:new("realForwardOverlay2", Utils.getFilename("/moreRealistic/_RES/Forward-ON.png", g_modsDirectory), fX, fY, width, height);
	
	self.realBackwardOverlay1 = Overlay:new("realBackwardOverlay1", Utils.getFilename("/moreRealistic/_RES/Backward-OFF.png", g_modsDirectory), bX, bY+0.0016, width, height);
	self.realBackwardOverlay2 = Overlay:new("realBackwardOverlay2", Utils.getFilename("/moreRealistic/_RES/Backward-ON.png", g_modsDirectory), bX, bY, width, height);
			
	-- image proportion should always be DDS conform (1*1 or 1*2 or 2*1 => exemple : 128*128, 128*256 etc)
	--local gW = 0.5*256/1920;
	--local gH = 0.5*128/1080;
	
	--local gX = 1-gW; -- right side
	--local gY = 0.375;
	
	--self.realGasTankOverlay = Overlay:new("realGasTankOverlay", Utils.getFilename("/moreRealistic/_RES/gasTankOverlay.png", g_modsDirectory), gX, gY+0.0016, gW, gH);
			
	
	
	
	
	self.realWantedAcceleration = 0;
	
	
	self.realShowTransmissionWarning = false;
	self.realTransmissionWarningDisplayTime = 5000; -- ms
	self.realTransmissionWarningDelayTime = 100; -- ms	
	self.realTransmissionWarningCurrentDisplayMaxTime = 0;
	self.realTransmissionWarningCurrentDelayMaxTime = 0;	
	
	self.realDisplayTimer = 0;
	self.realDisplaySpeed = 0;
	
	
	self.realAWDModeOn = false;
	
	self.realSteerableDirtyFlag = self:getNextDirtyFlag();
	
	
	self.realManageAwdMode = SpecializationUtil.callSpecializationsFunction("realManageAwdMode");
	self.realSetAwdActive = SpecializationUtil.callSpecializationsFunction("realSetAwdActive");
	
	self.realManageTransmissionMode = SpecializationUtil.callSpecializationsFunction("realManageTransmissionMode");
	self.realSetNextTransmissionMode = SpecializationUtil.callSpecializationsFunction("realSetNextTransmissionMode");
	
	self.realManageShuttle = SpecializationUtil.callSpecializationsFunction("realManageShuttle");
	self.realSetNextShuttleDirection = SpecializationUtil.callSpecializationsFunction("realSetNextShuttleDirection");
	
	self.realManageSpeedLimiter = SpecializationUtil.callSpecializationsFunction("realManageSpeedLimiter");
	self.realSetSpeedLimiterValue = SpecializationUtil.callSpecializationsFunction("realSetSpeedLimiterValue");
	
	self.realManageSpeedLevelLimit = SpecializationUtil.callSpecializationsFunction("realManageSpeedLevelLimit");
	self.realSetSpeedLevelLimit = SpecializationUtil.callSpecializationsFunction("realSetSpeedLevelLimit");
	
	self.realSetShuttleDisplayDirection = SpecializationUtil.callSpecializationsFunction("realSetShuttleDisplayDirection");
	self.realShuttleDisplayDirection = 1;
	
	self.realManageLockSteeringSystem = SpecializationUtil.callSpecializationsFunction("realManageLockSteeringSystem");
	self.realSetLockSteeringSystem = SpecializationUtil.callSpecializationsFunction("realSetLockSteeringSystem");	
	self.realLockSteeringSystem = false;
	
	self.realLastAutoRotateBackSpeedFactor = 0;
	self.realLastInputAxisXFactor = 0;
	
	self.realReverseDrivingModeEngaged = false;
	
	
	
	local realBrakeSound = getXMLString(xmlFile, "vehicle.realBrakeSound#file");
	if realBrakeSound ~= nil and realBrakeSound ~= "" then
		realBrakeSound = Utils.getFilename(realBrakeSound, self.baseDirectory);
		self.realBrakeSound = createSample("realBrakeSound");
		self.realBrakeSoundEnabled = false;
		loadSample(self.realBrakeSound, realBrakeSound, false);
		self.realBrakeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBrakeSound#pitchOffset"), 1);
		self.realBrakeSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBrakeSound#volume"), 1);
		setSamplePitch(self.realBrakeSound, self.realBrakeSoundPitchOffset);
	end;

	

end;



function RealisticSteerable:delete()    
	if self.realBrakeSound ~= nil then
		delete(self.realBrakeSound);
	end;
end;

function RealisticSteerable:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticSteerable:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticSteerable:update(dt)

	if self.isActive then --and self.realIsMotorStarted then
		self:realManageAwdMode();--TODO after wheelUtils computing !!!  else "realTotalMassOnMotorizedWheels" may be 0 whereas some new drive wheel has ground contact...		
		self:realManageTransmissionMode();
		self:realManageShuttle();	
		self:realManageSpeedLimiter();	
		self:realManageSpeedLevelLimit();
		self:realManageLockSteeringSystem();
	end;
	
	if self.isServer then		
		if Vehicle.debugRendering then
			self.realDebugDt = dt;
		end;
	end;
	
end;



function RealisticSteerable:updateTick(dt)	

	if not self.isActive then
		return;
	end;


	--must be done into update because the server has to broadcast the info even if it is not the current "driving" player 
	--print(self.time .. " checking vehicle / realShowTransmissionWarning = " .. tostring(self.realVehicleName) .. " / " .. tostring(self.realShowTransmissionWarning));
	if self.realShowTransmissionWarning then		
		if self.time>self.realTransmissionWarningCurrentDisplayMaxTime then	
			if g_server~=nil then
				--send the info to all clients
				g_server:broadcastEvent(RealisticSteerableTransmissionWarningEvent:new(self), nil, nil, self);
			end;			
		end;	
		self.realTransmissionWarningCurrentDisplayMaxTime = self.time + self.realTransmissionWarningDisplayTime;
		self.realShowTransmissionWarning = false;
	end;
	
	if self.isClient and self.realBrakeSound ~= nil then		
		if self.axisForward ~= nil then
			if not self.realBrakeSoundEnabled then
				if self.axisForward>0.7 and self.realDisplaySpeed>3 and self:getIsActiveForSound() then					
					playSample(self.realBrakeSound, 1, self.realBrakeSoundVolume, 0);
					self.realBrakeSoundEnabled = true;					
				end;
			else
				if self.axisForward<=0 then
					stopSample(self.realBrakeSound);
					if self.realDisplaySpeed>4 then
						self.realBrakeSoundEnabled = false;
					end;
				end;
			end;
		end;
	end;

	
	if self.isServer then	
	
		--there is someone controlling the vehicle (client or server)
		if self.isControlled then	
			
			if self.realShuttleIsManual then
				self:realSetShuttleDisplayDirection(self.realShuttleDirection);			
			else	
				if self.realReverseGearEngaged then				
					self:realSetShuttleDisplayDirection(-1);
				else					
					self:realSetShuttleDisplayDirection(1);
				end;	
			end;
		
		end;
	
			
		if self.realIsMotorStarted then			
			self.realDisplayTimer = self.realDisplayTimer + dt/1000;
			RealisticSteerable.updateDisplayInfo(self);
			RealisticSteerable.updateTransmissionWarning(self, dt);		
		else			
			self.realShowTransmissionWarning = false;			
			self.realTransmissionWarningCurrentDisplayMaxTime = 0;
			self.realTransmissionWarningCurrentDelayMaxTime = 0;		
			self.realDisplayTimer = 0;			
			self.realDisplaySpeed = 0;
		end;
				
				
		--workers do not consume fuel when "stuck" and alone (without a player entered in the vehicle)
		local computeFuelUsed = not (self.isHired and self.realGroundSpeed<0.1 and not self.isEntered);
		if g_currentMission.missionStats.difficulty==1 then
			computeFuelUsed = computeFuelUsed and (self.real2dGroundSpeed>0.01 or self.realMotorLoadS > 0.0001); --we are smart, and do not count fuel usage when not working (easy difficulty) => you can let your tractor at idle forever
		end;
		
		if computeFuelUsed then 
			
			local fuelUsed = 0;
			local fuelFactor = math.max(0.03, math.abs(self.realMotorLoadS)^0.7); -- minimum = 3% max consumption  | ^0.7 => big motor underloaded burn more fuel than smaller ones at full load
			  
			--fuelUsed = RealisticGlobalListener.realDifficultyFX7 * fuelFactor * self.realMaxFuelUsage * dt/(1000 * 3600); -- 2 / 1.5 / 1 factor for better game experience (else, it will be too long with recent tractors since they can run for 10hours at full load - that far too much for a game)
			--DURAL 20131029 - real fuel consumption now
			fuelUsed = fuelFactor * self.realMaxFuelUsage * dt/(1000 * 3600);
			
			--print("OverrideSteerable : fuel : " .. self.fuelUsage .. " / " .. dt .. " / " .. self.lastMovedDistance .. " / " .. fuelFactor .. " / " ..  g_currentMission.missionStats.playTimeSession .. " / " .. self.fuelFillLevel .. " / " .. usingTime .. " / " .. fuelUsed);
			--print("OverrideSteerable : " .. g_currentMission.missionStats.playTimeSession);
			
			
			--workers do not consumes fuel in easy difficulty
			if g_currentMission.missionStats.difficulty==1 and self:getIsHired() then
				--fuel costs
				local price = fuelUsed * g_fuelPricePerLiter;
				g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + price;
				g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + price;
				g_currentMission:addSharedMoney(-price, "vehicleRunningCost");
			else
				self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
			end;
							
				
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
						
		end;
		
	end;	

end;



function RealisticSteerable:readStream(streamId, connection)
	self.realAWDModeOn = streamReadBool(streamId);	
	--self.realReverseGearEngaged = streamReadBool(streamId);
	self.realTransmissionMode.currentMode = streamReadInt8(streamId);
	self.realShuttleDisplayDirection = streamReadInt8(streamId);
	self.realLockSteeringSystem = streamReadBool(streamId);
end;
 
function RealisticSteerable:writeStream(streamId, connection)
	streamWriteBool(streamId, self.realAWDModeOn);
	--streamWriteBool(streamId, self.realReverseGearEngaged);
	streamWriteInt8(streamId, self.realTransmissionMode.currentMode);
	streamWriteInt8(streamId, self.realShuttleDisplayDirection);
	streamWriteBool(streamId, self.realLockSteeringSystem);
end;




function RealisticSteerable:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		if streamReadBool(streamId) then
			self.realDisplaySpeed = 0.1*streamReadUIntN(streamId, 9);	
			if self.realDisplaySlip then
				self.realDisplaySlipPercent = 0.2*streamReadUIntN(streamId, 9);
			end;
			--EDIT 20131204 : display losses for combines
			if self.realDisplayHarvestingLosses then
				self.realDisplayHarvestingLossesPercent = streamReadUIntN(streamId, 7);
			end;
		end;
	end;
end;


function RealisticSteerable:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		if streamWriteBool(streamId, bitAND(dirtyMask, self.realSteerableDirtyFlag) ~= 0) then
			streamWriteUIntN(streamId, Utils.clamp(tonumber(self.realDisplaySpeed*10), 0, 511), 9); -- uint9 => 0 to 511	
			if self.realDisplaySlip then
				streamWriteUIntN(streamId, Utils.clamp(tonumber(self.realDisplaySlipPercent*5), 0, 511), 9); -- uint9 => 0 to 511
			end;
			--EDIT 20131204 : display losses for combines
			if self.realDisplayHarvestingLosses then
				streamWriteUIntN(streamId, Utils.clamp(tonumber(self.realDisplayHarvestingLossesPercent), 0, 127), 7); -- uint7 => 0 to 127
			end;
		end;
	end;
end;









RealisticSteerable.draw = function (self)


	if not self.isEntered then
		return;
	end;
	
	if self.realLockSteeringSystem then
		--display a help message to say how to desactivate the lock
		g_currentMission:addHelpButtonText(RealisticUtils.realTexts["REALISTIC_LOCK_STEERING_OFF"], InputBinding.REALISTIC_LOCK_STEERING);
	end;
	
	
	if self.realAWDModePossible then
		if self.realAWDModeOn then
			g_currentMission:addHelpButtonText(RealisticUtils.realTexts["AWD_OFF"], InputBinding.REALISTIC_AWD);
		else
			g_currentMission:addHelpButtonText(RealisticUtils.realTexts["AWD_ON"], InputBinding.REALISTIC_AWD);
		end;
	end;
	
	if self.time<self.realTransmissionWarningCurrentDisplayMaxTime then
		g_currentMission:addWarning("\n" .. RealisticUtils.realTexts["REALISTIC_WARNING_TRANSMISSION_NOT_ENOUGH_POWER"]);	
	end;
	
	
	
	--*********************************************************************************************************
	--DURAL : morerealistic info display
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_RIGHT);
	-- vehicle name
	setTextColor(0.0, 0.0, 0.0, 0.75);
	renderText(0.9828, 0.865-0.0015, 0.024, self.realVehicleName);
 
	setTextColor(0.5, 1.0, 0.5, 1.0);
	renderText(0.9828, 0.865, 0.024, self.realVehicleName);
	
	
	
	
	
	
	if self.realAWDModePossible then
		setTextColor(0.0, 0.0, 0.0, 0.75);
		renderText(0.9828, 0.84-0.0015, 0.024, "AWD");
		if self.realAWDModeOn then
			-- AWD engaged 
			setTextColor(1, 0.89, 0.267, 1.0);
			renderText(0.9828, 0.84, 0.024, "AWD");
		end;
	end;
	
	local xd1 = 0.9828;
	if self.realDisplaySlip then
		local slipTxt = string.format("%1.1f%% slip", self.realDisplaySlipPercent);
	
		setTextColor(0.0, 0.0, 0.0, 0.75);
		renderText(xd1, 0.820-0.0015, 0.018, slipTxt);		
			
		setTextColor(1, 1, 1, 1.0);
		renderText(xd1, 0.820, 0.018, slipTxt);		
	end;
	
	--EDIT 20131204 - display harvesting losses
	if self.realDisplayHarvestingLosses then	
		local lossesTxt = string.format("%1.0f%% losses", self.realDisplayHarvestingLossesPercent);
		
		local xd2 = 0.91;
		if not self.realDisplaySlip then
			xd2 = xd1;
		end;
	
		setTextColor(0.0, 0.0, 0.0, 0.75);
		renderText(xd2, 0.820-0.0015, 0.018, lossesTxt);		
			
		setTextColor(1, 1, 1, 1.0);
		renderText(xd2, 0.820, 0.018, lossesTxt);		
	end;
	
	
	
	if self.realTransmissionMode.switchPossible then
		local transText = self.realTransmissionMode.modes[self.realTransmissionMode.currentMode].text;
		setTextColor(0.0, 0.0, 0.0, 0.75);
		renderText(0.974, 0.730-0.0015, 0.024, transText);			
		setTextColor(1, 0.89, 0.267, 1.0);
		renderText(0.974, 0.730, 0.024, transText);		
	end;
	
	-- forward or backward engaged ?
	self.realForwardOverlay1:render();
	self.realBackwardOverlay1:render();
	
	--print(self.time .. " realShuttleDisplayDirection=" .. tostring(self.realShuttleDisplayDirection));
	
	--DURAL 2013/11/01 add "reverse driving mode" support
	local displayedDirection = self.realShuttleDisplayDirection;
	if self.realReverseDrivingModeEngaged then
		displayedDirection = -displayedDirection;
	end;
	
	if displayedDirection==1 then
		self.realForwardOverlay2:render();
	elseif displayedDirection==-1 then
		self.realBackwardOverlay2:render();		
	end;
	
	--** ONLY FOR DEBUG PURPOSE 
	if Vehicle.debugRendering and self.isServer then
		RealisticSteerable.realDebugPrintInfo01(self);
		RealisticSteerable.displayDebugInfo(self);
		RealisticSteerable.realUpdateDynamicTest1(self);
	end;
	
	--20131221 - reset render text parameters
	setTextBold(false);	
	setTextAlignment(RenderText.ALIGN_LEFT);

end;







function RealisticSteerable.updateDisplayInfo(self)

	if self.realDisplayTimer>0.4 then
		
		self.realDisplayTimer = 0;
		self.realDisplaySpeed = self.realGroundSpeed;
		self.realDisplaySlipPercent = self.realAvgTouchingMotorizedWheelSlipS*100;
		
		if self.realDisplayHarvestingLosses then
			self.realDisplayHarvestingLossesPercent = 0.5*self.realDisplayHarvestingLossesPercent + 0.5*100*self.realCombineCurrentLosses;
		end;
		
		self:raiseDirtyFlags(self.realSteerableDirtyFlag);
		
	end;

end;




function RealisticSteerable.updateTransmissionWarning(self, dt)
	
	--local acc = math.abs(self.realWantedAcceleration);
	--local avgWheelsSpeed = math.abs(self.realAvgMotorizedWheelSpd);
	--local lastAxisPower = math.abs(self.realLastAxisPower);
	
	
	-- transmission has not enough power when power go to at least one wheel, and accelerationn is full and average motorized wheel speed is null
	if not self.realManualGearSet and not (self.realShuttleIsManual and self.realShuttleDirection==0) and not self.realIsBraking and math.abs(self.lastAcceleration)>0.95 and self.realNbMotorizedWheels>0 and math.abs(self.realAvgMotorizedWheelSpd)<0.05 then 
		--print("self.time | self.realTransmissionWarningCurrentMaxTime : " .. self.time .. " | " .. self.realTransmissionWarningCurrentMaxTime);		
		if not self.realShowTransmissionWarning then
			if self.realTransmissionWarningCurrentDelayMaxTime==0 then
				self.realTransmissionWarningCurrentDelayMaxTime = self.time + self.realTransmissionWarningDelayTime;	
			elseif self.time>self.realTransmissionWarningCurrentDelayMaxTime then
				self.realShowTransmissionWarning = true;
				self.realTransmissionWarningCurrentDelayMaxTime = 0;
			end;
		end;
		
	else
		self.realShowTransmissionWarning = false;	
		self.realTransmissionWarningCurrentDelayMaxTime = 0;
	end;

end;

function RealisticSteerable:realManageAwdMode()
	if self.isControlled and self.realAWDModePossible then
		if self:getIsActiveForInput(false) and InputBinding.hasEvent(InputBinding.REALISTIC_AWD) then			
			self:realSetAwdActive(not self.realAWDModeOn);			
		end;
	end;
end;


function RealisticSteerable:realManageTransmissionMode()
	if self.isControlled and self.realTransmissionMode.switchPossible then
		if self:getIsActiveForInput(false) and InputBinding.hasEvent(InputBinding.REALISTIC_TRANSMISSION_MODE) then			
			self:realSetNextTransmissionMode();
		end;
	end;
end;

function RealisticSteerable:realManageShuttle()

	if self.isControlled then
		if g_server==nil then
			if self:getIsActiveForInput(false) and InputBinding.hasEvent(InputBinding.REALISTIC_SHUTTLE_DIRECTION) then
				--raise toggle shuttle event to say it to the server
				g_client:getServerConnection():sendEvent(RealisticSteerableToggleShuttleEvent:new(self, nil));
			end;
		else
			if self.realShuttleIsManual then
				if self:getIsActiveForInput(false) and InputBinding.hasEvent(InputBinding.REALISTIC_SHUTTLE_DIRECTION) then
					self:realSetNextShuttleDirection();								
				end;
			end;
		end;
	end;
	
end;


function RealisticSteerable:realManageSpeedLimiter()

	--if self.isControlled and self.motor.speedLevel>0 and not self:getIsHired() then
	if self.isControlled and not self:getIsHired() then
		if self:getIsActiveForInput(false) then
			if InputBinding.hasEvent(InputBinding.REALISTIC_SPEEDLIMITER_INC) then
				self:realSetSpeedLimiterValue(true);
			elseif InputBinding.hasEvent(InputBinding.REALISTIC_SPEEDLIMITER_DEC) then
				self:realSetSpeedLimiterValue(false);
			end;
		end;
	end;

end;


function RealisticSteerable:realManageSpeedLevelLimit()
	
	if self.isControlled and not self:getIsHired() then
		if self:getIsActiveForInput(false) then
			if InputBinding.hasEvent(InputBinding.REALISTIC_SET_SPEED_LEVEL_LIMIT_1) then
				self:realSetSpeedLevelLimit(1);
			elseif InputBinding.hasEvent(InputBinding.REALISTIC_SET_SPEED_LEVEL_LIMIT_2) then
				self:realSetSpeedLevelLimit(2);
			elseif InputBinding.hasEvent(InputBinding.REALISTIC_SET_SPEED_LEVEL_LIMIT_3) then
				self:realSetSpeedLevelLimit(3);
			elseif InputBinding.hasEvent(InputBinding.REALISTIC_SET_SPEED_LEVEL_LIMIT_4) then
				self:realSetSpeedLevelLimit(4);
			end;
		end;
	end;

end;



function RealisticSteerable:realManageLockSteeringSystem()
	if self.isControlled then
		if self:getIsActiveForInput(false) and InputBinding.hasEvent(InputBinding.REALISTIC_LOCK_STEERING) then			
			self:realSetLockSteeringSystem(not self.realLockSteeringSystem);			
		end;
	end;
end;


function RealisticSteerable:realSetNextTransmissionMode(noEventSend)	
	
	if self.isServer then

		local currMode = self.realTransmissionMode.currentMode;
		local switchingOk = false;
		
		for i=1, self.realTransmissionMode.maxMode do
			currMode = currMode + 1;
			if currMode>self.realTransmissionMode.maxMode then
				currMode = 1;				
			end;
			if self.realTransmissionMode.modes[currMode].enabled then
				self.realTransmissionMode.currentMode = currMode;
				switchingOk = true;
				break;
			end;
		end;
		
		if switchingOk then	
			if self.realTransmissionMode.currentMode == 1 then -- manual shuttle
				self.realDirectInverser = false;
				self.realShuttleIsManual = true;
			elseif self.realTransmissionMode.currentMode == 2 then -- double tap inverser
				self.realDirectInverser = false;
				self.realShuttleIsManual = false;
			elseif self.realTransmissionMode.currentMode == 3 then -- direct inverser (auto)
				self.realDirectInverser = true;
				self.realShuttleIsManual = false;
			end;
		end;
		
	end;
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RealisticSteerableToggleTransmissionModeEvent:new(self, self.realTransmissionMode.currentMode), nil, nil, self);
		else
			g_client:getServerConnection():sendEvent(RealisticSteerableToggleTransmissionModeEvent:new(self, nil));
		end;
	end;
	
	
end;



function RealisticSteerable:realSetAwdActive(awdActive, noEventSend)

	if awdActive~=self.realAWDModeOn then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(RealisticSteerableToggleAwdEvent:new(self, awdActive), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(RealisticSteerableToggleAwdEvent:new(self, awdActive));
			end;
		end;
		
		self.realAWDModeOn = awdActive;	
		if awdActive then
			self.requiredDriveMode = 1;			
		else
			self.requiredDriveMode = 2;
		end;
		
	end;

end;



function RealisticSteerable:realSetNextShuttleDirection()

	local newShuttleDirection = self.realShuttleDirection * -1;
	if newShuttleDirection==0 then
		newShuttleDirection = 1;
	end;			
	self:realSetShuttleDirection(self.realShuttleDirection, newShuttleDirection);

end;


function RealisticSteerable:realSetSpeedLimiterValue(increase)

	if g_server == nil then
		--client side : notify the server that we want to increase/decrease the current speedLevel speed value		
		g_client:getServerConnection():sendEvent(RealisticSteerableSpeedLimiterEvent:new(self, increase));
	elseif self.motor.speedLevel>0 then
		--server side : modify the current speedlevel speedvalue		
		if increase then
			self.motor.realSpeedLevels[self.motor.speedLevel] = math.min(self.realMaxVehicleSpeed, self.motor.realSpeedLevels[self.motor.speedLevel] + 0.2);
		else
			self.motor.realSpeedLevels[self.motor.speedLevel] = math.max(0.5, self.motor.realSpeedLevels[self.motor.speedLevel] - 0.2);
		end;
	end;

end;



function RealisticSteerable:realSetSpeedLevelLimit(speedLevel)
	
	if g_server ~= nil then
		--if we are the server, just set the new speed level and speed limit
		self.motor.realSpeedLevels[speedLevel] = Utils.clamp(self.realGroundSpeed*3.6, 0.5, self.realMaxVehicleSpeed);
		
		--by default, setting speed level and setting speed level limit share the same base key (example : key 1 for setting the speed level 1 and CTRL + 1 to set the speed limit for speed level 1)
		--and so, when we set the speed level limit, we set the current speed level too.
		if self.motor.speedLevel~=speedLevel then
			Steerable.setSpeedLevel(self, speedLevel);
		end;
	else
		--if we are the client, tell the server which speedLevel we want to set to the current speed
		g_client:getServerConnection():sendEvent(RealisticSteerableSetSpeedLevelLimitEvent:new(self, speedLevel));
	end;

end;



function RealisticSteerable:realSetShuttleDisplayDirection(direction, noEventSend)
	
	if self.realShuttleDisplayDirection ~= direction then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(RealisticSteerableShuttleDisplayDirectionEvent:new(self, direction), nil, nil, self);
			end;
		end;
		self.realShuttleDisplayDirection = direction;
		
		--print(self.time .. " RealisticSteerable:realSetShuttleDisplayDirection  new direction = " .. tostring(direction));
	end;

end;


function RealisticSteerable:realSetLockSteeringSystem(lockSteeringSystem, noEventSend)
	
	if self.realLockSteeringSystem ~= lockSteeringSystem then		
		if g_server==nil then
			--client side : tell the server if we want to lock or not the steering
			g_client:getServerConnection():sendEvent(RealisticSteerableToggleLockSteeringEvent:new(self, lockSteeringSystem));
		else
			--server side : if the event has not been transmitted, broadcast it to the clients
			if noEventSend == nil or noEventSend == false then				
				--broadcast the new steering lock state to all the clients
				g_server:broadcastEvent(RealisticSteerableToggleLockSteeringEvent:new(self, lockSteeringSystem), nil, nil, self);				
			end;
		end;
		self.realLockSteeringSystem = lockSteeringSystem;
		--print(self.time .. " RealisticSteerable:realSetShuttleDisplayDirection  new direction = " .. tostring(direction));
	end;

end;





function RealisticSteerable:getSaveAttributesAndNodes(nodeIdent)

	local nodes = "";
	
	--adding the current speed limits for each speed level
	for i=1, table.getn(self.motor.realSpeedLevels) do
		if i>1 then
			nodes = nodes.."\n";
		end;
		nodes = nodes.. nodeIdent..string.format('<realSpeedLimiter%d', i)..' speedLimit="'..self.motor.realSpeedLevels[i]..'" />';
	end;
	
	--adding the current transmission mode
	local attributes = string.format('realSelectedTransmissionMode="%d"', self.realTransmissionMode.currentMode);	
	--EDIT 20130906 - add steeringLock status
	attributes = attributes .. " " .. string.format('realLockSteeringSystem="%s"', tostring(self.realLockSteeringSystem));
	-- EDIT 20130909 - add the AWD status
	attributes = attributes .. " " .. string.format('realAWDModeOn="%s"', tostring(self.realAWDModeOn));
	

	return attributes, nodes;

end;

function RealisticSteerable:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	
	for i=1, table.getn(self.motor.realSpeedLevels) do
		local speedLevelKey = key..string.format(".realSpeedLimiter%d#speedLimit", i);
		local speedLimit = getXMLFloat(xmlFile, speedLevelKey);
		if speedLimit ~= nil then
			self.motor.realSpeedLevels[i] = math.min(self.realMaxVehicleSpeed, speedLimit);
		end;		
	end;
	
	local transMode = getXMLInt(xmlFile, key.."#realSelectedTransmissionMode");
	if transMode~=nil then
		--setting the previous transmission mode so that "realSetNextTransmissionMode" set the right mode
		self.realTransmissionMode.currentMode = transMode-1;
		RealisticSteerable.realSetNextTransmissionMode(self);
	end;
	
	--EDIT 20130906 - load steeringLock status
	self.realLockSteeringSystem = Utils.getNoNil(getXMLBool(xmlFile, key.."#realLockSteeringSystem"), false);

	--EDIT 20130906 - load AWD status	
	local awdActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#realAWDModeOn"), false);
	self:realSetAwdActive(awdActive, true);
	
	
	return BaseMission.VEHICLE_LOAD_OK;

end;











RealisticSteerable.realDebugPrintInfo01 = function(self)

	--__DURAL__
	if self.realDebugRenderingInitialized and self.isControlled then
			
		local fullText = "";
		
		
		setTextBold(false);
		setTextColor(1, 1, 1, 1);
		setTextAlignment(RenderText.ALIGN_LEFT);
		
		
				
		--local mtq, brk = self.motor:getTorque(1, self);
		
		if self.realTotalMassOnTheWheels~=nil then
			fullText = fullText .. string.format("total mass on the wheels : %1.3f T", self.realTotalMassOnTheWheels) .. "\n";
		end;
		
		if self.realTotalMovingMassOnTheWheels~=nil then			
			fullText = fullText .. string.format("total moving mass on the wheels : %1.3f T", self.realTotalMovingMassOnTheWheels) .. "\n";
		end;
		
		--renderText(0.5, 0.31, 0.025, string.format("motor accS : %1.3f", self.motor.realAccS));
		--renderText(0.5, 0.28, 0.025, string.format("realCurrentFadingOut : %1.8f", self.motor.realDebugCurrentFadingOut));
		
	
		fullText = fullText .. string.format("rotated time :  %1.9f", self.rotatedTime) .. "\n";
		
		local posX, posY, posZ = getWorldTranslation(self.realMainComponent.node);
		
		fullText = fullText .. string.format("position X,Y,Z : %1.3f %1.3f %1.3f", posX, posY, posZ) .. "\n";
		
		local rotX, rotY, rotZ = getWorldRotation(self.realMainComponent.node);		
		fullText = fullText .. string.format("rotation X,Y,Z : %1.3f %1.6f %1.3f", rotX, rotY, rotZ) .. "\n";
		
		
		
		--renderText(0.01, 0.43, 0.025, string.format("patinage tendance smooth : %1.3f", self.realSlipDirection2));
		--renderText(0.01, 0.40, 0.025, string.format("avg wheel slip : %1.3f", self.realAvgMotorizedWheelSlip*100) .. "%");		
		fullText = fullText .. string.format("cosAngleValue : %1.8f", self.realYCosValue) .. "\n";
		
		--renderText(0.01, 0.34, 0.025, string.format("motor tuning : %1.8f", self.motor.realFineTuning));
		--renderText(0.01, 0.31, 0.025, string.format("motor rpm s : %1.1f", self.motor.realMotorRpmS));				
		fullText = fullText .. string.format("regulator fx S : %1.3f", self.realRegulatorFxS) .. "\n";
		fullText = fullText .. string.format("motor load : %1.3f", self.realMotorLoad) .. "\n";
		fullText = fullText .. string.format("motor load S : %1.3f", self.realMotorLoadS) .. "\n";
		
		
		
		--renderText(0.01, 0.34, 0.025, string.format("DirectionAngle : %1.8f", self.realDirectionAngle));
		
		--renderText(0.01, 0.37, 0.025, string.format("patinage smooth 1 : %1.3f", self.realAvgMotorizedWheelSlip0*100) .. "%");
		--renderText(0.01, 0.34, 0.025, string.format("patinage smooth 2 : %1.3f", self.realAvgMotorizedWheelSlip2*100) .. "%");
		--renderText(0.01, 0.31, 0.025, string.format("patinage tendance : %1.3f", self.realSlipDirection));
		--renderText(0.01, 0.28, 0.025, string.format("display speed : %1.3f", self.realLastDisplaySpeed));
		--renderText(0.01, 0.25, 0.025, string.format("real speed : %1.3f", self.realLastRealSpeed));
		--renderText(0.01, 0.22, 0.025, string.format("patinage 2 : %1.3f", self.realLastGeneralSlipping*100) .. "%");
		--renderText(0.01, 0.19, 0.025, string.format("acc : %1.3f", self.realAcceleration) .. "m.s-2");
		
		fullText = fullText .. string.format("real spd 1 : %1.3f m.s-1", self.lastSpeedReal*1000) .. "\n";
		fullText = fullText .. string.format("real spd 2 : %1.3f m.s-1", self.realGroundSpeed) .. "\n";
		fullText = fullText .. string.format("acc : %1.3f m.s-2", self.realDebugAcc) .. "\n";
		
		
		--renderText(0.01, 0.10, 0.025, string.format("realAcc : %1.3f", self.realAcc));	
		
		
		--renderText(0.01, 0.10, 0.025, string.format("slip inc : %1.6f", self.realLastSlipInc));
		--renderText(0.01, 0.07, 0.025, string.format("boost pwr : %1.3f", self.realBoostPower));
		
		
		renderText(0.01, 0.25, 0.02, fullText);	
		
		
	end;


end;





function RealisticSteerable.displayDebugInfo(self)

	if Vehicle.debugRendering and self.realDebugRenderingInitialized then
				
		--if self.isControlled then
			--acc
		--	local newVel = Utils.vector3Length(getLinearVelocity(self.realMainComponent.node));
		--	self.realDebugAcc = (newVel-self.realGroundSpeed)*1000/dt;
		--end;				
		
		RealisticVehicle.manageTestButtons(self);
		RealisticVehicle.manageTest2Buttons(self);
		
		
		if self.isControlled then
		
			setTextBold(false);
			setTextColor(1, 1, 1, 1);
			setTextAlignment(RenderText.ALIGN_LEFT);
			
			local fullText = "";
			
			local angX, angY, angZ = getAngularVelocity(self.realMainComponent.node);
			
			fullText = fullText .. string.format("realTestValue : %1.0f", self.realTestValue) .. "\n";
			fullText = fullText .. string.format("vel dx: %1.4f", self.realVelX) .. "\n";
			fullText = fullText .. string.format("vel dy: %1.4f", self.realVelY) .. "\n";
			fullText = fullText .. string.format("vel dz: %1.4f", self.realVelZ) .. "\n";
			fullText = fullText .. string.format("vel rx: %1.4f", angX) .. "\n";
			fullText = fullText .. string.format("vel ry: %1.4f", angY) .. "\n";
			fullText = fullText .. string.format("vel rz: %1.4f", angZ) .. "\n";
			fullText = fullText .. string.format("moving mass : %1.4f", self.realTotalMovingMass*1000) .. "\n";
			--fullText = fullText .. string.format("dt : %1.4f", dt);
			
			renderText(0.3, 0.19, 0.02, fullText);
			
			
			
			
			
			
			
			local brakeText = "Braking";
			if not self.realDebugBrakeActivated then
				brakeText = "idle";			
			end;
			
			local fullText = "";
			
			
			
			for k, wheel in pairs(self.wheels) do
				fullText = fullText .. string.format("W %d, y/mS %4.2f/%4.2f, maxF %4.1f, curF %4.1f, wSpd %4.2f brk %1.1f tPwr %4.1f s %4.3f axleSpdAdd %7.5f mBf %5.2f", 
				wheel.num, (wheel.realY-wheel.netInfo.yMin)*100, wheel.realSupportedMassS, wheel.realDebugMaxPossibleForce, wheel.realGroundForce, wheel.axleSpeed*wheel.radius, wheel.realDebugBrakeForce, wheel.realPowerApplied, wheel.realLastSlip, wheel.realAxleSpdAdd, wheel.realDebugMotorBrakeForce) .. "\n";			
			end;
			
			--attached implement wheels
			for k, implement in pairs(self.attachedImplements) do
				if implement.object.wheels and implement.object.isRealistic then
					local implementHasWheels = false;
					--print("RealisticVehicle:draw " .. tostring(implement.object.wheels));
					for k, wheel in pairs(implement.object.wheels) do
						fullText = fullText .. string.format("W %d, y/mS %1.2f/%1.2f, brk %1.1f axleSpd %1.2f wSpd %1.1f", 
						wheel.num, (wheel.realY-wheel.netInfo.yMin)*100, wheel.realSupportedMassS, wheel.realDebugBrakeForce, wheel.axleSpeed, wheel.axleSpeed*wheel.radius) .. "\n";					
						implementHasWheels = true;
					end;
				
					if implementHasWheels then
						break; --only first implement with wheels
					end;
				end;			
			end;
			
			
			
			fullText = fullText .. string.format("brakepedal : %1.3f", self.realBrakePedal) .. "\n";
			fullText = fullText .. string.format("reverseTimer : %1.2f", self.realReverseTimer) .. "\n";
			fullText = fullText .. string.format("brake : " .. brakeText) .. "\n";
			fullText = fullText .. string.format("Reverse gear engaged : " .. tostring(self.realReverseGearEngaged)) .. "\n";	
			
			fullText = fullText .. string.format("Current axis power : %1.2f", self.realLastAxisPower) .. "\n";
			fullText = fullText .. string.format("Current power consumption : %1.2f", self.realCurrentTotalPowerConsumption) .. "\n";
			fullText = fullText .. string.format("Spd fx : %1.2f", self.realSoundSpdFx) .. "\n";
			fullText = fullText .. string.format("Motor fx : %1.2f", self.realSoundMotorFx) .. "\n";
			
			
			fullText = fullText .. string.format("General rain Fx : %1.2f / rainScale : %1.2f", RealisticGlobalListener.realRainFx, g_currentMission.environment.lastRainScale) .. "\n";
			fullText = fullText .. string.format("Stiff factor : %1.2f", self.realStiffFactor) .. "\n";
			
			fullText = fullText .. string.format("Avg slippage : %1.1f", self.realAvgTouchingMotorizedWheelSlipS*100) .. "%\n";
			fullText = fullText .. string.format("MotorBrake Fx : %1.2f", self.realCurrentMotorBrakeForceFx) .. "%\n";
			--fullText = fullText .. string.format("input x smoothed : %1.3f", self.realInputAxisXS) .. "\n";
			
			
			renderText(0.01, 0.97, 0.02, fullText);		
			
			
			
			
			
		end;
			
	end;--debug

end;








function RealisticSteerable.realUpdateDynamicTest1(self)


	-- TEST
	if not self.realDebugRenderingInitialized then
		return;
	end;
	
	
	setTextBold(false);
	setTextColor(1, 1, 1, 1);
	setTextAlignment(RenderText.ALIGN_LEFT);
	
	
	--Vehicle.testUpdate(self, dt);
	
	--self.testAcc = self.testAcc;
	--self.testLastAcceleration = self.testLastAcceleration;
	
	if not self.testFinBlocage then
		if self.testAcc==1 then
			self.testFinBlocage = self.lastAcceleration<self.testLastAcceleration;
		else
			self.testFinBlocage = self.lastAcceleration>self.testLastAcceleration;
		end;			
	end;
	self.testLastAcceleration = self.lastAcceleration;
	
	
	if self.testFinBlocage and self.testAcc==0 and self.lastAcceleration>0 then
		self.testAcc=1;
		self.testFinBlocage = false;
		
			
	end;
	
	if self.testFinBlocage and self.testAcc==1 and self.lastAcceleration<1 then
		self.testAcc=0;
		self.testFinBlocage = false;
		self.testDist2 = 0;
	end;
	
	
	if self.testAcc==1 then				
		self.testDist2 = 0;
		self.testDistanceStarted = false;				
	end;
	

	if self.testTimerStarted then
		
		if self.testAcc==0 then
			self.testTimerStarted = false;				
			self.testSpeed = self.lastSpeed*3600;	

			self.testDistanceStarted = true;
			self.testDist2 = 0;
			local newX,newY,newZ = getWorldTranslation(self.realMainComponent.node);
			self.testLastPosition = {newX,newY,newZ};
			
		else
			self.testTimer = self.testTimer + self.realDebugDt/1000;
			
			--dist during acceleration
			local newX,newY,newZ = getWorldTranslation(self.realMainComponent.node);			
			local dX, dY, dZ = newX - self.testLastPosition[1], newY - self.testLastPosition[2], newZ - self.testLastPosition[3];
			self.testLastPosition = {newX,newY,newZ};
			self.testDist1 = self.testDist1 + Utils.vector3Length(dX, dY, dZ);
			
		end;
		
	else
		
		if self.testAcc==1 then
			self.testTimer = 0;
			self.testTimerStarted = true;
			self.testDist1 = 0;
			local newX,newY,newZ = getWorldTranslation(self.realMainComponent.node);
			self.testLastPosition = {newX,newY,newZ};	
		end;
		
		if self.testDistanceStarted then
			local newX,newY,newZ = getWorldTranslation(self.realMainComponent.node);			
			local dX, dY, dZ = newX - self.testLastPosition[1], newY - self.testLastPosition[2], newZ - self.testLastPosition[3];
			self.testLastPosition = {newX,newY,newZ};
						
			if math.abs(self.lastSpeedReal*1000)<0.1 then	
				self.testDistanceStarted = false;					
			end;
			
			self.testDist2 = self.testDist2 + Utils.vector3Length(dX, dY, dZ);
			
		
		end;
		
	end;
	
	
	local decc = 0;
	if self.testDist2~=0 then
		decc = (self.testSpeed/3.6)^2/(2*self.testDist2);
	end;
	renderText(0.75, 0.67, 0.025, string.format("deceleration : %1.4f", decc));
	renderText(0.75, 0.64, 0.025, string.format("chrono : %1.4f", self.testTimer));
	renderText(0.75, 0.61, 0.025, string.format("speed : %1.4f", self.testSpeed));
	renderText(0.75, 0.58, 0.025, string.format(" dist : %1.4f", self.testDist1));
	renderText(0.75, 0.55, 0.025, string.format("braking dist : %1.4f", self.testDist2));
	renderText(0.75, 0.52, 0.025, string.format("cur spd 1 : %1.4f", self.lastSpeed*3600));	
	if self.isRealistic then
		renderText(0.75, 0.49, 0.025, string.format("cur spd 2 : %1.4f", self.realGroundSpeed*3.6));
		--renderText(0.75, 0.49, 0.025, string.format("cur spd 3 : %1.4f", self.realGrndSpeed*3.6) .. "m.s-1");
	end;
		
	


end;
