RealisticMower = {};

function RealisticMower.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
end;


function RealisticMower:load(xmlFile) 
	
	self.isRealisticMower = true;
	self.realMowerWasTooFast = false;

	self.realMowerWorkingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realMowerWorkingPowerConsumption"), 0);	
	self.realMowerWorkingPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realMowerWorkingPowerConsumptionInc"), 0);
	
	self.realMowerWorkingSpeedLimit = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realMowerWorkingSpeedLimit"), 30); --kph
	
	
	--loading mowerCutAreaResistance if present
	self.realMowerUseResistance = false;
	local i = 0;
	while true do
		local areaKey = string.format("vehicle.mowerCutAreas.mowerCutArea(%d)", i);
		if not hasXMLProperty(xmlFile, areaKey) then
			break;
		end
		local area = {};
		if self:loadAreaFromXML(area, xmlFile, areaKey) then
			self.mowerCutAreas[i+1].realMowerWorkingResistance = Utils.getNoNil(getXMLFloat(xmlFile, areaKey .. "#realMowerWorkingResistance"), 0);
			if self.mowerCutAreas[i+1].realMowerWorkingResistance~=0 then
				self.realMowerUseResistance = true;
			end;			
		end;
		i = i + 1;
	end;	
	
	
	self.realGetIsWorkingTooFast = RealisticMower.realGetIsWorkingTooFast;
	
	
	self.realCurrentPowerConsumption = 0;
	self.realMowerTmpAreaS = 0;
	self.realCurrentMowerWorkingResistance = 0;
  
end;

function RealisticMower:delete()    
end;

function RealisticMower:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticMower:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticMower:updateTick(dt)	

	if self.isServer and self.isActive then
	
		self.realCurrentMowerWorkingResistance = 0;
		if self.realMowerUseResistance then			
			--update "resistance"		
			local x,y,z = getWorldTranslation(self.groundReferenceNode);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			if terrainHeight+self.groundReferenceThreshold >= y then
				for _,area in pairs(self.mowerCutAreas) do
					if self:getIsAreaActive(area) then
						--add mowerCutArea resistance
						self.realCurrentMowerWorkingResistance = self.realCurrentMowerWorkingResistance + area.realMowerWorkingResistance;
					end;
				end;
			end;
		end;
		
		self.realCurrentPowerConsumption = 0;
		if self.isTurnedOn then -- the mower is active
			self.realCurrentPowerConsumption = self.realMowerWorkingPowerConsumption;
			
			self.realMowerTmpAreaS = 0.9*self.realMowerTmpAreaS + 0.1*self.lastMowerArea*g_currentMission:getFruitPixelsToSqm();			
			self.realCurrentPowerConsumption = self.realCurrentPowerConsumption + self.realMowerWorkingPowerConsumptionInc*self.realMowerTmpAreaS/(0.06*dt);-- now we do not use the speed to "dampen" the powerInc since 2013 version of the moreRealistic engine is more steady					
			
			--print(self.time .. " RealisticMower:updateTick - last area cut = " .. self.realTmpAreaS);
		else
			self.realMowerTmpAreaS = 0;
		end;		
		
	end;

end;


function RealisticMower:update(dt)

	if self.isServer and self.isActive then
		if self.realMowerUseResistance and self.realCurrentMowerWorkingResistance>0 and self.realGroundSpeed>0.1 then
			local force = -self.realCurrentMowerWorkingResistance*dt/1000/ self.realGroundSpeed;-- direction vector = velocity vector					
			addForce(self.realMainComponent.node, force*self.realVelX, force*self.realVelY, force*self.realVelZ, self.realComX, self.realComY, self.realComZ, true);	
		end;
	end;

end;

function RealisticMower:draw() 		
end;

--20131017
--called within RealisticVehicle:draw
function RealisticMower:realGetIsWorkingTooFast()	
	return self.realMowerWasTooFast, self.realMowerWorkingSpeedLimit;
end;

