

RealisticGlobalListener = {};

--__DEBUG__
--Vehicle.debugRendering = true;
addConsoleCommand("debugmode", "Toggles the debug rendering of the vehicles", "Vehicle.consoleCommandToggleDebugRendering", nil);
addConsoleCommand("givememoney", "Add 1000000$ to your bank account", "RealisticGlobalListener.consoleCommandGiveMeMoney", nil);
addConsoleCommand("givemesilos", "Add 100000L to all of your silos", "RealisticGlobalListener.consoleCommandGiveMeSilos", nil);

RealisticGlobalListener.dt = 1/60;

--RealisticGlobalListener.AIMaxSteeringDeltaTime = 0.001;


RealisticGlobalListener.realFirstLoadMap = true;
RealisticGlobalListener.realFirstUpdate = true;
RealisticGlobalListener.realGameTimeScale = 1;
RealisticGlobalListener.realMissionTime = 0; -- s
RealisticGlobalListener.realDtS = 0; -- "smoothed" dt in s


RealisticGlobalListener.realRainModeActive = false; -- for different wheel lateral stiffness setting




--RealisticGlobalListener.realNeedStoreItemsPriceRefresh = true;

RealisticGlobalListener.realCurrentDay = -1;

--difficulty multipliers : hard, normal easy => set in RealisticGlobalListener:update (first update)
RealisticGlobalListener.realDifficultyFX5 = 1; -- 1 / 1 / 0.5 -- seed usage
--RealisticGlobalListener.realDifficultyFX6 = 1; -- 1 / 2 / 4 -- std game difficulty multiplier
RealisticGlobalListener.realDifficultyFX7 = 1; -- 2 / 1.5 / 1 -- fuel usage "bonus" / not used anymore, but keep it for compatibility with old version of the "mrManualIgnition"
RealisticGlobalListener.realDifficultyFX8 = 1; -- 1 / 1 / 0.5   -- sprayer usage "bonus"
--RealisticGlobalListener.realDifficultyFX9 = 1; -- 0.5 / 0.666 / 1

RealisticGlobalListener.realStationList = nil;
RealisticGlobalListener.realPDADisplayedFillTypes = nil;





--Map maker can modify these values when loading their map
function RealisticGlobalListener.setVariable()
	 
	
	
	

	RealisticGlobalListener.gravity = 9.81;
	RealisticGlobalListener.tractionForceTuning = 1; -- general force coeff. applied to wheel force delivered to the ground
	RealisticGlobalListener.realFrictionTuning = 1.1; -- general friction coeef. used to compute max possible force delivered by a wheel.
	RealisticGlobalListener.rollingResistanceTuning = 1; -- general rolling resistance coeff. applied to vehicle rolling resistance
	RealisticGlobalListener.airResistanceTuning = 1; -- general air resistance coeff. applied to vehicle air resistance
	RealisticGlobalListener.motorBrakeForceTuning = 1; -- general motorBrakeForce coeff.
	RealisticGlobalListener.antiRollForceTuning = 0.12; -- general antiroll force coeff
	RealisticGlobalListener.initTime = 2000; -- 2s to initialize vehicle mass
	RealisticGlobalListener.draftForceTuning = 1; -- general draft force coeff (applyied to "realiticTool" resistance force) -> nice if we could modify it function of soil type (clay or sand)
	
	RealisticGlobalListener.realRoadTractionFx = 1.1; -- real figure should be near 1.07 (of course, it depends on the wheel rubber, road material, humidity and temperature)
	RealisticGlobalListener.realFieldTractionFx = 0.7;
	
	

	RealisticGlobalListener.fuelDensity = 0.83;	
	
	
	RealisticGlobalListener.priceBalancing = 1; -- general price balancing applied to all selling/buying product / EDIT 20131204 : base price multiplier = 1 = real
	
	RealisticGlobalListener.seedPriceBalancing = 1; -- should take into account priceBalancing also applied -> total multiplier = priceBalancing x seedPriceBalancing
	RealisticGlobalListener.balePriceBalancing = 1.5; -- should take into account priceBalancing already applied -> total multiplier = priceBalancing x balePriceBalancing [ x windrowPriceBalancing in case of windrow fill type]
	RealisticGlobalListener.woolPriceBalancing = 4;-- should take into account priceBalancing already applied -> total multiplier = priceBalancing x woolPriceBalancing
	RealisticGlobalListener.eggPriceBalancing = 3; -- should take into account priceBalancing already applied -> total multiplier = priceBalancing x eggPriceBalancing
	RealisticGlobalListener.milkPriceBalancing = 0.2; -- should take into account priceBalancing already applied -> total multiplier = priceBalancing x milkPriceBalancing
	RealisticGlobalListener.fuelPriceBalancing = 1;  -- should take into account priceBalancing already applied -> total multiplier = priceBalancing x fuelPriceBalancing
	RealisticGlobalListener.fertilizerPriceBalancing = 1; -- should take into account priceBalancing already applied -> total multiplier = priceBalancing x fertilizerPriceBalancing
	
	--20131220 - windrow
	RealisticGlobalListener.windrowPriceBalancing = 2.5; -- -- should take into account priceBalancing already applied -> total multiplier = priceBalancing x windrowPriceBalancing
	
	RealisticGlobalListener.silagePriceBalancing = 1; -- should take into account priceBalancing already applied -> total multiplier = priceBalancing x silagePriceBalancing
	
	RealisticGlobalListener.pigPriceBalancing = 0.15; -- should take into account priceBalancing already applied -> total multiplier = priceBalancing x pigPriceBalancing
	
	RealisticGlobalListener.hiredWorkerWageBalancing = 1/20; -- should take into account priceBalancing already applied -> total multiplier = priceBalancing x hiredWorkerWageBalancing | base wage is 2000 / hour, we want to set it to 100/H when playing in hard with real prices. Of course, this multiplier has to be set for each "mr" map to be right according to the price balancing
	
	RealisticGlobalListener.startingSilosBaseAmount = 5000; -- this is a "value" amount
	RealisticGlobalListener.startingMoney = 25000;
	
	
	--*************************************************************************************************************************
	--20131029 - loading specific map configuration
	
	--print("  TEST0 = " .. tostring(g_currentMission.realMapBaseDirectory));
	--if g_currentMission.realMapBaseDirectory~=nil then
	
	--20131220 - no need for the "g_currentMission.realMapBaseDirectory" anymore
	
	local baseMapDirectory = g_currentMission.missionInfo.baseDirectory;	

	--print(" TEST1 = " .. tostring(baseMapDirectory));
	
	if baseMapDirectory~= nil then
		
		local xmlPath = baseMapDirectory .. "realisticStartSettings.xml";
		
		
		print("**** moreRealistic engine : trying to load the specific configuration file of the current map (if the file is not present, you will see an error just below this line - do not take it into account - ****");
		local xmlFile = loadXMLFile("startSettings", xmlPath);
		
		--print("  TEST1 = " .. tostring(xmlPath));
		
		if xmlFile~=nil then
		
			local xmlMainNode = "startSettings";
		
			--print("  TEST2 = " .. tostring(getXMLFloat(xmlFile, xmlMainNode .. ".priceBalancing#value")));
			
			local value = getXMLFloat(xmlFile, xmlMainNode .. ".priceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.priceBalancing = value;
			end;
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".seedPriceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.seedPriceBalancing = value;
			end;
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".balePriceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.balePriceBalancing = value;
			end;
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".woolPriceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.woolPriceBalancing = value;
			end;			
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".eggPriceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.eggPriceBalancing = value;
			end;
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".milkPriceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.milkPriceBalancing = value;
			end;
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".fuelPriceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.fuelPriceBalancing = value;
			end;
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".fertilizerPriceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.fertilizerPriceBalancing = value;
			end;
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".silagePriceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.silagePriceBalancing = value;
			end;
			
			--20131220 - windrow
			value = getXMLFloat(xmlFile, xmlMainNode .. ".windrowPriceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.windrowPriceBalancing = value;
			end;			
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".pigPriceBalancing#value");
			if value~=nil then
				RealisticGlobalListener.pigPriceBalancing = value;
			end;
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".startingSilosBaseAmount#value");
			if value~=nil then
				RealisticGlobalListener.startingSilosBaseAmount = value;
			end;
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".startingMoney#value");
			--print("RealisticGlobalListener.setVariable - startingMoney=" .. tostring(value));
			if value~=nil then
				RealisticGlobalListener.startingMoney = value;
			end;	

			value = getXMLFloat(xmlFile, xmlMainNode .. ".hiredWorkerWageBalancing#value");			
			if value~=nil then
				RealisticGlobalListener.hiredWorkerWageBalancing = value;
			end;			
			
			value = getXMLFloat(xmlFile, xmlMainNode .. ".fieldTractionFx#value");			
			if value~=nil then
				RealisticGlobalListener.realFieldTractionFx = value;
			end;
			
			
			delete(xmlFile);
			
		end;
	--end; -- g_currentMission.realMapBaseDirectory~=nil
	end; -- end baseMapDirectory~= nil
	--*************************************************************************************************************************
	
	
	
	RealisticGlobalListener.realRainFx = g_currentMission.environment.lastRainScale;
	RealisticGlobalListener.realRainFx2 = 1 - 0.5 * RealisticGlobalListener.realRainFx;
	
	RealisticGlobalListener.AREA_CORRECTION_ENABLED = true;
	RealisticGlobalListener.AREA_MAX_CORRECTION = 0.4;

end;




function RealisticGlobalListener:loadMap(name)

	if RealisticGlobalListener.realFirstLoadMap then
		RealisticGlobalListener.realFirstLoadMap = false;
		--call setVariable once
		RealisticGlobalListener.setVariable();
	end;
	
end;

function RealisticGlobalListener:deleteMap()  

	--print("RealisticGlobalListener:deleteMap => reset global variable");

	--reset global variable
	RealisticGlobalListener.realMissionTime = 0; -- s
	--RealisticGlobalListener.realNeedStoreItemsPriceRefresh = true;
	RealisticGlobalListener.realCurrentDay = -1;	
	
	RealisticGlobalListener.realFirstUpdate = true;
	RealisticGlobalListener.realFirstLoadMap = true;
	
	g_currentMission.realMapOverrideStartingMoneyAndSilo = false;
	--g_currentMission.realMapBaseDirectory = nil;
  
end;

function RealisticGlobalListener:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticGlobalListener:keyEvent(unicode, sym, modifier, isDown)
end;



function RealisticGlobalListener:update(dt)

	if RealisticGlobalListener.realFirstUpdate then			
	
		RealisticGlobalListener.realFirstUpdate = false;	
		RealisticGlobalListener.realDtS = dt/1000;
		
		--computing difficulty multipliers (hard, normal, easy)
		--RealisticGlobalListener.realDifficultyFX5 = 1.75 + g_currentMission.missionStats.difficulty * 0.25; -- 2 / 2.25 / 2.5
		--RealisticGlobalListener.realDifficultyFX6 = 2^math.max(0, 3-g_currentMission.missionStats.difficulty); -- 1 / 2 / 4
		--RealisticGlobalListener.realDifficultyFX7 = 0.5 + g_currentMission.missionStats.difficulty*0.5; -- 2 / 1.5 / 1
		--RealisticGlobalListener.realDifficultyFX8 = 1 - 0.15*(3-g_currentMission.missionStats.difficulty); -- 1 / 0.85 / 0.7
		--RealisticGlobalListener.realDifficultyFX9 = 2/(1+g_currentMission.missionStats.difficulty); -- 0.5 / 0.666 / 1
		
		--DURAL 20131029 - only give "bonus" for easy difficulty
		if g_currentMission.missionStats.difficulty==1 then
			RealisticGlobalListener.realDifficultyFX8 = 0.5;
			RealisticGlobalListener.realDifficultyFX5 = 0.5;
		end;
		
		--test class
		--RealisticUtils.testClass("g_currentMission.fieldDefinitionBase", g_currentMission.fieldDefinitionBase);
		--local fieldDef = g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber[15];
		--RealisticUtils.testClass("fieldDef 15", fieldDef);
		
		--RealisticUtils.testClass("g_currentMission", g_currentMission);
		
		--RealisticUtils.testClass("TrafficVehicleUtil", TrafficVehicleUtil);
		
	
		
		--RealisticUtils.testClass("RoadUtil.roads[1].crossroads[1]", RoadUtil.roads[1].crossroads[1]);
		--RealisticUtils.testClass("RoadUtil.roads[1].roadsToCrossroads   ", RoadUtil.roads[1].roadsToCrossroads);
		
		--testing all roads
		--[[
		for k0,road in pairs(RoadUtil.roads) do
		
			print("** TESTING ROAD " .. tostring(k0) .. " / " .. getName(road.spline));
			for _,p0 in pairs(road)do
				print(tostring(_) .. " = " .. tostring(p0));
			end;
		
			for k,crossroad in pairs(road.crossroads) do
			
				print("** CROSSROAD " .. tostring(k));
				for k2, param in pairs(crossroad) do
					print(tostring(k2) .. " : " .. tostring(param));
				end;
				if crossroad.road2~=nil then
					print("  road2 name = " .. getName(crossroad.road2.spline));
				else
					print("  road2 name = no road 2 for this crossroad...");
				end;
			
			end;
			
		end;]]
		
		--RealisticUtils.testClass("Fillable", Fillable);
		
		--for index,fruitDesc in pairs(FruitUtil.fruitIndexToDesc) do
			--RealisticUtils.testClass("FruitUtil.fruitIndexToDesc[" .. tostring(index) .. "]", fruitDesc);
			--RealisticUtils.testClass("Fruit : " .. tostring(fruitDesc.name), fruitDesc.forageWagonConversionSources);
		--end;
		
		--RealisticUtils.testClass("g_gui", g_gui);
		
		--print("g_fuelPricePerLiter = " .. tostring(g_fuelPricePerLiter));
		--print("milk price : " .. tostring(Fillable.fillTypeNameToDesc["milk"].pricePerLiter));
		
		--RealisticUtils.testClass("_G.MapsUtil", _G.MapsUtil);
		
		--RealisticUtils.testClass("g_currentMission.missionInfo", g_currentMission.missionInfo);
				
		-- condition for a new game :
		-- g_currentMission.missionInfo.saveDate == "--.--.--"
		-- g_currentMission.missionInfo.playTime == 0
		-- g_currentMission.missionInfo.isValid == false	
		RealisticGlobalListener.registerStations();
		RealisticGlobalListener.registerPDADisplayedFillTypes();
		if not g_currentMission.missionInfo.isValid then 			
			-- we have to set the fruits prices and milk production scale again if its a new game (since our prices have been overrided when loading the default carrerGame.xml template)
			RealisticGlobalListener.setMissionInfosForNewGame(self);			
		end;
		RealisticGlobalListener.setMissionInfos(self);
		
		
		
		
		
		if g_server~=nil then			
			
			RealisticGlobalListener.loadMoreRealisticInfos();
					
			--RealisticGlobalListener.realGameTimeScale = g_settingsTimeScale;
		
		end;--g_server~=nil	
		
	end;--end first Update
	

	RealisticGlobalListener.realDtS = 0.97 * RealisticGlobalListener.realDtS + 0.03 * dt/1000;
	RealisticGlobalListener.realMissionTime = RealisticGlobalListener.realMissionTime + dt/1000; -- s
	
	
	--print("RealisticGlobalListener   realMissionTime / testing / g_server~=nil = " .. tostring(RealisticGlobalListener.realMissionTime) .. " / " .. tostring(RealisticGlobalListener.testing) .. " / " .. tostring(g_server));
	
	if g_server~=nil then
	
		

		if g_currentMission.environment.lastRainScale > RealisticGlobalListener.realRainFx then
			RealisticGlobalListener.realRainFx = math.min(g_currentMission.environment.lastRainScale, RealisticGlobalListener.realRainFx + g_currentMission.environment.lastRainScale * 0.001/6000 * dt * g_currentMission.missionStats.timeScale); -- 100 minutes to reach rainFx = 1 when rainScale = 1
		else
			if g_currentMission.environment.lastRainScale==0 then -- only increase back friction fx when it is not raining anymore
				RealisticGlobalListener.realRainFx = math.max(g_currentMission.environment.lastRainScale, RealisticGlobalListener.realRainFx - 0.001/7200 * dt * g_currentMission.missionStats.timeScale); --2 hour to fully dry from 1 to 0 (drying up)
			end;
		end;
		RealisticGlobalListener.realRainFx2 = 1 - 0.5*RealisticGlobalListener.realRainFx;		
		RealisticGlobalListener.realRainModeActive = RealisticGlobalListener.realRainFx>0.25;
		
		--print(RealisticGlobalListener.realMissionTime .. " lastRainScale=".. tostring(g_currentMission.environment.lastRainScale).." / newWantedFrictionFx = " .. tostring(newFrictionFx) .. " / frictionFx = " .. tostring(RealisticGlobalListener.realFrictionFx));
		
					
		--catching midnight event
		if RealisticGlobalListener.realCurrentDay~=g_currentMission.environment.currentDay then
			--print("RealisticGlobalListener:update => lastCurrentDay / currentDay :" .. tostring(RealisticGlobalListener.realCurrentDay) .. " / " ..  g_currentMission.environment.currentDay);
			
			--check if we are really changing day or if it is the loading of a savegame/newgame
			if RealisticGlobalListener.realCurrentDay~=-1 then			
				RealisticGlobalListener.refreshStationsPrices();
			end;		
			
			--RealisticGlobalListener.realNeedStoreItemsPriceRefresh = true;
			 
			RealisticGlobalListener.realCurrentDay = g_currentMission.environment.currentDay;		
		end;
		
		
		--[[if RealisticGlobalListener.realNeedStoreItemsPriceRefresh and not g_currentMission.storeIsActive then
			--//RealisticGlobalListener.refreshStoreItemsPrice();
			RealisticGlobalListener.realNeedStoreItemsPriceRefresh = false;
		end;]]
	
	end;--g_server~=nil
	
	
	
end;

function RealisticGlobalListener:draw()
end;



RealisticGlobalListener.setMissionInfos = function(self)

	
	if g_server~=nil then -- not useful for client		
		
		--no need for difficulty multiplier since the fruit prices are so high in normal or easy
		--we have to set the "g_fuelPricePerLiter since the "GasStationTrigger" class use it instead of the fillType.pricePerLiter for fuel...	
		RealisticUtils.setFillTypePriceV2("fuel");
		g_fuelPricePerLiter = (Fillable.fillTypeNameToDesc["fuel"]).pricePerLiter;		
				
		RealisticUtils.setFillTypePriceV2("fertilizer");	
		
		for k, fillType in pairs(Fillable.fillTypeNameToDesc) do
			-- no need for "difficultyMultiplier" since its already taking into acount by tipTrigger.lua and the pda display (multipliers = 1 / 2 / 4)					
			RealisticUtils.setFillTypePriceV2(fillType.name, true);
			--pricePerLiter and previousHourPrice are loaded from the careerSaveGame.xml
		end;
	
		for k, fruitType in pairs(FruitUtil.fruitTypes) do
			
			--protection to avoid "crash" when badly registered fruits are in the game 
			if fruitType.seedUsagePerSqm==nil then
				--RealisticUtils.printWarning("RealisticGlobalListener.setMissionInfos", "fruitType badly registered : " .. tostring(fruitType.name) .. " / seedUsagePerSqm=" .. tostring(fruitType.seedUsagePerSqm));
				fruitType.seedUsagePerSqm = 0;
			end;
		
					
			local found, seedPrice, usage, yield = RealisticUtils.getFruitInfosV2(fruitType.name);
			if found then																	
				fruitType.literPerSqm = yield;			
				fruitType.seedPricePerLiter = seedPrice;						 
				fruitType.seedUsagePerSqm = usage;	
				--print("RealisticGlobalListener.setMissionInfos - setting fruit info - name="..tostring(fruitType.name) .. " / literPerSqm="..tostring(yield) .. " / seedPricePerLiter="..tostring(seedPrice) .. " / seedUsagePerSqm="..tostring(usage));
			else
				if fruitType.seedUsagePerSqm>0 then
					--setting the selling price per liter as purchasing price				
					local fillType = FruitUtil.fruitTypeToFillType[fruitType.index];				
					fruitType.seedPricePerLiter = Fillable.fillTypeIndexToDesc[fillType].pricePerLiter;	
					RealisticUtils.printWarning("RealisticGlobalListener.setMissionInfos", "fruitType not found in RealisticUtils : " .. tostring(fruitType.name) .. " - seedPricePerLiter defined by default to : " .. tostring(fruitType.seedPricePerLiter));					
				end;
			end;	
			
			-- it a game => more enjoyable if we have to refill more often than in reality (we can't play with square miles fields..., it will take too much time for a game)
			--fruitType.seedUsagePerSqm = fruitType.seedUsagePerSqm * RealisticGlobalListener.realDifficultyFX5; -- 2 / 2.25  /  2.5	
			--DURAL - 20131029 - no more "high" usage for gameplay (except for easy difficulty)
			fruitType.seedUsagePerSqm = fruitType.seedUsagePerSqm * RealisticGlobalListener.realDifficultyFX5; -- 1 / 1 / 0.5
			
		end;
		
	end;--g_server~=nil
	
end;

RealisticGlobalListener.setMissionInfosForNewGame = function(self)

	--print("***** RealisticGlobalListener.setMissionInfosForNewGame ****** / starting money = " .. tostring(RealisticGlobalListener.startingMoney));

	--setting the milk production scale	
	--g_currentMission.milkProductionScale = RealisticGlobalListener.realDifficultyFX4;-- 0.5 0.25 0.166667
	
	if g_server ~= nil then
	
		for k, fillType in pairs(Fillable.fillTypeNameToDesc) do		
			RealisticUtils.setFillTypePriceV2(fillType.name);
		end;
		
		if not g_currentMission.realMapOverrideStartingMoneyAndSilo then
			--setting the starting money and starting silos filllevel
			g_currentMission.missionStats.money = RealisticGlobalListener.startingMoney;		
			
			--RealisticUtils.testClass("g_currentMission.missionStats.farmSiloAmounts", g_currentMission.missionStats.farmSiloAmounts);
			for fillTypeIndex, amount in pairs(g_currentMission.missionStats.farmSiloAmounts) do
				--20130814 - fix random amount for non commercial "fruits" (like grass, chaff, hay etc)
				-- => only set a random silos amount for base game fruits
				if RealisticUtils.isCommercialFillType(fillTypeIndex) then
					local rand = 0.3*math.random();
					local amount = RealisticGlobalListener.startingSilosBaseAmount;
					--20130919
					-- take into account the price per liter to set the sarting amount
					local found, density, pricePerKg, pricePerLiter = RealisticUtils.getFillTypeInfosV2(Fillable.fillTypeIndexToDesc[fillTypeIndex].name);
					if found and pricePerLiter>0 then
						-- we don't want to take into account priceBalancing
						pricePerLiter = pricePerLiter / RealisticGlobalListener.priceBalancing;
						--print("    RealisticGlobalListener.setMissionInfosForNewGame - filltype="..tostring(Fillable.fillTypeIndexToDesc[fillTypeIndex].name).." /pricePerLiter="..tostring(pricePerLiter));
						amount = amount * (0.15/pricePerLiter); -- 0.15 = 150/M3
					end;
					--g_currentMission.missionStats.farmSiloAmounts[fillTypeIndex] = (1-rand) * amount;
					
					--20130919
					--updating the visual "heap" if exist
					g_currentMission:setSiloAmount(fillTypeIndex, (1-rand) * amount);

				end;
			end;
		end;
		
	end;
	
	--not useful since the multipliers are already randomized when registerStation is called
	--if g_server~=nil then -- not useful for client
	--	RealisticGlobalListener.refreshStationsPrices();
	--end;
	
end;


--only needed because the fruit prices displayed on the PDA are in /M3 whereas the pda says "/T"
RealisticGlobalListener.registerPDADisplayedFillTypes = function()

	RealisticGlobalListener.realPDADisplayedFillTypes = {};

	for _, trigger in pairs(g_currentMission.tipTriggers) do
		if trigger.appearsOnPDA then
			for k, fillType in pairs(trigger.acceptedFillTypes) do
				if RealisticGlobalListener.realPDADisplayedFillTypes[k]==nil then
					--print("RealisticGlobalListener.registerPDADisplayedFillTypes : inserting = " .. tostring(k) .."/" .. tostring(Fillable.fillTypeIntToName[k]));
					RealisticGlobalListener.realPDADisplayedFillTypes[k]=true;
				end;
			end;
		end;
	end;

end;


RealisticGlobalListener.registerStations = function()

	RealisticGlobalListener.realStationList = {};

	--[[
	for _, trigger in pairs(g_currentMission.tipTriggers) do		
		
		if trigger.appearsOnPDA then
		
			print("RealisticGlobalListener.registerStations - checking trigger = " .. tostring(trigger) .. " for station " .. trigger.stationName);
		
			if RealisticGlobalListener.realStationList[trigger.stationName]==nil then
				print("RealisticGlobalListener.registerStations -     new station = " .. trigger.stationName);
				RealisticGlobalListener.realStationList[trigger.stationName] = {};
				RealisticGlobalListener.realStationList[trigger.stationName].realBasePriceMultipliers = {};
				RealisticGlobalListener.realStationList[trigger.stationName].realPriceMultipliers = {};
				--backing up base price multiplier	
				for k,multiplier in pairs(trigger.priceMultipliers) do				
					RealisticGlobalListener.realStationList[trigger.stationName].realBasePriceMultipliers[k] = multiplier;	
					-- in case "realisticInfos.xml" is empty or missing, we set the random price multipliers
					RealisticGlobalListener.realStationList[trigger.stationName].realPriceMultipliers[k] = RealisticUtils.getNewStationPriceMultiplier(multiplier);				
				end;
				RealisticGlobalListener.realStationList[trigger.stationName].triggerList = {};			
			end;
			
			print("RealisticGlobalListener.registerStations -       adding trigger " .. tostring(trigger) .. " to station " .. trigger.stationName);
			table.insert(RealisticGlobalListener.realStationList[trigger.stationName].triggerList, trigger);
			
			-- in case "realisticInfos.xml" is empty or missing, we set the random price multipliers
			for k,multiplier in pairs(RealisticGlobalListener.realStationList[trigger.stationName].realPriceMultipliers) do						
				for j,trigger in pairs(RealisticGlobalListener.realStationList[trigger.stationName].triggerList) do
					trigger.priceMultipliers[k] = RealisticGlobalListener.realStationList[trigger.stationName].realPriceMultipliers[k];
				end;
			end;
			
		end;
	end;]]
	
	
	--20130918 - take into account triggers with "appearsOnPDA=false" but with the same stationName as a trigger with "appearsOnPDA=true"	Example : Springhill
	
	--1. load all the "station" (distinct stationName)
	for _, trigger in pairs(g_currentMission.tipTriggers) do		
		
		if trigger.appearsOnPDA then			
		
			if RealisticGlobalListener.realStationList[trigger.stationName]==nil then
				--print("RealisticGlobalListener.registerStations -     new station = " .. trigger.stationName);
				RealisticGlobalListener.realStationList[trigger.stationName] = {};
				RealisticGlobalListener.realStationList[trigger.stationName].realBasePriceMultipliers = {};
				RealisticGlobalListener.realStationList[trigger.stationName].realPriceMultipliers = {};
				--backing up base price multiplier	
				for k,multiplier in pairs(trigger.priceMultipliers) do				
					RealisticGlobalListener.realStationList[trigger.stationName].realBasePriceMultipliers[k] = multiplier;	
					-- in case "realisticInfos.xml" is empty or missing, we set the random price multipliers
					RealisticGlobalListener.realStationList[trigger.stationName].realPriceMultipliers[k] = RealisticUtils.getNewStationPriceMultiplier(multiplier);				
				end;
				RealisticGlobalListener.realStationList[trigger.stationName].triggerList = {};			
			end;
			
		end;
	end;
	
	--2. parsing all the triggers again and add each trigger to its "stationName" realStation if found
	for _, trigger in pairs(g_currentMission.tipTriggers) do		
		
		if RealisticGlobalListener.realStationList[trigger.stationName]~=nil then
			--print("RealisticGlobalListener.registerStations -       adding trigger " .. tostring(trigger) .. " to station " .. trigger.stationName);
			table.insert(RealisticGlobalListener.realStationList[trigger.stationName].triggerList, trigger);
			
			-- applying the realStation pricemultipliers to the added trigger
			for k,multiplier in pairs(RealisticGlobalListener.realStationList[trigger.stationName].realPriceMultipliers) do					
				trigger.priceMultipliers[k] = RealisticGlobalListener.realStationList[trigger.stationName].realPriceMultipliers[k];				
			end;
		end;
		
	end;
	
	
	--new client ask for the current multipliers
	if g_server==nil then
		--print("RealisticGlobalListener.registerStations client asking for update");
		g_client:getServerConnection():sendEvent(RealisticStationsMultipliersClientAskEvent:new());		
	end;

end;


RealisticGlobalListener.refreshStationsPrices = function()

	for _, station in pairs(RealisticGlobalListener.realStationList) do
		for k,multiplier in pairs(station.realPriceMultipliers) do
			station.realPriceMultipliers[k] = RealisticUtils.getNewStationPriceMultiplier(station.realBasePriceMultipliers[k]); -- 15% more or less => between 0.85 and 1.15 of the genuine price multiplier	
			for j,trigger in pairs(station.triggerList) do
				trigger.priceMultipliers[k] = station.realPriceMultipliers[k];
			end;
		end;
	end;
	
	--send new data to all clients
	g_server:broadcastEvent(RealisticStationsMultipliersServerSendEvent:new());
	
end;



RealisticGlobalListener.loadMoreRealisticInfos = function()

	--print("RealisticGlobalListener.loadMoreRealisticInfos - missionInfo.isValid = " .. tostring(g_currentMission.missionInfo.isValid));

	if g_currentMission.missionInfo.isValid then
	
		local savegamePath = getUserProfileAppPath() .. "savegame".. g_currentMission.missionInfo.savegameIndex .. "/realisticInfos.xml";
		local xmlFile = loadXMLFile("realisticInfos", savegamePath);
		
		--print("RealisticGlobalListener.loadMoreRealisticInfos - xmlFile = " .. tostring(xmlFile) .. " / xmlFilePath=" .. tostring(savegamePath));
		
		if xmlFile ~= nil then
			
			local i = -1;
			
			while true do
				i = i + 1;
				local xmlStationPath = string.format("realisticInfos.stations.station(%d)", i);
				local stationName = getXMLString(xmlFile, xmlStationPath .. "#name");				
				
				if stationName == nil then
					break;
				end;
				
				--print("RealisticGlobalListener.loadMoreRealisticInfos - checking station '"..tostring(stationName) .. "'");
				
				for name, station in pairs(RealisticGlobalListener.realStationList) do
					if name==stationName then
					
						--print("RealisticGlobalListener.loadMoreRealisticInfos -     loading multipliers for '"..tostring(name) .. "'");
					
						--EDIT 20130918 -> k = id of the fruit type !!!
						local xmlIndex = 0;
						for k,multiplier in pairs(station.realPriceMultipliers) do
							
							--print("RealisticGlobalListener.loadMoreRealisticInfos -       checking multipliers for fruit id "..tostring(k));
							local saveGameMultiplier = getXMLFloat(xmlFile, string.format(xmlStationPath .. ".priceMultiplier(%d)", xmlIndex));
							if saveGameMultiplier==nil then
								break;
							end;
							station.realPriceMultipliers[k] = saveGameMultiplier;
							for j,trigger in pairs(station.triggerList) do								
								trigger.priceMultipliers[k] = station.realPriceMultipliers[k];
								--print("RealisticGlobalListener.loadMoreRealisticInfos -         setting multipliers value for trigger "..tostring(j) .. " / fruit id " ..tostring(k) .. " / value = "..tostring(station.realPriceMultipliers[k]));
							end;
							
							xmlIndex = xmlIndex + 1;
							
						end;
						break; -- no need to continue,  there is only 1 entry in the RealisticGlobalListener.realStationList table for a stationName
					end;
				end;				
				
			end; --end while
			
			delete(xmlFile);
			
		end;
	end;
end;



local oldCareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)

	oldCareerScreenSaveSelectedGame(self);
	
	--20130830 - protection to avoid crashing on dedicated server which try to save the game before the first update
	if RealisticGlobalListener.realStationList~=nil then
	
		local dir = self.savegames[self.selectedIndex].savegameDirectory;	
		local xmlFile = createXMLFile("realisticInfos", dir .. "/realisticInfos.xml", "realisticInfos");
		
		if xmlFile ~= nil then
						
			
			--saving the current priceMultipliers for each station		
			local i = -1;		
			for stationName, station in pairs(RealisticGlobalListener.realStationList) do	
				i = i + 1;
				setXMLString(xmlFile, string.format("realisticInfos.stations.station(%d)#name", i), stationName);
						
				local j = -1;
				for k,multiplier in pairs(station.realPriceMultipliers) do
					j = j + 1;				
					setXMLFloat(xmlFile, string.format("realisticInfos.stations.station(%d).priceMultiplier(%d)", i, j), station.realPriceMultipliers[k]);
				end;
						
			end;		
			
			saveXMLFile(xmlFile);		
		   
		end;
		
	end;
	
end;



function RealisticGlobalListener.consoleCommandGiveMeMoney(unusedSelf)
	if Vehicle.debugRendering and g_server~=nil then
		g_currentMission.missionStats.money = g_currentMission.missionStats.money + 1000000;
		return "Money added = 1000000";
	end;	
end;


function RealisticGlobalListener.consoleCommandGiveMeSilos(unusedSelf)
	if Vehicle.debugRendering and g_server~=nil then
		for i=1, table.getn(g_currentMission.missionStats.farmSiloAmounts) do
			g_currentMission.missionStats.farmSiloAmounts[i] = g_currentMission.missionStats.farmSiloAmounts[i] + 100000;
		end;
		return "All silos increased by 100000";
	end;	
end;




addModEventListener(RealisticGlobalListener);
