RealisticFruitPreparer = {};

function RealisticFruitPreparer.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
end;


function RealisticFruitPreparer:load(xmlFile) 

	self.isRealistic = true;

	if not self.isRealisticCombine then
		self.realWorkingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realWorkingPowerConsumption"), 0);	
		self.realWorkingPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realWorkingPowerConsumptionInc"), 0);
		self.realWorkingPowerConsumptionIncMinSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realWorkingPowerConsumptionInc#minSpeed"), 0)/3.6;
		
		self.realCurrentPowerConsumption = 0;
		self.realTmpAreaS = 0;
		
		self.realLastPreparedArea = 0;	
	end;
	
	
	local i1 = 0;
	self.realGenPreparerAreas = {};
	for k, preparerArea in pairs(self.fruitPreparerAreas) do
		i1 = i1 + 1;
		self.realGenPreparerAreas[i1] = {};
		local x,y,z = getTranslation(preparerArea.start);
		self.realGenPreparerAreas[i1].start = {x=x, y=y, z=z};
		x,y,z = getTranslation(preparerArea.width);
		self.realGenPreparerAreas[i1].width = {x=x, y=y, z=z};
		x,y,z = getTranslation(preparerArea.height);
		self.realGenPreparerAreas[i1].height = {x=x, y=y, z=z};
	end;
	
  
end;

function RealisticFruitPreparer:delete()    
end;

function RealisticFruitPreparer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticFruitPreparer:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticFruitPreparer:updateTick(dt)	

	if self.isServer and self.isActive then
		if self.isRealisticCombine then
			if self.isThreshing then
				RealisticFruitPreparer.realCuttingAreaCorrection(self);
			end;
		else	
			self.realCurrentPowerConsumption = 0;
			if self.isTurnedOn then -- the fruit preparer is active
				self.realCurrentPowerConsumption = self.realWorkingPowerConsumption;
				
				self.realTmpAreaS = 0.9*self.realTmpAreaS + 0.1*self.realLastPreparedArea*g_currentMission:getFruitPixelsToSqm();
				--local speed = self.realGroundSpeed - self.realWorkingPowerConsumptionIncMinSpeed;
				if self.realGroundSpeed>self.realWorkingPowerConsumptionIncMinSpeed then
					--self.realCurrentPowerConsumption = self.realCurrentPowerConsumption + self.realWorkingPowerConsumptionInc*(self.realTmpAreaS*speed/(0.06*dt));--now ^1 instead of ^0.5 since the 2013 version of the moreRealistic engine is more steady
					self.realCurrentPowerConsumption = self.realCurrentPowerConsumption + self.realWorkingPowerConsumptionInc*self.realTmpAreaS/(0.06*dt);-- now we do not use the speed to "dampen" the powerInc since 2013 version of the moreRealistic engine is more steady					
				end;
				--print(self.time .. " RealisticFruitPreparer:updateTick - last area cut = " .. self.realTmpAreaS);
				RealisticFruitPreparer.realCuttingAreaCorrection(self);
			else
				self.realTmpAreaS = 0;
			end;		
			
		end;
	end;
end;


function RealisticFruitPreparer:update(dt)
end;

function RealisticFruitPreparer:draw() 		
end;





function RealisticFruitPreparer.realCuttingAreaCorrection(self)

	local i = 1;
	for k, preparerArea in pairs(self.fruitPreparerAreas ) do
		RealisticUtils.realAreaCorrection(self, preparerArea, self.realGenPreparerAreas[i]);
		i = i + 1;
	end;

end;

