RealisticFertilizerTank = {};

function RealisticFertilizerTank.prerequisitesPresent(specializations)	
	return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function RealisticFertilizerTank:load(xmlFile)
	
	self.isRealistic = true;
	self.isRealisticFertilizerTank = true;	
		
	self.realFillingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realFillingPowerConsumption"), 0);
	
	
	self.realRefillTriggers = {};
	local i = 0;
	while true do
		local refillZoneTriggeri = string.format("vehicle.realRefillZoneTriggers.realRefillZoneTrigger(%d)", i);
		local indexStr = getXMLString(xmlFile, refillZoneTriggeri .. "#index");
		if indexStr == nil then
			break;
		end;
		
		local refillZoneTriggerShape = Utils.indexToObject(self.components, indexStr);
		local refillZoneTrigger = RealisticSprayerMobileFillTrigger:new(refillZoneTriggerShape, self);
		table.insert(self.realRefillTriggers, refillZoneTrigger);
		
		i = i + 1;
	end;
	
	
	
	
	-- tank is being refilling (like a sprayer)
	self.realIsFilling = false;
	
	
	self.setIsSprayerFilling = RealisticSprayer.realSetIsSprayerFilling;
	self.realSetIsSprayerFilling = RealisticSprayer.realSetIsSprayerFilling;
	self.addSprayerFillTrigger = Sprayer.addSprayerFillTrigger;
	self.removeSprayerFillTrigger = Sprayer.removeSprayerFillTrigger;

	self.fillLitersPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillLitersPerSecond"), 125);
	self.isSprayerFilling = false;
	self.sprayerFillTriggers = {};
	self.sprayerFillActivatable = SprayerFillActivatable:new(self);
	
	self.realCurrentPowerConsumption = 0;
	
end;


function RealisticFertilizerTank:delete()	
	
	for i=1, table.getn(self.realRefillTriggers) do
		self.realRefillTriggers[i]:delete();
	end;	
	
end;
 
 
function RealisticFertilizerTank:readStream(streamId, connection)
	local isFilling = streamReadBool(streamId);
	self:realSetIsSprayerFilling(isFilling, true);		
end;

function RealisticFertilizerTank:writeStream(streamId, connection)	
	streamWriteBool(streamId, self.isSprayerFilling);		
end;

function RealisticFertilizerTank:readUpdateStream(streamId, timestamp, connection)	
end;

function RealisticFertilizerTank:writeUpdateStream(streamId, connection, dirtyMask)
end;

function RealisticFertilizerTank:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticFertilizerTank:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticFertilizerTank:updateTick(dt)
	
	if self.isSprayerFilling and self.isServer then
		RealisticSprayer.realManageFilling(self, dt);
	end;
	
	if self.isServer and self.isActive then
		
		self.realCurrentPowerConsumption = 0;		
		if self.isSprayerFilling then -- the tank  pump is active for pumping
			self.realCurrentPowerConsumption = self.realCurrentPowerConsumption + self.realFillingPowerConsumption;		
		end;
		
	end;
	
end;

function RealisticFertilizerTank:update(dt)
end;


function RealisticFertilizerTank:draw()
end;



 
 
 
 