RealisticEnhancedRoundBaler = {};

function RealisticEnhancedRoundBaler.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticBaler, specializations);
end;


function RealisticEnhancedRoundBaler:load(xmlFile) 	

	self.isRealistic = true;
	
	self.realERBalerManageAutoMode = SpecializationUtil.callSpecializationsFunction("realERBalerManageAutoMode");
	self.realERBalerSetAutoModeActive = SpecializationUtil.callSpecializationsFunction("realERBalerSetAutoModeActive");
	
	self.realEnhancedBaler = {};
	self.realEnhancedBaler.autoMode = {};
		
	self.realEnhancedBaler.autoMode.isPossible = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.realEnhancedBaler.autoMode#isPossible"), false);
	self.realEnhancedBaler.autoMode.warningPercent = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.autoMode#warningPercent"), 0.85);
	self.realEnhancedBaler.autoMode.ejectingTimeMs = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.autoMode#ejectingTimeMs"), 5000);
	self.realEnhancedBaler.autoMode.isActive = false;
	self.realEnhancedBaler.autoMode.ejectingTimer = 0;
	self.realEnhancedBaler.autoMode.ejectingTimerEnabled = false;
	
	self.realEnhancedBaler.closedSoundRequired = false;
	
	
	if self.isClient then
		--loading all the sounds
		
		--1. look if there is a default sound warning	
		local soundFile = getXMLString(xmlFile, "vehicle.realEnhancedBaler.sounds.default#file");
		if soundFile ~= nil and soundFile ~= "" then
			soundFile = Utils.getFilename(soundFile, self.baseDirectory);
			--print("soundFile = " .. tostring(soundFile));
			self.realEnhancedBaler.soundWarningDefault = createSample("realERBalerDefaultWarning");			
			loadSample(self.realEnhancedBaler.soundWarningDefault, soundFile, false);						
		end;
		self.realEnhancedBaler.soundWarningDefaultPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.default#pitchOffset"), 1);
		self.realEnhancedBaler.soundWarningDefaultVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.default#volume"), 1);
		self.realEnhancedBaler.soundWarningDefaultLoopNumber = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.default#loopNumber"), 1);
		
				
		--2. look if there is an "almost full" sound warning
		local soundFile = getXMLString(xmlFile, "vehicle.realEnhancedBaler.sounds.almostFull#file");
		if soundFile ~= nil and soundFile ~= "" then
			soundFile = Utils.getFilename(soundFile, self.baseDirectory);
			self.realEnhancedBaler.soundWarningAlmostFull = createSample("realERBalerAlmostFullWarning");			
			loadSample(self.realEnhancedBaler.soundWarningAlmostFull, soundFile, false);			
		else
			self.realEnhancedBaler.soundWarningAlmostFull = self.realEnhancedBaler.soundWarningDefault;	
			self.realEnhancedBaler.soundWarningAlmostFullUseDefault = true;
		end;
		self.realEnhancedBaler.soundWarningAlmostFullEnabled = false;
		self.realEnhancedBaler.soundWarningAlmostFullPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.almostFull#pitchOffset"), self.realEnhancedBaler.soundWarningDefaultPitchOffset);
		self.realEnhancedBaler.soundWarningAlmostFullVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.almostFull#volume"), self.realEnhancedBaler.soundWarningDefaultVolume);
		self.realEnhancedBaler.soundWarningAlmostFullLoopNumber = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.almostFull#loopNumber"), self.realEnhancedBaler.soundWarningDefaultLoopNumber);
		
		--3. look if there is a "full" sound warning
		local soundFile = getXMLString(xmlFile, "vehicle.realEnhancedBaler.sounds.full#file");
		if soundFile ~= nil and soundFile ~= "" then
			soundFile = Utils.getFilename(soundFile, self.baseDirectory);
			self.realEnhancedBaler.soundWarningFull = createSample("realERBalerFullWarning");			
			loadSample(self.realEnhancedBaler.soundWarningFull, soundFile, false);			
		else
			self.realEnhancedBaler.soundWarningFull = self.realEnhancedBaler.soundWarningDefault;
			self.realEnhancedBaler.soundWarningFullUseDefault = true;
		end;
		self.realEnhancedBaler.soundWarningFullEnabled = false;
		self.realEnhancedBaler.soundWarningFullPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.full#pitchOffset"), self.realEnhancedBaler.soundWarningDefaultPitchOffset);
		self.realEnhancedBaler.soundWarningFullVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.full#volume"), self.realEnhancedBaler.soundWarningDefaultVolume);
		self.realEnhancedBaler.soundWarningFullLoopNumber = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.full#loopNumber"), self.realEnhancedBaler.soundWarningDefaultLoopNumber);
		
		--4. look if there is a "door opening" sound warning		
		local soundFile = getXMLString(xmlFile, "vehicle.realEnhancedBaler.sounds.doorOpening#file");
		if soundFile ~= nil and soundFile ~= "" then
			soundFile = Utils.getFilename(soundFile, self.baseDirectory);
			self.realEnhancedBaler.soundWarningDoorOpening = createSample("realERBalerDoorOpeningWarning");			
			loadSample(self.realEnhancedBaler.soundWarningDoorOpening, soundFile, false);			
		else
			self.realEnhancedBaler.soundWarningDoorOpening = self.realEnhancedBaler.soundWarningDefault;	
			self.realEnhancedBaler.soundWarningDoorOpeningUseDefault = true;
		end;
		self.realEnhancedBaler.soundWarningDoorOpeningEnabled = false;
		self.realEnhancedBaler.soundWarningDoorOpeningPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.doorOpening#pitchOffset"), self.realEnhancedBaler.soundWarningDefaultPitchOffset);
		self.realEnhancedBaler.soundWarningDoorOpeningVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.doorOpening#volume"), self.realEnhancedBaler.soundWarningDefaultVolume);
		self.realEnhancedBaler.soundWarningDoorOpeningLoopNumber = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.doorOpening#loopNumber"), self.realEnhancedBaler.soundWarningDefaultLoopNumber);
		
		--5. look if there is a "door closed" sound warning
		local soundFile = getXMLString(xmlFile, "vehicle.realEnhancedBaler.sounds.doorClosed#file");
		if soundFile ~= nil and soundFile ~= "" then
			soundFile = Utils.getFilename(soundFile, self.baseDirectory);
			self.realEnhancedBaler.soundWarningDoorClosed = createSample("realERBalerDoorClosedWarning");			
			loadSample(self.realEnhancedBaler.soundWarningDoorClosed, soundFile, false);			
		else
			self.realEnhancedBaler.soundWarningDoorClosed = self.realEnhancedBaler.soundWarningDefault;	
			self.realEnhancedBaler.soundWarningDoorClosedUseDefault = true;
		end;
		self.realEnhancedBaler.soundWarningDoorClosedEnabled = false;
		self.realEnhancedBaler.soundWarningDoorClosedPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.doorClosed#pitchOffset"), self.realEnhancedBaler.soundWarningDefaultPitchOffset);
		self.realEnhancedBaler.soundWarningDoorClosedVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.doorClosed#volume"), self.realEnhancedBaler.soundWarningDefaultVolume);
		self.realEnhancedBaler.soundWarningDoorClosedLoopNumber = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realEnhancedBaler.sounds.doorClosed#loopNumber"), self.realEnhancedBaler.soundWarningDefaultLoopNumber);
		
		
		
		--disable the standard alarm sound
		self.realBalerAlarmDisabled = true;
		
	end;
		 
end;


function RealisticEnhancedRoundBaler:delete() 	

	--delete all the sounds
	if self.realEnhancedBaler.soundWarningDefault then		
		delete(self.realEnhancedBaler.soundWarningDefault);		
	end;	
	
	if not self.realEnhancedBaler.soundWarningAlmostFullUseDefault and self.realEnhancedBaler.soundWarningAlmostFull then		
		delete(self.realEnhancedBaler.soundWarningAlmostFull);		
	end;	
	self.realEnhancedBaler.soundWarningAlmostFullEnabled = false;
	
	if not self.realEnhancedBaler.soundWarningFullUseDefault and self.realEnhancedBaler.soundWarningFull then
		delete(self.realEnhancedBaler.soundWarningFull);		
	end;
	self.realEnhancedBaler.soundWarningFullEnabled = false;
	
	if not self.realEnhancedBaler.soundWarningDoorOpeningUseDefault and self.realEnhancedBaler.soundWarningDoorOpening then
		delete(self.realEnhancedBaler.soundWarningDoorOpening);		
	end;
	self.realEnhancedBaler.soundWarningDoorOpeningEnabled = false;
	
	if not self.realEnhancedBaler.soundWarningDoorClosedUseDefault and self.realEnhancedBaler.soundWarningDoorClosed then
		delete(self.realEnhancedBaler.soundWarningDoorClosed);		
	end;
	self.realEnhancedBaler.soundWarningDoorClosedEnabled = false;

end;

function RealisticEnhancedRoundBaler:mouseEvent(posX, posY, isDown, isUp, button)	
end;

function RealisticEnhancedRoundBaler:keyEvent(unicode, sym, modifier, isDown)	
end;


function RealisticEnhancedRoundBaler:readStream(streamId, connection)
	self.realEnhancedBaler.autoMode.isActive = streamReadBool(streamId);		
end;
 
function RealisticEnhancedRoundBaler:writeStream(streamId, connection)
	streamWriteBool(streamId, self.realEnhancedBaler.autoMode.isActive);	
end;



function RealisticEnhancedRoundBaler:update(dt)	

	if self.isActive then
		self:realERBalerManageAutoMode();
	end;
	
end;

function RealisticEnhancedRoundBaler:updateTick(dt)

	if self.isActive and self.isTurnedOn then	

		--sound management
		if self.isClient then		
			
			if self.fillLevel>=(self.realEnhancedBaler.autoMode.warningPercent*self.capacity) then		
				-- play the warning sound "almost finished"		
				if not self.realEnhancedBaler.soundWarningAlmostFullEnabled and self:getIsActiveForSound() then
					if self.realEnhancedBaler.soundWarningAlmostFull then						
						setSamplePitch(self.realEnhancedBaler.soundWarningAlmostFull, self.realEnhancedBaler.soundWarningAlmostFullPitchOffset);
						playSample(self.realEnhancedBaler.soundWarningAlmostFull, self.realEnhancedBaler.soundWarningAlmostFullLoopNumber, self.realEnhancedBaler.soundWarningAlmostFullVolume, 0);
						self.realEnhancedBaler.soundWarningAlmostFullEnabled = true;
					end;
				end;
			elseif self.realEnhancedBaler.soundWarningAlmostFullEnabled then				
				self.realEnhancedBaler.soundWarningAlmostFullEnabled = false;
			end;
			
			-- play the warning sound "full, netting process iminent"
			if self.fillLevel>=self.capacity then
				if not self.realEnhancedBaler.soundWarningFullEnabled and self:getIsActiveForSound() then
					if self.realEnhancedBaler.soundWarningFull then						
						setSamplePitch(self.realEnhancedBaler.soundWarningFull, self.realEnhancedBaler.soundWarningFullPitchOffset);
						playSample(self.realEnhancedBaler.soundWarningFull, self.realEnhancedBaler.soundWarningFullLoopNumber, self.realEnhancedBaler.soundWarningFullVolume, 0);
						self.realEnhancedBaler.soundWarningFullEnabled = true;
					end;
				end;
			elseif self.realEnhancedBaler.soundWarningFullEnabled then				
				self.realEnhancedBaler.soundWarningFullEnabled = false;
			end;
			
			-- play the warning sound "door opening"
			if self.balerUnloadingState == Baler.UNLOADING_OPENING then
				if not self.realEnhancedBaler.soundWarningDoorOpeningEnabled and self:getIsActiveForSound() then
					if self.realEnhancedBaler.soundWarningDoorOpening then						
						setSamplePitch(self.realEnhancedBaler.soundWarningDoorOpening, self.realEnhancedBaler.soundWarningDoorOpeningPitchOffset);
						playSample(self.realEnhancedBaler.soundWarningDoorOpening, self.realEnhancedBaler.soundWarningDoorOpeningLoopNumber, self.realEnhancedBaler.soundWarningDoorOpeningVolume, 0);
						self.realEnhancedBaler.soundWarningDoorOpeningEnabled = true;
					end;
				end;
			elseif self.realEnhancedBaler.soundWarningDoorOpeningEnabled then				
				self.realEnhancedBaler.soundWarningDoorOpeningEnabled = false;	
				
			end;
			
			if self.balerUnloadingState == Baler.UNLOADING_CLOSING then
				--set the flag to allow the "closed warning" to be played
				self.realEnhancedBaler.closedSoundRequired = true;
			end;
			
			-- play the warning sound "door closed"
			if self.balerUnloadingState == Baler.UNLOADING_CLOSED then
				if self.realEnhancedBaler.closedSoundRequired and not self.realEnhancedBaler.soundWarningDoorClosedEnabled and self:getIsActiveForSound() then
					if self.realEnhancedBaler.soundWarningDoorClosed then											
						setSamplePitch(self.realEnhancedBaler.soundWarningDoorClosed, self.realEnhancedBaler.soundWarningDoorClosedPitchOffset);
						playSample(self.realEnhancedBaler.soundWarningDoorClosed, self.realEnhancedBaler.soundWarningDoorClosedLoopNumber, self.realEnhancedBaler.soundWarningDoorClosedVolume, 0);
						self.realEnhancedBaler.soundWarningDoorClosedEnabled = true;
						self.realEnhancedBaler.closedSoundRequired = false;
					end;
				end;
			elseif self.realEnhancedBaler.soundWarningDoorClosedEnabled then				
				self.realEnhancedBaler.soundWarningDoorClosedEnabled = false;
			end;
			
		end; -- end self.isClient
		
		-- operating management
		if self.isServer then
		
			if self.realEnhancedBaler.autoMode.isActive then
				
				if self.balerUnloadingState == Baler.UNLOADING_CLOSED then			
					if self.fillLevel>=self.capacity then					
						if self.realEnhancedBaler.autoMode.ejectingTimerEnabled then
							self.realEnhancedBaler.autoMode.ejectingTimer = self.realEnhancedBaler.autoMode.ejectingTimer - dt;
							if self.realEnhancedBaler.autoMode.ejectingTimer <= 0 then
								--ejecting the bale
								self:setIsUnloadingBale(true);
								self.realEnhancedBaler.autoMode.ejectingTimerEnabled = false;
							end;
						else
							-- starting the ejecting timer
							self.realEnhancedBaler.autoMode.ejectingTimerEnabled = true;
							self.realEnhancedBaler.autoMode.ejectingTimer = self.realEnhancedBaler.autoMode.ejectingTimeMs;
						end;	
					end;
				else
					self.realEnhancedBaler.autoMode.ejectingTimerEnabled = false;
					if self.balerUnloadingState == Baler.UNLOADING_OPEN then
						--closing the door
						self:setIsUnloadingBale(false);
					end;					
				end; -- en state = closed
				
			end; -- end auto mod active
			
		end; --end self.isServer
		
		
	end;

end;

function RealisticEnhancedRoundBaler:draw() 

	if self.realEnhancedBaler.autoMode.isPossible then
		if self.realEnhancedBaler.autoMode.isActive then
			g_currentMission:addHelpButtonText(RealisticUtils.realTexts["ERBALER_AUTO_OFF"], InputBinding.REALISTIC_ERBALER_AUTO);
		else
			g_currentMission:addHelpButtonText(RealisticUtils.realTexts["ERBALER_AUTO_ON"], InputBinding.REALISTIC_ERBALER_AUTO);
		end;
	end;

end;


function RealisticEnhancedRoundBaler:realERBalerSetAutoModeActive(active, noEventSend)

	if active~=self.realEnhancedBaler.autoMode.isActive then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(RealisticEnhancedRoundBalerToggleAutoModeEvent:new(self, active), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(RealisticEnhancedRoundBalerToggleAutoModeEvent:new(self, active));
			end;
		end;
		
		self.realEnhancedBaler.autoMode.isActive = active;			
				
	end;

end;

function RealisticEnhancedRoundBaler:realERBalerManageAutoMode()
	if self.realEnhancedBaler.autoMode.isPossible then
		if self:getIsActiveForInput(false) and InputBinding.hasEvent(InputBinding.REALISTIC_ERBALER_AUTO) then			
			self:realERBalerSetAutoModeActive(not self.realEnhancedBaler.autoMode.isActive);			
		end;
	end;
end;

function RealisticEnhancedRoundBaler:onDeactivateSounds()
		
	--stop all the sounds
	if self.realEnhancedBaler.soundWarningAlmostFullEnabled then
		stopSample(self.realEnhancedBaler.soundWarningAlmostFull);		
	end;	
	self.realEnhancedBaler.soundWarningAlmostFullEnabled = false;
	
	if self.realEnhancedBaler.soundWarningFullEnabled then
		stopSample(self.realEnhancedBaler.soundWarningFull);		
	end;
	self.realEnhancedBaler.soundWarningFullEnabled = false;
	
	if self.realEnhancedBaler.soundWarningDoorOpeningEnabled then
		stopSample(self.realEnhancedBaler.soundWarningDoorOpening);		
	end;
	self.realEnhancedBaler.soundWarningDoorOpeningEnabled = false;
	
	if self.realEnhancedBaler.soundWarningDoorClosedEnabled then
		stopSample(self.realEnhancedBaler.soundWarningDoorClosed);		
	end;
	self.realEnhancedBaler.soundWarningDoorClosedEnabled = false;
	
	self.realEnhancedBaler.closedSoundRequired = false;	
		
end;



function RealisticEnhancedRoundBaler:getSaveAttributesAndNodes(nodeIdent)

	local nodes = "";		
	--add the automode status
	local attributes = string.format('realERBalerAutoModeActive="%s"', tostring(self.realEnhancedBaler.autoMode.isActive));	

	return attributes, nodes;

end;

function RealisticEnhancedRoundBaler:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	
	--load the automode status
	local autoModeActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#realERBalerAutoModeActive"), false);
	self:realERBalerSetAutoModeActive(autoModeActive, true);	
	
	return BaseMission.VEHICLE_LOAD_OK;

end;