RealisticAutostacker = {};

function RealisticAutostacker.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
end;


function RealisticAutostacker:load(xmlFile) 

	self.isRealistic = true;
	self.isRealisticAutostacker = true;
	
	self.realOnDesactivatePS = SpecializationUtil.callSpecializationsFunction("realOnDesactivatePS");

	self.realAutoStackerWorkingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realAutoStackerWorkingPowerConsumption"), 0);	
	self.realCurrentPowerConsumption = 0;
	
	self.updateLoadedBalesMass = SpecializationUtil.callSpecializationsFunction("updateLoadedBalesMass");
	self.realAutostakerLastFillLevel = 0;
	self.realBalesMass = 0;
  
end;

function RealisticAutostacker:delete()    
end;

function RealisticAutostacker:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticAutostacker:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticAutostacker:updateTick(dt)	

	if self.isServer and self.isActive then
		
		self.realCurrentPowerConsumption = 0;				
		
		for _, anim in pairs(self.activeAnimations) do
			--at least one animation playing
			self.realCurrentPowerConsumption = self.realAutoStackerWorkingPowerConsumption;
			break;
		end;

		if self.fillLevel ~= self.realAutostakerLastFillLevel then
			self:updateLoadedBalesMass();
			self.realAutostakerLastFillLevel = self.fillLevel;
		end;
		
	end;

end;


function RealisticAutostacker:update(dt)
end;

function RealisticAutostacker:draw() 		
end;

function RealisticAutostacker:updateLoadedBalesMass() 

	local balesMass = 0;

	for _, balePlace in pairs(self.balePlaces) do
		if balePlace.bales ~= nil then
			for _, baleServerId in pairs(balePlace.bales) do
				local bale = networkGetObject(baleServerId);				
				if bale ~= nil and bale.isRealistic then
					balesMass = balesMass + bale.realCurrentMass;
				end;				
			end;
		end;
	end;
	
	for i, baleServerId in ipairs(self.startBalePlace.bales) do
		local bale = networkGetObject(baleServerId);
		if bale ~= nil and bale.isRealistic then
			balesMass = balesMass + bale.realCurrentMass;
		end;
	end;
	
	--print("RealisticAutostacker:updateLoadedBalesMass :=> new bales mass : " .. tostring(balesMass));
	--self.realBalesMass = balesMass;
	self.realFillableFillMass = balesMass;
		
end;


function RealisticAutostacker:realOnDesactivatePS()
	
	if self.baleGrabParticleSystems~=nil then
		Utils.setEmittingState(self.baleGrabParticleSystems, false);
	end;

end;

