--***********************************************  DURAL *************************************************
--** we want to get back the total cut area
function WindrowAreaEvent.runLocallyEX1(cuttingAreas, dropAreas, accumulatedCuttingAreaValues, accumulatedFruitType)
   
	--***********************  DURAL ********************
	--** init totalAreaRaked
		local totalAreaRaked = 0;
   
   
       local numAreas = table.getn(cuttingAreas);
       local numDropAreas = table.getn(dropAreas);
   
       local refX, refY;
       local values = {};
       for i=1, numAreas do
           local d = cuttingAreas[i];
           if refX==nil then
               refX = d[1];
               refY = d[2];
           else
               table.insert(values, {x=d[1], y=d[2]});
           end
           table.insert(values, {x=d[3], y=d[4]});
           table.insert(values, {x=d[5], y=d[6]});
       end
       for i=1, numDropAreas do
           local d = dropAreas[i];
           if refX==nil then
               refX = d[1];
               refY = d[2];
           else
               table.insert(values, {x=d[1], y=d[2]});
           end
           table.insert(values, {x=d[3], y=d[4]});
           table.insert(values, {x=d[5], y=d[6]});
       end
   
       local values, bitType = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);
   
       local restSum = 0;
       local fruitType = FruitUtil.FRUITTYPE_GRASS;
       local fruitTypeFix = false;
   
       local cuttingAreasSend = {};
       local dropAreasSend = {};
       for i=1, numAreas do
           local vi = i-1;
           local x = values[vi*3+1].x;
           local z = values[vi*3+1].y;
           local x1 = values[vi*3+2].x;
           local z1 = values[vi*3+2].y;
           local x2 = values[vi*3+3].x;
           local z2 = values[vi*3+3].y;
   
           local area = 0;
           if fruitTypeFix then
               area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
           else
               -- first try dry grass to avoid wet grass destroying dry grass
               fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
               area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
   
               if area == 0 then
                   for fruitId=1, FruitUtil.NUM_FRUITTYPES do
                       if fruitId ~= FruitUtil.FRUITTYPE_DRYGRASS then
                           local ids = g_currentMission.fruits[fruitId];
                           if ids ~= nil and ids.windrowId ~= 0 then
                               fruitType = fruitId;
                               area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                               if area > 0 then
                                   break;
                               end
                           end
                       end
                   end
               end
           end
           if area > 0 then
	--*************************** DURAL ************************
	--** update totalAreaRaked
				totalAreaRaked = totalAreaRaked + area;
		   
               fruitTypeFix = true;
   
               -- now that we removed the windrow, maybe there is some hidden drygrass to grow (set it to growth state 1 if there is some)
               if fruitType == FruitUtil.FRUITTYPE_DRYGRASS then
                   Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1);
               end
   
               table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
           end
           -- add the accumulated value
           if not fruitTypeFix or accumulatedFruitType == fruitType then
               area = area + accumulatedCuttingAreaValues[i];
               fruitType = accumulatedFruitType;
           end
           accumulatedCuttingAreaValues[i] = 0;
           if area > 0 then
               if numDropAreas >= numAreas then
                   local dvi = i+numAreas-1;
                   local dx = values[dvi*3+1].x;
                   local dz = values[dvi*3+1].y;
                   local dx1 = values[dvi*3+2].x;
                   local dz1 = values[dvi*3+2].y;
                   local dx2 = values[dvi*3+3].x;
                   local dz2 = values[dvi*3+3].y;
   
                   local old, total = Utils.getFruitWindrowArea(fruitType, dx, dz, dx1, dz1, dx2, dz2);
   
                   local value = (area+old) / total;
                   -- round to the lower value, so the error we make is always positive as we place not enough windrows
                   value = math.floor(value+0.001);
   
                   if value >= 1 then
                       -- calculate the error we make by the rounding and clamping, so we can add it the next time
                       value = math.min(value, g_currentMission.maxWindrowValue);
                       accumulatedCuttingAreaValues[i] = math.min(math.max(area+old - value*total, 0), 2*g_currentMission.maxWindrowValue);
   
                       if fruitType == FruitUtil.FRUITTYPE_GRASS or fruitType == FruitUtil.FRUITTYPE_DRYGRASS then
                           -- switch all dry grass to grass, and then destroy everything that is not grass
                           Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2);
                           Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2);
   
                           Utils.updateFruitWindrowArea(fruitType, dx, dz, dx1, dz1, dx2, dz2, value, true, false);
                       else
                           Utils.updateFruitWindrowArea(fruitType, dx, dz, dx1, dz1, dx2, dz2, value, true, true);
                       end
                       table.insert(dropAreasSend, {dx, dz, dx1, dz1, dx2, dz2,value});
                   else
                       -- calculate the error we make by not changing the drop area
                       accumulatedCuttingAreaValues[i] = area;
                   end
               else
                   restSum = restSum + area;
               end
           end
       end
       if restSum > 0 and numDropAreas > 0 then
           local dvi = numAreas;
           local dx = values[dvi*3+1].x;
           local dz = values[dvi*3+1].y;
           local dx1 = values[dvi*3+2].x;
           local dz1 = values[dvi*3+2].y;
           local dx2 = values[dvi*3+3].x;
           local dz2 = values[dvi*3+3].y;
           local old, total = Utils.getFruitWindrowArea(fruitType, dx, dz, dx1, dz1, dx2, dz2);
   
           local value = (restSum+old) / total;
           -- round to the lower value, so the error we make is always positive as we place not enough windrows
           value = math.floor(value+0.001);
   
           if value >= 1 then
               -- calculate the error we make by the rounding and clamping, so we can add it the next time
               value = math.min(value, g_currentMission.maxWindrowValue);
               accumulatedCuttingAreaValues[1] = math.min(math.max(restSum+old - value*total, 0), 2*g_currentMission.maxWindrowValue);
   
               if fruitType == FruitUtil.FRUITTYPE_GRASS or fruitType == FruitUtil.FRUITTYPE_DRYGRASS then
                   -- switch all dry grass to grass, and then destroy everything that is not grass
                   Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2);
                   Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2);
   
                   Utils.updateFruitWindrowArea(fruitType, dx, dz, dx1, dz1, dx2, dz2, value, true, false);
               else
                   Utils.updateFruitWindrowArea(fruitType, dx, dz, dx1, dz1, dx2, dz2, value, true, true);
               end
               table.insert(dropAreasSend, {dx, dz, dx1, dz1, dx2, dz2,value});
           else
               -- calculate the error we make by not changing the drop area
               accumulatedCuttingAreaValues[1] = restSum;
           end
       end
	   
	   
	   --******************************  DURAL  **************************
	   --** return totalAreaRaked	   
       return cuttingAreasSend, dropAreasSend, fruitType, bitType, totalAreaRaked;
   end
