  function VehicleCamera:update(dt)
       self.smoothUpdateDt = self.smoothUpdateDt + dt;
   
       local smoothDt = 25; -- update with constant 40fps
       while self.smoothUpdateDt > smoothDt do
           local target = self.zoomTarget;
           if self.zoomLimitedTarget >= 0 then
               target = math.min(self.zoomLimitedTarget, self.zoomTarget);
           end;
           self.zoom = 0.9*self.zoom + 0.1*target;

           self.smoothUpdateDt = self.smoothUpdateDt-smoothDt;
       end;
       if self.isActivated then
           if self.isRotatable then
   
               local rotSpeed = 0.001*dt;
               local inputW = InputBinding.getDigitalInputAxis(InputBinding.AXIS_LOOK_UPDOWN_VEHICLE);
               local inputZ = InputBinding.getDigitalInputAxis(InputBinding.AXIS_LOOK_LEFTRIGHT_VEHICLE);
               if InputBinding.isAxisZero(inputW) then
                   inputW = InputBinding.getAnalogInputAxis(InputBinding.AXIS_LOOK_UPDOWN_VEHICLE);
               end;
               if InputBinding.isAxisZero(inputZ) then
                   inputZ = InputBinding.getAnalogInputAxis(InputBinding.AXIS_LOOK_LEFTRIGHT_VEHICLE);
               end;
               if self.limitRotXDelta > 0.001 then
                   self.rotX = math.min(self.rotX - rotSpeed*inputW, self.rotX);
               elseif self.limitRotXDelta < -0.001 then
                   self.rotX = math.max(self.rotX - rotSpeed*inputW, self.rotX);
               else
                   self.rotX = self.rotX - rotSpeed*inputW;
               end;
               --self.rotX = self.rotX - rotSpeed*inputW;
               self.rotY = self.rotY - rotSpeed*inputZ;
   		end;
       end;
   
   
   	local useScaledTrans = false;
   	local scaledTransDist = 0;
       if self.limit then
           self.rotX = math.min(self.rotMaxX, math.max(self.rotMinX, self.rotX));
       end;
   
       self:updateRotateNodeRotation();
   
   
       if self.limit then
           -- adjust rotation to avoid clipping with terrain
           if self.isRotatable and self.useWorldXZRotation then
   
               local numIterations = 4;
               for i=1, numIterations do
                   local transX, transY, transZ = self.transDirX*self.zoom, self.transDirY*self.zoom, self.transDirZ*self.zoom;
                   local x,y,z = localToWorld(getParent(self.cameraPositionNode), transX, transY, transZ);
   
                   local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
   
                   local minHeight = terrainHeight + 0.9;
                   if y < minHeight then
                       local h = math.sin(self.rotX)*self.zoom;
                       local h2 = h-(minHeight-y);
--**********************************************************************************************************************************************
--DURAL : bug fixed. sometime, when a vehicle is upside down, h2 is smaller than -self.zoom
-- example : with the lizard ATV
					--self.rotX = math.asin(h2/self.zoom);
                       self.rotX = math.asin(Utils.clamp(h2/self.zoom, -1, 1));
--**********************************************************************************************************************************************
                       self:updateRotateNodeRotation();
                   else
                       break;
                   end;
               end;
           end;
   
           -- adjust zoom to avoid collision with objects
--**********************************************************************************************************************************************
--DURAL : disable collision with object detection
           --if self.allowTranslation then
		   if self.allowTranslation and not Utils.getNoNil(self.vehicle.realDisableCameraCollisionDetection, false) then
 --*********************************************************************************************************************************************  
               self.limitRotXDelta = 0;
   
               --local len = Utils.vector3Length(self.transX, self.transY, self.transZ);
               --len = math.min(self.transMax, math.max(self.transMin, len));
               --self.transX, self.transY, self.transZ = self.transDirX*len, self.transDirY*len, self.transDirZ*len;
               local hasCollision, collisionDistance, nx,ny,nz, normalDotDir = self:getCollisionDistance();
               if hasCollision then
                   local distOffset = 0.1;
                   if normalDotDir ~= nil then
                       local absNormalDotDir = math.abs(normalDotDir)
                       distOffset = Utils.lerp(1.2, 0.1, absNormalDotDir*absNormalDotDir*(3-2*absNormalDotDir));
                   end
                   collisionDistance = math.max(collisionDistance-distOffset, 0.01);
                   self.disableCollisionTime = self.vehicle.time+400;
                   self.zoomLimitedTarget = collisionDistance;
                   if collisionDistance < self.zoom then
                       self.zoom = collisionDistance;
                   end;
                   if self.isRotatable and nx ~= nil and collisionDistance < self.transMin then
                       local lnx,lny,lnz = worldDirectionToLocal(self.rotateNode, nx,ny,nz);
                       --print("normal: "..nx.." "..ny.. " "..nz.. " local: "..lnx .. " "..lny.." "..lnz);
                       if lny > 0.5 then
                           self.limitRotXDelta = 1;
                           --self.rotX = self.rotX - dt*0.0001;
                       elseif lny < -0.5 then
                           self.limitRotXDelta = -1;
                           --self.rotX = self.rotX + dt*0.0001;
                       end;
                   end;
               else
                   if self.disableCollisionTime <= self.vehicle.time then
                       self.zoomLimitedTarget = -1;
                   end;
               end;
           end;
   
   	end;
    self.transX, self.transY, self.transZ = self.transDirX*self.zoom, self.transDirY*self.zoom, self.transDirZ*self.zoom;
   	setTranslation(self.cameraPositionNode, self.transX, self.transY, self.transZ);
end;