
local oldTrailerUpdateTipping = Trailer.updateTipping;

Trailer.updateTipping = function(self, dt)

	if not self.isRealisticTrailer then
		return oldTrailerUpdateTipping(self, dt);
	end;

	
	if not self.isServer then
		return;
	end;
	
   if self:getCanTip() then
	   local fillType = self.currentFillType;

	   local fillDelta = -self.fillLevel;
	   if self.currentTipReferencePointIndex ~= nil then
		   local animation = self.tipAnimations[self.currentTipReferencePointIndex];
		   if animation ~= nil and animation.dischargeEndTime > animation.dischargeStartTime then
				--now take into account the current capacity and the "tipping angle" (function of the animation time) rather than a fixed value.
				local currentAnimTime = self:getCurrentTipAnimationTime();
				--if self:getCurrentTipAnimationTime() >= animation.dischargeStartTime then
				if currentAnimTime >= animation.dischargeStartTime then					
					--local m = self.capacity/((animation.dischargeEndTime-animation.dischargeStartTime)/animation.animationOpenSpeedScale);
					if animation.realMaxDischargeSpeed==nil then				
						animation.realMaxDischargeSpeed = self.capacity/3;
					end;
					
					local openPercent = 0;
					
					if animation.dischargeStartTime>=animation.animationDuration then
						if currentAnimTime>=animation.animationDuration then
							openPercent = 1;
						end;
					else
						openPercent = (currentAnimTime-animation.dischargeStartTime) / (animation.animationDuration-animation.dischargeStartTime);
						if animation.realDischargeAnimTimeFx~=nil then
							--print(self.time .. " Trailer.updateTipping - current openPercent = " .. tostring(openPercent) .. " - openPercentFx="..tostring(openPercent^animation.realDischargeAnimTimeFx));
							openPercent = openPercent^animation.realDischargeAnimTimeFx;
						end;	
					end;					
											
					local m = 0.001 * Utils.clamp(self.fillLevel, 0.1*animation.realMaxDischargeSpeed, animation.realMaxDischargeSpeed) * math.max(0.1, openPercent);
					--print(self.time .. " Trailer.updateTipping - current empty speed = " .. tostring(m*1000) .. " liter per second - maxDischargeSpeed=" .. tostring(animation.realMaxDischargeSpeed) .. " - openPercent Fx=" .. tostring(openPercent));
					fillDelta = -m * dt;
				else
					fillDelta = 0;
				end
		   end
	   end

	   if fillDelta < 0 then
		   local curFill = self.fillLevel;
		   self:setFillLevel(self.fillLevel + fillDelta, fillType);
		   local fillDelta = self.fillLevel - curFill;
		   self.lastFillDelta = fillDelta;

		   if self.currentTipTrigger ~= nil then
			   if self.currentTipTrigger.updateTrailerTipping ~= nil then
				   self.currentTipTrigger:updateTrailerTipping(self, fillDelta*self.fillLevelToTippedFillLevel, fillType);
			   end
		   elseif self:getCanTipToGround() then
			   if fillDelta < 0 then
				   local x, _,z = getWorldTranslation(self.groundDropArea.start);
				   local x1,_,z1 = getWorldTranslation(self.groundDropArea.width);
				   local x2,_,z2 = getWorldTranslation(self.groundDropArea.height);

				   local area = {x,z,x1,z1,x2,z2, -fillDelta*self.fillLevelToTippedFillLevel};
				   local area, bitType, valueAccumulation = TrailerTipAreaEvent.runLocally(area, fillType, self.groundAmountAccumulation)
				   if area ~= nil then
					   g_server:broadcastEvent(TrailerTipAreaEvent:new(area, bitType, fillType));
				   end;
				   if valueAccumulation ~= nil then
					   self.groundAmountAccumulation = valueAccumulation;
				   end;
			   end;
		   end;
	   end
   else
	   self:onEndTip();
   end;
end;
