local oldSteerableLoad = Steerable.load;
Steerable.load = function (self, xmlFile)

	oldSteerableLoad(self, xmlFile);
	
	if self.isRealistic then
	
		-- override default rot speed value
		self.speedRotScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.speedRotScale#scale"), 0.25);
		self.realMaxSpeedForMaxRotSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realMaxSpeedForMaxRotSpeed"), 6)/3.6; -- under 6 kph, when turning with the keyboard, use the max rot speed
		
		--self.realInputAxisXS = 0;
		self.realInputXFx = 0;
		
		--20130919 - avoid disabling the speedlevel if the player do not release the acceleration key enough fast
		self.realSpeedLevelDisablingTime = 1000; -- when setting a speedlevel, the player can't disable it by accelerating too much for 1s (avoid disabling a speedlevel when setting it)
		self.realSpeedLevelDisablingMaxTime = 0;
		
		self.realManageDirectionInputs = Steerable.realManageDirectionInputs;
		
		--20131216 - allow modders to override or extend this function to alter the "input" by script (baler automatically stoping the tractor for example, or gps mod with autosteer)
		self.realUpdateDriveAxisInput = Steerable.realUpdateDriveAxisInput;
		
	end;

end;




local oldSteerableDraw = Steerable.draw;
Steerable.draw = function (self)


	if not self.isRealistic then
	
		 if Vehicle.debugRendering then
			--display wheels info
			local fullText = "";
			
			--get the current real velocity
			local velx, vely, velz = getLinearVelocity(self.components[1].node);	
			local groundSpeed = Utils.vector3Length(velx, vely, velz);
			
			fullText = fullText .. string.format("Velocity=%4.2f / lastSpeedReal=%4.2f",groundSpeed,self.lastSpeedReal*1000);
			
			for k, wheel in pairs(self.wheels) do
				fullText = fullText .. string.format("W %d, wSpd %4.2f", k, math.rad(getWheelShapeAxleSpeed(wheel.node, wheel.wheelShape)*wheel.radius)) .. "\n";			
			end;
			renderText(0.01, 0.97, 0.02, fullText);
		end;
	
		return oldSteerableDraw(self);
	end;

   
	if not self.isEntered then
	   return;
	end;
   
   
   
--*********************************************************************************************************	
--DURAL : new computation for the kmh
		local kmh = math.min(999, math.max(0, math.abs(self.realDisplaySpeed)*3.6));   
--*********************************************************************************************************    
   
       self.hudBackgroundOverlay:render();
   
       setTextBold(true);
   
       setTextColor(1.0, 1.0, 1.0, 1.0);
       setTextAlignment(RenderText.ALIGN_CENTER);
   
--*********************************************************************************************************	
--DURAL : new computation for the maxSpeed       
	   local maxSpeed = self.realSpeedometerMaxSpeed * self.speedDisplayScale;
--*********************************************************************************************************	   
   
       local speedI18N = g_i18n:getSpeed(kmh);
   
--*********************************************************************************************************	
--DURAL : new display format (%1.1f)
       setTextColor(0, 0, 0, 1);
       renderText(self.hudBasePosX + self.hudBaseWidth / 2 + 0.002, self.hudBasePosY + 0.008 + 3 * 0.0396, 0.024, string.format("%1.1f " .. g_i18n:getText("speedometer"), speedI18N));
       setTextColor(1, 1, 1, 1);
       renderText(self.hudBasePosX + self.hudBaseWidth / 2 + 0.002, self.hudBasePosY + 0.01 + 3 * 0.0396, 0.024, string.format("%1.1f " .. g_i18n:getText("speedometer"), speedI18N));
--*********************************************************************************************************	   
       self.hudBarRedOverlay.width = self.hudBarWidth * math.min(1, kmh / maxSpeed);
       setOverlayUVs(self.hudBarRedOverlay.overlayId, 0, 0.05, 0, 1, math.min(1, kmh / maxSpeed), 0.05, math.min(1, kmh / maxSpeed), 1);
       self.hudBarRedOverlay:render();
   
   
   
       local currentFuelPercentage = 0;
       local fuelWarnPercentage = 20;
       if self.fuelCapacity > 0 then
           currentFuelPercentage = (self.fuelFillLevel / self.fuelCapacity + 0.0001) * 100;
       end;
   
       setTextColor(0, 0, 0, 1);
       renderText(self.hudBasePosX + self.hudBaseWidth / 2 + 0.002, self.hudBasePosY + 0.008 + 1 * 0.0396, 0.024, string.format("%d " .. g_i18n:getText("fluid_unit_long"), g_i18n:getFluid(self.fuelFillLevel)));
       if currentFuelPercentage < fuelWarnPercentage then
           setTextColor(1, 0, 0, 1);
       else
           setTextColor(1, 1, 1, 1);
       end;
       renderText(self.hudBasePosX + self.hudBaseWidth / 2 + 0.002, self.hudBasePosY + 0.01 + 1 * 0.0396, 0.024, string.format("%d " .. g_i18n:getText("fluid_unit_long"), g_i18n:getFluid(self.fuelFillLevel)));
   
       if currentFuelPercentage < fuelWarnPercentage then
           setTextColor(1, 1, 1, 1);
       end;
   
       self.hudBarGreenOverlay.width = self.hudBarWidth * (self.fuelFillLevel / self.fuelCapacity); -- TODO: check for division by zero!
       setOverlayUVs(self.hudBarGreenOverlay.overlayId, 0, 0.05, 0, 1, self.fuelFillLevel / self.fuelCapacity, 0.05, self.fuelFillLevel / self.fuelCapacity, 1);
       self.hudBarGreenOverlay:render();
   
       local trailerFillLevel, trailerCapacity = self:getAttachedTrailersFillLevelAndCapacity();
       if trailerFillLevel ~= nil and trailerCapacity ~= nil and trailerCapacity > 0 then
           self:drawGrainLevel(trailerFillLevel, trailerCapacity);
       end;
   
       -- render HUD frame overlay last (after all bars have been rendered)
       self.hudFramesOverlay:render();
   
       setTextAlignment(RenderText.ALIGN_LEFT);
       setTextBold(false);
   
       if self.showWaterWarning then
           --g_currentMission:addWarning("Fahren Sie nicht zu tief ins Wasser", 0.05, 0.025+0.007);
           g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_depth_into_the_water"), 0.05, 0.025+0.007);
       end;
   
       if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
         (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
         self.lightsState == 0 and self.lightsTypesMask == 0
       then
           g_currentMission:addHelpButtonText(g_i18n:getText("Turn_on_lights"), InputBinding.TOGGLE_LIGHTS);
       end;
   
       if table.getn(self.attachedImplements) > 1 or (self:getIsSelectable() and table.getn(self.attachedImplements) > 0) then
           g_currentMission:addHelpButtonText(g_i18n:getText("Change_tools"), InputBinding.SWITCH_IMPLEMENT);
       end;
   
       if self == g_currentMission.controlledVehicle then
           if g_currentMission.trailerInTipRange ~= nil then
               local canDump = true;
               --printText = g_i18n:getText("Dump");
               --printButton = InputBinding.ATTACH;
   
               -- check if current fruit type is accepted by the station
               if g_currentMission.currentTipTrigger ~= nil then
                   if not g_currentMission.currentTipTriggerIsAllowed then
                       local text = g_currentMission.currentTipTrigger:getNoAllowedText(g_currentMission.trailerInTipRange);
                       if text ~= nil and text ~= "" then
                           g_currentMission:addWarning(text, 0.018, 0.033);
                       end
                       --printText = nil;
                       --printButton = nil;
                       canDump = false;
                   end;
               end;
               if canDump then
                   g_currentMission:enableHudIcon("tip", 4);
                   g_currentMission:addHelpButtonText(g_currentMission.trailerInTipRange.tipText, InputBinding.ATTACH);
               end;
           end;
   
           -- enable attachment icon if needed
           if (g_currentMission.attachableInMountRange ~= nil and g_currentMission.attachableInMountRangeVehicle.attacherJoints[g_currentMission.attachableInMountRangeIndex].jointIndex == 0) then
               g_currentMission:enableHudIcon("attach", 3);
               g_currentMission:addHelpButtonText(g_i18n:getText("Attach"), InputBinding.ATTACH);
           end;
   
			
			--DURAL 20131008 - check if self.selectedImplement.object~=nil too (more "robust")
           if self.selectedImplement ~= nil and self.selectedImplement.object~=nil and self.selectedImplement.object.attacherVehicle ~= nil then
               local object = self.selectedImplement.object;
               local jointDesc = object.attacherVehicle.attacherJoints[self.selectedImplement.jointDescIndex];
   
               if object.allowsLowering and jointDesc.allowsLowering then
                   if jointDesc.moveDown then
                       g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lift_OBJECT"), object.typeDesc), InputBinding.LOWER_IMPLEMENT);
                   elseif object.needsLowering then
                       g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lower_OBJECT"), object.typeDesc), InputBinding.LOWER_IMPLEMENT);
                   end;
               end;
           end;
       end;
   
       --local cam = self.cameras[self.camIndex];
       --if cam ~= nil then
       --    renderText(0.4,0.5,0.03,string.format("rot: %f trans: %f", cam.rotX, Utils.vector3Length(cam.transX, cam.transY, cam.transZ)));
       --end;
   
       if Vehicle.debugRendering then
           local str = "";
           str = str .. string.format("   wheel rpm: %1.2f", self.wheelRpm) .. "\n";
           str = str .. string.format("   motor rpm: %1.2f", self.motor.lastMotorRpm) .. "\n";
           str = str .. string.format("           acc: %1.2f", self.lastAcceleration) .. "\n";
           str = str .. string.format("      real acc: %1.2f", self.lastRealAcceleration) .. "\n";
           str = str .. string.format("   frict. scale: %1.2f", self.wheelFrictionScale) .. "\n";
           str = str .. string.format("vel acc[m/s2]: %1.4f", self.lastSpeedAcceleration*1000*1000) .. "\n";
           str = str .. string.format("     vel[km/h]: %1.3f", self.lastSpeed*3600) .. "\n";
   
           local x,_,z = getWorldTranslation(self.components[1].node);
           local fieldOwned = g_currentMission:getIsFieldOwnedAtWorldPos(x,z);
           str = str ..               "  field owned: "..tostring(fieldOwned).. "\n";
			--[[
           if self.isServer then
               if table.getn(self.wheels) > 0 then
                   str = str .. " long. slip, lat. slip, susp\n";
                   for i=1, table.getn(self.wheels) do
                       local wheel = self.wheels[i];
                       local susp = 100-Utils.clamp(100*(wheel.netInfo.y - wheel.netInfo.yMin)/wheel.netInfo.yRange, 0, 100);
   
                       local longSlip, latSlip = getWheelShapeSlip(self.wheels[i].node, self.wheels[i].wheelShape);
                       if longSlip ~= nil and latSlip ~= nil then
                           str = str .. string.format("wheel %d: %2.2f, %2.2f, %1.2f%%", i, longSlip, latSlip, susp) .. "\n";
                       end;
                   end;
               end;
   
               -- wheel slip graphs:
               for i=1, table.getn(self.wheels) do
                   local wheel = self.wheels[i];
                   local longSlip, latSlip = getWheelShapeSlip(wheel.node, wheel.wheelShape);
   
                   local longStiffness = 1000000*wheel.longitudalStiffness*self.wheelFrictionScale;
                   local longExtremumSlip = wheel.longitudalExtremumSlip;
                   local longExtremumValue = wheel.longitudalExtremumValue;
                   local longAsymptoteSlip = wheel.longitudalAsymptoteSlip;
                   local longAsymptoteValue = wheel.longitudalAsymptoteValue;
   
                   local latStiffness = 1000000*wheel.lateralStiffness*self.wheelFrictionScale;
                   local latExtremumSlip = wheel.lateralExtremumSlip;
                   local latExtremumValue = wheel.lateralExtremumValue;
                   local latAsymptoteSlip = wheel.lateralAsymptoteSlip;
                   local latAsymptoteValue = wheel.lateralAsymptoteValue;
   
   
                   local longMaxSlip = longAsymptoteSlip * 3;
                   local latMaxSlip = latAsymptoteSlip * 3;
   
                   local sizeX = 0.15;
                   local sizeY = 0.15;
                   local spacingX = 0.01;
                   local spacingY = 0.01;
                   local x = spacingX + (0.2+spacingX) * (i-1);
                   local longY = 1-spacingY-sizeY;
                   local latY = longY-spacingY-sizeY;
   
                   local numGraphValues = 30;
   
   
                   -- longitudal graph
                   local longGraph = wheel.debugLongitudalFrictionGraph;
                   if longGraph == nil then
                       longGraph = Graph:new(numGraphValues, x, longY, sizeX, sizeY, 0, longExtremumValue*2, false, "");
                       longGraph:setColor(1, 1, 1, 1);
                       wheel.debugLongitudalFrictionGraph = longGraph;
   
                       for s=1, numGraphValues do
                           longGraph:setValue(s, WheelsUtil.calculateWheelTireFriction((s-1)/(numGraphValues-1) * longMaxSlip, longExtremumSlip, longExtremumValue, longAsymptoteSlip, longAsymptoteValue, 1));
                       end
                   end
   
                   -- lateral graph
                   local latGraph = wheel.debugLateralFrictionGraph
                   if latGraph == nil then
                       latGraph = Graph:new(numGraphValues, x, latY, sizeX, sizeY, 0, latExtremumValue*2, false, "");
                       latGraph:setColor(1, 1, 1, 1);
                       wheel.debugLateralFrictionGraph = latGraph;
   
                       for s=1, numGraphValues do
                           latGraph:setValue(s, WheelsUtil.calculateWheelTireFriction((s-1)/(numGraphValues-1) * latMaxSlip, latExtremumSlip, latExtremumValue, latAsymptoteSlip, latAsymptoteValue, 1));
                       end
                   end
   
   
   
   
                   local longSlipOverlay = wheel.debugLongitudalFrictionSlipOverlay;
                   if longSlipOverlay == nil then
                       longSlipOverlay = createImageOverlay("dataS/scripts/shared/graph_pixel.png");
                       wheel.debugLongitudalFrictionSlipOverlay = longSlipOverlay;
                   end
                   local latSlipOverlay = wheel.debugLateralFrictionSlipOverlay;
                   if latSlipOverlay == nil then
                       latSlipOverlay = createImageOverlay("dataS/scripts/shared/graph_pixel.png");
                       wheel.debugLateralFrictionSlipOverlay = latSlipOverlay;
                   end
   
                   longGraph:draw();
                   latGraph:draw();
   
   
                   setOverlayColor(longSlipOverlay, 0, 1, 0, 0.2);
                   setOverlayColor(latSlipOverlay, 0, 1, 0, 0.2);
                   renderOverlay(longSlipOverlay, x, longY, sizeX*math.min(math.abs(longSlip)/longMaxSlip, 1), sizeY);
                   renderOverlay(latSlipOverlay, x, latY, sizeX*math.min(math.abs(latSlip)/latMaxSlip, 1), sizeY);
               end
           end;]]
           renderText(0.45, 0.35, 0.02, str);
		   
			
		   
       end;
   end;



   
   
   
local oldSteerableUpdateTick = Steerable.updateTick;
Steerable.updateTick = function(self, dt)

	if not self.isRealistic then
		return oldSteerableUpdateTick(self, dt);
	end;
	
	--more precise steering/acc only for the client on server side
	--here, we only update steering input in "updatetick" (less frequently than "update")
	-- too much "strain" on the network otherwise
	if self.isClient and not self.isServer then
		self:realManageDirectionInputs(dt);
	end;
	
	if self.isServer and self.steeringEnabled and not (self.isControlled and self.isMotorStarted) then
		--self.realIsMotorized and not (self.isControlled and self.realIsMotorStarted) then
		if self.realIsActive and self.firstTimeRun then		
			self.axisForward = 0;
			self.axisSide = 0;
			--print(self.time .. " - " .. tostring(self.realVehicleName) .. " - motor stopped : rolling until complete stop");
			WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, 0, false, self.requiredDriveMode); -- vehicle continue to follow wheels steering angle until complete stop	
		end;		
	end;
	
end;



local oldSteerableUpdate = Steerable.update;
Steerable.update = function(self, dt)

	if not self.isRealistic then
		return oldSteerableUpdate(self, dt);
	end;
	
	
	--we don't want the "oldSteerableUpdate" to call setfuelFillLevel for no nothing
	local backupLastMovedDistance = self.lastMovedDistance;
	self.lastMovedDistance = 0;
	oldSteerableUpdate(self, dt);
	self.lastMovedDistance = backupLastMovedDistance;
	
	
	--since the old steerable can't add the travelled distance, we do it now
	--count all the travelled distances, included hired worker ones
	if self.isServer and self.lastMovedDistance>0 then
		g_currentMission.missionStats.traveledDistanceTotal = g_currentMission.missionStats.traveledDistanceTotal + self.lastMovedDistance*0.001; -- convert to km
		g_currentMission.missionStats.traveledDistanceSession = g_currentMission.missionStats.traveledDistanceSession + self.lastMovedDistance*0.001;
	end;
	
	
	--more precise steering/acc only for the client on server side
	-- too much "strain" on the network otherwise
	if self.isServer and self.isClient then
		self:realManageDirectionInputs(dt);
	end;

end;

   
   
   
   
   
   
   
   
local oldSteerableCalculateRealAcceleration = Steerable.calculateRealAcceleration;
Steerable.calculateRealAcceleration = function(self, acceleration, dt)

	if not self.isRealistic then
		return oldSteerableCalculateRealAcceleration(self, acceleration, dt);
	end;

	
	local accFx = 1;
	
	if not self.realManualGearSet then
		-- acc reactivity function of current speed
		accFx = math.max(0.37, 0.15*self.realGroundSpeed^1.5);	
		-- acc reactivity function of current motorload
		accFx = accFx * math.max(1, self.realMotorLoad*3); 
	end;
	
	--more motor acc if speed acc = 0
	--if math.abs(self.realDebugAcc)<0.01 then
	--	accFx = math.max(accFx, 0.25);
	--end;

	local maxAccelerationSpeed = self.maxAccelerationSpeed*accFx;
	local decelerationSpeed = self.decelerationSpeed;
	local brakeSpeed = self.realBrakeSpeed;
	
	if self.movingDirection < 0 then
		maxAccelerationSpeed = self.backwardMaxAccelerationSpeed*accFx;
		decelerationSpeed = self.backwardDecelerationSpeed;
	end;
	
	if self.realManualGearSet then
		maxAccelerationSpeed = self.realManualGearAccelerationSpeed*accFx;
		decelerationSpeed = self.realManualGearDecelerationSpeed;
	end;
	
	if self.realThrottleIsManual then
		if acceleration>=0 then
			if self.realThrottleOnlyManual then
				acceleration = self.realThrottleCurrentValue;
			else
				acceleration = math.max(acceleration, self.realThrottleCurrentValue);
			end;
		end;
	end;
	

	-- __DURAL__	
	-- desactivate vehicle when fuel level reach 0
	if self.fuelFillLevel == 0 then
		acceleration = 0;
		if self.isMotorStarted then
			self.lastAcceleration = 0;
			self:stopMotor(true);
			
			--if self.deactivateOnLeave then
			self.lastAcceleration = 0;
--** NOT USEFUL ANYMORE. SEE  "self.realAutoParkBrakeValue = 1;" in "WheelsUtil.updateWheelsPhysics"
			--[[if self.isServer then
				for k,wheel in pairs(self.wheels) do
					if wheel.hasHandBrake then
						setWheelShapeProps(wheel.node, wheel.wheelShape, 0, wheel.brakeRatio * self.realHandBrakeForce, 0);
					end;
				end;
			end;--]]
			self:onDeactivateAttachments();
			--end;
			
		end;
		if self.isAITractorActivated then
			self:stopAITractor();
		end;
		if self.isAIThreshing then
			self:stopAIThreshing();
		end;
	end;
	
	if acceleration==0 then
		maxAccelerationSpeed = decelerationSpeed;
	elseif (self.realBackwardGearEngaged==false and acceleration<0)  or (self.realBackwardGearEngaged==true and acceleration>0) then		
		maxAccelerationSpeed = brakeSpeed;	
	--else--if self.movingDirection==0 then
		--maxAccelerationSpeed = (0.25 + math.min(0.75, self.realGroundSpeed)) * maxAccelerationSpeed; -- start gentle
	end; 
	
	
	if math.abs(acceleration) > 0.0001 then
		if Utils.sign(acceleration) ~= Utils.sign(self.lastAcceleration) then
			self.lastAcceleration = 0;
		end;
		acceleration = math.min(math.max(acceleration, self.lastAcceleration-dt*maxAccelerationSpeed), self.lastAcceleration+dt*maxAccelerationSpeed);
		self.lastAcceleration = acceleration;
	else
		if self.lastAcceleration > 0 then
			self.lastAcceleration = math.max(self.lastAcceleration-dt*decelerationSpeed, 0);
		elseif self.lastAcceleration < 0 then
			self.lastAcceleration = math.min(self.lastAcceleration+dt*decelerationSpeed, 0);
		end;
	end;
	self.lastRealAcceleration = acceleration;
	 
	return acceleration;
end;



local oldSteerableUpdateVehiclePhysics = Steerable.updateVehiclePhysics;
Steerable.updateVehiclePhysics = function(self, axisForward, axisForwardIsAnalog, axisSide, axisSideIsAnalog, dt)
      
	if not self.isRealistic then
		return oldSteerableUpdateVehiclePhysics(self, axisForward, axisForwardIsAnalog, axisSide, axisSideIsAnalog, dt);
	end;
	 
--************************************************* DURAL ******************************************************************	
--smoothing light pressure on pedals
	--not useful anymore : instead of "smoothing" the accelerator, we smooth the target speed in realisticMotorized | and smooth the brakepedal in "overrideWheelUtils"
	--if axisForwardIsAnalog then
		--axisForward = axisForward^3; --Utils.sign(axisForward) * math.abs(axisForward)^3;		
	--end;
--************************************************ END DURAL **************************************************************


	--DURAL : 20131101 - add support for "reverse driving mode"
	if self.realReverseDrivingModeEngaged then
		if not self.realShuttleIsManual then		
			axisForward = -axisForward;
		end;
		axisSide = -axisSide;
	end;
	  
	local acceleration = 0;
	if self.isMotorStarted and self.motorStartTime <= self.time then
		acceleration = -axisForward;
		
		if self.time<self.realSpeedLevelDisablingMaxTime then			
			acceleration = math.min(acceleration, 0);
		end;	
		
	--************************************************* DURAL ******************************************************************
	--** we do not want vehicle to be "faster" at accelerating when leaving the regulator mode (speed level). so, we keep the last regulator acceleration as starting acceleration when going from the regulator to manual acceleration
		if self.motor.speedLevel ~= 0 then
			if  (acceleration>0.1 and acceleration >= self.realRegulatorFxS) then -- only desactivate the speedlevel if the current input acceleration>=regulator (EDIT 20131206 - check the input is >0.1 to avoid 0>=0 when setting a speedlevel before the motor is started)
				self.lastAcceleration = self.lastAcceleration*acceleration;
				self.motor:setSpeedLevel(0, true);
				--print(self.time .. " - " .. tostring(self.realVehicleName) .. " - set speedlevel 0 due to operator input");
			elseif acceleration<-0.1 then -- desactivate the speedlevel if we want to brake
				self.motor:setSpeedLevel(0, true);
			else -- do not desactivate the speedlevel, and so, acc = 1
				acceleration = 1;
			end;              
		end;
--************************************************ END DURAL **************************************************************               
	end;
	if self.fuelFillLevel == 0 then
		acceleration = 0;
	end;

	self.realWantedAcceleration = acceleration;
	acceleration = Steerable.calculateRealAcceleration(self, acceleration, dt);
	--print(self.time .. " steerable - " .. tostring(self.realVehicleName) .. " - acc before = "..tostring(self.realWantedAcceleration) .. " - acc after = " .. tostring(acceleration));

  
	--if Input.isKeyPressed(Input.KEY_a) then
	local inputAxisX = axisSide;
	if axisSideIsAnalog then
		local targetRotatedTime = 0;
		if inputAxisX < 0 then
			-- 0 to maxRotTime
			targetRotatedTime = math.min(-self.maxRotTime*inputAxisX, self.maxRotTime);
		else
			-- 0 to minRotTime
			targetRotatedTime = math.max(self.minRotTime*inputAxisX, self.minRotTime);
		end;
		
		--avoid the steering to get back instantly when using both the analog device and the keyboard to steer the vehicle 
		--(example : when steering with the keyboard, if we release the steer key, the wheels get back to the analog device position instantly)
		local maxTime = self.maxRotatedTimeSpeed*dt;
		if math.abs(targetRotatedTime-self.rotatedTime) > maxTime then
			if targetRotatedTime > self.rotatedTime then
				self.rotatedTime = self.rotatedTime + maxTime;
			else
				self.rotatedTime = self.rotatedTime - maxTime;
			end;
		else
			self.rotatedTime = targetRotatedTime;
		end;
		
		
	else -- not analog
	
		--keyboard -> steering quicker at lower speed
		local speed = self.realGroundSpeed - self.realMaxSpeedForMaxRotSpeed;
		local rotScale = 1;
		if speed>0 then		
		--if self.realGroundSpeed>0 then	
			rotScale = 1 / (1 + self.speedRotScale*speed)^0.8;
		end;
		
		--"smooth" the inputAxisX when the steering system is "locked" (no autoRotateBack)
		if self.realLockSteeringSystem==true or self.autoRotateBackSpeed==0 then
			if inputAxisX==0 then
				self.realInputXFx = math.max(0, self.realInputXFx - dt/250);
			else
				self.realInputXFx = math.min(1, self.realInputXFx + dt/1000);
			end;
			inputAxisX = self.realInputXFx * inputAxisX;
			rotScale = 1.2 * rotScale;
		end;
		
		
		--local rotScale = math.min(1.0/(self.realGroundSpeed*self.speedRotScale+self.speedRotScaleOffset), 1);
	--local inputAxisX = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_SIDE_VEHICLE);
	
	
	--[[
		local targetRotatedTime = 0;
		
		if inputAxisX~=0 then			
			self.realInputAxisXS = math.min(1, (0.001*dt+self.realInputAxisXS^0.5)^2);
		else			
			self.realInputAxisXS = math.max(0, self.realInputAxisXS - 0.002*dt);			
		end;
		
		if inputAxisX < 0 then
			-- 0 to maxRotTime
			targetRotatedTime = math.min(self.maxRotTime*self.realInputAxisXS, self.maxRotTime);
		else
			-- 0 to minRotTime
			targetRotatedTime = math.max(self.minRotTime*self.realInputAxisXS, self.minRotTime);
		end;		
		
		local maxTime = self.maxRotatedTimeSpeed*dt;
		if math.abs(targetRotatedTime-self.rotatedTime) > maxTime then
			if targetRotatedTime > self.rotatedTime then
				self.rotatedTime = self.rotatedTime + maxTime;
			else
				self.rotatedTime = self.rotatedTime - maxTime;
			end;
		else
			self.rotatedTime = targetRotatedTime;
		end;]]
	
	
	
	
	
		  
--************************************************* DURAL ******************************************************************	  
--** "damping" inputAxisX		

		

		--[[
		if inputAxisX==0 then
			self.realLastInputAxisXFactor = math.max(0, self.realLastInputAxisXFactor - dt/1000);
			--self.realLastInputAxisXFactor = math.max(self.realLastInputAxisXFactor, self.realLastAutoRotateBackSpeedFactor);
		else
			if self.realLastInputAxisXFactor<1 then -- inputAxisX == -1 or 1 on a keyboard
				self.realLastInputAxisXFactor = math.min(1, self.realLastInputAxisXFactor + dt/1000);
				if self.rotatedTime~=0 and Utils.sign(self.rotatedTime)==Utils.sign(inputAxisX) then
					self.realLastInputAxisXFactor = math.max(self.realLastInputAxisXFactor, self.realLastAutoRotateBackSpeedFactor);				
				end;
			end;
		end;	
		inputAxisX = self.realLastInputAxisXFactor*inputAxisX;

--************************************************ END DURAL **************************************************************  

		if inputAxisX~=0 or self.rotatedTime==0 then
			self.realLastAutoRotateBackSpeedFactor = math.max(0, self.realLastAutoRotateBackSpeedFactor - dt/1000);
		end;]]
		
		  
		if inputAxisX==0 then

			if self.realLockSteeringSystem==false and self.autoRotateBackSpeed ~= 0 then

--************************************************* DURAL ******************************************************************	  
--** "damping" autoRotateBackSpeed
				--[[
				if self.rotatedTime~=0 then				
					if self.realLastAutoRotateBackSpeedFactor<1 then
						self.realLastAutoRotateBackSpeedFactor = math.min(1, self.realLastAutoRotateBackSpeedFactor + dt/1000);
						if self.articulatedAxis~=nil then
							self.realLastAutoRotateBackSpeedFactor = math.max(self.realLastAutoRotateBackSpeedFactor, self.realLastInputAxisXFactor);
						end;
					end;
				end;
				local autoRotateBackSpeed = self.realLastAutoRotateBackSpeedFactor * self.autoRotateBackSpeed;]]
					  
				if self.rotatedTime > 0 then
					self.rotatedTime = math.max(self.rotatedTime - dt/1000*self.autoRotateBackSpeed*rotScale, 0);
				else
					self.rotatedTime = math.min(self.rotatedTime + dt/1000*self.autoRotateBackSpeed*rotScale, 0);
				end;
			
			end;

		else --inputX~=0			
			if inputAxisX < 0 then				
				self.rotatedTime = math.min(self.rotatedTime - dt/1000*inputAxisX*rotScale, self.maxRotTime);				
			else				
				self.rotatedTime = math.max(self.rotatedTime - dt/1000*inputAxisX*rotScale, self.minRotTime);				
			end;
		end;
		
		--self.realLastInputAxisXFactor = math.max(0.1, 0.9*self.realLastInputAxisXFactor + 0.1*math.abs(inputAxisX));
		
	end; -- end not analog control device
--************************************************ END DURAL ************************************************************** 
  
	
  
	if self.firstTimeRun then
		WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode)
	end;
	  
end;










local oldSteerableSetSpeedLevel = Steerable.setSpeedLevel;
Steerable.setSpeedLevel = function(self, speedLevel)

	if not self.isRealistic then
		return oldSteerableSetSpeedLevel(self, speedLevel);
	end;

--**************************************** DURAL *********************************
--** No torque brakedown when shifting speedlevel

	--EDIT 20131205 - not needed anymore ?
	--20131018 - check the motor is started in case the manual ignition mod is in used
	--if speedLevel~=0 and not self.realIsMotorStarted then
	--	return;
	--end;
	
	--print(self.time .. " setting speedlevel = " .. tostring(speedLevel));
	
	--only the server should run this function	
	if self.isServer and speedLevel~=0 then
		
		if self:realGetIsAiDriven() then
			local targetSpeed = self.motor.realSpeedLevelsAI[speedLevel];
			if targetSpeed<(3.6*self.realGroundSpeed) then
				self.lastAcceleration = 1;
			end;
		else
			local targetSpeed = self.motor.realSpeedLevels[speedLevel];
			if self.motor.speedLevel~=0 then
				--current speed level ~= 0
				if targetSpeed>(3.6*self.realGroundSpeed) then
					self.lastAcceleration = self.realRegulatorFxS;
				else
					self.lastAcceleration = 1;
				end;
			else
				--current speed level == 0
				if targetSpeed>(3.6*self.realGroundSpeed*self.realMovingDirection) then
					--self.lastAcceleration = self.realRegulatorFxS;
				else
					self.lastAcceleration = 1;
				end;
			end;			
		end;
		
	end;
	
	
	--if self.lastAcceleration==1 then
	--	self.lastAcceleration = self.realRegulatorFxS;		
	--end;
	
		
--***************************************** END DURAL ***************************************
	
	self.motor:setSpeedLevel(speedLevel, false);
	
	self.realSpeedLevelDisablingMaxTime = self.time + self.realSpeedLevelDisablingTime;
	
end;





local oldSteerableOnLeave = Steerable.onLeave;
Steerable.onLeave = function(self)

	if not self.isRealistic then
		return oldSteerableOnLeave(self);
	end;

	self.isControlled = false;
	self.cameras[self.camIndex]:onDeactivate();

	

	if self.characterNode ~= nil then
		if self.disableCharacterOnLeave then
			setVisibility(self.characterNode, false);
		else
			setVisibility(self.characterNode, true);
		end;
	end;

	Steerable.realDesactivateVehicle(self);

	
	self.isEntered = false;
	g_currentMission.controlledVehicles[self] = nil;
end;






local oldSteerableDrawGrainLevel = Steerable.drawGrainLevel;
Steerable.drawGrainLevel = function(self, level, capacity)

	if not self.isRealistic then
		return oldSteerableDrawGrainLevel(self, level, capacity);
	end;

	local percent = 0;
	if capacity > 0 then -- skip if there's no capacity
		percent = level / capacity * 100;

		setTextBold(true);
		setTextAlignment(RenderText.ALIGN_CENTER);

		setTextColor(0, 0, 0, 1);
		renderText(self.hudBasePosX + self.hudBaseWidth / 2 + 0.002, self.hudBasePosY + 0.008 + 2 * 0.0396, 0.024, string.format("%d (%d%%)", level, percent));

--************************************************ DURAL ****************************************************
-- we want to display the fill level in red if level>capacity
		if level>capacity then
			setTextColor(1, 0, 0, 1);
		else
			setTextColor(1, 1, 1, 1);
		end;
		renderText(self.hudBasePosX + self.hudBaseWidth / 2 + 0.002, self.hudBasePosY + 0.01 + 2 * 0.0396, 0.024, string.format("%d (%d%%)", level, percent));

		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(false);
		-- render the grain fill level bar
--************************************************ DURAL ****************************************************
-- we don't want the "bar" to be more than its full length...		
		level = math.min(capacity, level);		
		
		self.hudBarGoldOverlay.width = self.hudBarWidth * (level / capacity);
		setOverlayUVs(self.hudBarGoldOverlay.overlayId, 0, 0.05, 0, 1, level / capacity, 0.05, level / capacity, 1);
		self.hudBarGoldOverlay:render();
	end;
	
end;










Steerable.realDesactivateVehicle = function(self)

	if self.deactivateLightsOnLeave then
		self:setLightsTypesMask(0, true);
	end;
	if not self.isAIThreshing then
		self:setBeaconLightsVisibility(false, true);
	end;
	self:setBrakeLightsVisibility(false);
	
	if self.stopMotorOnLeave then
		self.lastAcceleration = 0;
		self:stopMotor(true);
	else
		Motorized.stopSounds(self);
	end;
	
	if self.deactivateOnLeave then
		self.lastAcceleration = 0;
		--** NOT USEFUL ANYMORE. SEE  "self.realAutoParkBrakeValue = 1;" in "WheelsUtil.updateWheelsPhysics"
		--[[
		if false and self.isServer then
			--print(self.time .. "  " .. self.realVehicleName .. " deactivateOnLeave, realHandBrakeForce = " .. tostring(self.realHandBrakeForce));
			for k,wheel in pairs(self.wheels) do
				if wheel.hasHandBrake then
					setWheelShapeProps(wheel.node, wheel.wheelShape, 0, wheel.brakeRatio * self.realHandBrakeForce, 0);
				end;
			end;
		end;--]]
		--//self:onDeactivateAttachements();
		self:onDeactivateAttachments();
	else
		if self.deactivateLightsOnLeave then
			self:onDeactivateAttachmentsLights();
		end;
		self:onDeactivateAttachmentsSounds();		
	end;
	
	
	self.realShowTransmissionWarning = false;	
	self.realTransmissionWarningCurrentDisplayMaxTime = 0;

end;



function Steerable:realManageDirectionInputs(dt)

	--DURAL : 2013/10/04 : do not allow steering or acceleration while the engine is starting
	--if self.isEntered and self.isClient and self.isMotorStarted then
	if self.isEntered and self.isClient and self.realIsMotorStarted then
		
		self:realUpdateDriveAxisInput();
		
		if not self:getIsActiveForInput(false) then
			if not self.axisSideIsAnalog then
				self.axisSide = 0;
			end
			if not self.axisForwardIsAnalog then
				self.axisForward = 0;
			end

			if self.steeringEnabled then				
				if g_gui.currentGui ~= nil and g_gui.currentGuiName ~= "ChatDialog" then
					--print("Steerable.realManageDirectionInputs - currentGuiName = " ..   g_gui.currentGuiName);
					self.motor:setSpeedLevel(0, true)
				end;
			end;
		end
		
		if g_isServerStreamingVersion then self.axisSide = self.axisSide * 0.5; end;   -- This is the factor to slow down the steering
		
		if self.isServer then -- if we are also the server, no need to send an event.
			if self.steeringEnabled then
				Steerable.updateVehiclePhysics(self, self.axisForward, self.axisForwardIsAnalog, self.axisSide, self.axisSideIsAnalog, dt);
			end;
		else
			if self.steeringEnabled and self.motor.speedLevel>0 then
				--Braking or accelerating more than the current regulator position
				if self.axisForward>0 or self.axisForward<=self.realRegulatorFxS then
					self.motor:setSpeedLevel(0, true)
				end;
			end;
	 
			--self.motor:computeMotorRpm(self.wheelRpm, self.axisForward);
			self:raiseDirtyFlags(self.steerableGroundFlag);
		end;
	end;

end;


function Steerable:realUpdateDriveAxisInput()

	self.axisForward = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
	self.axisForwardIsAnalog = false;
	if InputBinding.isAxisZero(self.axisForward) then
		self.axisForward = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
		--DURAL : correction bug "axisForwardIsAnalog" = true even if the player play with a keyboard...
		self.axisForwardIsAnalog = not InputBinding.isAxisZero(self.axisForward);
	end;

	self.axisSide = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_SIDE_VEHICLE);
	self.axisSideIsAnalog = false;
	if InputBinding.isAxisZero(self.axisSide) then
		self.axisSide = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_SIDE_VEHICLE);
		--DURAL : correction bug "axisSideIsAnalog" = true even if the player play with a keyboard...
		self.axisSideIsAnalog = not InputBinding.isAxisZero(self.axisSide);
	end;

end;

