
function SowingMachineFillTrigger:fillSowingMachine(sowingMachine, delta)
	
	if not sowingMachine:allowFillType(self.fillType, false) then
		return 0.0;
	end
	local oldFillLevel = sowingMachine:getFillLevel(self.fillType);
	if self.isSiloTrigger then
		local silo = g_currentMission:getSiloAmount(self.fillType);
		delta = math.min(delta, silo);
		if delta > 0 then
			sowingMachine:setFillLevel(oldFillLevel + delta, self.fillType, true);
			delta = sowingMachine:getFillLevel(self.fillType) - oldFillLevel;

			g_currentMission:setSiloAmount(self.fillType, silo - delta);
		end
	else
		sowingMachine:setFillLevel(oldFillLevel + delta, self.fillType, true);
		delta = sowingMachine:getFillLevel(self.fillType) - oldFillLevel;
		
		--local fruitTypeDesc = FruitUtil.fillTypeToFruitType[self.fillType];
		--local fruitTypeDesc = FruitUtil.fruitIndexToDesc[fruitType];
		--local name = Fillable.fillTypeIntToName[self.fillType];
		--print(sowingMachine.time .. " SowingMachineFillTrigger.fillSowingMachine  name / fillType / fruitType = " .. name .. " / " .. tostring(self.fillType) .. " / " .. tostring(fruitTypeDesc));
		
		--20131001 - DURAL - better support for "not normal sowing machine". Example : bulk handling kit from Sam123
		local price = 0;		
		if sowingMachine.seeds~=nil and sowingMachine.currentSeed~=nil then		
			local fruitType = sowingMachine.seeds[sowingMachine.currentSeed];
			if fruitType ~= nil then
				local fruitTypeDesc = FruitUtil.fruitIndexToDesc[fruitType];
				if fruitTypeDesc ~= nil then
					price = delta*fruitTypeDesc.seedPricePerLiter;
				end;
			end;
		else
			local fillTypeDesc = Fillable.fillTypeIndexToDesc[self.fillType]
			if fillTypeDesc ~= nil then
				price = delta*fillTypeDesc.pricePerLiter;
			end;
		end;
		
		if price ~= 0 then					
			g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + price;
			g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + price;

			g_currentMission:addSharedMoney(-price, "other");			
		end;
		
	end

	return delta;
end