
oldMotorizedUpdateTick = Motorized.updateTick;
Motorized.updateTick = function(self, dt)

	if not self.isRealistic then
		return oldMotorizedUpdateTick(self, dt)
	end;

	if self.isServer then
--***********************************  DURAL  ***********************************
--** no need to raise the dirty flag for very small amount of fuel
		--if math.abs(self.fuelFillLevel-self.sentFuelFillLevel) > 0.001 then
		if math.abs(self.fuelFillLevel-self.sentFuelFillLevel) > 0.1 then
			self:raiseDirtyFlags(self.motorizedDirtyFlag);
			self.sentFuelFillLevel = self.fuelFillLevel;
		end;
	end;

	if self.isFuelFilling then

		if self.isClient then
			if self:getIsActiveForSound() then
				if not self.refuelSampleRunning then
					playSample(self.refuelSample, 0, 1, 0);
					self.refuelSampleRunning = true;
				end;
			end;
		end;

		if self.isServer then
			local delta = 0;
			if self.fuelFillTrigger ~= nil then
				delta = self.fuelFillLitersPerSecond*dt*0.001;
				delta = self.fuelFillTrigger:fillFuel(self, delta);
			end;

--***********************************  DURAL  **************************************************************************************
--** better to check the current fill level VS tank capacity since the motor can use a bit of fuel between each call to "fillFuel"
			--if delta <= 0 then			
			if self.fuelFillLevel == self.fuelCapacity then
				self:setIsFuelFilling(false);
			end;
		end;
		
	end;
	
end;




oldMotorizedUpdate = Motorized.update;
Motorized.update = function(self, dt)

	if not self.isRealistic then
		return oldMotorizedUpdate(self, dt);
	end;
	
			
	

	if self.isClient then -- no need for sound on standalone server
		self.realEngineSound3dEnabled = false;
		
		--DURAL : 20131004 - fix the bug with realIsMotorStarted being false even if the engine is running
		if self.isMotorStarted then		
			if self:getIsActiveForSound() then			
			--if self.realIsMotorStarted then
			
				--print("Motorized.update self.time=" .. tostring(self.time) .. "  isSamplePlaying(self.motorStartSound) = " .. tostring(isSamplePlaying(self.motorStartSound)));
				
				--RealisticUtils.testClass("g_i18n", g_i18n);
				--RealisticUtils.testClass("self", self);
				--return;
				
				if self.motorSound ~= nil and not self.motorSoundEnabled then
					if self.motorStartSound == nil or not isSamplePlaying(self.motorStartSound) or getSamplePlayOffset(self.motorStartSound) >= getSampleDuration(self.motorStartSound)-1.5*dt then
						playSample(self.motorSound, 0, self.motorSoundVolume, 0);
						if self.motorSoundRun ~= nil then
							playSample(self.motorSoundRun, 0, 0.0, 0);
						end;
						self.motorSoundEnabled = true;
					end;
				end;

				if self.compressionSound ~= nil and not self.compressionSoundEnabled and self.compressionSoundTime <= self.time then
					playSample(self.compressionSound, 1, self.compressionSoundVolume, 0);				
					self.compressionSoundTime = self.time + 180000;
					self.compressionSoundEnabled = true;
				end;
				
				if self.motorSound3D ~= nil then
					setVisibility(self.motorSound3D, false);
				end;			

			else--if self.isMotorStarted then -- we are not in the vehicle, play the 3d sound
				if self.motorSound3D ~= nil then
					setVisibility(self.motorSound3D, true);
					self.realEngineSound3dEnabled = true;
				end
			end;
		end;
	

		if self.isEntered and self.reverseDriveSound ~= nil then			
			--DURAL : 20131101 - fix the reverse sound playing when switching to forward direction without moving in T1 mode (manual shuttle)
			--if self.realReverseGearEngaged then
			if self.realShuttleDisplayDirection==-1 then
				if not self.reverseDriveSoundEnabled and self:getIsActiveForSound() then
					playSample(self.reverseDriveSound, 0, self.reverseDriveSoundVolume, 0);
					self.reverseDriveSoundEnabled = true;
				end;
			else
				if self.reverseDriveSoundEnabled then
					stopSample(self.reverseDriveSound);
					self.reverseDriveSoundEnabled = false;
				end;
			end;		
		end;
		
	end; -- end isclient
		
		
		
		
	--print(self.time .. " Motorized.update sound " .. tostring(self.motorSound) .. " / " .. tostring(self.motorSoundVolume) .. " / " .. tostring(self.motorSoundPitchOffset).. " / " .. tostring(self.motorSoundPitchMax));
	--print(self.time .. " Motorized.update sound run " .. tostring(self.motorSoundRun) .. " / " .. tostring(self.motorSoundRunVolume).. " / " .. tostring(self.motorSoundRunPitchOffset).. " / " .. tostring(self.motorSoundRunPitchMax));
	
			
	--computing soundSpdFx and soundMotorFx
	-- only server side and if somebody is inside the vehicle
	--if self.isServer and (self.isControlled or self:realGetIsAiDriven()) then
	--DURAL - 20131020 : update the engine sound pitch and volume even if the vehicle is not controlled (manual ignition mod support)
	if self.isServer and self.isMotorStarted then
	
		local spdFx = 0;
		local motorFx = 0;
		local engineRevFx = 0;
		local maxSpeed = self.realMaxVehicleSpeed/3.6; -- kmh to m/s
		
		if maxSpeed<=0 then
			maxSpeed = 10;
		end;
		
		
		if self.realManualGearSet and ((self.realShuttleIsManual and self.realShuttleDirection==0 and not self.realHydrostaticTransmission) or not self.realClutchEngaged) then
			
			
			spdFx = self.realGroundSpeed / maxSpeed;
			
			--motorFx = math.max(0, self.realManualGearMotorRpmRatio-self.realManualGearIdleRpmRatio)/(1-self.realManualGearIdleRpmRatio);
			if self.realMotorLoad>0.01 then							
				motorFx = math.abs(0.1+self.realMotorLoad); -- minimal sound when motor has any load
			end;
			engineRevFx = math.max(self.lastAcceleration, self.realMotorLoad);
			if engineRevFx<self.realSoundEngineRevFx then
				engineRevFx = math.max(engineRevFx, self.realSoundEngineRevFx - 0.001*dt);
			else
				engineRevFx = math.min(engineRevFx, self.realSoundEngineRevFx + 0.001*dt);
			end;
			
			--[[
			if self.realThrottleIsManual then
				motorFx = math.abs(self.realMotorLoadS);
				if self.lastAcceleration>0 then						
					motorFx = math.max(motorFx, (self.lastAcceleration-self.realThrottleMinValue)/(1-self.realThrottleMinValue));
				end;
			else
				motorFx = math.max(math.abs(self.realMotorLoadS), math.abs(self.lastAcceleration));
			end;--]]
			--self.realManualGearClutchIsSlipping = false;
		else
			if self.realManualGearSet and self.realManualGearMaxSpeed>0 and not self.realHydrostaticTransmission then
				--local gearRatioFx = math.abs(self.realAvgMotorizedWheelSpd/(self.realManualGearMaxSpeed*1.1));	
				
				--if self.realManualGearClutchIsSlipping then
					--slipping clutch
				--	gearRatioFx = math.abs(self.realMotorLoadS);						
				--end;
				
				--print("Motorized.update - gearRatioFx = " .. tostring(gearRatioFx));
				--spdFx = (0.5 * self.realGroundSpeed / (self.realManualGearMaxSpeed + 0.5) + 0.5 * gearRatioFx)^2;
				--spdFx = 0.5 * self.realGroundSpeed / maxSpeed + 0.5 * gearRatioFx;
				--motorFx = (0.25*math.abs(self.realMotorLoad) + 0.75*gearRatioFx)^2;
				
				if self.realShuttleDirection==-1 then -- reverse
					engineRevFx = math.max(0, -self.realManualGearMinSpeed-self.realAvgMotorizedWheelSpd)/(self.realManualGearMaxSpeed-self.realManualGearMinSpeed);
				else
					engineRevFx = math.max(0, self.realAvgMotorizedWheelSpd-self.realManualGearMinSpeed)/(self.realManualGearMaxSpeed-self.realManualGearMinSpeed);				
				end;
				
				spdFx = self.realGroundSpeed / maxSpeed;
				if self.realMotorLoad>0.01 then							
					motorFx = math.abs(0.1+self.realMotorLoad); -- minimal sound when motor has any load
				end;
				
			else
				--print(self.time .. " " .. self.realVehicleName .. " realGroundSpeed = " .. tostring(self.realGroundSpeed) .. " - maxSpeed = " .. tostring(maxSpeed));
				spdFx = self.realGroundSpeed / maxSpeed;
				if self.realMotorLoad>0.01 then							
					motorFx = math.abs(0.1+self.realMotorLoad); -- minimal sound when motor has any load
				end;
				
				--taking into account motor rev up when braking (auto motor brake)
				if self.realCurrentMotorBrakeForceFx>0 then
					--motorFx = math.max(motorFx, math.min(0.9, self.realGroundSpeed/6)); -- max motorbrake sound at 20km/h
					-- more sound when "braking" more weight
					--local fx1 = Utils.clamp(self.realTotalMovingMassOnTheWheels/self.realComponentsCurrentMass, 1,4);
					local fx1 = self.realCurrentMotorBrakeForceFx * 0.5 * math.min(2, self.realGroundSpeed) + 0.01*self.realGroundSpeed; -- max motorbrake start at 2 mph
					--local fx1 = math.max(self.realMotorBrakeFx, spdFx^0.5);
					motorFx = math.max(motorFx, math.min(2.5, fx1));
				end;
				
				--taking into account motor rev up for some tools (mainly PTO driven one. Example : combine discharging)
				if self.realNeedEngineRev then
					motorFx = math.max(motorFx, 0.75);
				end;
				
				--self.realManualGearClutchIsSlipping = false;
				--print(self.time .. " Motorized.update - realGroundSpeed = " .. tostring(self.realGroundSpeed) .. " / realMaxVehicleSpeed = " .. tostring(self.realMaxVehicleSpeed) .. " / spdFx = " .. tostring(spdFx));
				
			end;
		end;				
					
		self.realLastMotorFx = 0.95*self.realLastMotorFx + 0.05*motorFx;
		--self.realLastEngineRevFx = 0.95*self.realLastEngineRevFx + 0.05*engineRevFx;
		
		self.realSoundSpdFx = spdFx;	
		self.realSoundMotorFx = self.realLastMotorFx;
		self.realSoundEngineRevFx = engineRevFx;
		
		self:raiseDirtyFlags(self.realMotorizedDirtyFlag);
		
		--print(self.time .. " " .. self.realVehicleName .. " realSoundSpdFx = " .. tostring(self.realSoundSpdFx) .. " realSoundMotorFx = " .. tostring(self.realSoundMotorFx) .. " motorload = " .. tostring(self.realMotorLoad)); 
		
	end; -- end is server
			
	--motorFx = 0.8*self.realLastMotorFx + 0.2*motorFx;			
	
	--if Vehicle.debugRendering then
	--	self.realDebugSpdFx = self.realSoundSpdFx;
	--	self.realDebugMotorFx = self.realSoundMotorFx;
	--end;
	
	--if self.isClient and self.isEntered then -- no need for sound on standalone server
	-- EDIT 20130906 to allow variable 3D sound
	if self.isClient then
	
		if self.motorSoundEnabled or self.realEngineSound3dEnabled then
			if self.motorSound ~= nil then
			
				--different sound computing on fixed ratios gearboxes
				if self.realManualGearSet then
				
					local minVolumeFx = RealisticUtils.linearFx(self.realSoundSpdFx^0.25, 0.6, 0.8);			   
					local volume = RealisticUtils.linearFx(math.max(self.realSoundMotorFx^0.75, self.realSoundEngineRevFx) , minVolumeFx*self.motorSoundVolume, self.motorSoundVolume);
					local pitch = RealisticUtils.linearFx(self.realSoundEngineRevFx^0.5, self.motorSoundPitchOffset, self.motorSoundPitchMax);
					pitch = Utils.clamp(pitch, 0.5, 2); -- pitch must be between 0.5 and 2
				   
					if self.motorSoundEnabled then
						setSampleVolume(self.motorSound, volume*self.realEngineSoundVolumeFx);	
						setSamplePitch(self.motorSound, pitch);
					else -- realEngineSound3dEnabled
						--modify the 3D sound
						if self.motorSound3D ~= nil and self.motorSound3DVolume>0 then
							setSampleVolume(getAudioSourceSample(self.motorSound3D), volume*self.motorSoundVolume/self.motorSound3DVolume);	
							setSamplePitch(getAudioSourceSample(self.motorSound3D), pitch);
						end;
					end;
				
				else
		   
					local minVolumeFx = RealisticUtils.linearFx(self.realSoundSpdFx^0.25, 0.6, 0.8);			   
					local volume = RealisticUtils.linearFx(self.realSoundMotorFx^0.75, minVolumeFx*self.motorSoundVolume, self.motorSoundVolume);					
					local pitch = math.max(	self.motorSoundPitchMax * self.realSoundSpdFx^0.5,
											0.1 * self.motorSoundPitchMax * self.realSoundSpdFx + RealisticUtils.linearFx(self.realSoundMotorFx^0.5, self.motorSoundPitchOffset, self.motorSoundPitchMax));
											
					pitch = Utils.clamp(pitch, 0.5, 2); -- pitch must be between 0.5 and 2
				   
					if self.motorSoundEnabled then
						--print(self.time .. " - Motorized.update - " ..self.realVehicleName .. " - modify motor sound : " .. tostring(self.motorSound));
						setSampleVolume(self.motorSound, volume*self.realEngineSoundVolumeFx);	
						setSamplePitch(self.motorSound, pitch);
					else -- realEngineSound3dEnabled
						--modify the 3D sound
						--print(self.time .. " - Motorized.update - " ..self.realVehicleName .. " - modify 3D sound : " .. tostring(self.motorSound3D));
						if self.motorSound3D ~= nil and self.motorSound3DVolume>0 then
							--print(self.time .. " - Motorized.update - " ..self.realVehicleName .. " - modify 3D sound - new volume = " .. tostring(volume*self.motorSoundVolume/self.motorSound3DVolume) .. " / new pitch = " .. tostring(pitch));
							setSampleVolume(getAudioSourceSample(self.motorSound3D), volume*self.motorSoundVolume/self.motorSound3DVolume);	
							setSamplePitch(getAudioSourceSample(self.motorSound3D), pitch);
						end;
					end;
					
				end;
			   
			end;
		   
		   
			if self.motorSoundRun ~= nil then	

				if self.motorSoundEnabled then
		   
					--different sound computing on fixed ratios gearboxes
					if self.realManualGearSet then
					
						local minVolumeFx = RealisticUtils.linearFx(self.realSoundSpdFx^0.25, 0, 0.8);
						local volume = RealisticUtils.linearFx(math.max(self.realSoundMotorFx^0.75, self.realSoundEngineRevFx), minVolumeFx*self.motorSoundRunVolume, self.motorSoundRunVolume);
						local pitch = RealisticUtils.linearFx(self.realSoundEngineRevFx^0.5, self.motorSoundRunPitchOffset, self.motorSoundRunPitchMax)
						
						pitch = Utils.clamp(pitch, 0.5, 2); -- pitch must be between 0.5 and 2
									
						setSampleVolume(self.motorSoundRun, volume*self.realEngineSoundVolumeFx);	
						setSamplePitch(self.motorSoundRun, pitch);
						
					else
			   
						local minVolumeFx = RealisticUtils.linearFx(self.realSoundSpdFx^0.25, 0, 0.8);
						local volume = RealisticUtils.linearFx(self.realSoundMotorFx^0.75, minVolumeFx*self.motorSoundRunVolume, self.motorSoundRunVolume);
						local pitch = math.max(	self.motorSoundRunPitchMax * self.realSoundSpdFx^0.5,
												0.1 * self.motorSoundRunPitchMax * self.realSoundSpdFx + RealisticUtils.linearFx(self.realSoundMotorFx^0.5, self.motorSoundRunPitchOffset, self.motorSoundRunPitchMax));
											
						pitch = Utils.clamp(pitch, 0.5, 2); -- pitch must be between 0.5 and 2
									
						setSampleVolume(self.motorSoundRun, volume*self.realEngineSoundVolumeFx);	
						setSamplePitch(self.motorSoundRun, pitch);		

					end;
					
				end;
					
			end;
		end;
	
		if self.compressedAirSound ~= nil then
						
			if not self.compressedAirSoundEnabled and self.realBrakePedal==0 and self.realGroundSpeed > 7 then -- 7 m/s = 25 km/h
				-- if we drive fast enough, we need to run the compressor the next time we brake
				self.compressedAirSoundEnabled = true;
			end;

			if self.compressedAirSoundEnabled and self.realGroundSpeed > 5.5 and self.realBrakePedal>0.2 then -- 5.5 m/s = 20 km/h
				-- play the compressor sound if we drive fast enough and brake
				if self:getIsActiveForSound() then
					playSample(self.compressedAirSound, 1, self.compressedAirSoundVolume, 0);
					setSamplePitch(self.compressedAirSound, self.compressedAirSoundPitchOffset);
				end;
				self.compressedAirSoundEnabled = false;
			end;

		end; -- end => self.compressedAirSound ~= nil	
		
	end; -- end self.isClient
   
end;
   
   
   
   
local oldMotorizedStartMotor = Motorized.startMotor;   
Motorized.startMotor = function(self, noEventSend)

	if self.isRealistic then
		if self.fuelFillLevel == 0 then			
			return;
		end;
		self:realSetReverseGearActive(false);		
	end;

	oldMotorizedStartMotor(self, noEventSend);
	

end;




local oldMotorizedStopMotor = Motorized.stopMotor;
Motorized.stopMotor = function(self, noEventSend)
	
	if not self.isRealistic then
		return oldMotorizedStopMotor(self, noEventSend);
	end;
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetMotorTurnedOnEvent:new(self, false), nil, nil, self);
		else
			g_client:getServerConnection():sendEvent(SetMotorTurnedOnEvent:new(self, false));
		end;
	end;
	
	--print(self.time .. " stop motor for vehicule : " .. self.realVehicleName);
	
--************************************************************** DURAL ******************************************************
--** only do the shutdown sound and co if the motor is effectively started
	if self.isMotorStarted then

		self.isMotorStarted = false;
		self.realIsMotorStarted = false;

		Motorized.stopSounds(self);

		if self:getIsActiveForSound() and self.isClient then
			if self.motorStopSound ~= nil then				
				playSample(self.motorStopSound, 1, self.motorStopSoundVolume, 0);
			end;
		end;

		self.motor:setSpeedLevel(0, false);

		if self.isClient then
			Utils.setEmittingState(self.exhaustParticleSystems, false);
		end;
		
		if self.isServer then
			--RESET some variables
			self.realMotorLoad = 0;	
			self.realMotorLoadS = 0;	
			self.realRegulatorFxS = 0;
			self.realLastMotorFx = 0;
			
			for k, wheel in pairs(self.wheels) do									
				wheel.realSlipCoeff = 1;
				wheel.realAxleSpdAdd = 0;
				wheel.realLastSteeringAngle = 100; -- something wrong to force "realApplyWheelPhysics" in overrideWheelUtils
			end;
		end;
		
	end;
--***************************************************** END DURAL *********************************************************
	
end;




local oldMotorizedLoadFromAttributesAndNodes = Motorized.loadFromAttributesAndNodes;
Motorized.loadFromAttributesAndNodes = function(self, xmlFile, key, resetVehicles)
	
	if not self.isRealistic then
		return oldMotorizedLoadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	end;
	
	local fuelFillLevel = getXMLFloat(xmlFile, key.."#fuelFillLevel");
	if fuelFillLevel ~= nil then
--*************************************************** DURAL *****************************************************
--** No more minimum refilling level at startup
		self:setFuelFillLevel(fuelFillLevel);
--************************************************** END DURAL **************************************************
	end;
	return BaseMission.VEHICLE_LOAD_OK;
	
end;


--*************************************************** DURAL *****************************************************
--** no need to allow refilling if the tank is nearly full
local oldMotorizedRefuelActivatableGetIsActivatable = MotorizedRefuelActivatable.getIsActivatable;
MotorizedRefuelActivatable.getIsActivatable = function(self)
	
	if not self.motorized.isRealistic then
		return oldMotorizedRefuelActivatableGetIsActivatable(self);
	end;	
	
	--if self.motorized:getIsActiveForInput(false) and self.motorized.fuelFillLevel < self.motorized.fuelCapacity then
	if self.motorized:getIsActiveForInput(false) and (self.motorized.fuelCapacity-self.motorized.fuelFillLevel)>0.1 then
		-- find the first trigger which is activable
		for i=1, table.getn(self.motorized.fuelFillTriggers) do
			local trigger = self.motorized.fuelFillTriggers[i];
			if trigger:getIsActivatable(self.motorized) then
				self:updateActivateText();
				return true;
			end
		end
	end
	return false;
end;



   