



FillablePallet.setNodeId = function(self, nodeId)

	

	FillablePallet:superClass().setNodeId(self, nodeId);	
	
--***************************************************************************************************************************
--** DURAL : add moreRealistic detection and init

	self.isRealistic = Utils.getNoNil(getUserAttribute(self.nodeId, "isRealistic"), false);	

	if self.isRealistic and self.isServer then
		self.realEmptyMass = Utils.getNoNil(getUserAttribute(self.nodeId, "realEmptyMass"), 0.1);	
		self.realSleepPos = {x=0,y=0,z=0, maxDistBeforeAwake=0.05};
		self.update = FillablePallet.realUpdate;
		self.realSleepingMode1 = false;		
		--print(RealisticGlobalListener.realMissionTime .. " FillablePallet.setNodeId - realEmptyMass=" .. tostring(self.realEmptyMass));
	end;

--***************************************************************************************************************************
	
	self.capacity = Utils.getNoNil(tonumber(getUserAttribute(nodeId, "capacity")), self.capacity);
	self.fillablePalletValueScale = Utils.getNoNil(tonumber(getUserAttribute(nodeId, "fillablePalletValueScale")), 1);


	self.fillType = Fillable.FILLTYPE_WOOL;
	local fillTypeStr = getUserAttribute(nodeId, "fillType");
	if fillTypeStr ~= nil then
		local fillTypeInt = Fillable.fillTypeNameToInt[fillTypeStr];
		if fillTypeInt ~= nil then
			self.fillType = fillTypeInt;
		end
	end

	self.visibilityNodes = Utils.indexToObject(nodeId, getUserAttribute(nodeId, "visibilityNodesIndex"));
	self.visibilityNodesAdditive = Utils.getNoNil(getUserAttribute(nodeId, "visibilityNodesAdditive"), false);

	self.fillLevel = -1;
	self:setFillLevel(0, false);
	
end;




local oldFillableSetFillLevel = FillablePallet.setFillLevel;
FillablePallet.setFillLevel = function(self, fillLevel, setDirty)

	

	if self.isRealistic and self.isServer then	
		local found, density, pricePerKg = RealisticUtils.getFillTypeInfosV2(Fillable.fillTypeIntToName[self.fillType]);
		self.realCurrentMass = self.realEmptyMass + 0.001 * fillLevel * density;		
		--print(RealisticGlobalListener.realMissionTime .. " FillablePallet.setFillLevel - emptymass / fillLevel / realCurrentMass / fillType = " .. tostring(self.realEmptyMass) .. " / " .. tostring(fillLevel) .. " / " .. tostring(self.realCurrentMass) .. " / " .. tostring(Fillable.fillTypeIntToName[self.fillType]));		
		setMass(self.nodeId, self.realCurrentMass);
		setCenterOfMass(self.nodeId, 0, 0.6, 0);
	end;
	
	oldFillableSetFillLevel(self, fillLevel, setDirty);

end;




FillablePallet.realUpdate = function(self, dt)
	
	local velX, velY, velZ = getLinearVelocity(self.nodeId);
	
	--protection when the FillablePallet is "caught" (mounted)  by an autostacker or anything else
	if velX==nil then
		--print("FillablePallet.realUpdate : velX is nil");
		if not self.realSleepingMode1 then
			FillablePallet.realSetSleepMode(self);
		end;
		return;
	end;
	
	if self.realSleepingMode1 then

		--get the moved distance since sleep mode
		local x,y,z = getWorldTranslation(self.nodeId);
	
		if Utils.vector3Length(x-self.realSleepPos.x, z-self.realSleepPos.z, z-self.realSleepPos.z)>self.realSleepPos.maxDistBeforeAwake then
			--print(tostring(self.nodeId) .. " awakes");
			self.realSleepingMode1 = false;			
			FillablePallet.realSetMass(self, self.realCurrentMass);			
			FillablePallet.realApplyForce(self, dt);
		end;
		
	else		
		
		local velocity = Utils.vector3Length(velX, velY, velZ);
		
		if velocity<0.003 then
			FillablePallet.realSetSleepMode(self);
		else			
			FillablePallet.realApplyForce(self, dt);			
		end;
		
	end;

end;



FillablePallet.realApplyForce = function(self, dt)

	local suppDownForce = 0.75*self.realCurrentMass*RealisticGlobalListener.gravity*dt/1000;-- assume the vehicle below the pallet is a 4-wheels (telehandlers, tractor, baletrailer)	
	addForce(self.nodeId, 0, -suppDownForce, 0, 0, 0, 0, true);
	
end;


FillablePallet.realSetSleepMode = function(self)

	self.realSleepingMode1 = true;
	FillablePallet.realSetMass(self, 4*self.realCurrentMass);
	
	local x,y,z = getWorldTranslation(self.nodeId);
	self.realSleepPos.x = x;
	self.realSleepPos.y = y;
	self.realSleepPos.z = z;

end;

FillablePallet.realSetMass = function(self, newMass)
	setMass(self.nodeId, newMass);
end;
