local FillableOldLoad = Fillable.load;
Fillable.load = function(self, xmlFile)

--** init some variables before calling oldFilllableLoad since it calls "setFillLevel"
	if self.isRealistic then
		self.realCapacityFx = {};
		self.realCapacityFx[Fillable.FILLTYPE_UNKNOWN] = 1;
		self.realBaseCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0.0);
		self.realFillVolume = 0;
	end;

	FillableOldLoad(self, xmlFile);

	if self.isRealistic then
		
		local i = 0;
		while true do
		
			local key = string.format("vehicle.realCapacityMultipliers.realCapacityMultiplier(%d)", i);
			if not hasXMLProperty(xmlFile, key) then
				break;
			end;
			local fillTypeString = getXMLString(xmlFile, key.."#fillType");
			local multiplier = getXMLFloat(xmlFile, key.."#multiplier");
			
			local fillType = Fillable.fillTypeNameToInt[fillTypeString];
			if fillType~=nil then
				self.realCapacityFx[fillType] = multiplier;
			end;
			
			i = i + 1;
			
		end;
		
		self.realFillableFillMass = 0;		
		
	end;
	
end;





local oldFillableReadUpdateStream = Fillable.readUpdateStream;
Fillable.readUpdateStream = function(self, streamId, timestamp, connection)

	if not self.isRealistic then
		return oldFillableReadUpdateStream(self, streamId, timestamp, connection);
	end;

	if connection:getIsServer() then
		if self.synchronizeFillLevel then
			if streamReadBool(streamId) then
				local fillLevel;
				if self.synchronizeFullFillLevel then
					fillLevel = streamReadFloat32(streamId);
				else
					--less precise - but allow "overfilling" up to 10 times the capacity
					fillLevel = streamReadUInt16(streamId)/6553*self.capacity;
				end
				local fillType = streamReadUIntN(streamId, Fillable.sendNumBits);
				
				--allow overfilling up to 10 times the capacity
				self:setFillLevel(fillLevel, fillType, true, 10);
			end;
		end;
	end;
	
end;
   
local oldFillableWriteUpdateStream = Fillable.writeUpdateStream;   
Fillable.writeUpdateStream = function(self, streamId, connection, dirtyMask)

	if not self.isRealistic then
		return oldFillableWriteUpdateStream(self, streamId, connection, dirtyMask);
	end;

	if not connection:getIsServer() then
		if self.synchronizeFillLevel then
			if streamWriteBool(streamId, bitAND(dirtyMask, self.fillableDirtyFlag) ~= 0) then
				if self.synchronizeFullFillLevel then
					streamWriteFloat32(streamId, self.fillLevel);
				else
					local percent = 0;
					if self.capacity ~= 0 then
						--less precise - but allow "overfilling" up to 10 times the capacity
						percent = Utils.clamp(self.fillLevel / self.capacity, 0, 10);
					end;
					streamWriteUInt16(streamId, math.floor(percent*6553));
				end
				streamWriteUIntN(streamId, self.currentFillType, Fillable.sendNumBits);
			end;
		end
	end;
	
end;




local FillableOldUpdate = Fillable.update;
Fillable.update = function(self, dt)

	--print("Fillable:update");
	
	if not self.isRealistic then
		return FillableOldUpdate(self, dt);
	end;

	
end;



local oldFillableSetFillLevel = Fillable.setFillLevel;
Fillable.setFillLevel = function(self, fillLevel, fillType, force, overFillingRatio, compressionRatio)

	if not self.isRealistic then
		return oldFillableSetFillLevel(self, fillLevel, fillType, force);
	end;	
	
	--if self.isActive then
		--print(self.time .. " setFillLevel - current filllevel=" .. tostring(self.fillLevel) .. " / wanted filllevel=" .. tostring(fillLevel)  .. " / filltype=" .. tostring(fillType));
	--end;
	
		
	if (force == nil or force == false) and not self:allowFillType(fillType, false) then
		return;
	end;
	
	if fillLevel<0.000001 then
 		fillLevel = 0; -- avoid really tiny fillLevel (could be considered as "math.min" and so, comparison becomes "wrong")
	end;
	
	--********************************************************************** DURAL **********************************************************************	
	-- backing up current fill type
	local previousFillType = self.currentFillType;
   
	self.currentFillType = fillType;
	
	   
--********************************************************************** DURAL **********************************************************************
--** setting the capacity according to the fillType
		

	self.capacity = tonumber(self.realBaseCapacity * Utils.getNoNil(self.realCapacityFx[self.currentFillType], 1));
	
	--print(string.format("%u my name is : %s -> fillLevel:%s / fillVolume:%s / capacity:%s / compressionRatio:%s",self.time,self.realVehicleName,tostring(self.fillLevel),tostring(self.realFillVolume),tostring(self.capacity),tostring(compressionRatio)));
		
	local maxFillLevel = self.capacity;
	if overFillingRatio~=nil then
		maxFillLevel = self.capacity * overFillingRatio;
	end;
	
	
	--********************************************************************** DURAL **********************************************************************	
	-- backing up current fill level
	local previousFillLevel = self.fillLevel;
	
	
	--** taking into account compressionRatio (a compressionRatio==2 means you can put 2000L of material in a volume of 1M3)
	--** realFillVolume = compressed qty in liter
	--** fillLevel = occupied volume in liter	
	local fillDelta = fillLevel-previousFillLevel;	
	if fillDelta<=0 then -- emptying the fillable
		self.fillLevel = fillLevel;
		if self.fillLevel <= 0 then
			self.fillLevel = 0;
			self.realFillVolume = 0;
			self.currentFillType = Fillable.FILLTYPE_UNKNOWN;
			--** resetting the max capacity
			self.capacity = self.realBaseCapacity;		
		else
			--computing the realFillVolume to remove
			local fx1 = self.realFillVolume/previousFillLevel;
			local qtyToRemove = (previousFillLevel - self.fillLevel)*fx1;
			self.realFillVolume = self.realFillVolume - qtyToRemove;
		end;		
	else -- filling the fillable
		if compressionRatio~=nil and compressionRatio>0 then
			self.fillLevel = math.min(maxFillLevel, self.fillLevel+fillDelta/compressionRatio);
			self.realFillVolume = self.realFillVolume + (self.fillLevel-previousFillLevel)*compressionRatio;
		else			
			self.fillLevel = math.min(maxFillLevel, fillLevel);
			self.realFillVolume = self.realFillVolume + self.fillLevel-previousFillLevel;--if the realFillVolume is greater than the fillLevel because we use the compression previously, we keep the compressed volume
		end;
	end;
   --********************************************************************** END DURAL **********************************************************************
   
	--********************************************************************** DURAL **********************************************************************	
	-- only change visual fill level if needed (allow "plane shake" to be effective with mixer wagon
	if self.isClient and (previousFillLevel~=self.fillLevel or previousFillType~=self.currentFillType) then
	
		--if self.isActive then
			--print(self.time .. " setFillLevel - updating fillplane - current filllevel=" .. tostring(self.fillLevel) .. " / filltype=" .. tostring(self.currentFillType));
		--end;
	
		if self.currentFillPlane ~= nil then
			for _, node in ipairs(self.currentFillPlane.nodes) do
				setVisibility(node.node, false);
			end;
			self.currentFillPlane = nil;
		end;
		if self.fillPlanes ~= nil and self.defaultFillPlane ~= nil then
			local fillPlane;
			local t = 0;
			if fillType ~= Fillable.FILLTYPE_UNKNOWN then
				local fillTypeName = Fillable.fillTypeIntToName[fillType];
				fillPlane = self.fillPlanes[fillTypeName];
				t = self.fillLevel/self.capacity;
			end;
			if fillPlane == nil then
				fillPlane = self.defaultFillPlane;
			end;			
			for _, node in ipairs(fillPlane.nodes) do
				local x,y,z, rx,ry,rz, sx,sy,sz = node.animCurve:get(t);
				setTranslation(node.node, x, y, z);
				setRotation(node.node, rx, ry, rz);
				setScale(node.node, sx, sy, sz);
				setVisibility(node.node, self.fillLevel > 0 or node.alwaysVisible);
			end;
			self.currentFillPlane = fillPlane;
		end;
	end;
	   
	if self.isServer then
		Fillable.realComputeFillMass(self);
		if self.fillLevelToTippedFillLevel~=nil then
			if self.fillLevel==0 then
				self.fillLevelToTippedFillLevel = 1;
			else
				self.fillLevelToTippedFillLevel = self.realFillVolume / self.fillLevel;
			end;
		end;
	end;
	   	   
end;
   
   
   
   
Fillable.realComputeFillMass = function(self)

	local addMass = 0;			
	local fillTypeName = Fillable.fillTypeIntToName[self.currentFillType];
	
	
	
	
	if fillTypeName=="seeds" and self.seeds~=nil then
		local fruitDesc = FruitUtil.fruitIndexToDesc[self.seeds[self.currentSeed]];
		fillTypeName = "seeds_" .. fruitDesc.name;
	end;
	if self.isRealisticBaler then
		--fillTypeName = "straw_" .. fillTypeName;			
		addMass = self.realBalesMass;						
	end;	
	
	--print(self.time .. " Fillable.realComputeFillMass - fillTypeName = " .. fillTypeName .. " / addMass = " .. tostring(addMass));
	
	
	if self.realFillVolume>0 then
		local found, density, pricePerKg = RealisticUtils.getFillTypeInfosV2(fillTypeName);
		local fx = 0.001*density;
		--print(self.time .. " fillable : " .. self.realVehicleName .. " fillTypeName / fillLevel / fx / addMass : " .. fillTypeName .. " / " .. self.fillLevel .. " / " .. fx .. " / " .. addMass);
		self.realFillableFillMass = self.realFillVolume*fx + addMass;
	else
		self.realFillableFillMass = addMass;
	end;
	
end;



local oldFillableLoadFromAttributesAndNodes = Fillable.loadFromAttributesAndNodes;
Fillable.loadFromAttributesAndNodes = function(self, xmlFile, key, resetVehicles)
	if not self.isRealistic then
		return oldFillableLoadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	end;

	if self.synchronizeFillLevel then
		local fillLevel = getXMLFloat(xmlFile, key.."#fillLevel");
		local fillVolume = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fillVolume"), fillLevel);
		local fillType = getXMLString(xmlFile, key.."#fillType");
		if fillLevel ~= nil and fillType ~= nil then
			local fillTypeInt = Fillable.fillTypeNameToInt[fillType];
			if fillTypeInt ~= nil then
				--DURAL : edit 20131017 - we don't want to set the filllevel when the filltype is "unknwon" (example : old dlc pack bale loader)
				if fillTypeInt==Fillable.FILLTYPE_UNKNOWN then
					self.fillLevel = fillLevel;
				else			
					self:setFillLevel(fillLevel, fillTypeInt);
					--init fillVolume
					self.realFillVolume = fillVolume;
					if self.isServer then
						Fillable.realComputeFillMass(self);
						if self.fillLevelToTippedFillLevel~=nil then
							self.fillLevelToTippedFillLevel = self.realFillVolume / self.fillLevel;
						end;
					end;
				end;
			end;
		end;
	end
	return BaseMission.VEHICLE_LOAD_OK;
	
end;




local oldFillableGetSaveAttributesAndNodes = Fillable.getSaveAttributesAndNodes;
Fillable.getSaveAttributesAndNodes = function(self, nodeIdent)
	if not self.isRealistic then
		return oldFillableGetSaveAttributesAndNodes(self, nodeIdent);
	end;

	if self.synchronizeFillLevel then
		local fillType = Fillable.fillTypeIntToName[self.currentFillType];
		if fillType == nil then
			fillType = "unknown";
		end;
		local attributes = 'fillLevel="'..self.fillLevel..'" fillVolume="'..self.realFillVolume..'" fillType="'..fillType..'"';
		return attributes, nil;
	end;
	
	return nil;
end;