--DURAL
-- override default "getAllowShovelFillType" to allow unloading chaff with a shovel
BunkerSilo.getAllowShovelFillType = function(self, fillType)
	if self.state == BunkerSilo.STATE_FILL then
		return fillType == Fillable.FILLTYPE_CHAFF;
	elseif self.state == BunkerSilo.STATE_DRAIN then
		return fillType == Fillable.FILLTYPE_SILAGE;
	end;
	return false;
end;
   
--DURAL
-- override default "getAllowShovelFillType" to allow unloading chaff with a shovel
BunkerSilo.addShovelFillLevel = function(self, shovel, fillLevelDelta, fillType)
	
	if 	self.state == BunkerSilo.STATE_DRAIN and fillType == Fillable.FILLTYPE_SILAGE or
		--20131023 - check if the shovel "allows" the unloading into a bunker silo (mainly for buckrake)
		self.state == BunkerSilo.STATE_FILL and fillType == Fillable.FILLTYPE_CHAFF and shovel.realShovelEnableUnloadingInFillingStateBunkerSilo then
		
		local oldFillLevel = self.fillLevel;

		local x,y,z = 0,0,0;
		if shovel.shovelTipReferenceNode ~= nil then
			x,y,z = getWorldTranslation(shovel.shovelTipReferenceNode);
		end;
		self:setFillDeltaAt(x,y,z, fillLevelDelta, true);

		return self.fillLevel - oldFillLevel;		
	end;
   return 0;
end;
