local oldBaleLoadFromAttributesAndNodes = Bale.loadFromAttributesAndNodes;
Bale.loadFromAttributesAndNodes = function(self, xmlFile, key, resetVehicles)

	local result = oldBaleLoadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	if result then
		Bale.realInitialization(self);
	end;
	
	return result;

end;



local oldBaleLoad = Bale.load;
Bale.load = function(self, i3dFilename, x,y,z, rx,ry,rz, fillLevel)

	--print("bale loading : i3d filename => " .. i3dFilename);

	oldBaleLoad(self, i3dFilename, x,y,z, rx,ry,rz, fillLevel);
	
	Bale.realInitialization(self);
	
end;



local oldBaleGetValue = Bale.getValue;
function Bale:getValue()

	if not self.isRealistic then
		return oldBaleGetValue(self);
	end;

	local pricePerLiter = 0;
	local desc = Fillable.fillTypeIndexToDesc[self.fillType];
	
	if desc ~= nil then
		pricePerLiter = desc.pricePerLiter;
	end;
		
	--FIX 2013/09/09 -> "BarnMoverTrigger" already applies the "difficulty multiplier"
	--print("selling bale - fillLevel="..tostring(self.fillLevel).." /pricePerLiter="..tostring(pricePerLiter).."/baleValueScale="..tostring(self.baleValueScale).." /balePriceBalancing="..tostring(RealisticGlobalListener.balePriceBalancing).." / realDifficultyFX6="..tostring(RealisticGlobalListener.realDifficultyFX6));
		
	--return self.fillLevel * pricePerLiter * self.baleValueScale * RealisticGlobalListener.balePriceBalancing * RealisticGlobalListener.realDifficultyFX6; -- difficulty FX = 1 2 4 (hard normal easy)
	return self.fillLevel * pricePerLiter * self.baleValueScale * RealisticGlobalListener.balePriceBalancing;
	
end;





Bale.realInitialization = function(self)

	--print("Bale.realInitialization : " .. RealisticGlobalListener.realMissionTime);

	self.isRealistic = Utils.getNoNil(getUserAttribute(self.nodeId, "isRealistic"), false);	
	if self.isRealistic then
		
		local found, density, pricePerKg = RealisticUtils.getFillTypeInfosV2(Fillable.fillTypeIntToName[self.fillType]);
		if not found then
			density = 0.04; -- default density = wheat straw
		end;
		self.realCurrentMass = 0.001 * self.fillLevel * density;
				
		--print("Bale.realInitialization  bale mass = " .. tostring(self.realCurrentMass) .. " /filllevel="..tostring(self.fillLevel) .. " /density="..tostring(density) .. " /filltype="..tostring(Fillable.fillTypeIntToName[self.fillType]));
		
		--override the default "baleValueScale" to be a float
		self.baleValueScale = Utils.getNoNil(getUserAttribute(self.nodeId, "baleValueScale"), 1.0);	
				
		if self.isServer then
				
			self.realSleepingMode1 = false;
			self.realSleepPos = {x=0,y=0,z=0, maxDistBeforeAwake=0.05};
			
			self.update = Bale.realUpdate;
			
		end;
		
		Bale.realSetMass(self, self.realCurrentMass);
		
			
	end;

end;


Bale.realUpdate = function(self, dt)
	
	local velX, velY, velZ = getLinearVelocity(self.nodeId);
	
	--protection when the bale is "caught" (mounted)  by an autostacker or anything else
	if velX==nil then
		--print("Bale.realUpdate : velX is nil");
		if not self.realSleepingMode1 then
			Bale.realSetSleepMode(self);
		end;
		return;
	end;
	
	
	
	
	if self.realSleepingMode1 then

		--get the moved distance since sleep mode
		local x,y,z = getWorldTranslation(self.nodeId);
	
		if Utils.vector3Length(x-self.realSleepPos.x, z-self.realSleepPos.z, z-self.realSleepPos.z)>self.realSleepPos.maxDistBeforeAwake then
			--print(tostring(self.nodeId) .. " awakes");
			self.realSleepingMode1 = false;			
			Bale.realSetMass(self, self.realCurrentMass);			
			Bale.realApplyForce(self, dt);
		end;
		
	else		
		
		local velocity = Utils.vector3Length(velX, velY, velZ);
		
		if velocity<0.03 then
			Bale.realSetSleepMode(self);
		else			
			Bale.realApplyForce(self, dt);			
		end;
		
	end;

end;



Bale.realApplyForce = function(self, dt)
	
	local suppDownForce = self.realCurrentMass*RealisticGlobalListener.gravity*dt/1000;	
	addForce(self.nodeId, 0, -suppDownForce, 0, 0, 0, 0, true);	
	
end;


Bale.realSetSleepMode = function(self)

	self.realSleepingMode1 = true;
	Bale.realSetMass(self, 4*self.realCurrentMass);
	
	local x,y,z = getWorldTranslation(self.nodeId);
	self.realSleepPos.x = x;
	self.realSleepPos.y = y;
	self.realSleepPos.z = z;

end;


Bale.realSetMass = function(self, newMass)

	setMass(self.nodeId, newMass);

end;




