


local oldAttachableLoad = Attachable.load;
Attachable.load = function(self, xmlFile)
	
	oldAttachableLoad(self, xmlFile);
	
	if self.isRealistic then
	
		self.realUpdateSteeringAxle = Attachable.realUpdateSteeringAxle;

		if self.attacherJoint ~= nil then
	
			--override default values
			self.attacherJoint.upperDistanceToGround = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.attacherJoint#upperDistanceToGround"), 100); -- set a high value to fully lift 3 point hitch by default

		
		
			-- load the wanted transLimit and rotLimit when attached to a tractor
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#realWantedLoweredTransLimit"));		
			self.attacherJoint.realWantedLoweredTransLimit = { math.abs(Utils.getNoNil(x, 0)), math.abs(Utils.getNoNil(y, 0)), math.abs(Utils.getNoNil(z, 0)) };		
			
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#realWantedRaisedTransLimit"));
			self.attacherJoint.realWantedRaisedTransLimit = { math.abs(Utils.getNoNil(x, 0)), math.abs(Utils.getNoNil(y, 0)), math.abs(Utils.getNoNil(z, 0)) };
			
			local rotX, rotY, rotZ = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#realWantedLoweredRotLimit"));
			self.attacherJoint.realWantedLoweredRotLimit = { math.rad(math.abs(Utils.getNoNil(rotX, 0))), math.rad(math.abs(Utils.getNoNil(rotY, 0))), math.rad(math.abs(Utils.getNoNil(rotZ, 0))) };
		
			local rotX, rotY, rotZ = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#realWantedRaisedRotLimit"));
			self.attacherJoint.realWantedRaisedRotLimit = { math.rad(math.abs(Utils.getNoNil(rotX, 0))), math.rad(math.abs(Utils.getNoNil(rotY, 0))), math.rad(math.abs(Utils.getNoNil(rotZ, 0))) };
		
			-- load the wanted minRot2 and maxRot2
			self.attacherJoint.realWantedLoweredRot2 = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.attacherJoint#realWantedLoweredRot2"), 0));
			
			self.attacherJoint.realWantedRaisedRotInc = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.attacherJoint#realWantedRaisedRotInc"), -0.75)); -- angle in  to add to the rot2 for each  lift (starting from the maxRot and maxRot2)
		
			self.attacherJoint.realWantedRaisedRot2 = getXMLFloat(xmlFile, "vehicle.attacherJoint#realWantedRaisedRot2"); -- override "realWantedMinRotInc" if defined
			if self.attacherJoint.realWantedRaisedRot2 ~= nil then
				self.attacherJoint.realWantedRaisedRot2 = math.rad(self.attacherJoint.realWantedRaisedRot2);
			end;
			
			
			
			
		
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#realForceTransLimit"));
			if x~=nil and y~=nil and z~= nil then
				self.attacherJoint.realForceTransLimit = { x, 0.5*y, z }; -- 0.5*y because we only autorise joint translimit in one direction
				
				if y~=0 then
					local posX, posY, posZ = getTranslation(self.attacherJoint.node);
					setTranslation(self.attacherJoint.node, posX, posY-0.5*y, posZ);
				end;
				
			end;
		
		end; -- end attacherJoint not nil
		
		
	
		--self.onBrake = SpecializationUtil.callSpecializationsFunction("onBrake");
		self.realBrakePedalPosition = 1;
			
		--[[
		self.attacherJoint.realAttacherHeight = getXMLFloat(xmlFile, "vehicle.attacherJoint#realAttacherHeight");
		if self.attacherJoint.realAttacherHeight==nil then
			-- get the translate Y of the attcher node
			local x1,y1,z1 = getTranslation(self.attacherJoint.node);
			self.attacherJoint.realAttacherHeight = y1;
		end;--]]
		
		--do we want a max height when the implement is lifted ?
		--self.attacherJoint.realAttacherHeightLifted = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.attacherJoint#realAttacherHeightLifted"), -99);
		
		--self.attacherJoint.realMinRot2Fx = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.attacherJoint#realMinRot2Fx"), 1 );
		--self.attacherJoint.realMinRot2Add = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.attacherJoint#realMinRot2Add"), 0));
		
		self.realAttachableIsReady = false;				
				
	end;
	
end;



local oldAttachableUpdate = Attachable.update;
Attachable.update = function(self, dt)
	
	--print("attachable:update");
	
	
	
	if not self.isRealistic then
		return oldAttachableUpdate(self, dt);
	end;
	
	
	
	if self.isClient and self.isActive then
		if self.updateSteeringAxleAngle then
			self:realUpdateSteeringAxle();			
		end;
	end;

	if self.firstTimeRun and self.updateWheels and self.isServer and not self.realAttachableStill then
	
		for k, wheel in pairs(self.wheels) do	

			--print(self.time .. "Attachable.update : braking - " .. self.realBrakePedalPosition);
		
			--WheelsUtil.updateWheelPhysics(self, wheel, false, 0, self.realBrakePedalPosition, self.requiredDriveMode, dt, 0, 0);
			WheelsUtil.realUpdateAttachableWheelPhysics(self, wheel, false, self.realBrakePedalPosition, dt);
			
			
			--WheelsUtil.updateWheelPhysics2(self, wheel, false, 0, 0, self.requiredDriveMode, dt, 0, 0);
			--setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 0, wheel.steeringAngle);
		end;
		
	end;
	
	if self.realIsActive then
		self.realAttachableStill = false;
	else
		if self.realBrakePedalPosition==1 then
			self.realAttachableStill = true;
		end;
	end;

end;


Attachable.updateTick = function(self, dt)

	self.realAttachableIsReady = self.attacherVehicle~=nil and self.time > (self.attachTime+2000);

end;



	
local oldAttachableOnBrake = Attachable.onBrake;
Attachable.onBrake = function(self, forced, brakeForceCoeff)

	--print("attachable:onBrake");

	if not self.isRealistic then
		return oldAttachableOnBrake(self, forced);		
	end;

	-- do not brake for the first 2 seconds after attaching, to allow balancing of the difference between the attacher joints
	if self.realAttachableIsReady or forced then	
		
		self.isBraking = true;		
		self.realBrakePedalPosition = Utils.getNoNil(brakeForceCoeff, 1);
		self.realIsBraking = self.realBrakePedalPosition>0;		
		
		for k,implement in pairs(self.attachedImplements) do
			implement.object:onBrake(forced, brakeForceCoeff);
		end;
		
	end;
	
end;


local oldAttachableOnReleaseBrake = Attachable.onReleaseBrake;
Attachable.onReleaseBrake = function(self)

	--print("attachable:onReleaseBrake");

	if not self.isRealistic then
		return oldAttachableOnReleaseBrake(self);		
	end;

	self.isBraking = false;	
	self.realBrakePedalPosition = 0;
	self.realIsBraking = false;
	
	
	for k,implement in pairs(self.attachedImplements) do
		implement.object:onReleaseBrake();
	end;
	
end;

--*********************************** DURAL **************************************
--** modification to avoid implement lowering/raising when tractor vehicle motor is stopped
local oldAttachableOnSetLowered = Attachable.onSetLowered;
Attachable.onSetLowered = function(self, lowered)
	
	if not self.isRealistic then
		return oldAttachableOnSetLowered(self, lowered);		
	end;

	if self.attacherVehicle~=nil then
		if Utils.getNoNil(self.attacherVehicle.isMotorStarted, true) and self.lowerAnimation ~= nil and self.playAnimation ~= nil then
			if lowered then
				self:playAnimation(self.lowerAnimation, self.lowerAnimationSpeed, nil, true);
			else
				self:playAnimation(self.lowerAnimation, -self.lowerAnimationSpeed, nil, true);
			end;
		end;
	end;
end;

local oldAttachableOnDetach = Attachable.onDetach;
Attachable.onDetach = function(self, attacherVehicle, jointDescIndex)

	if self.isRealistic then
		self.realAttachableIsReady = false;
		--DURAL - 20131005 - handle detaching "self detaching" joint attacher (useful for "cutter trailers" with a "cutter joint attacher" to attach the header/cutter for example)
		--   when the player detach the trailer from the tractor/combine, the cutter is automatically detached from the trailer too.
		--[[for _,implement in ipairs(self.attachedImplements) do
			if implement.object ~= nil then
				--check if the joint attacher is a self detaching one
				if implement.object.allowsDetaching then
					local implementIndex = self:getImplementIndexByObject(implement.object);
					if implementIndex ~= nil then
						local jointDesc = self.attacherJoints[implement.jointDescIndex];
						if jointDesc.realAutoDetaching then
							self:detachImplement(implementIndex);
						end;
					end;
				end;
			end;
		end;	--]]
		
		--20131007- new method		
		for index,jointDesc in pairs(self.attacherJoints) do	
			if jointDesc.realAutoDetaching then	
				local implementIndex = self:getImplementIndexByJointDescIndex(index);
				if implementIndex~= nil then
					self:detachImplement(implementIndex);
				end;
			end;		
		end;	
		
	end;
	
	return oldAttachableOnDetach(self, attacherVehicle, jointDescIndex);

end;


--return true if there was an implement to auto detach
Attachable.realDoAutoDetachImplement = function(self)

	for _,implement in ipairs(self.attachedImplements) do
		if implement.object ~= nil then
			--check if the joint attacher is a self detaching one
			if implement.object.allowsDetaching then
				local implementIndex = self:getImplementIndexByObject(implement.object);
				if implementIndex ~= nil then
					local jointDesc = self.attacherJoints[implement.jointDescIndex];
					if jointDesc.realAutoDetaching then
						self:detachImplement(implementIndex);
						return true;
					end;
				end;
			end;
		end;
	end;

	return false;

end;





local oldAttachableOnDeactivate = Attachable.onDeactivate;
Attachable.onDeactivate = function(self)

	if not self.isRealistic then
		return oldAttachableOnDeactivate(self);		
	end;

	self:onBrake(true);
--************************************* DURAL ***************************************
--we want to keep the last steering axle when detaching the implement.
	--self.steeringAxleAngle = 0;	
--************************************************************************************
	self:setLightsTypesMask(0, true);
	self:setBeaconLightsVisibility(false, true);

end;




Attachable.realUpdateSteeringAxle = function(self)
	if self.attacherVehicle ~= nil and self.lastSpeedReal>0.0001 then
		if self.movingDirection < 0 and not self.steeringAxleUpdateBackwards then
			self.steeringAxleAngle = 0;
		else
			local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
			local dot = z; -- 0*x + z*1;
			dot = dot / Utils.vector2Length(x,z);
			local angle = math.acos(dot);
			if x < 0 then
				angle = -angle;
			end;
			local startSpeed = self.steeringAxleAngleScaleStart;
			local endSpeed = self.steeringAxleAngleScaleEnd;
			local scale = Utils.clamp(1 - (self.lastSpeedReal*3600-startSpeed)/(endSpeed-startSpeed), 0, 1);
			self.steeringAxleAngle = angle*scale;				
		end;
		--let the steering axle in the last state when detaching the trailer
	--else
		--	self.steeringAxleAngle = 0;
	end;
end;
