function AnimatedVehicle:loadEX1(xmlFile)

	if not self.isRealistic then
		return;
	end;

	--loading the hydraulic sound to play while a animation is playing
	local animatedHydraulicSound = getXMLString(xmlFile, "vehicle.animatedHydraulicSound#file");
	if animatedHydraulicSound ~= nil and animatedHydraulicSound ~= "" then
		animatedHydraulicSound = Utils.getFilename(animatedHydraulicSound, self.baseDirectory);
		self.animatedHydraulicSound = createSample("animatedHydraulicSound");
		self.animatedHydraulicSoundEnabled = false;
		loadSample(self.animatedHydraulicSound, animatedHydraulicSound, false);
		self.animatedHydraulicSoundPitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedHydraulicSound#pitchOffset"), 1);
		self.animatedHydraulicSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedHydraulicSound#volume"), 1);
		setSamplePitch(self.animatedHydraulicSound, self.animatedHydraulicSoundPitch);
	else
		self.animatedHydraulicSoundPitch = 1;
		self.animatedHydraulicSoundVolume = 1;
	end;	
	
	--setting the default "true" value to the playsound parameter
	for _,anim in pairs(self.animations) do
		anim.playSound = true;
	end;
	
	--loading the "playSound" parameter for each anim
	local i=0;
	while true do
		local key = string.format("vehicle.animations.animation(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		
		local name = getXMLString(xmlFile, key.."#name");
		if name ~= nil then
			--get the loaded anim by name and set its "playsound" parameter
			local anim = self.animations[name];
			if anim~=nil then
				local playSound = Utils.getNoNil(getXMLBool(xmlFile, key.."#playSound"), true);
				anim.playSound = playSound;
			end;
		end;
		i = i + 1;
	end;
	
end;
AnimatedVehicle.load = Utils.appendedFunction(AnimatedVehicle.load, AnimatedVehicle.loadEX1);



function AnimatedVehicle:deleteEX1()

	if not self.isRealistic then
		return;
	end;

	--deleting the hydraulic sound
	if self.animatedHydraulicSound ~= nil then
		delete(self.animatedHydraulicSound);
		self.animatedHydraulicSound = nil;
	end;
	
end;
AnimatedVehicle.delete = Utils.appendedFunction(AnimatedVehicle.delete, AnimatedVehicle.deleteEX1);



function AnimatedVehicle:updateTickEX1()

	if not self.isRealistic then
		return;
	end;

	if self.isClient and self.animatedHydraulicSound~=nil then
	
		if self.isActive and self:getIsActiveForSound() then -- 20121221 - add the "getIsActiveForSound" to stop the sound if the vehicle is active but not controlled by the player
	
			local playHydraulicSound = false;	
			for _, anim in pairs(self.activeAnimations) do
				--at least one animation playing
				if anim.playSound then
					playHydraulicSound = true;
					break;
				end;
			end;
			if playHydraulicSound then
				if not self.animatedHydraulicSoundEnabled and self:getIsActiveForSound() then			
					playSample(self.animatedHydraulicSound, 0, self.animatedHydraulicSoundVolume, 0);
					self.animatedHydraulicSoundEnabled = true;
				end;
			else
				if self.animatedHydraulicSoundEnabled then
					stopSample(self.animatedHydraulicSound);
					self.animatedHydraulicSoundEnabled = false;
				end;
			end;
			
		else -- not active
			if self.animatedHydraulicSoundEnabled then
				stopSample(self.animatedHydraulicSound);
				self.animatedHydraulicSoundEnabled = false;
			end;
		end;
			
	end;	
	
end;
AnimatedVehicle.updateTick = Utils.appendedFunction(AnimatedVehicle.updateTick, AnimatedVehicle.updateTickEX1);