



local oldAIVehicleUtilDriveInDirection = AIVehicleUtil.driveInDirection;
AIVehicleUtil.mrDriveInDirection = function(self, dt, acceleration, allowedToDrive, moveForwards, lx, lz, speedLevel, useReduceSpeed, noDefaultHiredWorker)

		
	--********************************  DURAL  *************************************************************	
	--*** optimized speedlevel *****	
	
	if noDefaultHiredWorker==nil or noDefaultHiredWorker==false then
	
		if self.turnStage==0 then -- when the AI is working, we set the speedlevel adequately to the implements
			if useReduceSpeed then
				speedLevel = 3; -- updated in OverrideAITractor.lua (updateToolsInfo)
			else
				speedLevel = 1; -- updated in OverrideAITractor.lua (updateToolsInfo)		
			end;
		else
			speedLevel = 2; -- set in RealisticMotorized.lua (load function) => ai maneuver speed		
		end;
		
	end; -- end not noDefaultHiredWorker
		
		
	local angle = 0;
	if lx ~= nil and lz ~= nil then
	
	
		--print(string.format("%g AIVehicleUtil - turnstage = %u lx = %1.3f lz = %1.3f", self.time,self.turnStage,lx,lz));
	
		-- cur dir = 0 0 1
		-- desired dir = lx, ly, lz
		
		if not moveForwards then
			lz = -lz;
		end;
		
		angle = math.deg(math.acos(lz));
		if angle < 0 then
			angle = 90;
		end;
		--do not take into account angleLimit anymore
		--angle = math.min(angle, steeringAngleLimit);

		local turnLeft = lx > 0.00001;
		
		-- not useful naymore since we are targeting a point in the back of the vehicle now (see aicombine and aitractor)
		--if not moveForwards then
		--	turnLeft = not turnLeft;
		--end;
		
		local targetRotTime = 0;
		
		local steeringSpeed = self.aiSteeringSpeed;

		if turnLeft then
			--rotate to the left
			targetRotTime = self.maxRotTime
			if self.realVehicleSteeringAngle>0 then
				targetRotTime = targetRotTime*math.min(angle/self.realVehicleSteeringAngle, 1);
			end;
			--if self.maxRotTime~=0 then
			--	steeringSpeed = steeringSpeed * math.max(0.25, math.abs(self.rotatedTime/self.maxRotTime));
			--end;
		else
			--rotate to the right
			targetRotTime = self.minRotTime;
			if self.realVehicleSteeringAngle>0 then
				targetRotTime = targetRotTime*math.min(angle/self.realVehicleSteeringAngle, 1);
			end;
			--if self.maxRotTime~=0 then
			--	steeringSpeed = steeringSpeed * math.max(0.25, math.abs(self.rotatedTime/self.minRotTime));
			--end;
		end;
		
		--print(self.time .. " AIVehicleUtil.driveInDirection - target angle = " .. tostring(angle) .. " / targetRotTime=" .. tostring(targetRotTime) .. " /  realVehicleSteeringAngle=" .. tostring(self.realVehicleSteeringAngle));
		
--******************** DURAL **********************************************************
		local steeringSpeed = self.aiSteeringSpeed;

		if noDefaultHiredWorker==nil or noDefaultHiredWorker==false then 
			if self.turnStage==0 then -- working in line
				steeringSpeed = 0.25 * steeringSpeed;
			else
				--turning stages / maneuvering
				steeringSpeed = steeringSpeed * Utils.clamp((3.6*self.realGroundSpeed/self.realAiManeuverSpeed)^0.5, 0.4, 1);
			end;
		else
			steeringSpeed = 1.5 * steeringSpeed; -- faster steering speed for Courseplay or FollowMe AI drivers
		end;
		
		--print(self.time .. " AIVehicleUtil.driveInDirection - steeringSpeed = " .. tostring(1000*steeringSpeed) .. " / lx=" .. tostring(lx) .. " / lz=" .. tostring(lz));

		if targetRotTime > self.rotatedTime then
			self.rotatedTime = math.min(self.rotatedTime + dt*steeringSpeed, targetRotTime);
		else
			self.rotatedTime = math.max(self.rotatedTime - dt*steeringSpeed, targetRotTime);
		end;
--************************************************************************************
	end

	
	
	
	
	--********************************  END DURAL  *************************************************************

	if self.firstTimeRun then
		local acc = acceleration;	
		local disableChangingDirection = false;
		if speedLevel ~= nil and speedLevel ~= 0 then			
			self.motor:setSpeedLevel(speedLevel, true);
		end;		
		if not moveForwards then
			acc = -acc;
		end;
		if not allowedToDrive then
			acc = 0;
--********************************  DURAL  *************************************************************
-- "computing" braking acc
			if self.realGroundSpeed>0.5 then
				acc = -math.min(1, self.realGroundSpeed/3)*Utils.sign(self.movingDirection); --braking function of speed
				--print(self.time .. " AIVehicleUtil.driveInDirection self.movingDirection = " .. tostring(self.movingDirection));
				disableChangingDirection = true; -- we want the AI to brake, not reversing
			end;
--********************************  END DURAL  *************************************************************
		end;
		
		--print(self.time .. " AIVehicleUtil.mrDriveInDirection - acceleration / acc before = " .. tostring(acceleration) .. " / " .. tostring(acc));
		
		if self.maxAccelerationSpeed ~= nil then
			acc = Steerable.calculateRealAcceleration(self, acc, dt);
		end;
		
		--print(self.time .. " AIVehicleUtil.mrDriveInDirection - acc after = " .. tostring(acc));
		
--********************************  DURAL  *************************************************************	
--** we do NOT want AI to use handbrake with tractors or combines...
		--WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acc, not allowedToDrive, self.requiredDriveMode);
		WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acc, false, self.requiredDriveMode, disableChangingDirection);
--********************************  END DURAL  *************************************************************
	end;
	
end;






















--*******************************  DEPRECATED *****************************************************************




local oldAIVehicleUtilDriveInDirection = AIVehicleUtil.driveInDirection;
AIVehicleUtil.driveInDirection2 = function(self, dt, steeringAngleLimit, acceleration, slowAcceleration, slowAngleLimit, allowedToDrive, moveForwards, lx, lz, speedLevel, slowMaxRpmFactor)

	if not self.isRealistic then
		return oldAIVehicleUtilDriveInDirection(self, dt, steeringAngleLimit, acceleration, slowAcceleration, slowAngleLimit, allowedToDrive, moveForwards, lx, lz, speedLevel, slowMaxRpmFactor);
	end;
	
	local angle = 0;
	if lx ~= nil and lz ~= nil then
	
	
			
--********************************  DURAL  *************************************************************
-- increase turn radius when working with "no-backward" tools
	--print(self.time .. " turnstage = " .. tostring(self.turnStage));

		if self.isAITractorActivated and self.aiTurnNoBackward then
		
		
			print(self.time .. " turnstage = " .. tostring(self.turnStage));
		
			if self.turnStage==2 and self.realAiWorkingDistance~=nil then
		
				self.turnEndDistance = 0.5;
			
				--compute the lateral distance between the current position of the tractor and the target position
				local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);				
				local distance = Utils.vector2Length(x-self.aiTractorTargetX, z-self.aiTractorTargetZ);
				
				--get the working width
				
				
				--local distance2 = -self.aiTractorDirectionX*distance + -self.aiTractorDirectionZ*distance;
				
			
				
				--local minDistance = 2*self.realAiWorkingDistance;-- + self.turnEndBackDistance + self.aiToolExtraTargetMoveBack;
				local minDistance = math.sqrt((self.turnEndBackDistance + self.aiToolExtraTargetMoveBack)^2 + self.aiTractorTurnRadius^2);
				
					--print(self.time .. " x / targetX / TargetBeforeTurnX = " .. tostring(x) .. " / " .. tostring(self.aiTractorTargetX) .. " / " .. tostring(self.aiTractorTargetBeforeTurnX));
					--print(self.time .. " z / targetZ / TargetBeforeTurnZ = " .. tostring(z) .. " / " .. tostring(self.aiTractorTargetZ) .. " / " .. tostring(self.aiTractorTargetBeforeTurnZ));
					--print(self.time .. " dist / minDist = " .. tostring(distance) .. " / " .. tostring(minDistance));
				
				if distance<minDistance then
					--turn the wheel to the opposite side to get a better turn radius after
					
					--local newTargetX = self.aiTractorTargetX + self.aiTractorDirectionX*2 + self.aiTractorDirectionZ * 100;
					--local newTargetZ = self.aiTractorTargetZ + self.aiTractorDirectionZ*2 - self.aiTractorDirectionX * 100;
					
					lx, lz = AIVehicleUtil.getDriveDirection(self.aiTractorDirectionNode, 2*x-self.aiTractorTargetX, y, 2*z-self.aiTractorTargetZ);
					--lx, lz = AIVehicleUtil.getDriveDirection(self.aiTractorDirectionNode, 2*self.aiTractorTargetBeforeTurnX-self.aiTractorTargetX, y, 2*self.aiTractorTargetBeforeTurnZ-self.aiTractorTargetZ);
					--lx, lz = AIVehicleUtil.getDriveDirection(self.aiTractorDirectionNode, newTargetX, y, newTargetZ);
					
					--set collision trigger shape accordingly					
					local maxlx = 0.7071067; --math.sin(maxAngle);
					local colDirX = lx;
					local colDirZ = lz;

					if colDirX > maxlx then
						colDirX = maxlx;
						colDirZ = 0.7071067; --math.cos(maxAngle);
					elseif colDirX < -maxlx then
						colDirX = -maxlx;
						colDirZ = 0.7071067; --math.cos(maxAngle);
					end;

					for triggerId,_ in pairs(self.numCollidingVehicles) do
						AIVehicleUtil.setCollisionDirection(self.aiTractorDirectionNode, triggerId, colDirX, colDirZ);
					end;				
					
				end;
				
			--elseif self.turnStage==4 then
				--local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);	
				--2 meters before field
				--local additionalDistance = self.turnEndBackDistance + self.aiToolExtraTargetMoveBack;
				--lx, lz = AIVehicleUtil.getDriveDirection(self.aiTractorDirectionNode, self.aiTractorTargetX + self.aiTractorDirectionX*additionalDistance, y, self.aiTractorTargetZ + self.aiTractorDirectionZ*additionalDistance);			
			end;
			
			
			
		end;
--********************************  END DURAL  *************************************************************
	
	
	
		-- cur dir = 0 0 1
		-- desired dir = lx, ly, lz
		local dot = lz; -- = lx*0 + lz*1
		angle = math.deg(math.acos(dot));
		if angle < 0 then
			angle = angle+180;
		end;

		local turnLeft = lx > 0.00001;
		if not moveForwards then
			turnLeft = not turnLeft;
		end;
		
		local targetRotTime = 0;

		if turnLeft then
			--rotate to the left
			targetRotTime = self.maxRotTime*math.min(angle/steeringAngleLimit, 1);
		else
			--rotate to the right
			targetRotTime = self.minRotTime*math.min(angle/steeringAngleLimit, 1);
		end;

		if targetRotTime > self.rotatedTime then
			self.rotatedTime = math.min(self.rotatedTime + dt*self.aiSteeringSpeed, targetRotTime);
		else
			self.rotatedTime = math.max(self.rotatedTime - dt*self.aiSteeringSpeed, targetRotTime);
		end
	end


	
	--********************************  DURAL  *************************************************************	
	--*** optimized speedlevel *****	
	if self.turnStage==0 then -- when the AI is working, we set the speedlevel adequately to the implements
		speedLevel = self.realAiWorkingSpeedLevel; -- updated in OverrideAITractor.lua / OverrideAICombine.lua
		acceleration = 1;
	else
		speedLevel = self.realAiManeuverSpeedLevel; -- set in RealisticMotorized.lua
		acceleration = 1;
	end;
	
	--********************************  END DURAL  *************************************************************

	if self.firstTimeRun then
		local acc = acceleration;
		if speedLevel ~= nil and speedLevel ~= 0 then
			--acc = self.motor.accelerations[speedLevel];
			self.motor:setSpeedLevel(speedLevel, true);
			--[[if math.abs(angle) >= slowAngleLimit then
				self.motor.maxRpmOverride = self.motor.maxRpm[speedLevel]*slowMaxRpmFactor;
			else
				self.motor.maxRpmOverride = nil;
			end;]]
			--[[if math.abs(angle) >= slowAngleLimit then
				acc = slowAcceleration;
			end;
		else
			if math.abs(angle) >= slowAngleLimit then
				acc = slowAcceleration;
			end;]]
		end;		
		if not moveForwards then
			acc = -acc;
		end;
		if not allowedToDrive then
			acc = 0;
--********************************  DURAL  *************************************************************
-- "computing" braking acc
			if self.realGroundSpeed>0.5 then
				acc = -math.min(1, self.realGroundSpeed/3)*Utils.sign(self.movingDirection); --braking function of speed
				--print(self.time .. " AIVehicleUtil.driveInDirection self.movingDirection = " .. tostring(self.movingDirection));
			end;
--********************************  END DURAL  *************************************************************
		end;
		if self.maxAccelerationSpeed ~= nil then
			acc = Steerable.calculateRealAcceleration(self, acc, dt);
		end;
--********************************  DURAL  *************************************************************	
--** we do NOT want AI to use handbrake with tractors or combines...
		--WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acc, not allowedToDrive, self.requiredDriveMode);
		WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acc, false, self.requiredDriveMode);
--********************************  END DURAL  *************************************************************
	end;
	
end;
