

local oldAITractorLoad = AITractor.load;
AITractor.load = function(self, xmlFile)

	
	oldAITractorLoad(self, xmlFile);

	if self.isRealistic then
	
		self.realTurnStage3MinDistanceBeforeTurnStage4 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTurnStage3MinDistanceBeforeTurnStage4"), 6);	-- meters
		self.realTurnStage2MinCosAngleBeforeNextStage = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTurnStage2MinCosAngleBeforeNextStage"), -0.1);
		self.realTurnStage3MinCosAngleBeforeNextStage = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTurnStage2MinCosAngleBeforeNextStage"), 0.7);
	
		--override default value
		self.aiTractorTurnRadius = getXMLFloat(xmlFile, "vehicle.aiTractorTurnRadius");
		self.aiTurnWidthScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiTurnWidthScale#value"), 1); -- use the aiTurnWidthMaxDifference value
		self.aiTurnWidthMaxDifference = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiTurnWidthMaxDifference#value"), 0.1); -- 10cm overlap
		self.turnTimeout = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turnTimeout"), 1000);
		self.frontMarkerDistanceScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.frontMarkerDistanceScale"), 0.9); -- 0.9 because we don't know if the speed is constant or not. so, we should take into consideration speed reduction (because of the ground friction, slope, or because AI reduces speed when this is the end of the field)

		
		
		if self.aiTractorTurnRadius == nil then
			--try to compute the turn radius
			if self.realNbWheels == 4 then
				local sumRot = 0;
				local divider = 0;
				--[[
				for k, wheel in pairs(self.wheels) do
					sumRot = sumRot + math.abs(wheel.rotMax) + math.abs(wheel.rotMin);
					if math.abs(wheel.rotMax)>0 then
						divider = divider + 1;
					end;
					if math.abs(wheel.rotMin)>0 then
						divider = divider + 1;
					end;
				end;]]
				
				for k, wheel in pairs(self.wheels) do
					local rot = math.min(math.abs(wheel.rotMax), math.abs(wheel.rotMin));
					if rot>0 then
						divider = divider + 1;
						sumRot = sumRot + rot;
					end;					
				end;
				
				if sumRot>0 then
					local avgRot = sumRot / divider;
					--local cosValue = math.cos(0.5*math.pi - avgRot);					
					local tanValue = math.tan(avgRot);
					
					if tanValue>0 then
						--computing the wheelbase
						local x1,_,z1 = getTranslation(self.wheels[1].repr);
						local x2,_,z2 = getTranslation(self.wheels[2].repr);
						local x3,_,z3 = getTranslation(self.wheels[3].repr);
						local wheelBase = math.max(math.abs(z1-z2), math.abs(z1-z3));						
						local axleWidth = 2*math.max(math.abs(x3), math.max(math.abs(x1), math.abs(x2)));
						
						--print("tanValue = " .. tostring(tanValue));
						--print("wheelBase = " .. tostring(wheelBase));
						
						if wheelBase>0 then
							self.aiTractorTurnRadius = wheelBase/tanValue; 
							local margin = 7.5/self.aiTractorTurnRadius*0.5*axleWidth; -- to take into account the tyre width, the uneven ground, slippage and slow turning speed worker
							self.aiTractorTurnRadius = self.aiTractorTurnRadius + margin;
							--print(self.realVehicleName .. " turnradius = " .. tostring(self.aiTractorTurnRadius) .. " wheelbase="..tostring(wheelBase) .. " axleWidth=" .. tostring(axleWidth));
						end;
					end;
				end;
			end;
			if self.aiTractorTurnRadius == nil then				
				self.aiTractorTurnRadius = 6.5; -- default value			
			end;
		end;
		
		self.realMaxAiTurnRadius = 0;
		self.realAiTargetingDirX = 0;
		
		--print("AITractor.load - " .. tostring(self.realVehicleName) .. " - turn radius = " .. tostring(self.aiTractorTurnRadius));
	
	end;

end;








local oldAITractorUpdateToolsInfo = AITractor.updateToolsInfo;
AITractor.updateToolsInfo = function(self)

	--setting max working speed for AI driven tractor
	if self.isRealistic and self.isServer then		
		local maxSpeedLimit = 100;
		local maxImplementRadius = 0;
		for k,implement in pairs(self.attachedImplements) do
			if implement.object.realWorkingSpeedLimit then
				if implement.object.realWorkingSpeedLimit<maxSpeedLimit then
					maxSpeedLimit = implement.object.realWorkingSpeedLimit;
				end;
			end;
			if implement.object.realAiTurnRadius then
				maxImplementRadius = math.max(maxImplementRadius, implement.object.realAiTurnRadius);
			end;
		end;
		
		maxSpeedLimit = 0.75*maxSpeedLimit;
		self.motor.realSpeedLevelsAI[1] = maxSpeedLimit; -- working speed (kph)
		self.motor.realSpeedLevelsAI[3] = math.min(math.max(5, 0.5*maxSpeedLimit), self.realAiManeuverSpeed); -- reduce working speed
		
		self.realMaxAiTurnRadius = math.max(self.aiTractorTurnRadius, maxImplementRadius);
		
		--[[
		local appropriateSpdLvl = 1;
		local numSpdLvl = table.getn(self.motor.realSpeedLevels);
		if maxSpeedLimit>self.realMaxVehicleSpeed then
			appropriateSpdLvl = numSpdLvl;
		else						
			for i=1, numSpdLvl do
				if self.motor.realSpeedLevels[i]<=(maxSpeedLimit-1) then
					appropriateSpdLvl = i;
				end;
			end;
		end;
		self.realAiWorkingSpeedLevel = appropriateSpdLvl;]]	
		
	end;

	oldAITractorUpdateToolsInfo(self);
	
	--compute tool width/length
	--[[self.realAiWorkingDistance = nil;
	if self.aiCurrentLeftMarker~=nil and self.aiCurrentRightMarker~=nil and self.aiCurrentBackMarker~=nil then
		local lx,_,lz = getTranslation(self.aiCurrentLeftMarker);
		local rx,_,_ = getTranslation(self.aiCurrentRightMarker);	
		local _,_,bz = getTranslation(self.aiCurrentBackMarker);	
		--keep the larger between width and length
		self.realAiWorkingDistance = math.max(math.abs(lx-rx), math.abs(lz-bz));
	end;]]

end;


local oldAITractorStartAITractor = AITractor.startAITractor;
AITractor.startAITractor = function(self, noEventSend)

	if not self.isRealistic then
		return oldAITractorStartAITractor(self, noEventSend);
	end;

	--engage AWD if possible	
	if self.realAWDModePossible and not self.realAWDModeOn then
		self:realSetAwdActive(true);
	end;
	
	--reset turnStage2 step
	self.realTurnStage2Step = 0;
		
	return oldAITractorStartAITractor(self, noEventSend);

end;




local oldAITractorStopAITractor = AITractor.stopAITractor;
AITractor.stopAITractor = function(self, noEventSend)

	if not self.isRealistic then
		return oldAITractorStopAITractor(self, noEventSend);
	end;

	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(AITractorSetStartedEvent:new(self, false));
		else
			g_client:getServerConnection():sendEvent(AITractorSetStartedEvent:new(self, false));
		end;
	end;
	self:dismiss();
	if self.isAITractorActivated then

		if self.isServer then
			self.motor:setSpeedLevel(0, false);
			self.motor.maxRpmOverride = nil;

			WheelsUtil.updateWheelsPhysics(self, 0, self.lastSpeed, 0, false, self.requiredDriveMode);

			AITractor.removeCollisionTrigger(self, self);
		end;
		self.isAITractorActivated = false;

		self.checkSpeedLimit = true;

		self.aiTractorTurnLeft = nil;
		
--******************************** DURAL *********************************************		
		self:setAIImplementsMoveDown(false);
--******************************** END DURAL *****************************************		

		for _,implement in pairs(self.attachedImplements) do
			if implement.object ~= nil then
				
--******************************** DURAL *********************************************				
				--if implement.object.needsLowering and implement.object.aiNeedsLowering then
				--	self:setJointMoveDown(implement.jointDescIndex, false, true);
				--end;
--******************************** END DURAL *****************************************	
				AITractor.removeCollisionTrigger(self, implement.object);
				implement.object:aiTurnOff();
			end
		end;

		if not self:getIsActive() then
			self:onLeave();
		end;

	end; -- end self.isAITractorActivated
	
end;









--only to "inject" the routine to manage "no backward" tool turning
local oldAITractorUpdateAIMovement = AITractor.updateAIMovement;
function AITractor.updateAIMovement(self, dt)
	
	if not self.isRealistic then
		return oldAITractorUpdateAIMovement(self, dt);
	end;


   
       if not self.isControlled then
           if g_currentMission.environment.needsLights then
               self:setLightsVisibility(true);
           else
               self:setLightsVisibility(false);
           end;
       end;
   
       local allowedToDrive = true;
   
       for _,v in pairs(self.numCollidingVehicles) do
           if v > 0 then
               allowedToDrive = false;
               break;
           end;
       end;
       --if self.turnStage > 0 then
           if self.waitForTurnTime > self.time then
               allowedToDrive = false;
           end;
       --end;
	   
--**************************************************************************************************
-- DURAL : do not allow AI to move when the engine is not fully started
		if allowedToDrive then
			allowedToDrive = self.realIsMotorStarted;
		end;
--****************************************************************************************************
	   
	   
       if not allowedToDrive then
           --local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
           --local lx, lz = 0, 1; --AIVehicleUtil.getDriveDirection(self.aiTractorDirectionNode, self.aiTractorTargetX, y, self.aiTractorTargetZ);
           --AIVehicleUtil.driveInDirection(self, dt, 30, 0, 0, 28, false, moveForwards, lx, lz)
           AIVehicleUtil.mrDriveInDirection(self, dt, 0, false, moveForwards);
           return;
       end;
   
       local speedLevel = 1;
   
       if not self:getIsAITractorAllowed() then
           self:stopAITractor();
           return;
       end;
   
   
       -- Seeding:
       --      Required: Cultivated, Ploughed
       -- Direct Planting:
       --      Required: Seeded, Cultivated, Ploughed without Fruit of current type
       -- Forage Wagon:
       --      Required: Windrow of current type
       -- Spray:
       --      Required: Seeded, Cultivated, Ploughed without Sprayed
       -- Mower:
       --      Required: Fruit of type grass
   
       local leftMarker = self.aiCurrentLeftMarker;
       local rightMarker = self.aiCurrentRightMarker;
       local backMarker = self.aiCurrentBackMarker;
       local groundInfoObject = self.aiCurrentGroundInfoObject;
   
       local terrainDetailRequiredMask = 0;
       if groundInfoObject.aiTerrainDetailChannel1 >= 0 then
           terrainDetailRequiredMask = bitOR(terrainDetailRequiredMask, 2^groundInfoObject.aiTerrainDetailChannel1);
           if groundInfoObject.aiTerrainDetailChannel2 >= 0 then
               terrainDetailRequiredMask = bitOR(terrainDetailRequiredMask, 2^groundInfoObject.aiTerrainDetailChannel2);
               if groundInfoObject.aiTerrainDetailChannel3 >= 0 then
                   terrainDetailRequiredMask = bitOR(terrainDetailRequiredMask, 2^groundInfoObject.aiTerrainDetailChannel3);
               end
           end
       end
   
       local terrainDetailProhibitedMask = groundInfoObject.aiTerrainDetailProhibitedMask;
       local requiredFruitType = groundInfoObject.aiRequiredFruitType;
       local requiredMinGrowthState = groundInfoObject.aiRequiredMinGrowthState;
       local requiredMaxGrowthState = groundInfoObject.aiRequiredMaxGrowthState;
       local prohibitedFruitType = groundInfoObject.aiProhibitedFruitType;
       local prohibitedMinGrowthState = groundInfoObject.aiProhibitedMinGrowthState;
       local prohibitedMaxGrowthState = groundInfoObject.aiProhibitedMaxGrowthState;
   
   
       local newTargetX, newTargetY, newTargetZ;
   
       local moveForwards = true;
       local updateWheels = true;
   
       self.turnTimer = self.turnTimer - dt;

--************************************************************** DURAL **********************************************************
	   local useReduceSpeed = false;
--********************************************************** END DURAL *********************************************************
   
       if self.turnTimer < 0 or self.turnStage > 0 then
           if self.turnStage > 1 then
               local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
               local dirX, dirZ = self.aiTractorDirectionX, self.aiTractorDirectionZ;
               local myDirX, myDirY, myDirZ = localDirectionToWorld(self.aiTractorDirectionNode, 0, 0, 1);
   
               newTargetX = self.aiTractorTargetX;
               newTargetY = y;
               newTargetZ = self.aiTractorTargetZ;
               if self.turnStage == 2 then
                   self.turnStageTimer = self.turnStageTimer - dt;
--*******************************************  DURAL  **************************************************
                   --if myDirX*dirX + myDirZ*dirZ > 0.2 or self.turnStageTimer < 0 then
				   if myDirX*dirX + myDirZ*dirZ > self.realTurnStage2MinCosAngleBeforeNextStage or self.turnStageTimer < 0 then
--*******************************************************************************************************
                       if self.aiTurnNoBackward then
                           self.turnStage = 4;
                       else
                           self.turnStage = 3;
                           moveForwards = false;
                       end;
                       if self.turnStageTimer < 0 then
   
                           self.aiTractorTargetBeforeSaveX = self.aiTractorTargetX;
                           self.aiTractorTargetBeforeSaveZ = self.aiTractorTargetZ;
   
                           newTargetX = self.aiTractorTargetBeforeTurnX;
                           newTargetZ = self.aiTractorTargetBeforeTurnZ;
   
                           moveForwards = false;
                           self.turnStage = 6;
                           self.turnStageTimer = self.turnStage6Timeout;
                       else
                           self.turnStageTimer = self.turnStage3Timeout;
                       end;
                   end;
               elseif self.turnStage == 3 then -- moving backward
                   self.turnStageTimer = self.turnStageTimer - dt;
				   moveForwards = false;

--*******************************************  DURAL  **************************************************				   
				   -- now checking if a sufficient distance has been reached to move to stage 4
					if (myDirX*dirX + myDirZ*dirZ)>self.realTurnStage3MinCosAngleBeforeNextStage then
						--check current distance to the target point				
						local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
						local distance = Utils.vector2Length(newTargetX - x, newTargetZ - z);
						
						--print(self.time .. " turnstage2 - distance = " .. tostring(distance));
						
						if distance > self.realTurnStage3MinDistanceBeforeTurnStage4 or self.turnStageTimer < 0 then
							self.turnStage = 4;
							moveForwards = true;							
						end;
					end;				   
                   --[[
				   if myDirX*dirX + myDirZ*dirZ > 0.85 or self.turnStageTimer < 0 then
                       self.turnStage = 4;
                   else
                       moveForwards = false;
                   end;]]
--*******************************************************************************************************
               elseif self.turnStage == 4 then
                   local dx, dz = x-newTargetX, z-newTargetZ;
                   local dot = dx*dirX + dz*dirZ;
                   if -dot < self.turnEndDistance then
                       newTargetX = self.aiTractorTargetX + dirX*(self.turnTargetMoveBack + self.aiToolExtraTargetMoveBack);
                       newTargetY = y;
                       newTargetZ = self.aiTractorTargetZ + dirZ*(self.turnTargetMoveBack + self.aiToolExtraTargetMoveBack);
                       self.turnStage = 5;
                       --print("turning done");
                   end;
               elseif self.turnStage == 5 then
                   local backX, backY, backZ = getWorldTranslation(backMarker);
                   local dx, dz = backX-newTargetX, backZ-newTargetZ;
                   local dot = dx*dirX + dz*dirZ;
                   if -dot < self.turnEndBackDistance+self.aiToolExtraTargetMoveBack then
                       self.turnTimer = self.turnTimeoutLong;
                       self.turnStage = 0;
                       self:setAIImplementsMoveDown(true);
                       self.waitForTurnTime = self.time + self.waitForTurnTimeout;
                       AITractor.updateInvertLeftRight(self);
                       leftMarker = self.aiCurrentLeftMarker;
                       rightMarker = self.aiCurrentRightMarker;
                       --print("turning done");
                   end;
               elseif self.turnStage == 6 then
                   self.turnStageTimer = self.turnStageTimer - dt;
                   if self.turnStageTimer < 0 then
                       self.turnStageTimer = self.turnStage2Timeout;
                       self.turnStage = 2;
   
                       newTargetX = self.aiTractorTargetBeforeSaveX;
                       newTargetZ = self.aiTractorTargetBeforeSaveZ;
                   else
                       local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
                       local dirX, dirZ = -self.aiTractorDirectionX, -self.aiTractorDirectionZ;
                       -- just drive along direction
                       local targetX, targetZ = self.aiTractorTargetX, self.aiTractorTargetZ;
                       local dx, dz = x-targetX, z-targetZ;
                       local dot = dx*dirX + dz*dirZ;
   
                       local projTargetX = targetX +dirX*dot;
                       local projTargetZ = targetZ +dirZ*dot;
   
                       newTargetX = projTargetX-dirX*self.aiTractorLookAheadDistance;
                       newTargetZ = projTargetZ-dirZ*self.aiTractorLookAheadDistance;
                       moveForwards = false;
                   end;
               end;
           elseif self.turnStage == 1 then
               -- turn
               AITractor.updateInvertLeftRight(self);
               leftMarker = self.aiCurrentLeftMarker;
               rightMarker = self.aiCurrentRightMarker;
   
               local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
               local dirX, dirZ = self.aiTractorDirectionX, self.aiTractorDirectionZ;
               local sideX, sideZ = -dirZ, dirX;
               local lX,  lY,  lZ = getWorldTranslation(leftMarker);
               local rX,  rY,  rZ = getWorldTranslation(rightMarker);
   
               local markerWidth = Utils.vector2Length(lX-rX, lZ-rZ);
   
               local lWidthX = lX + dirX * self.sideWatchDirOffset;
               local lWidthZ = lZ + dirZ * self.sideWatchDirOffset;
               local lStartX = lWidthX - sideX*0.7*markerWidth;
               local lStartZ = lWidthZ - sideZ*0.7*markerWidth;
               local lHeightX = lStartX + dirX*self.sideWatchDirSize;
               local lHeightZ = lStartZ + dirZ*self.sideWatchDirSize;
   
               local rWidthX = rX + dirX * self.sideWatchDirOffset;
               local rWidthZ = rZ + dirZ * self.sideWatchDirOffset;
               local rStartX = rWidthX + sideX*0.7*markerWidth;
               local rStartZ = rWidthZ + sideZ*0.7*markerWidth;
               local rHeightX = rStartX + dirX*self.sideWatchDirSize;
               local rHeightZ = rStartZ + dirZ*self.sideWatchDirSize;
   
               local leftArea, leftAreaTotal = AITractor.getAIArea(self, lStartX, lStartZ, lWidthX, lWidthZ, lHeightX, lHeightZ, terrainDetailRequiredMask, terrainDetailProhibitedMask, requiredFruitType, requiredMinGrowthState, requiredMaxGrowthState, prohibitedFruitType, prohibitedMinGrowthState, prohibitedMaxGrowthState)
               local rightArea, rightAreaTotal = AITractor.getAIArea(self, rStartX, rStartZ, rWidthX, rWidthZ, rHeightX, rHeightZ, terrainDetailRequiredMask, terrainDetailProhibitedMask, requiredFruitType, requiredMinGrowthState, requiredMaxGrowthState, prohibitedFruitType, prohibitedMinGrowthState, prohibitedMaxGrowthState)
   
               -- turn to where ground/fruit is to be changed
   
               local leftOk = (leftArea > 0 and leftArea > 0.15*leftAreaTotal);
               local rightOk = (rightArea > 0 and rightArea > 0.15*rightAreaTotal);
   
               if self.aiTractorTurnLeft == nil then
                   if leftOk or rightOk then
                       if leftArea > rightArea then
                           self.aiTractorTurnLeft = true;
                       else
                           self.aiTractorTurnLeft = false;
                       end
                   else
                       self:stopAITractor();
                       return;
                   end;
               else
                   self.aiTractorTurnLeft = not self.aiTractorTurnLeft;
                   if (self.aiTractorTurnLeft and not leftOk) or (not self.aiTractorTurnLeft and not rightOk) then
                       self:stopAITractor();
                       return;
                   end
               end
   
               local targetX, targetZ = self.aiTractorTargetX, self.aiTractorTargetZ;
               --[[local x = (lX+rX)/2;
               local z = (lZ+rZ)/2;
               local markerSideOffset, lY, lZ = worldToLocal(self.aiTractorDirectionNode, x, (lY+rY)/2, z);
               markerSideOffset = math.abs(markerSideOffset);
               local dx, dz = x-targetX, z-targetZ;
               local dot = dx*dirX + dz*dirZ;
               local x, z = targetX + dirX*dot, targetZ + dirZ*dot;]]
               markerWidth = math.max(markerWidth*self.aiTurnWidthScale, markerWidth-self.aiTurnWidthMaxDifference); -- - markerSideOffset;
   
               local invertsMarker = AITractor.invertsMarkerOnTurn(self, self.aiTractorTurnLeft);
               if not invertsMarker then
                   -- if not inverting, we need to adjust the markerWidth
                   local mx = (lX+rX)*0.5;
                   local mz = (lZ+rZ)*0.5;
                   local markerSideOffset, _, _ = worldToLocal(self.aiTractorDirectionNode, mx, (lY+rY)*0.5, mz);
                   --markerSideOffset = math.abs(markerSideOffset);
                   markerWidth = markerWidth + markerSideOffset;
                   --local dx, dz = x-targetX, z-targetZ;
                   --local dot = dx*dirX + dz*dirZ;
                   --local x, z = targetX + dirX*dot, targetZ + dirZ*dot;]]
               end;
   
   
               --local backX, backY, backZ = getWorldTranslation(backMarker);
               local projTargetLX, projTargetLZ = Utils.projectOnLine(lX, lZ, targetX, targetZ, dirX, dirZ)
               local projTargetRX, projTargetRZ = Utils.projectOnLine(rX, rZ, targetX, targetZ, dirX, dirZ)
   
               x = (projTargetLX+projTargetRX)*0.5;
               z = (projTargetLZ+projTargetRZ)*0.5;
   
               local _, _, localZ = worldToLocal(self.aiTractorDirectionNode, x, (lY+rY)*0.5, z);
               self.aiToolExtraTargetMoveBack = math.max(-localZ, 0);
   
   
               if self.aiTractorTurnLeft then
                   newTargetX = x-sideX*markerWidth;
                   newTargetY = y;
                   newTargetZ = z-sideZ*markerWidth;
                   AITractor.aiRotateLeft(self);
               else
                   newTargetX = x+sideX*markerWidth;
                   newTargetY = y;
                   newTargetZ = z+sideZ*markerWidth;
                   AITractor.aiRotateRight(self);
               end;
               local aiForceTurnNoBackward = false;
               for _,implement in pairs(self.attachedImplements) do
                   if implement.object.aiForceTurnNoBackward then
                       aiForceTurnNoBackward = true;
                       break;
                   end;
               end;
   
               self.aiTurnNoBackward = (markerWidth >= 2*self.aiTractorTurnRadius) or aiForceTurnNoBackward;
   
               self.aiTractorTargetBeforeTurnX = self.aiTractorTargetX;
               self.aiTractorTargetBeforeTurnZ = self.aiTractorTargetZ;
   
               self.aiTractorDirectionX = -dirX;
               self.aiTractorDirectionZ = -dirZ;
   
               self.turnStage = 2;
               self.turnStageTimer = self.turnStage2Timeout;
   
               if self.aiTractorTurnLeft then
                   --print("turning left ", markerWidth);
               else
                   --print("turning right ", markerWidth);
               end;
           else -- self.turnTimer<0 => no more work. try turnstage 1 to find something to do left or right
		   
--********************************************************** DURAL ************************************************************************
--** do not raise the implement at once ! wait a little so that terrain "patches" can be updated
				if self.turnTimer<-400 then -- 400 ms
					self.turnStage = 1;   					
					self:setAIImplementsMoveDown(false);
					self.waitForTurnTime = self.time + 0.3*self.waitForTurnTimeout;
				end;
				allowedToDrive = false;	 -- needed to force the AI to brake the tractor
				--updateWheels = false;
--********************************************************** END DURAL ************************************************************************               
           end;
       else -- stage 0 - working
           local dirX, dirZ = self.aiTractorDirectionX, self.aiTractorDirectionZ;
           local lX,  lY,  lZ = getWorldTranslation(leftMarker);
           local rX,  rY,  rZ = getWorldTranslation(rightMarker);
--********************************************************** DURAL ************************************************************************
           --self.lastFrontMarkerDistance = self.lastSpeed*self.turnTimeout;
		   --self.lastFrontMarkerDistance = self.realGroundSpeed*self.turnTimeout/1000;
		   self.lastFrontMarkerDistance = self.motor.realSpeedLevelsAI[1]*self.turnTimeout/3600;

           local scaledDistance = self.lastFrontMarkerDistance*self.frontMarkerDistanceScale;
           local lX2 = lX + dirX*scaledDistance;
           local lZ2 = lZ + dirZ*scaledDistance;
   
           local rX2 = rX + dirX*scaledDistance;
           local rZ2 = rZ + dirZ*scaledDistance;   
   
           local area = AITractor.getAIArea(self, lX2, lZ2, rX2, rZ2, lX2 + dirX*2, lZ2 + dirZ*2, terrainDetailRequiredMask, terrainDetailProhibitedMask, requiredFruitType, requiredMinGrowthState, requiredMaxGrowthState, prohibitedFruitType, prohibitedMinGrowthState, prohibitedMaxGrowthState);
   
           if area >= 1 then
               self.turnTimer = self.turnTimeout;

			else
				--no more ground to work with ? reduce the speed in case this is the end of the field
				useReduceSpeed = true;
				
				--check if there is still some ground to work just in front of the implement 
				area = AITractor.getAIArea(self, lX, lZ, rX, rZ, lX + dirX*2, lZ + dirZ*2, terrainDetailRequiredMask, terrainDetailProhibitedMask, requiredFruitType, requiredMinGrowthState, requiredMaxGrowthState, prohibitedFruitType, prohibitedMinGrowthState, prohibitedMaxGrowthState);
				if area>0 then
					self.turnTimer = 2*dt; -- set a small bit of time to complete the remaining ground to work
				end;
				
--********************************************************** END DURAL ************************************************************************	
           end;
   
   
           local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
           local dirX, dirZ = self.aiTractorDirectionX, self.aiTractorDirectionZ;
           -- just drive along direction
           local targetX, targetZ = self.aiTractorTargetX, self.aiTractorTargetZ;
           local dx, dz = x-targetX, z-targetZ;
           local dot = dx*dirX + dz*dirZ;
   
           local projTargetX = targetX +dirX*dot;
           local projTargetZ = targetZ +dirZ*dot;
   
           --print("old target: "..targetX.." ".. targetZ .. " distOnDir " .. dot.." proj: "..projTargetX.." "..projTargetZ);
   
           newTargetX = projTargetX+self.aiTractorDirectionX*self.aiTractorLookAheadDistance;
           newTargetY = y;
           newTargetZ = projTargetZ+self.aiTractorDirectionZ*self.aiTractorLookAheadDistance;
           --print(distOnDir.." target: "..newTargetX.." ".. newTargetZ);
       end;


--*************************************************** DURAL ************************************************************************************		   
       if updateWheels then
	   
			local lx, lz = 0,0;
			if moveForwards then
				lx, lz = AIVehicleUtil.getDriveDirection(self.aiTractorDirectionNode, newTargetX, newTargetY, newTargetZ);
				lx, lz = AITractor.realGetDriveDirectionFix(self, lx, lz, newTargetX, newTargetZ); 
			else
				--setting a target point behind the tractor
				local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
				local distance = Utils.vector2Length(newTargetX - x, newTargetZ - z);
				
				local x2,z2 = Utils.projectOnLine(x, z, newTargetX, newTargetZ, self.aiTractorDirectionX, self.aiTractorDirectionZ)
				
				local reverseTargetX, reverseTargetY, reverseTargetZ = x2-2*self.aiTractorDirectionX, newTargetY, z2-2*self.aiTractorDirectionZ;			
				lx, lz = AIVehicleUtil.getDriveDirection(self.aiTractorDirectionNode, reverseTargetX, reverseTargetY, reverseTargetZ);
				
				--print(self.time .. " vehicleSteeringAngle=" .. tostring(self.realVehicleSteeringAngle) ..  " reverse lx / lz = " .. tostring(lx) .. " / " .. tostring(lz) .. " targetX / targetZ = " .. tostring(reverseTargetX) .. " / " .. tostring(reverseTargetZ));
				
			end;
--*************************************************** END DURAL ************************************************************************************
		   
 --*************************************************** DURAL ************************************************************************************				
			if allowedToDrive then
				AIVehicleUtil.mrDriveInDirection(self, dt, 1, true, moveForwards, lx, lz, speedLevel, useReduceSpeed);
			else			
				AIVehicleUtil.mrDriveInDirection(self, dt, 0, false, moveForwards);				
			end;
--*************************************************** END DURAL ************************************************************************************
   
           --local maxAngle = 0.785398163; --45?;
           local maxlx = 0.7071067; --math.sin(maxAngle);
           local colDirX = lx;
           local colDirZ = lz;
   
           if colDirX > maxlx then
               colDirX = maxlx;
               colDirZ = 0.7071067; --math.cos(maxAngle);
           elseif colDirX < -maxlx then
               colDirX = -maxlx;
               colDirZ = 0.7071067; --math.cos(maxAngle);
           end;
		   
		   --print(self.time .. " turnStage / lx / lz / dx / dz = " ..tostring(self.turnStage) .. " / " .. tostring(lx) .. " / " .. tostring(lz) .. " / " .. tostring(colDirX) .. " / " .. tostring(colDirZ));
   
           for triggerId,_ in pairs(self.numCollidingVehicles) do
               AIVehicleUtil.setCollisionDirection(self.aiTractorDirectionNode, triggerId, colDirX, colDirZ);
           end;
       end;
   
       if newTargetX ~= nil and newTargetZ ~= nil then
           self.aiTractorTargetX = newTargetX;
           self.aiTractorTargetZ = newTargetZ;
       end;
   end;
   
   
   
AITractor.realGetDriveDirectionFix = function(self, lx, lz, targetX, targetZ)

	-- modify turn path when working with "no-backward" tools
	--print(self.time .. " turnstage = " .. tostring(self.turnStage));

		if self.aiTurnNoBackward then		
		
			
			
			
			if self.turnStage==0 then
				--resetting variables for next maneuver
				self.realTurnStage2Step = 0;
				--self.realAiTargetingDirX = 0;
				--self.realAiTurnStage2Step0TargetX = nil;
				--self.realAiTurnStage2Step0TargetZ = nil;
				self.realAiTurnStage2Step0TargetTurningCircleX=nil;
				self.realAiTurnStage2Step0TargetTurningCircleZ=nil;
			end;
			
			if self.turnStage==2 then
			
				local myDirX, myDirY, myDirZ = localDirectionToWorld(self.aiTractorDirectionNode, 0, 0, 1);	
				
				
				
				--print(string.format(" %g timer=%u turnstage = %u turnStage2Step = %u myDir compared to target dir = %1.4f",self.time,self.turnStageTimer,self.turnStage,self.realTurnStage2Step,self.aiTractorDirectionX*myDirX + self.aiTractorDirectionZ*myDirZ));
			
				if self.realTurnStage2Step==0 then		
					
					--compute the distance between the current position of the tractor and the target position taking into account the ""
					
					--local finalTargetX = targetX + self.aiTractorDirectionX*(self.turnTargetMoveBack + self.aiToolExtraTargetMoveBack);                    
                    --local finalTargetZ = targetZ + self.aiTractorDirectionZ*(self.turnTargetMoveBack + self.aiToolExtraTargetMoveBack);
					
					
					--local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);						
					--local distance = Utils.vector2Length(x-finalTargetX, z-finalTargetZ);
					
					--setting the direction we want to target (left or right)
					--if self.realAiTargetingDirX == 0 then
					--	self.realAiTargetingDirX = 1;
					--	if lx<0 then
					--		self.realAiTargetingDirX = -1;
					--	end;
					--end;		


					--set the center point of the turning circle when the tractor is at the final target position (turning circle at the opposite side from where the tractor started its turning stage)
					if self.realAiTurnStage2Step0TargetTurningCircleX==nil then	
						local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
						local sideX, sideZ = -self.aiTractorDirectionZ, self.aiTractorDirectionX;
						if self.aiTractorTurnLeft then
							-- 0.9 factor for aiToolExtraTargetMoveBack because we loose some time (and distance) when rotating the wheels
							self.realAiTurnStage2Step0TargetTurningCircleX = targetX +sideX*self.realMaxAiTurnRadius + self.aiTractorDirectionX*self.aiToolExtraTargetMoveBack*0.9; -- side offset and then longitudinal offset							
							self.realAiTurnStage2Step0TargetTurningCircleZ = targetZ +sideZ*self.realMaxAiTurnRadius + self.aiTractorDirectionZ*self.aiToolExtraTargetMoveBack*0.9; -- side offset and then longitudinal offset								
						else							
							self.realAiTurnStage2Step0TargetTurningCircleX = targetX -sideX*self.realMaxAiTurnRadius + self.aiTractorDirectionX*self.aiToolExtraTargetMoveBack*0.9; -- side offset and then longitudinal offset							
							self.realAiTurnStage2Step0TargetTurningCircleZ = targetZ -sideZ*self.realMaxAiTurnRadius + self.aiTractorDirectionZ*self.aiToolExtraTargetMoveBack*0.9; -- side offset and then longitudinal offset							
						end;						
					end;
					

					local steeringWantedDir = -1;
					if self.aiTractorTurnLeft then
						steeringWantedDir = 1;
					end;
					
					--local centerTurnCircleX,_,centerTurnCircleZ = localToWorld(self.aiTractorDirectionNode, steeringWantedDir*self.realMaxAiTurnRadius, 0, 0);
					--local oppositeCirclePositionX,_,oppositeCirclePositionZ = localToWorld(self.aiTractorDirectionNode, steeringWantedDir*self.realMaxAiTurnRadius*2, 0, 0);
					
					
					--set the center point of the current turning circle (turning circle at the side where the final target is)
					local turningCircleX,_,turningCircleZ = localToWorld(self.aiTractorDirectionNode, steeringWantedDir*self.realMaxAiTurnRadius, 0, 0);
					
					--if self.realAiTurnStage2Step0TargetX==nil then	
					--	local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
					--	self.realAiTurnStage2Step0TargetX, self.realAiTurnStage2Step0TargetZ = Utils.projectOnLine(x, z, targetX, targetZ, self.aiTractorDirectionX, self.aiTractorDirectionZ)
					--end;
					
					
					
					--local distance = Utils.vector2Length(centerTurnCircleX-self.realAiTurnStage2Step0TargetX, centerTurnCircleZ-self.realAiTurnStage2Step0TargetZ);
					
					--take into account steering speed that increases the current distance when too slow (take time to fully rotate in one direction, but the tractor continues moving during steering ans so, it continues moving away)
					--distance = distance + 1*self.maxRotTime*self.realAiManeuverSpeed/3.6;
					
					--distance between center of the turning circle and the line defined by the target point and the target direction
					-- u = target direction vector. A = center of turning circle. B = target point.
					-- distance = norm(cross product between BA and u)/norm(u)     -- in french : norme(produit vectoriel(BA et u)/norme(u)					
					--local normU = Utils.vector2Length(self.aiTractorDirectionX, self.aiTractorDirectionZ);
					--local normCrossProd = math.abs((oppositeCirclePositionZ-targetZ)*self.aiTractorDirectionX - (oppositeCirclePositionX-targetX)*self.aiTractorDirectionZ); 
					--local distance = normCrossProd;-- /normU; normU always == 1 since its a direction vector
					
					--local minDistance = self.realMaxAiTurnRadius;
					--local minDistance = 0.1;
					local minDistance = 1.05*2*self.realMaxAiTurnRadius;--5% more since there can be slippage or the ground is not even
					
					local distance = Utils.vector2Length(turningCircleX-self.realAiTurnStage2Step0TargetTurningCircleX, turningCircleZ-self.realAiTurnStage2Step0TargetTurningCircleZ);
					
					
					--take into account current vehicle position and turning radius
					--cos angle between "tractor direction" and -targetDirection = scalar
					--local cosAngle = myDirX*-self.aiTractorDirectionX + myDirZ*-self.aiTractorDirectionZ;					
					--projected distance because of the current tractor direction that would require extra turning to return back to the correct position
					--distance = distance + self.aiTractorTurnRadius * 3*(1-cosAngle);
					
					--local l1 = Utils.vector2Length(myDirX, myDirZ);
					--local l2 = Utils.vector2Length(self.aiTractorDirectionX, self.aiTractorDirectionZ),
					
					--print(self.time .. " aitractordirection x / z = " .. tostring(self.aiTractorDirectionX) .. " / " .. tostring(self.aiTractorDirectionZ));
					--print(self.time .. " l1 / l2 = " .. tostring(l1) .. " / " .. tostring(l2));
					
					--print(string.format("%g   turnStage2 - minDistance=%1.3f / current distance=%1.3f / turningRadius=%1.2f / TurnStage2Step0TargetX=%1.2f / TurnStage2Step0TargetZ=%1.2f",self.time,minDistance,distance,self.realMaxAiTurnRadius,self.realAiTurnStage2Step0TargetX,self.realAiTurnStage2Step0TargetZ));
					--print(string.format("%g   turnStage2 - minDistance=%1.3f / current distance=%1.3f / turningRadius=%1.2f / centerTurnCircleX=%1.2f / centerTurnCircleZ=%1.2f",self.time,minDistance,distance,self.realMaxAiTurnRadius,centerTurnCircleX,centerTurnCircleZ));
					--print(string.format("%g   turnStage2 - minDistance=%1.3f / current distance=%1.3f / turningRadius=%1.2f / TargetTurningCircleX=%1.2f / TargetTurningCircleZ=%1.2f",self.time,minDistance,distance,self.realMaxAiTurnRadius,self.realAiTurnStage2Step0TargetTurningCircleX,self.realAiTurnStage2Step0TargetTurningCircleZ));
					
					if distance>minDistance then
						-- minDistance reach
						self.realTurnStage2Step = 1;
					else
						--turn the wheel to the opposite side to get a better turn radius after									
						if self.aiTractorDirectionX*myDirX + self.aiTractorDirectionZ*myDirZ > -0.7 then --about 45
							--move in a straight line to move away
							--print(self.time .. " move straight to pull away ! dist / minDist = " .. tostring(distance) .. " / " .. tostring(minDistance));
							lx = 0;
							lz = 1;						
						else
							--turn to the opposite side (compared to the targetX,targetZ point) until we are at 45 compared to the target direction
							--print(self.time .. " fully turn to the opposite side !");
							
							--lx, lz = AIVehicleUtil.getDriveDirection(self.aiTractorDirectionNode, targetX - self.aiTractorDirectionX*100, y, targetZ - self.aiTractorDirectionZ*100);
							lz = 0;
							lx = 1;
							if self.aiTractorTurnLeft then
								lx = -1;
							end;
							
							--[[
							if lx>0 then
								lx = -1;
								lz = 0;							
							else
								lx = 1;
								lz = 0;	
							end;]]
							--local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
							--lx, lz = AIVehicleUtil.getDriveDirection(self.aiTractorDirectionNode, 2*x - targetX, y, 2*z - targetZ);
						end;
						
					end;
					
				end;
				
				if self.realTurnStage2Step==1 then
				
					--we are enough far away : turn in the correct direction until we are perpendicular to the target direction
					--targeting the 'high' point (far away in the headland, in the opposite direction than the aiTractorDirection)
					--local fx,_,_ = worldToLocal(self.aiTractorDirectionNode, targetX - self.aiTractorDirectionX*100, y, targetZ - self.aiTractorDirectionZ*100);
					--if fx>0 then
					--	lx = 1;
					--	lz = 0;							
					--else
					--	lx = -1;
					--	lz = 0;	
					--end;

					lz = 0;
					lx = -1;
					if self.aiTractorTurnLeft then
						lx = 1;
					end;	

					--if we are perpendicular to the target direction vector, just move in a straight line to reach the line that goes through the direction vector
					if math.abs(self.aiTractorDirectionX*myDirX + self.aiTractorDirectionZ*myDirZ) < 0.1 then
						self.realTurnStage2Step = 2;
					end;
					
					--if math.abs(self.aiTractorDirectionX*myDirX + self.aiTractorDirectionZ*myDirZ) > 0.9 then -- parallel to the "aiTractorDirection", we can get back to the genuine "procedure"
					--	self.realTurnStage2Step = 2;						
					--	self.turnStageTimer = self.turnStage2Timeout;
					--end;					
						
				end; -- end turn stage 2 step 1
				
				--[[ skip this one
				if self.realTurnStage2Step == 2 then
				
					--if we are perpendicular to the target direction vector, just move in a straight line to reach the line that goes through the direction vector
					if math.abs(self.aiTractorDirectionX*myDirX + self.aiTractorDirectionZ*myDirZ) < 0.1 then
						self.realTurnStage2Step = 3;
					end;
					
				end; -- end turn stage 2 step 2]]
				
				if self.realTurnStage2Step == 2 then
				
					local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);	
						
					--check if we can go to turnStage4
					--compute distance between our position and the line defined by the target point and the target direction
					-- u = direction vector. A = our position. B = target point.
					-- distance = norm(cross product between BA and u)/norm(u)     -- in french : norme(produit vectoriel(BA et u)/norme(u)
					local normU = Utils.vector2Length(self.aiTractorDirectionX, self.aiTractorDirectionZ);
					local normCrossProd = math.abs((z-targetZ)*self.aiTractorDirectionX - (x-targetX)*self.aiTractorDirectionZ); 
					local distance = normCrossProd/normU;			
					
					
					--print(self.time .. " move straight to reach the direction vector line ! dist / minDist = " .. tostring(distance) .. " / " .. tostring(minDistance));
					
					if distance<self.turnEndDistance/Utils.clamp(0.25*self.aiToolExtraTargetMoveBack, 1, 2) then
						self.turnStage=4;	
						--print(string.format("turnstage 4 - dist = %1.2f / minDist = %1.2f",distance,self.turnEndDistance/Utils.clamp(0.25*self.aiToolExtraTargetMoveBack, 1, 2)));
					else
						--straight line						
						lx = 0;
						lz = 1;	
					end;
				
				end; -- end turn stage 2 step 3
				
				lz = math.max(0, lz);
					
			end; -- end turn stage 2
			
			if self.turnStage==4 or self.turnStage==5 then
			
				--we want to target the std target point with some offset function of tractor direction and distance from the std target point
				local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);	
				local newTargetX =  2*targetX - x;
				local newTargetZ =  2*targetZ - z;
				local dist = 0.66*Utils.vector2Length(targetX - x, targetZ - z);
				newTargetX = newTargetX - self.aiTractorDirectionX*dist;
				newTargetZ = newTargetZ - self.aiTractorDirectionZ*dist;
				
				lx, lz = AIVehicleUtil.getDriveDirection(self.aiTractorDirectionNode, newTargetX, y, newTargetZ);
			
			end; -- end turn stage 4
						
		end; --end aiTractor and noBackward tool		
		
		--[[
		local ts = tostring(self.turnStage);
		if self.turnStage==2 then			
			ts = ts .. "-" .. tostring(self.realTurnStage2Step);						
		end;
		print(self.time .. " turnstage = " .. tostring(ts) .. " lx/lz = " .. tostring(lx) .. " / " .. tostring(lz));]]
		
		return lx,lz;


end;

