local oldAICombinePostLoad = AICombine.postLoad;
AICombine.postLoad = function(self, xmlFile)

	--update max speed possible for "integrated" cutter
	if self.isServer and self.isRealistic then
	
		self.realAiMinDistanceBeforeTurning = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realAiMinDistanceBeforeTurning"), 2);	-- meters			
		self.realTurnStage1DistanceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTurnStage1DistanceThreshold"), 6);	-- meters
		self.realTurnStage1CosAngleThreshold = math.cos(math.rad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTurnStage1AngleThreshold"), 45)));	-- degre
		self.realTurnStage2MinDistanceBeforeTurnStage3 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTurnStage2MinDistanceBeforeTurnStage3"), 10);	-- meters
		
		self.realAiCombineTargetMotorLoad = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realAiCombineTargetMotorLoad"), 0.85); -- 0.85 = 85%
		
		
		local baseSpd = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realAiWorkingSpeed#baseSpeed"), 5);
		local minSpd = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realAiWorkingSpeed#minSpeed"), baseSpd*0.75);
		local maxSpd = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realAiWorkingSpeed#maxSpeed"), baseSpd*1.5);		
		self.realAiSpeed = {baseSpeed=baseSpd, minSpeed=minSpd, maxSpeed=maxSpd};	
		
		--override default value
		self.aiTurnThreshWidthScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiTurnThreshWidthScale#value"), 1); -- 100% of the width
		self.aiTurnThreshWidthMaxDifference = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiTurnThreshWidthMaxDifference#value"), 0); -- 0cm overlap
		
		--backup base max overlap allowed
		self.realBaseMaxOverlap = self.aiTurnThreshWidthMaxDifference;
		
		self.realAiMaxWorkingSpeed = self.realAiSpeed.maxSpeed;
		
		self.realAiThreshingNextRowFurtherSideX = 0;
		self.realAiThreshingNextRowFurtherSideZ = 0;
		
		self.realAiThreshingFinalTargetX = 0;
		self.realAiThreshingFinalTargetZ = 0;
		
					
		AICombine.updateMaxSpeedInfo(self);
	end;

	if oldAICombinePostLoad~=nil then
		oldAICombinePostLoad(self, xmlFile);
	end;
end;




local oldAICombineAttachImplement = AICombine.attachImplement;
AICombine.attachImplement = function(self, implement)
	oldAICombineAttachImplement(self, implement);
--********************************** DURAL *******************************************************
--** update max speed possible
	if self.isServer and self.isRealistic then
		AICombine.updateMaxSpeedInfo(self);
	end;
--*********************************** END DURAL ****************************************************
end;


local oldAICombineDetachImplement = AICombine.detachImplement;
AICombine.detachImplement = function(self, implementIndex)
	oldAICombineDetachImplement(self, implementIndex);
--********************************** DURAL *******************************************************
--** update max speed possible
	if self.isServer and self.isRealistic then
		AICombine.updateMaxSpeedInfo(self);
	end;
--*********************************** END DURAL ****************************************************
end;



AICombine.updateMaxSpeedInfo = function(self)

	--compute the appropriate speedlevel	
	local maxSpeedLimit = 100;
	local maxOverlap = 999;
	for cutter,implement in pairs(self.attachedCutters) do
		if cutter.realCutterSpeedLimit~=nil then
			if cutter.realCutterSpeedLimit<maxSpeedLimit then
				maxSpeedLimit = cutter.realCutterSpeedLimit;
			end;
		end;
		if cutter.realAiMaxOverlap~=nil then
			if cutter.realAiMaxOverlap<maxOverlap then
				maxOverlap = cutter.realAiMaxOverlap;
			end;
		end;
	end;
	
	
	
	maxSpeedLimit = math.min(maxSpeedLimit-2, 0.85*maxSpeedLimit);
	--maxSpeedLimit = math.min(maxSpeedLimit, self.realAiMaxWorkingSpeed);
	maxSpeedLimit = math.min(maxSpeedLimit, self.realAiSpeed.maxSpeed);
	
	--self.motor.realSpeedLevelsAI[1] = maxSpeedLimit; -- this value is now computed in "updateCurrentSpeedWanted"
	self.motor.realSpeedLevelsAI[3] = math.min(math.max(5, 0.5*maxSpeedLimit), self.realAiManeuverSpeed); -- reduce working speed
	
	self.realAiMaxWorkingSpeed = maxSpeedLimit;
	
	--print(string.format("%g - %s / work speed = %1.2f / reduce speed = %1.2f",self.time,self.realVehicleName,self.motor.realSpeedLevelsAI[1],self.motor.realSpeedLevelsAI[3]));
	
	self.aiTurnThreshWidthMaxDifference = math.min(self.realBaseMaxOverlap, maxOverlap);
	
	--print(self.time .. " new aiTurnThreshWidthMaxDifference = " .. tostring(self.aiTurnThreshWidthMaxDifference));
	
end;



AICombine.updateCurrentSpeedWanted = function(self, reset)	

	if reset then
		self.motor.realSpeedLevelsAI[1] = self.realAiSpeed.baseSpeed;
	elseif self.realMotorLoadS>self.realAiCombineTargetMotorLoad then
		--faster when decreasing speed
		--self.motor.realSpeedLevelsAI[1] = math.max(self.realAiSpeed.minSpeed, self.motor.realSpeedLevelsAI[1]-0.05);
		self.motor.realSpeedLevelsAI[1] = math.min(self.realGroundSpeed*3.6, self.motor.realSpeedLevelsAI[1] * (1 - (self.realAiCombineTargetMotorLoad-self.realMotorLoadS)^2));
	else
		--slower when increasing speed
		--self.motor.realSpeedLevelsAI[1] = math.min(self.realAiMaxWorkingSpeed, self.motor.realSpeedLevelsAI[1]+0.3*(self.realAiCombineTargetMotorLoad-self.realMotorLoadS)^2);
		--self.motor.realSpeedLevelsAI[1] = math.min(self.realAiMaxWorkingSpeed, self.motor.realSpeedLevelsAI[1] * (1 + 0.3*(self.realAiCombineTargetMotorLoad-self.realMotorLoadS)^2));
		--self.motor.realSpeedLevelsAI[1] = self.realGroundSpeed * 3.6;
		self.motor.realSpeedLevelsAI[1] = math.min(self.realGroundSpeed*3.6, self.motor.realSpeedLevelsAI[1] * (1 + 0.3*(self.realAiCombineTargetMotorLoad-self.realMotorLoadS)^2));
	end;
	
	self.motor.realSpeedLevelsAI[1] = Utils.clamp(self.motor.realSpeedLevelsAI[1], self.realAiSpeed.minSpeed, self.realAiMaxWorkingSpeed);
	
	--print(self.time .. " new speed wanted = " .. tostring(self.motor.realSpeedLevelsAI[1]));
	
end;



local oldAICombineUpdateAIMovement = AICombine.updateAIMovement;
 AICombine.updateAIMovement = function(self, dt)
 
		
		if not self.isRealistic then
			return oldAICombineUpdateAIMovement(self, dt);
		end;
 
 
   
       if not self:getIsAIThreshingAllowed() then
           self:stopAIThreshing();
           return;
       end;
   
       if not self.isControlled then
           if g_currentMission.environment.needsLights then
               self:setLightsVisibility(true);
           else
               self:setLightsVisibility(false);
           end;
       end;
   
       local allowedToDrive = true;
       if self.grainTankCapacity == 0 then
           if not self.pipeStateIsUnloading[self.currentPipeState] then
               allowedToDrive = false;
           end
           if not self.isPipeUnloading and (self.lastArea > 0 or self.lastLostGrainTankFillLevel > 0) then
               -- there is some fruit to unload, but there is no trailer. Stop and wait for a trailer
               self.waitingForTrailerToUnload = true;
           end;
       else
           if self.grainTankFillLevel >= self.grainTankCapacity then
               allowedToDrive = false;
           end
       end
   
       if self.waitingForTrailerToUnload then
           if self.lastValidGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
               local trailer = self:findTrailerToUnload(self.lastValidGrainTankFruitType);
               if trailer ~= nil then
                   -- there is a trailer to unload. Continue working
                   self.waitingForTrailerToUnload = false;
               end;
           else
               -- we did not cut anything yet. We shouldn't have ended in this state. Just continue working
               self.waitingForTrailerToUnload = false;
           end;
       end;
   
       if (self.grainTankFillLevel >= self.grainTankCapacity and self.grainTankCapacity > 0) or self.waitingForTrailerToUnload or self.waitingForDischarge then
           allowedToDrive = false;
       end;
       for _,v in pairs(self.numCollidingVehicles) do
           if v > 0 then
               allowedToDrive = false;
               break;
           end;
       end;
       if self.turnStage > 0 then
           if self.waitForTurnTime > self.time or (self.pipeIsUnloading and self.turnStage < 3) then
               allowedToDrive = false;
           end;
       end;
       if not self:getIsThreshingAllowed(true) then
           allowedToDrive = false;
           self:setIsThreshing(false);
           self.waitingForWeather = true;
       else
           if self.waitingForWeather then
               if self.turnStage == 0 then
                   self.driveBackTime = self.time + self.driveBackTimeout;
               end;
               self:startThreshing();
               self.waitingForWeather = false;
           end;
       end;
       if not allowedToDrive then
           --local x,y,z = getWorldTranslation(self.aiTreshingDirectionNode);
           --local lx, lz = 0, 1; --AIVehicleUtil.getDriveDirection(self.aiTreshingDirectionNode, self.aiThreshingTargetX, y, self.aiThreshingTargetZ);
           --AIVehicleUtil.driveInDirection(self, dt, 30, 0, 0, 28, false, moveForwards, lx, lz)
		   --DURAL
           AIVehicleUtil.mrDriveInDirection(self, dt, 0, false, true);
           return;
       end;
   
       local speedLevel = 2;
   
       local leftMarker = self.aiLeftMarker;
       local rightMarker = self.aiRightMarker;
       local hasFruitPreparer = false;
       local fruitType = self.lastValidInputFruitType;
       if self.fruitPreparerFruitType ~= nil and self.fruitPreparerFruitType == fruitType then
           hasFruitPreparer = true;
       end
       for cutter,implement in pairs(self.attachedCutters) do
           if cutter.aiLeftMarker ~= nil and leftMarker == nil then
               leftMarker = cutter.aiLeftMarker;
           end;
           if cutter.aiRightMarker ~= nil and rightMarker == nil then
               rightMarker = cutter.aiRightMarker;
           end;
           if Cutter.getUseLowSpeedLimit(cutter) then
               speedLevel = 1;
           end;
       end;
   
       if leftMarker == nil or rightMarker == nil then
           self:stopAIThreshing();
           return;
       end;
   
       if self.driveBackTime >= self.time then
           local x,y,z = getWorldTranslation(self.aiTreshingDirectionNode);
           local lx, lz = AIVehicleUtil.getDriveDirection(self.aiTreshingDirectionNode, self.aiThreshingTargetX, y, self.aiThreshingTargetZ);
--************************************************** DURAL ****************************************************************
--** even in reverse the AI needs to accelerate to move...
           --AIVehicleUtil.driveInDirection(self, dt, 30, 0, 0, 28, true, false, lx, lz, speedLevel, 1)
		   AIVehicleUtil.mrDriveInDirection(self, dt, 1, true, false, lx, lz, speedLevel);
--********************************************** END DURAL  ***************************************************************
           return;
       end;
   
       local hasArea = true;
       if self.lastArea < 1 then
           local x,y,z = getWorldTranslation(self.aiTreshingDirectionNode);
           local dirX, dirZ = self.aiThreshingDirectionX, self.aiThreshingDirectionZ;
           local lInX,  lInY,  lInZ = getWorldTranslation(leftMarker);
           local rInX,  rInY,  rInZ = getWorldTranslation(rightMarker);

--******************************************** DURAL ********************************************************************
--** check if there is no more "fruit" under the "cutter" too
		      
			--check 0.25cm under the cutter
			lInX = lInX - 0.25*dirX;
			lInZ = lInZ - 0.25*dirZ;
		   
			rInX = rInX - 0.25*dirX;
			rInZ = rInZ - 0.25*dirZ;
			  
			--and check in front of the cutter
			local heightX = lInX + dirX * (self.frontAreaSize + 0.25);
			local heightZ = lInZ + dirZ * (self.frontAreaSize + 0.25);
		   
--******************************************** END DURAL *****************************************************************
   
           local area = Utils.getFruitArea(fruitType, lInX, lInZ, rInX, rInZ, heightX, heightZ, hasFruitPreparer);
           if area < 1 then
               hasArea = false;
           end;
       end;
       if hasArea then
           self.turnTimer = self.turnTimeout;
       else
           self.turnTimer = self.turnTimer - dt;
       end;
	   
	   --print(self.time .. " hasArea=" .. tostring(hasArea) .. " TurnStage=" .. self.turnStage);
   
   
       local newTargetX, newTargetY, newTargetZ;
   
       local moveForwards = true;
       local updateWheels = true;
   
   
       if self.turnTimer < 0 or self.turnStage > 0 then
           if self.turnStage > 0 then
               local x,y,z = getWorldTranslation(self.aiTreshingDirectionNode);
               local dirX, dirZ = self.aiThreshingDirectionX, self.aiThreshingDirectionZ;
               local myDirX, myDirY, myDirZ = localDirectionToWorld(self.aiTreshingDirectionNode, 0, 0, 1);
   
               newTargetX = self.aiThreshingTargetX;
               newTargetY = y;
               newTargetZ = self.aiThreshingTargetZ;
			   
--**********************************************  TURNSTAGE 1 ******************************************************************************
--** move forward and turn toward the next row direction (target the further side of the next row)			   
               if self.turnStage == 1 then
                   self.turnStageTimer = self.turnStageTimer - dt;
                   if self.lastSpeed < self.aiRescueSpeedThreshold then
                       self.aiRescueTimer = self.aiRescueTimer - dt;
                   else
                       self.aiRescueTimer = self.aiRescueTimeout;
                   end;
				   
					newTargetX = self.realAiThreshingNextRowFurtherSideX;
					newTargetZ = self.realAiThreshingNextRowFurtherSideZ;
				   
				   --compute the current distance between the combine and the further side of the next row
				   local distance = Utils.vector2Length(x-self.realAiThreshingNextRowFurtherSideX, z-self.realAiThreshingNextRowFurtherSideZ);
                   if (myDirX*dirX + myDirZ*dirZ) > self.realTurnStage1CosAngleThreshold or ((myDirX*dirX + myDirZ*dirZ)>0 and distance<self.realTurnStage1DistanceThreshold) or self.turnStageTimer < 0 or self.aiRescueTimer < 0 then
                       self.turnStage = 2;
                       moveForwards = false;
					   
					    newTargetX = self.realAiThreshingFinalTargetX;
						newTargetZ = self.realAiThreshingFinalTargetZ;
					   
					   --print(self.time .. " aicombine turnstage 1 - distance = " .. tostring(distance) .." / dist threshold = " .. tostring(self.realTurnStage1DistanceThreshold) .. " / cur Cos angle=" .. tostring(myDirX*dirX + myDirZ*dirZ) .. " - cos angle threshold=" .. tostring(self.realTurnStage1CosAngleThreshold)  );
					   
                       if self.turnStageTimer < 0 or self.aiRescueTimer < 0 then   
                           self.aiThreshingTargetBeforeSaveX = self.aiThreshingTargetX;
                           self.aiThreshingTargetBeforeSaveZ = self.aiThreshingTargetZ;
   
                           newTargetX = self.aiThreshingTargetBeforeTurnX;
                           newTargetZ = self.aiThreshingTargetBeforeTurnZ;
   
                           moveForwards = false;
                           self.turnStage = 4;
                           self.turnStageTimer = self.turnStage4Timeout;
                       else
                           self.turnStageTimer = self.turnStage2Timeout;
                       end;
                       self.aiRescueTimer = self.aiRescueTimeout;
                   end;
--**********************************************  TURNSTAGE 2 ******************************************************************************
--** move in reverse, preparing to face the next row
               elseif self.turnStage == 2 then
                   self.turnStageTimer = self.turnStageTimer - dt;
                   if self.lastSpeed < self.aiRescueSpeedThreshold then
                       self.aiRescueTimer = self.aiRescueTimer - dt;
                   else
                       self.aiRescueTimer = self.aiRescueTimeout;
                   end;
                   --if myDirX*dirX + myDirZ*dirZ > self.turnStage2AngleCosThreshold or self.turnStageTimer < 0 or self.aiRescueTimer < 0 then
				   if self.turnStageTimer < 0 or self.aiRescueTimer < 0 then
                       AICombine.switchToTurnStage3(self);
                   else
                       moveForwards = false;
                   end;
				   
				   
				   -- now checking if a sufficient distance has been reached to move to stage 3
					if (myDirX*dirX + myDirZ*dirZ)>0.95 then
						--check current distance to the target point				
						local x,y,z = getWorldTranslation(self.aiTreshingDirectionNode);
						local distance = Utils.vector2Length(newTargetX - x, newTargetZ - z);
						
						--print(self.time .. " turnstage2 - distance = " .. tostring(distance));
						
						if distance > self.realTurnStage2MinDistanceBeforeTurnStage3 then
							AICombine.switchToTurnStage3(self);
							moveForwards = true;
							lx, lz = AIVehicleUtil.getDriveDirection(self.aiTreshingDirectionNode, newTargetX, newTargetY, newTargetZ);
						end;
					end;
				   
				   
				   
--**********************************************  TURNSTAGE 3 ******************************************************************************
--** move forward toward the next row direction until the "turnEndDistance"
               elseif self.turnStage == 3 then
                   --[[if Utils.vector2Length(x-newTargetX, z-newTargetZ) < self.turnEndDistance then
                       self.turnTimer = self.turnTimeoutLong;
                       self.turnStage = 0;
                       --print("turning done");
                   end;]]
                   if self.lastSpeed < self.aiRescueSpeedThreshold then
                       self.aiRescueTimer = self.aiRescueTimer - dt;
                   else
                       self.aiRescueTimer = self.aiRescueTimeout;
                   end;
                   local dx, dz = x-newTargetX, z-newTargetZ;
                   local dot = dx*dirX + dz*dirZ;
                   if -dot < self.turnEndDistance then
                       self.turnTimer = self.turnTimeoutLong;
                       self.turnStage = 0;	
                   elseif self.aiRescueTimer < 0 then
                       self.aiThreshingTargetBeforeSaveX = self.aiThreshingTargetX;
                       self.aiThreshingTargetBeforeSaveZ = self.aiThreshingTargetZ;
   
                       newTargetX = self.aiThreshingTargetBeforeTurnX;
                       newTargetZ = self.aiThreshingTargetBeforeTurnZ;
   
                       moveForwards = false;
                       self.turnStage = 4;
                       self.turnStageTimer = self.turnStage4Timeout;
                   end;
--**********************************************  TURNSTAGE 4 ******************************************************************************
--** move in reverse until timeout and then launch stage 1 again
               elseif self.turnStage == 4 then
                   self.turnStageTimer = self.turnStageTimer - dt;
                   if self.lastSpeed < self.aiRescueSpeedThreshold then
                       self.aiRescueTimer = self.aiRescueTimer - dt;
                   else
                       self.aiRescueTimer = self.aiRescueTimeout;
                   end;
                   if self.aiRescueTimer < 0 then
                       self.aiRescueTimer = self.aiRescueTimeout;
                       local x,y,z = localDirectionToWorld(self.aiRescueNode, 0, 0, -1);
                       local scale = self.aiRescueForce/Utils.vector2Length(x,z);
                       addForce(self.aiRescueNode, x*scale, 0, z*scale, 0, 0, 0, true);
                   end;
                   if self.turnStageTimer < 0 then
                       self.aiRescueTimer = self.aiRescueTimeout;
                       self.turnStageTimer = self.turnStage1Timeout;
                       self.turnStage = 1;
   
                       newTargetX = self.aiThreshingTargetBeforeSaveX;
                       newTargetZ = self.aiThreshingTargetBeforeSaveZ;
                   else
                       local dirX, dirZ = -dirX, -dirZ;
                       -- just drive along direction
                       local targetX, targetZ = self.aiThreshingTargetX, self.aiThreshingTargetZ;
                       local dx, dz = x-targetX, z-targetZ;
                       local dot = dx*dirX + dz*dirZ;
   
                       local projTargetX = targetX +dirX*dot;
                       local projTargetZ = targetZ +dirZ*dot;
   
                       newTargetX = projTargetX-dirX*self.lookAheadDistance;
                       newTargetZ = projTargetZ-dirZ*self.lookAheadDistance;
                       moveForwards = false;
                   end;
               end;
           elseif fruitType == FruitUtil.FRUITTYPE_UNKNOWN then
--******************************************************************************************************
-- turnstage = 0 and timer < 0 and no more fruit to harvest => stopAI
               self:stopAIThreshing();
               return;
           else
--******************************************************************************************************
-- turnstage = 0 and timer < 0 => search for a new "row" of fruit to harvest (right or left)
               -- turn
   
               local x,y,z = getWorldTranslation(self.aiTreshingDirectionNode);
               local dirX, dirZ = self.aiThreshingDirectionX, self.aiThreshingDirectionZ;
               local sideX, sideZ = -dirZ, dirX;
               local lInX,  lInY,  lInZ = getWorldTranslation(leftMarker);
               local rInX,  rInY,  rInZ = getWorldTranslation(rightMarker);
   
               local threshWidth = Utils.vector2Length(lInX-rInX, lInZ-rInZ);
               local turnLeft = true;
   
               local lWidthX = x - sideX*0.5*threshWidth + dirX * self.sideWatchDirOffset;
               local lWidthZ = z - sideZ*0.5*threshWidth + dirZ * self.sideWatchDirOffset;
               local lStartX = lWidthX - sideX*0.7*threshWidth;
               local lStartZ = lWidthZ - sideZ*0.7*threshWidth;
               local lHeightX = lStartX + dirX*self.sideWatchDirSize;
               local lHeightZ = lStartZ + dirZ*self.sideWatchDirSize;
   
               local rWidthX = x + sideX*0.5*threshWidth + dirX * self.sideWatchDirOffset;
               local rWidthZ = z + sideZ*0.5*threshWidth + dirZ * self.sideWatchDirOffset;
               local rStartX = rWidthX + sideX*0.7*threshWidth;
               local rStartZ = rWidthZ + sideZ*0.7*threshWidth;
               local rHeightX = rStartX + dirX*self.sideWatchDirSize;
               local rHeightZ = rStartZ + dirZ*self.sideWatchDirSize;
   
               local leftFruit = Utils.getFruitArea(fruitType, lStartX, lStartZ, lWidthX, lWidthZ, lHeightX, lHeightZ, hasFruitPreparer);
               local rightFruit = Utils.getFruitArea(fruitType, rStartX, rStartZ, rWidthX, rWidthZ, rHeightX, rHeightZ, hasFruitPreparer);
               -- turn to where more fruit is to cut
               if leftFruit > 0 or rightFruit > 0 then
                   if leftFruit > rightFruit then
                       turnLeft = true;
                   else
                       turnLeft = false;
                   end
               else
					--no more fruit to harvest => end AI
                   self:stopAIThreshing();
                   return;
               end;
               local targetX, targetZ = self.aiThreshingTargetX, self.aiThreshingTargetZ;
               --local dx, dz = x-targetX, z-targetZ;
               --local dot = dx*dirX + dz*dirZ;
               --local x, z = targetX + dirX*dot, targetZ + dirZ*dot;
               --threshWidth = threshWidth*self.aiTurnThreshWidthScale;
   
   
   
               local markerSideOffset;
               if turnLeft then
                   markerSideOffset, _, _ = worldToLocal(self.aiTreshingDirectionNode, lInX, lInY, lInZ);
               else
                   markerSideOffset, _, _ = worldToLocal(self.aiTreshingDirectionNode, rInX, rInY, rInZ);
               end
               markerSideOffset = 2*markerSideOffset;
			   
               local areaOverlap = math.min(threshWidth*(1-self.aiTurnThreshWidthScale), self.aiTurnThreshWidthMaxDifference);
               if markerSideOffset > 0 then
                   markerSideOffset = math.max(markerSideOffset - areaOverlap, 0.01);
               else
                   markerSideOffset = math.min(markerSideOffset + areaOverlap, -0.01);
               end
   
               local x2,z2 = Utils.projectOnLine(x, z, targetX, targetZ, dirX, dirZ)
               newTargetX = x2-sideX*markerSideOffset;
               newTargetY = y;
               newTargetZ = z2-sideZ*markerSideOffset;
   
               self.aiThreshingDirectionX = -dirX;
               self.aiThreshingDirectionZ = -dirZ;
			   --set turnstage 1 to start the 180 turning procedure
               self.turnStage = 1;
               self.aiRescueTimer = self.aiRescueTimeout;
               self.turnStageTimer = self.turnStage1Timeout;
   
               self.aiThreshingTargetBeforeTurnX = self.aiThreshingTargetX;
               self.aiThreshingTargetBeforeTurnZ = self.aiThreshingTargetZ;
			   
--*******************************************  DURAL  ************************************************
--** save the position before doing the 180 turn
				self.realAiThreshingPositionBeforeTurnX = x;
				self.realAiThreshingPositionBeforeTurnZ = z;
				
				--get the position of the further side of the next row
				local halfWidth = 0;
				if turnLeft then
                   halfWidth, _, _ = worldToLocal(self.aiTreshingDirectionNode, rInX, rInY, rInZ);
				else                   
				   halfWidth, _, _ = worldToLocal(self.aiTreshingDirectionNode, lInX, lInY, lInZ);
				end
				self.realAiThreshingNextRowFurtherSideX = newTargetX+sideX*halfWidth;
				self.realAiThreshingNextRowFurtherSideZ = newTargetZ+sideZ*halfWidth;
				
				self.realAiThreshingFinalTargetX = newTargetX;
				self.realAiThreshingFinalTargetZ = newTargetZ;
				
--*************************************** END DURAL  *************************************************
   
               self.waitForTurnTime = self.time + self.waitForTurnTimeout;
               self:setAIImplementsMoveDown(false);
               -- do not thresh while turning
               self.allowsThreshing = false;
               updateWheels = false;
               if turnLeft then
                   --print("turning left ", threshWidth);
               else
                   --print("turning right ", threshWidth);
               end;
           end;
       else
--********************************************  TURNSTAGE 0  ********************************************
-- harvesting
	   
           local x,y,z = getWorldTranslation(self.aiTreshingDirectionNode);
           local dirX, dirZ = self.aiThreshingDirectionX, self.aiThreshingDirectionZ;
           -- just drive along direction
           local targetX, targetZ = self.aiThreshingTargetX, self.aiThreshingTargetZ;
           local dx, dz = x-targetX, z-targetZ;
           local dot = dx*dirX + dz*dirZ;
   
           local projTargetX = targetX +dirX*dot;
           local projTargetZ = targetZ +dirZ*dot;
   
           --print("old target: "..targetX.." ".. targetZ .. " distOnDir " .. dot.." proj: "..projTargetX.." "..projTargetZ);
   
           newTargetX = projTargetX+self.aiThreshingDirectionX*self.lookAheadDistance;
           newTargetY = y;
           newTargetZ = projTargetZ+self.aiThreshingDirectionZ*self.lookAheadDistance;
           --print(distOnDir.." target: "..newTargetX.." ".. newTargetZ);
		   
--*******************************************  DURAL  ************************************************
		   AICombine.updateCurrentSpeedWanted(self, false);
--*************************************** END DURAL  *************************************************		   
       end;
   
       if updateWheels then
			
			local lx, lz = 0,0;
			if moveForwards then
				lx, lz = AIVehicleUtil.getDriveDirection(self.aiTreshingDirectionNode, newTargetX, newTargetY, newTargetZ);
			else
				--setting a target point behind the combine
				local x,y,z = getWorldTranslation(self.aiTreshingDirectionNode);
				local distance = Utils.vector2Length(newTargetX - x, newTargetZ - z);
				
				local x2,z2 = Utils.projectOnLine(x, z, newTargetX, newTargetZ, self.aiThreshingDirectionX, self.aiThreshingDirectionZ)
				
				local reverseTargetX, reverseTargetY, reverseTargetZ = x2-2*self.aiThreshingDirectionX, newTargetY, z2-2*self.aiThreshingDirectionZ;			
				lx, lz = AIVehicleUtil.getDriveDirection(self.aiTreshingDirectionNode, reverseTargetX, reverseTargetY, reverseTargetZ);
				
				--print(self.time .. " vehicleSteeringAngle=" .. tostring(self.realVehicleSteeringAngle) ..  " reverse lx / lz = " .. tostring(lx) .. " / " .. tostring(lz) .. " targetX / targetZ = " .. tostring(reverseTargetX) .. " / " .. tostring(reverseTargetZ));
			end;
		   
		   
--*********************************************** DURAL **************************************************************
-- check the distance between the combine and the last row => if the minDistance is not reached, move in a straight line				
			if self.turnStage == 1 then	
				local x,y,z = getWorldTranslation(self.aiTreshingDirectionNode);
				local distance = Utils.vector2Length(x-self.realAiThreshingPositionBeforeTurnX, z-self.realAiThreshingPositionBeforeTurnZ);
				if distance<self.realAiMinDistanceBeforeTurning then
					--move in a straigh line
					lx=0;
					lz=1;					
				end;
			end;   
			
			--print(self.time .. " turnstage = " .. tostring(self.turnStage));

--** full power for a combine too
           --AIVehicleUtil.driveInDirection(self, dt, 25, 0.5, 0.5, 20, true, moveForwards, lx, lz, speedLevel, 0.9);			
			AIVehicleUtil.mrDriveInDirection(self, dt, 1, true, moveForwards, lx, lz, speedLevel);
			
--******************************************** END DURAL ****************************************************************
   
           --local maxAngle = 0.785398163; --45?;
           local maxlx = 0.7071067; --math.sin(maxAngle);
           local colDirX = lx;
           local colDirZ = lz;
   
           if colDirX > maxlx then
               colDirX = maxlx;
               colDirZ = 0.7071067; --math.cos(maxAngle);
           elseif colDirX < -maxlx then
               colDirX = -maxlx;
               colDirZ = 0.7071067; --math.cos(maxAngle);
           end;
   
           for triggerId,_ in pairs(self.numCollidingVehicles) do
               AIVehicleUtil.setCollisionDirection(self.aiTreshingDirectionNode, triggerId, colDirX, colDirZ);
           end;
       end;
   
       self.aiThreshingTargetX = newTargetX;
       self.aiThreshingTargetZ = newTargetZ;
   end;


local oldAICombineStartAIThreshing = AICombine.startAIThreshing;
AICombine.startAIThreshing = function(self, noEventSend)

	if not self.isRealistic then
		return oldAICombineStartAIThreshing(self, noEventSend);
	end;
	
	--engage AWD if possible	
	if self.realAWDModePossible and not self.realAWDModeOn then
		self:realSetAwdActive(true);
	end;
	
	if self.isServer then
		AICombine.updateCurrentSpeedWanted(self, true);
	end;
	
	return oldAICombineStartAIThreshing(self, noEventSend);

end;


