--
-- MoreLoan
--
-- @author  ANDR55
-- Version 0.1
-- @date 22.10.2013


MoreLoan = {};

function MoreLoan:loadMap(name)

	g_currentMission.missionStats.loanMax = 5000000;
	g_currentMission.missionStats.saveLoan = 0;
	MoreLoan:calculateLoanInterestRate();
	
end;

function MoreLoan:update(dt)

	if g_currentMission.missionStats.saveLoan ~= g_currentMission.missionStats.loan then
		MoreLoan:calculateLoanInterestRate();
		g_currentMission.missionStats.saveLoan = g_currentMission.missionStats.loan;
	end;
	
end;

function MoreLoan:calculateLoanInterestRate()

	local loanAnnualInterestRate = 0;
	
	if g_currentMission.missionStats.loan <= 200000 then
		loanAnnualInterestRate = 50;
	else
		loanAnnualInterestRate = g_currentMission.missionStats.loan / 2500;
	end;

	g_currentMission.missionStats.loanAnnualInterestRate = loanAnnualInterestRate * g_currentMission.missionStats.difficulty;
	
end;

function MoreLoan:deleteMap()
end;

function MoreLoan:delete()
end;

function MoreLoan:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MoreLoan:keyEvent(unicode, sym, modifier, isDown)
end;

function MoreLoan:draw()
end;

addModEventListener(MoreLoan);