

RealGenuineMap = {}

local RealGenuineMap_mt = Class(RealGenuineMap, Mission00);


function RealGenuineMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = RealGenuineMap_mt;
    end;
    local self = RealGenuineMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function RealGenuineMap:delete()
    RealGenuineMap:superClass().delete(self);
end;

function RealGenuineMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("$data/maps/map01.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
	
	--DURAL : add this line to support the "realisticStartSettings.xml" file
	--20131220 - not needed anymore
	--g_currentMission.realMapBaseDirectory = self.baseDirectory;
	
end;

function RealGenuineMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("realGenuineMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("$data/maps/map01/pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("$data/maps/map01/pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -230, 439.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -144.65, -352.25, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 513.75, 202, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 723.9, 608.25, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -162, -679.51, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -130, -383, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 89.6, -417.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -603.4, -834, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -94, 20.1, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -560, -7.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -172.25, -678.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 241.1, 438, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), 113.2, -392, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -195.85, -706.45, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 43.5, -128.3, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 395.1, -693.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 888.8 , 569.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 753.5 , 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 640.4 , 787.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 692.7 , -842.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 256, 655, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), -600, 585, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), -12, -93, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), 223, 405.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    RealGenuineMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
		self:updateFoundHorseshoes();
		self:updateFoundHelpIcons();
		self:updateMeteoriteCrash();
		self:updateRainbow();
--*************************************************************************************   DURAL  ***************************************************************
-- fixing missing cross roads on Hagensted
		RealGenuineMapFixes.fixMissingCrossRoads();
--*************************************************************************************  END DURAL  ***************************************************************		
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    --if g_isGamescomVersion then
        --self:playerOwnsAllFields();
    --end;

    self:finishLoadingTask();
	
	
	
end;

function RealGenuineMap:onStartMission()
    RealGenuineMap:superClass().onStartMission(self);
end;

function RealGenuineMap:mouseEvent(posX, posY, isDown, isUp, button)
    RealGenuineMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function RealGenuineMap:keyEvent(unicode, sym, modifier, isDown)
    RealGenuineMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function RealGenuineMap:update(dt)
    RealGenuineMap:superClass().update(self, dt);
end;

function RealGenuineMap:draw()
    RealGenuineMap:superClass().draw(self);
end;