--
-- vrataTrigger
--
-- MOD by Defender
--

print("MapMOD: vrataTrigger loaded");


vrataTriggerEvent = {};
vrataTriggerEvent_mt = Class(vrataTriggerEvent, Event);

InitEventClass(vrataTriggerEvent, "vrataTriggerEvent");

function vrataTriggerEvent:emptyNew()
    local self = Event:new(vrataTriggerEvent_mt);
    self.className="vrataTriggerEvent";
    return self;
end;

function vrataTriggerEvent:new(object, akce, otevirat, zavirat, rucne, stav)
    local self = vrataTriggerEvent:emptyNew()
    self.akce = akce;
    self.otevirat = otevirat;
    self.zavirat = zavirat;
    self.stav = stav;
    self.rucne = rucne;
    self.object = object;
    return self;
end;

function vrataTriggerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.akce = streamReadBool(streamId);
    if self.akce then
      self.otevirat = streamReadBool(streamId);
      self.zavirat = streamReadBool(streamId);
      self.rucne = streamReadBool(streamId);
    end;
    self.stav = streamReadInt8(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function vrataTriggerEvent:writeStream(streamId, connection)
    local id = networkGetObjectId(self.object);
    streamWriteInt32(streamId, id);
    streamWriteBool(streamId, self.akce);
    if self.akce then
      streamWriteBool(streamId, self.otevirat);
      streamWriteBool(streamId, self.zavirat);
      streamWriteBool(streamId, self.rucne);
    end;
    streamWriteInt8(streamId, self.stav);    
end;

function vrataTriggerEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object);
    end;

    if self.akce then
        self.object.otevirat = self.otevirat;
        self.object.zavirat = self.zavirat;
        self.object.rucne = self.rucne;
        self.object.stav = self.stav;
    else
      self.object.stav = self.stav;
    end;
    self.object:StavChanged(true);
end;

vrataTrigger = {};

local vrataTrigger_mt = Class(vrataTrigger, Object);

function vrataTrigger:OnCreate(id)
    local trigger = vrataTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
end;

function vrataTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, vrataTrigger_mt);
    self.className = "vrataTrigger";
    self.rootNode = 0;

    self.vrataTriggerDirtyFlag = self:getNextDirtyFlag();
    return self;
end;

vrataOnCreate = vrataTrigger.OnCreate;

function vrataTrigger:load(id)
  self.rootNode = id;
  local PdvereID = getUserAttribute(id, "Pdvere");
  local LdvereID = getUserAttribute(id, "Ldvere");
  self.casOtevreni = Utils.getNoNil(getUserAttribute(id, "casOtevreni"),3000);
  self.rucniOtevirani = Utils.getNoNil(getUserAttribute(id, "rucniOtevirani"),true);
  self.jenRucniOtevirani = Utils.getNoNil(getUserAttribute(id, "jenRucniOtevirani"),false);
  self.nearestDistance = Utils.getNoNil(getUserAttribute(id, "vzdalenost"), 5.0);
  local ot = getUserAttribute(id, "oteviraciDoba");
  self.oteviraciDobaOd, self.oteviraciDobaDo = Utils.getVectorFromString(ot);
  if PdvereID ~= nil then
    self.Pdvere = getChildAt(id, PdvereID);
    local ProtMinX, ProtMinY, ProtMinZ = Utils.getVectorFromString(getUserAttribute(self.Pdvere, "rotMin"));
    if ProtMinX~=nil and ProtMinY~=nil and ProtMinZ~=nil then
      self.ProtMin = {Utils.degToRad(Utils.getNoNil(ProtMinX,0)), Utils.degToRad(Utils.getNoNil(ProtMinY,0)), Utils.degToRad(Utils.getNoNil(ProtMinZ,0))};
    end;
    local ProtMaxX, ProtMaxY, ProtMaxZ = Utils.getVectorFromString(getUserAttribute(self.Pdvere, "rotMax"));
    if ProtMaxX~=nil and ProtMaxY~=nil and ProtMaxZ~=nil then
      self.ProtMax = {Utils.degToRad(Utils.getNoNil(ProtMaxX,0)), Utils.degToRad(Utils.getNoNil(ProtMaxY,0)), Utils.degToRad(Utils.getNoNil(ProtMaxZ,0))};
    end;
    self.Prot = (self.ProtMin~=nil and self.ProtMax~= nil);

    local PtransMinX, PtransMinY, PtransMinZ = Utils.getVectorFromString(getUserAttribute(self.Pdvere, "transMin"));
    if PtransMinX~=nil and PtransMinY~=nil and PtransMinZ~=nil then
      self.PtransMin = {PtransMinX, PtransMinY, PtransMinZ};
    end;
    local PtransMaxX, PtransMaxY, PtransMaxZ = Utils.getVectorFromString(getUserAttribute(self.Pdvere, "transMax"));
    if PtransMaxX~=nil and PtransMaxY~=nil and PtransMaxZ~=nil then
      self.PtransMax = {PtransMaxX, PtransMaxY, PtransMaxZ};
    end;
    self.Ptrans = (self.PtransMin~=nil and self.PtransMax~=nil);
  end;
  if LdvereID ~= nil then
    self.Ldvere = getChildAt(id, LdvereID);
    local LrotMinX, LrotMinY, LrotMinZ = Utils.getVectorFromString(getUserAttribute(self.Ldvere, "rotMin"));
    if LrotMinX~=nil and LrotMinY~=nil and LrotMinZ~=nil then
      self.LrotMin = {Utils.degToRad(Utils.getNoNil(LrotMinX,0)), Utils.degToRad(Utils.getNoNil(LrotMinY,0)), Utils.degToRad(Utils.getNoNil(LrotMinZ,0))};
    end;
    local LrotMaxX, LrotMaxY, LrotMaxZ = Utils.getVectorFromString(getUserAttribute(self.Ldvere, "rotMax"));
    if LrotMaxX~=nil and LrotMaxY~=nil and LrotMaxZ~=nil then
      self.LrotMax = {Utils.degToRad(Utils.getNoNil(LrotMaxX,0)), Utils.degToRad(Utils.getNoNil(LrotMaxY,0)), Utils.degToRad(Utils.getNoNil(LrotMaxZ,0))};
    end;
    self.Lrot = (self.LrotMin~=nil and self.LrotMax~= nil);
    
    local LtransMinX, LtransMinY, LtransMinZ = Utils.getVectorFromString(getUserAttribute(self.Ldvere, "transMin"));
    if LtransMinX~=nil and LtransMinY~=nil and LtransMinZ~=nil then
      self.LtransMin = {LtransMinX, LtransMinY, LtransMinZ};
    end;
    local LtransMaxX, LtransMaxY, LtransMaxZ = Utils.getVectorFromString(getUserAttribute(self.Ldvere, "transMax"));
    if LtransMaxX~=nil and LtransMaxY~=nil and LtransMaxZ~=nil then
      self.LtransMax = {LtransMaxX, LtransMaxY, LtransMaxZ};
    end;
    self.Ltrans = (self.LtransMin~=nil and self.LtransMax~=nil);
  end;
  self.otevirat = false;
  self.zavirat = false;
  self.stav = 0;
  self.vrataid = id;
  self.rucne = false;
  self.jeZavreno = false;
  self.pocetVozidel = 0;
  if not self.jenRucniOtevirani and self.isServer then
    setCollisionMask(id, 8192);
    addTrigger(id, "vrataTriggerCallback", self);
  else
    setCollisionMask(id, 8192);
  end;
end;

function vrataTrigger:delete()
  if not self.jenRucniOtevirani and self.isServer then
    removeTrigger(self.vrataid);
  end;
  --delete(self.rootNode);
  --vrataTrigger:superClass().delete(self);
end;

function vrataTrigger:loadMap(name)
end;

function vrataTrigger:deleteMap()
end;


function vrataTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function vrataTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function vrataTrigger:update(dt)
  self.jeZavreno = false;
  if self.oteviraciDobaOd~=nil and self.oteviraciDobaDo~=nil then
    self.jeZavreno =(g_currentMission.environment.dayTime > self.oteviraciDobaDo*60*60*1000) or (g_currentMission.environment.dayTime < self.oteviraciDobaOd*60*60*1000);
  end;
  
  if self.isClient then
    if self.jeZavreno and (self.stav>0) then
      self.otevirat = false;
      self.zavirat = true;
      self.rucne = false;
      self:StavChanged();
    end;
    if self.otevirat then
      if self.Pdvere ~= nil then
        if self.Prot then
          local x1,y1,z1 = getRotation(self.Pdvere);
          local rot1 = {x1,y1,z1};
          local newRot1 = Utils.getMovedLimitedValues(rot1, self.ProtMax, self.ProtMin, 3, self.casOtevreni, dt, false);
          setRotation(self.Pdvere, unpack(newRot1));
          if (math.abs(x1-newRot1[1]) <= 0.001) and (math.abs(y1-newRot1[2]) <= 0.001) and (math.abs(z1-newRot1[3]) <= 0.001) then
            self.otevirat = false;
            self.stav=1;
            self:StavChanged();
          end;
        end;
        if self.Ptrans then
          local x1,y1,z1 = getTranslation(self.Pdvere);
          local trans1 = {x1,y1,z1};
          local newTrans1 = Utils.getMovedLimitedValues(trans1, self.PtransMax, self.PtransMin, 3, self.casOtevreni, dt, false);
          setTranslation(self.Pdvere, unpack(newTrans1));
          if (math.abs(x1-newTrans1[1]) <= 0.001) and (math.abs(y1-newTrans1[2]) <= 0.001) and (math.abs(z1-newTrans1[3]) <= 0.001) then
            self.otevirat = false;
            self.stav=1;
            self:StavChanged();
          end;
        end;
      end;
      if self.Ldvere ~= nil then
        if self.Lrot then
          local x2,y2,z2 = getRotation(self.Ldvere);
          local rot2 = {x2,y2,z2};
          local newRot2 = Utils.getMovedLimitedValues(rot2, self.LrotMax, self.LrotMin, 3, self.casOtevreni, dt, false);
          setRotation(self.Ldvere, unpack(newRot2));
          if (math.abs(x2-newRot2[1]) <= 0.001) and (math.abs(y2-newRot2[2]) <= 0.001) and (math.abs(z2-newRot2[3]) <= 0.001) then
            self.otevirat = false;
            self.stav=1;
            self:StavChanged();
          end;
        end;
        if self.Ltrans then
          local x2,y2,z2 = getTranslation(self.Ldvere);
          local trans2 = {x2,y2,z2};
          local newTrans2 = Utils.getMovedLimitedValues(trans2, self.LtransMax, self.LtransMin, 3, self.casOtevreni, dt, false);
          setTranslation(self.Ldvere, unpack(newTrans2));
          if (math.abs(x2-newTrans2[1]) <= 0.001) and (math.abs(y2-newTrans2[2]) <= 0.001) and (math.abs(z2-newTrans2[3]) <= 0.001) then
            self.otevirat = false;
            self.stav=1;
            self:StavChanged();
          end;
        end;
      end;
    end;
    if self.zavirat then
      if self.Pdvere ~= nil then
        if self.Prot then
          local x1,y1,z1 = getRotation(self.Pdvere);
          local rot1 = {x1,y1,z1};
          local newRot1 = Utils.getMovedLimitedValues(rot1, self.ProtMax, self.ProtMin, 3, self.casOtevreni, dt, true);
          setRotation(self.Pdvere, unpack(newRot1));
          if (math.abs(x1-newRot1[1]) <= 0.001) and (math.abs(y1-newRot1[2]) <= 0.001) and (math.abs(z1-newRot1[3]) <= 0.001) then
            self.zavirat = false;
            self.stav = 0;
            self:StavChanged();
          end;
        end;
        if self.Ptrans then
          local x1,y1,z1 = getTranslation(self.Pdvere);
          local trans1 = {x1,y1,z1};
          local newTrans1 = Utils.getMovedLimitedValues(trans1, self.PtransMax, self.PtransMin, 3, self.casOtevreni, dt, true);
          setTranslation(self.Pdvere, unpack(newTrans1));
          if (math.abs(x1-newTrans1[1]) <= 0.001) and (math.abs(y1-newTrans1[2]) <= 0.001) and (math.abs(z1-newTrans1[3]) <= 0.001) then
            self.zavirat = false;
            self.stav = 0;
            self:StavChanged();
          end;
        end;
      end;
      if self.Ldvere ~= nil then  
        if self.Lrot then
          local x2,y2,z2 = getRotation(self.Ldvere);
          local rot2 = {x2,y2,z2};
          local newRot2 = Utils.getMovedLimitedValues(rot2, self.LrotMax, self.LrotMin, 3, self.casOtevreni, dt, true);
          setRotation(self.Ldvere, unpack(newRot2));
          if (math.abs(x2-newRot2[1]) <= 0.001) and (math.abs(y2-newRot2[2]) <= 0.001) and (math.abs(z2-newRot2[3]) <= 0.001) then
            self.zavirat=false;
            self.stav = 0;
            self:StavChanged();
          end;
        end;
        if self.Ltrans then
          local x2,y2,z2 = getTranslation(self.Ldvere);
          local trans2 = {x2,y2,z2};
          local newTrans2 = Utils.getMovedLimitedValues(trans2, self.LtransMax, self.LtransMin, 3, self.casOtevreni, dt, true);
          setTranslation(self.Ldvere, unpack(newTrans2));
          if (math.abs(x2-newTrans2[1]) <= 0.001) and (math.abs(y2-newTrans2[2]) <= 0.001) and (math.abs(z2-newTrans2[3]) <= 0.001) then
            self.zavirat = false;
            self.stav = 0;
            self:StavChanged();
          end;
        end;
      end;
    end;
    if self.rucniOtevirani and not self.jeZavreno then
      local nearestDistance = self.nearestDistance;
      local podminka = true;
      if (g_currentMission.player ~= nil) and (g_currentMission.player.isEntered) then
        local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
        if self.Pdvere ~= nil then
          local px, py, pz = getWorldTranslation(self.Pdvere);
          local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
          podminka = podminka and (distance < nearestDistance);
        end;
        if self.Ldvere ~= nil then
          local lx, ly, lz = getWorldTranslation(self.Ldvere);
	        local distance1 = Utils.vector3Length(lx-vx, ly-vy, lz-vz);
	        podminka = podminka and (distance1 < nearestDistance);
        end;
	      if podminka then
		      if not self.otevirat and not self.zavirat then
            g_currentMission:addExtraPrintText("Klavesa B : Otevrit/zavrit vrata");
            if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) then
	            if self.stav == 1 then
                self.otevirat = false;
                self.zavirat = true;
                self.rucne = false;
              else
                self.otevirat = true;
                self.zavirat = false;
                self.rucne = true;
              end;
              self:StavChanged();
  	        end;
          end;
	      end;
      end;
    end;
  end;
end;

function vrataTrigger:draw()
end;

function vrataTrigger:StavChanged(lokalne)
  if self.otevirat or self.zavirat then
    if (lokalne == nil) or (not lokalne) then 
      if (g_server ~= nil) then
        g_server:broadcastEvent(vrataTriggerEvent:new(self, true, self.otevirat, self.zavirat, self.rucne, self.stav), nil, nil, self);
      else
        g_client:getServerConnection():sendEvent(vrataTriggerEvent:new(self, true, self.otevirat, self.zavirat, self.rucne, self.stav), nil, nil, self);
      end;
    end;
    if self.Pdvere~=nil then
      setRigidBodyType(self.Pdvere, "NoRigidBody");
    end;
    if self.Ldvere~=nil then
      setRigidBodyType(self.Ldvere, "NoRigidBody");
    end;
  else
    if self.Pdvere~=nil then
      setRigidBodyType(self.Pdvere, "Static");
    end;
    if self.Ldvere~=nil then
      setRigidBodyType(self.Ldvere, "Static");
    end;
  end;
end;

function vrataTrigger:vrataTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
  if onEnter then
    if (otherId ~= nil) then
      if (g_currentMission.nodeToVehicle[otherId]~=nil) and (not Utils.getNoNil(g_currentMission.nodeToVehicle[otherId].isPathVehicle, false)) then
        self.pocetVozidel = self.pocetVozidel + 1;
      end;
      if self.jeZavreno then
        if g_currentMission.nodeToVehicle[otherId]~=nil and g_currentMission.nodeToVehicle[otherId]:getIsActiveForInput() then
          g_currentMission:addWarning("\nJe zavreno!\nOteviraci doba: "..tostring(self.oteviraciDobaOd).." - "..tostring(self.oteviraciDobaDo).." hod.");
        end;
      else
        if self.pocetVozidel > 0 then
          self.zavirat=false;
          self.otevirat=true;
          self:StavChanged();
        end;
      end;
		end;
  elseif onStay then
    if self.jeZavreno then
      if g_currentMission.nodeToVehicle[otherId]~=nil and g_currentMission.nodeToVehicle[otherId]:getIsActiveForInput() then
        g_currentMission:addWarning("\nJe zavreno!\nOteviraci doba: "..tostring(self.oteviraciDobaOd).." - "..tostring(self.oteviraciDobaDo).." hod.");
      end;
    end;
	elseif onLeave then
    if (g_currentMission.nodeToVehicle[otherId]~=nil) and (not Utils.getNoNil(g_currentMission.nodeToVehicle[otherId].isPathVehicle, false)) then
      self.pocetVozidel = self.pocetVozidel - 1;
    end;
    if not self.rucne then
      if self.pocetVozidel == 0 then
        self.zavirat=true;
        self.otevirat=false;
        self:StavChanged();
      end;
    end;            
	elseif onStay then
		if otherId ~= nil then
		end;
	end;	
end;